/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface PsiLanguageInjectionHost
extends PsiElement {
    public boolean isValidHost();

    public PsiLanguageInjectionHost updateText(@NotNull String var1);

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper();

    public static class Shred {
        public PsiLanguageInjectionHost host;
        private final RangeMarker relevantRangeInHost;
        public final TextRange range;
        public final String prefix;
        public final String suffix;

        public Shred(@NotNull PsiLanguageInjectionHost host, @NotNull RangeMarker relevantRangeInHost, @NotNull String prefix, @NotNull String suffix, @NotNull TextRange range) {
            if (host == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiLanguageInjectionHost$Shred.<init> must not be null");
            }
            if (relevantRangeInHost == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/PsiLanguageInjectionHost$Shred.<init> must not be null");
            }
            if (prefix == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/PsiLanguageInjectionHost$Shred.<init> must not be null");
            }
            if (suffix == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/PsiLanguageInjectionHost$Shred.<init> must not be null");
            }
            if (range == null) {
                throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/psi/PsiLanguageInjectionHost$Shred.<init> must not be null");
            }
            this.host = host;
            this.relevantRangeInHost = relevantRangeInHost;
            this.prefix = prefix;
            this.suffix = suffix;
            this.range = range;
            assert (this.isValid());
            assert (relevantRangeInHost.isValid());
        }

        public RangeMarker getHostRangeMarker() {
            return this.relevantRangeInHost;
        }

        public TextRange getRangeInsideHost() {
            TextRange hostTextRange = this.host.getTextRange();
            ProperTextRange textRange = this.relevantRangeInHost.isValid() ? new ProperTextRange(this.relevantRangeInHost.getStartOffset(), this.relevantRangeInHost.getEndOffset()) : null;
            ProperTextRange properTextRange = textRange = textRange == null ? null : textRange.intersection(hostTextRange);
            if (textRange == null) {
                return new ProperTextRange(0, hostTextRange.getLength());
            }
            return textRange.shiftRight(-hostTextRange.getStartOffset());
        }

        public String toString() {
            return "Shred " + this.host.getTextRange() + ": " + this.host + " Inhost range: " + (this.relevantRangeInHost.isValid() ? "" : "!") + "(" + this.relevantRangeInHost.getStartOffset() + "," + this.relevantRangeInHost.getEndOffset() + ");" + " PSI range: " + this.range;
        }

        public boolean isValid() {
            return this.relevantRangeInHost.isValid() && this.host.isValid();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Shred shred = (Shred)o;
            return this.host.equals(shred.host) && this.prefix.equals(shred.prefix) && this.suffix.equals(shred.suffix) && this.range.equals(shred.range) && TextRange.create(this.relevantRangeInHost).equals(TextRange.create(shred.relevantRangeInHost));
        }

        public int hashCode() {
            return this.range.hashCode();
        }
    }

    public static interface InjectedPsiVisitor {
        public void visit(@NotNull PsiFile var1, @NotNull List<Shred> var2);
    }
}

