/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import gnu.trove.THashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PsiIntersectionType
extends PsiType {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.PsiIntersectionType");
    private final PsiType[] myConjuncts;

    private PsiIntersectionType(@NotNull PsiType[] conjuncts) {
        if (conjuncts == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiIntersectionType.<init> must not be null");
        }
        super(PsiAnnotation.EMPTY_ARRAY);
        LOG.assertTrue(conjuncts.length != 0);
        LOG.assertTrue(conjuncts.length > 1);
        this.myConjuncts = conjuncts;
    }

    private static PsiType[] flattenAndRemoveDuplicates(PsiType[] conjuncts) {
        Set<PsiType> flattened = PsiIntersectionType.flatten(conjuncts, (Set<PsiType>)new THashSet());
        return flattened.toArray(new PsiType[flattened.size()]);
    }

    private static Set<PsiType> flatten(PsiType[] conjuncts, Set<PsiType> types) {
        for (PsiType conjunct : conjuncts) {
            if (conjunct instanceof PsiIntersectionType) {
                PsiIntersectionType type = (PsiIntersectionType)conjunct;
                PsiIntersectionType.flatten(type.getConjuncts(), types);
                continue;
            }
            types.add(conjunct);
        }
        if (types.size() > 1) {
            PsiType[] array = types.toArray(new PsiType[types.size()]);
            Iterator<PsiType> iterator = types.iterator();
            block1: while (iterator.hasNext()) {
                PsiType type = iterator.next();
                for (PsiType existing : array) {
                    if (type == existing || !type.isAssignableFrom(existing)) continue;
                    iterator.remove();
                    continue block1;
                }
            }
            if (types.isEmpty()) {
                types.add(array[0]);
            }
        }
        return types;
    }

    @NotNull
    public PsiType[] getConjuncts() {
        if (this.myConjuncts == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiIntersectionType.getConjuncts must not return null");
        }
        return this.myConjuncts;
    }

    @Override
    public String getPresentableText() {
        return this.myConjuncts[0].getPresentableText();
    }

    @Override
    public String getCanonicalText() {
        return this.myConjuncts[0].getCanonicalText();
    }

    @Override
    public String getInternalCanonicalText() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.myConjuncts.length; ++i) {
            buffer.append(this.myConjuncts[i].getInternalCanonicalText());
            if (i >= this.myConjuncts.length - 1) continue;
            buffer.append(" & ");
        }
        return buffer.toString();
    }

    @Override
    public boolean isValid() {
        for (PsiType conjunct : this.myConjuncts) {
            if (conjunct.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(String text) {
        return false;
    }

    @Override
    public <A> A accept(PsiTypeVisitor<A> visitor) {
        return this.myConjuncts[0].accept(visitor);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myConjuncts[0].getResolveScope();
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        if (this.myConjuncts == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiIntersectionType.getSuperTypes must not return null");
        }
        return this.myConjuncts;
    }

    public static PsiType createIntersection(PsiType ... conjuncts) {
        LOG.assertTrue(conjuncts.length >= 1);
        conjuncts = PsiIntersectionType.flattenAndRemoveDuplicates(conjuncts);
        if (conjuncts.length == 1) {
            return conjuncts[0];
        }
        return new PsiIntersectionType(conjuncts);
    }

    public PsiType getRepresentative() {
        return this.myConjuncts[0];
    }

    public boolean equals(Object obj) {
        PsiType[] second;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PsiIntersectionType)) {
            return false;
        }
        PsiType[] first = this.getConjuncts();
        if (first.length != (second = ((PsiIntersectionType)obj).getConjuncts()).length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            if (first[i].equals(second[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.myConjuncts[0].hashCode();
    }

    @Override
    public String toString() {
        String s = "PsiIntersectionType: ";
        for (PsiType conjunct : this.myConjuncts) {
            s = s + conjunct.getPresentableText() + ", ";
        }
        return s;
    }
}

