/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import org.jetbrains.annotations.NonNls;

public class PersistentFSConstants {
    public static final long FILE_LENGTH_TO_CACHE_THRESHOLD = 0x1400000L;
    public static final int MAX_INTELLISENSE_FILESIZE = PersistentFSConstants.maxIntellisenseFileSize();
    @NonNls
    private static final String MAX_INTELLISENSE_SIZE_PROPERTY = "idea.max.intellisense.filesize";

    private PersistentFSConstants() {
    }

    private static int maxIntellisenseFileSize() {
        int maxLimitBytes = 0x1400000;
        String userLimitKb = System.getProperty(MAX_INTELLISENSE_SIZE_PROPERTY);
        try {
            return userLimitKb != null ? Math.min(Integer.parseInt(userLimitKb) * 1024, 0x1400000) : 0x1400000;
        }
        catch (NumberFormatException ignored) {
            return 0x1400000;
        }
    }
}

