/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;

public class VFilePropertyChangeEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final String myPropertyName;
    private final Object myOldValue;
    private final Object myNewValue;

    public VFilePropertyChangeEvent(Object requestor, VirtualFile file, String propertyName, Object oldValue, Object newValue, boolean isFromRefresh) {
        super(requestor, isFromRefresh);
        this.myFile = file;
        this.myPropertyName = propertyName;
        this.myOldValue = oldValue;
        this.myNewValue = newValue;
    }

    @Override
    public VirtualFile getFile() {
        return this.myFile;
    }

    public Object getNewValue() {
        return this.myNewValue;
    }

    public Object getOldValue() {
        return this.myOldValue;
    }

    public String getPropertyName() {
        return this.myPropertyName;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[property( " + this.myPropertyName + ") changed for '" + this.myFile + "': oldValue = " + this.myOldValue + ", newValue = " + this.myNewValue + "]";
    }

    @Override
    public String getPath() {
        return this.myFile.getPath();
    }

    @Override
    public VirtualFileSystem getFileSystem() {
        return this.myFile.getFileSystem();
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFilePropertyChangeEvent event = (VFilePropertyChangeEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewValue.equals(event.myNewValue)) {
            return false;
        }
        if (!this.myOldValue.equals(event.myOldValue)) {
            return false;
        }
        return this.myPropertyName.equals(event.myPropertyName);
    }

    @Override
    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myPropertyName.hashCode();
        result = 31 * result + this.myOldValue.hashCode();
        result = 31 * result + this.myNewValue.hashCode();
        return result;
    }
}

