/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimedReference;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarHandlerBase {
    protected final TimedReference<ZipFile> myZipFile = new TimedReference(null);
    protected SoftReference<Map<String, EntryInfo>> myRelPathsToEntries = new SoftReference<Object>(null);
    protected final Object lock = new Object();
    protected final String myBasePath;

    public JarHandlerBase(String path) {
        this.myBasePath = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected Map<String, EntryInfo> initEntries() {
        Object object = this.lock;
        // MONITORENTER : object
        THashMap map = this.myRelPathsToEntries.get();
        if (map == null) {
            ZipFile zip = this.getZip();
            map = new THashMap();
            if (zip != null) {
                map.put("", new EntryInfo("", null, true));
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    boolean isDirectory = name.endsWith("/");
                    JarHandlerBase.getOrCreate(isDirectory ? name.substring(0, name.length() - 1) : name, isDirectory, (Map<String, EntryInfo>)map);
                }
                this.myRelPathsToEntries = new SoftReference<THashMap>(map);
            }
        }
        THashMap tHashMap = map;
        // MONITOREXIT : object
        if (tHashMap != null) return tHashMap;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/jar/JarHandlerBase.initEntries must not return null");
    }

    public File getMirrorFile(File originalFile) {
        return originalFile;
    }

    @Nullable
    public ZipFile getZip() {
        ZipFile zip = this.myZipFile.get();
        if (zip == null) {
            try {
                zip = new ZipFile(this.getMirrorFile(this.getOriginalFile()));
                this.myZipFile.set(zip);
            }
            catch (IOException e) {
                return null;
            }
        }
        return zip;
    }

    protected File getOriginalFile() {
        return new File(this.myBasePath);
    }

    private static EntryInfo getOrCreate(String entryName, boolean isDirectory, Map<String, EntryInfo> map) {
        EntryInfo info = map.get(entryName);
        if (info == null) {
            String shortName;
            int idx = entryName.lastIndexOf(47);
            String parentEntryName = idx > 0 ? entryName.substring(0, idx) : "";
            String string = shortName = idx > 0 ? entryName.substring(idx + 1) : entryName;
            if (".".equals(shortName)) {
                return JarHandlerBase.getOrCreate(parentEntryName, true, map);
            }
            info = new EntryInfo(shortName, JarHandlerBase.getOrCreate(parentEntryName, true, map), isDirectory);
            map.put(entryName, info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public String[] list(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarHandlerBase.list must not be null");
        }
        Object object = this.lock;
        // MONITORENTER : object
        EntryInfo parentEntry = this.getEntryInfo(file);
        HashSet<String> names = new HashSet<String>();
        Iterator<EntryInfo> i$ = this.getEntriesMap().values().iterator();
        while (true) {
            if (!i$.hasNext()) {
                String[] stringArray = ArrayUtil.toStringArray(names);
                // MONITOREXIT : object
                if (stringArray != null) return stringArray;
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/jar/JarHandlerBase.list must not return null");
            }
            EntryInfo info = i$.next();
            if (info.parent != parentEntry) continue;
            names.add(info.shortName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntryInfo getEntryInfo(VirtualFile file) {
        Object object = this.lock;
        synchronized (object) {
            String parentPath = this.getRelativePath(file);
            return this.getEntryInfo(parentPath);
        }
    }

    public EntryInfo getEntryInfo(String parentPath) {
        return this.getEntriesMap().get(parentPath);
    }

    protected Map<String, EntryInfo> getEntriesMap() {
        return this.initEntries();
    }

    private String getRelativePath(VirtualFile file) {
        String path = file.getPath().substring(this.myBasePath.length() + 1);
        return path.startsWith("/") ? path.substring(1) : path;
    }

    @Nullable
    private ZipEntry convertToEntry(VirtualFile file) {
        String path = this.getRelativePath(file);
        ZipFile zip = this.getZip();
        return zip != null ? zip.getEntry(path) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarHandlerBase.getLength must not be null");
        }
        Object object = this.lock;
        synchronized (object) {
            ZipEntry entry = this.convertToEntry(file);
            return entry != null ? entry.getSize() : 0L;
        }
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarHandlerBase.getInputStream must not be null");
        }
        BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream = new BufferExposingByteArrayInputStream(this.contentsToByteArray(file));
        if (bufferExposingByteArrayInputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/jar/JarHandlerBase.getInputStream must not return null");
        }
        return bufferExposingByteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        InputStream stream;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarHandlerBase.contentsToByteArray must not be null");
        }
        Object object = this.lock;
        synchronized (object) {
            byte[] byArray;
            ZipEntry entry = this.convertToEntry(file);
            if (entry == null) {
                byte[] byArray2 = new byte[]{};
                // MONITOREXIT @DISABLED, blocks:[4, 11] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                byArray = byArray2;
                if (byArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/jar/JarHandlerBase.contentsToByteArray must not return null");
                return byArray;
            }
            ZipFile zip = this.getZip();
            assert (zip != null) : file;
            stream = zip.getInputStream(entry);
            assert (stream != null) : file;
            byte[] byArray3 = FileUtil.loadBytes(stream, (int)entry.getSize());
            // MONITOREXIT @DISABLED, blocks:[2, 4] lbl20 : MonitorExitStatement: MONITOREXIT : var2_2
            byArray = byArray3;
            if (byArray3 != null) return byArray;
        }
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/jar/JarHandlerBase.contentsToByteArray must not return null");
        {
            finally {
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeStamp(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarHandlerBase.getTimeStamp must not be null");
        }
        if (file.getParent() == null) {
            return this.getOriginalFile().lastModified();
        }
        Object object = this.lock;
        synchronized (object) {
            ZipEntry entry = this.convertToEntry(file);
            return entry != null ? entry.getTime() : -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarHandlerBase.isDirectory must not be null");
        }
        if (file.getParent() == null) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            String path = this.getRelativePath(file);
            EntryInfo info = this.getEntryInfo(path);
            return info == null || info.isDirectory;
        }
    }

    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        if (fileOrDirectory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/jar/JarHandlerBase.exists must not be null");
        }
        if (fileOrDirectory.getParent() == null) {
            return this.myZipFile.get() != null || this.getOriginalFile().exists();
        }
        return this.getEntryInfo(fileOrDirectory) != null;
    }

    protected static class EntryInfo {
        final boolean isDirectory;
        protected final String shortName;
        final EntryInfo parent;

        public EntryInfo(String shortName, EntryInfo parent, boolean directory) {
            this.shortName = new String(shortName);
            this.parent = parent;
            this.isDirectory = directory;
        }
    }
}

