/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EncodingRegistry {
    public static Getter<EncodingRegistry> ourInstanceGetter;

    public abstract boolean isNative2Ascii(@NotNull VirtualFile var1);

    @Nullable
    public abstract Charset getDefaultCharset();

    @Nullable
    public abstract Charset getEncoding(@Nullable VirtualFile var1, boolean var2);

    public abstract boolean isUseUTFGuessing(VirtualFile var1);

    public abstract void setEncoding(@Nullable VirtualFile var1, @Nullable Charset var2);

    public static EncodingRegistry getInstance() {
        return ourInstanceGetter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Throwable> VirtualFile doActionAndRestoreEncoding(@NotNull VirtualFile fileBefore, @NotNull ThrowableComputable<VirtualFile, E> action) throws E {
        if (fileBefore == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/encoding/EncodingRegistry.doActionAndRestoreEncoding must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/encoding/EncodingRegistry.doActionAndRestoreEncoding must not be null");
        }
        Charset charsetBefore = EncodingRegistry.getInstance().getEncoding(fileBefore, true);
        VirtualFile fileAfter = null;
        try {
            VirtualFile virtualFile = fileAfter = action.compute();
            return virtualFile;
        }
        finally {
            Charset actual;
            if (fileAfter != null && !Comparing.equal(actual = EncodingRegistry.getInstance().getEncoding(fileAfter, true), charsetBefore)) {
                EncodingRegistry.getInstance().setEncoding(fileAfter, charsetBefore);
            }
        }
    }
}

