/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.SavingRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileEvent
extends EventObject {
    private final VirtualFile myFile;
    private final VirtualFile myParent;
    private final Object myRequestor;
    private final String myFileName;
    private long myOldModificationStamp;
    private long myNewModificationStamp;

    public VirtualFileEvent(@Nullable Object requestor, @NotNull VirtualFile file, String fileName, VirtualFile parent) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileEvent.<init> must not be null");
        }
        super(file);
        this.myRequestor = requestor != null ? requestor : file.getUserData(VirtualFile.REQUESTOR_MARKER);
        this.myFile = file;
        this.myFileName = fileName;
        this.myParent = parent;
    }

    /*
     * WARNING - void declaration
     */
    public VirtualFileEvent(@Nullable Object requestor, @NotNull VirtualFile file, VirtualFile parent, long oldModificationStamp, long l) {
        void newModificationStamp;
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileEvent.<init> must not be null");
        }
        super(file);
        this.myFile = file;
        this.myFileName = file.getName();
        this.myParent = parent;
        this.myRequestor = requestor != null ? requestor : file.getUserData(VirtualFile.REQUESTOR_MARKER);
        this.myOldModificationStamp = oldModificationStamp;
        this.myNewModificationStamp = newModificationStamp;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFileEvent.getFile must not return null");
        }
        return virtualFile;
    }

    @NotNull
    public String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFileEvent.getFileName must not return null");
        }
        return string;
    }

    @Nullable
    public VirtualFile getParent() {
        return this.myParent;
    }

    @Nullable
    public Object getRequestor() {
        return this.myRequestor;
    }

    public long getOldModificationStamp() {
        return this.myOldModificationStamp;
    }

    public long getNewModificationStamp() {
        return this.myNewModificationStamp;
    }

    public boolean isFromRefresh() {
        return this.myRequestor == null;
    }

    public boolean isFromSave() {
        return this.myRequestor instanceof SavingRequestor;
    }
}

