/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.CommonBundle;
import com.intellij.Patches;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.io.URLUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtil {
    public static final int MEGABYTE = 0x100000;
    @NonNls
    public static final String ASYNC_DELETE_EXTENSION = ".__del__";
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.io.FileUtil");
    private static final ThreadLocal<byte[]> BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[20480];
        }
    };
    private static final long CHANNELS_COPYING_LIMIT = 0x500000L;
    private static String ourCanonicalTempPathCache = null;
    private static final int MAX_FILE_DELETE_ATTEMPTS = 10;

    @Nullable
    public static String getRelativePath(File base, File file) {
        if (base == null || file == null) {
            return null;
        }
        if (!base.isDirectory() && (base = base.getParentFile()) == null) {
            return null;
        }
        if (base.equals(file)) {
            return ".";
        }
        String filePath = file.getAbsolutePath();
        String basePath = base.getAbsolutePath();
        return FileUtil.getRelativePath(basePath, filePath, File.separatorChar);
    }

    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator) {
        if (basePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.getRelativePath must not be null");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.getRelativePath must not be null");
        }
        return FileUtil.getRelativePath(basePath, filePath, separator, SystemInfo.isFileSystemCaseSensitive);
    }

    private static String ensureEnds(@NotNull String s, char endsWith) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.ensureEnds must not be null");
        }
        return StringUtil.endsWithChar(s, endsWith) ? s : s + endsWith;
    }

    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator, boolean caseSensitive) {
        int len;
        String filePathToCompare;
        if (basePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.getRelativePath must not be null");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.getRelativePath must not be null");
        }
        basePath = FileUtil.ensureEnds(basePath, separator);
        String basePathToCompare = caseSensitive ? basePath : basePath.toLowerCase();
        String string = filePathToCompare = caseSensitive ? filePath : filePath.toLowerCase();
        if (basePathToCompare.equals(FileUtil.ensureEnds(filePathToCompare, separator))) {
            return ".";
        }
        int lastSeparatorIndex = 0;
        for (len = 0; len < filePath.length() && len < basePath.length() && filePathToCompare.charAt(len) == basePathToCompare.charAt(len); ++len) {
            if (basePath.charAt(len) != separator) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != separator) continue;
            relativePath.append("..");
            relativePath.append(separator);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    public static boolean isAbsolute(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.isAbsolute must not be null");
        }
        return new File(path).isAbsolute();
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file, boolean strict) {
        File parent;
        if (ancestor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.isAncestor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.isAncestor must not be null");
        }
        File file2 = parent = strict ? FileUtil.getParentFile(file) : file;
        while (parent != null) {
            if (FileUtil.pathsEqual(parent.getPath(), ancestor.getPath())) {
                return true;
            }
            parent = FileUtil.getParentFile(parent);
        }
        return false;
    }

    @Nullable
    public static File getParentFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.getParentFile must not be null");
        }
        int skipCount = 0;
        File parentFile = file;
        while (true) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                return null;
            }
            if (".".equals(parentFile.getName())) continue;
            if ("..".equals(parentFile.getName())) {
                ++skipCount;
                continue;
            }
            if (skipCount <= 0) break;
            --skipCount;
        }
        return parentFile;
    }

    @NotNull
    public static String loadFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.loadFile must not be null");
        }
        String string = FileUtil.loadFile(file, null, false);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadFile must not return null");
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, boolean convertLineSeparators) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.loadFile must not be null");
        }
        String string = FileUtil.loadFile(file, null, convertLineSeparators);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadFile must not return null");
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.loadFile must not be null");
        }
        String string = FileUtil.loadFile(file, encoding, false);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadFile must not return null");
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, String encoding, boolean convertLineSeparators) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.loadFile must not be null");
        }
        String s = new String(FileUtil.loadFileText(file, encoding));
        String string = convertLineSeparators ? StringUtil.convertLineSeparators(s) : s;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadFile must not return null");
        }
        return string;
    }

    @NotNull
    public static char[] loadFileText(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.loadFileText must not be null");
        }
        char[] cArray = FileUtil.loadFileText(file, null);
        if (cArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadFileText must not return null");
        }
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static char[] loadFileText(@NotNull File file, @NonNls String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.loadFileText must not be null");
        }
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, encoding);
        try {
            char[] cArray = FileUtil.loadText(reader, (int)file.length());
            if (cArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadFileText must not return null");
            }
            return cArray;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static char[] loadText(@NotNull Reader reader, int length) throws IOException {
        char[] cArray;
        int count;
        int n;
        if (reader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.loadText must not be null");
        }
        char[] chars = new char[length];
        for (count = 0; count < chars.length && (n = reader.read(chars, count, chars.length - count)) > 0; count += n) {
        }
        if (count == chars.length) {
            cArray = chars;
            if (chars == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadText must not return null");
            return cArray;
        }
        char[] newChars = new char[count];
        System.arraycopy(chars, 0, newChars, 0, count);
        cArray = newChars;
        if (newChars != null) return cArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadText must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static byte[] loadFileBytes(@NotNull File file) throws IOException {
        byte[] bytes;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.loadFileBytes must not be null");
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            long len = file.length();
            if (len < 0L) {
                throw new IOException("File length reported negative, probably doesn't exist");
            }
            if (len > 0x6400000L) {
                throw new FileTooBigException("Attempt to load '" + file + "' in memory buffer, file length is " + len + " bytes.");
            }
            bytes = FileUtil.loadBytes(stream, (int)len);
        }
        finally {
            ((InputStream)stream).close();
        }
        if (bytes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadFileBytes must not return null");
        }
        return bytes;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int n;
        if (stream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.loadBytes must not be null");
        }
        byte[] bytes = new byte[length];
        for (int count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        if (bytes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadBytes must not return null");
        }
        return bytes;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream) throws IOException {
        int n;
        if (stream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.loadBytes must not be null");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] bytes = BUFFER.get();
        while ((n = stream.read(bytes, 0, bytes.length)) > 0) {
            buffer.write(bytes, 0, n);
        }
        buffer.close();
        byte[] byArray = buffer.toByteArray();
        if (byArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadBytes must not return null");
        }
        return byArray;
    }

    public static boolean processFirstBytes(@NotNull InputStream stream, int length, @NotNull Processor<ByteSequence> processor) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.processFirstBytes must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.processFirstBytes must not be null");
        }
        byte[] bytes = BUFFER.get();
        assert (bytes.length >= length) : "Cannot process more than " + bytes.length + " in one call, requested:" + length;
        int n = stream.read(bytes, 0, length);
        if (n <= 0) {
            return false;
        }
        return processor.process(new ByteSequence(bytes, 0, n));
    }

    @NotNull
    public static byte[] loadFirst(@NotNull InputStream stream, int maxLength) throws IOException {
        int n;
        if (stream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.loadFirst must not be null");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] bytes = BUFFER.get();
        while (maxLength > 0 && (n = stream.read(bytes, 0, Math.min(maxLength, bytes.length))) > 0) {
            buffer.write(bytes, 0, n);
            maxLength -= n;
        }
        buffer.close();
        byte[] byArray = buffer.toByteArray();
        if (byArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadFirst must not return null");
        }
        return byArray;
    }

    @NotNull
    public static String loadTextAndClose(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.loadTextAndClose must not be null");
        }
        String string = FileUtil.loadTextAndClose(new InputStreamReader(stream));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadTextAndClose must not return null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String loadTextAndClose(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.loadTextAndClose must not be null");
        }
        String string = new String(FileUtil.adaptiveLoadText(reader));
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.loadTextAndClose must not return null");
        }
        return string2;
        finally {
            reader.close();
        }
    }

    @NotNull
    public static char[] adaptiveLoadText(@NotNull Reader reader) throws IOException {
        int n;
        if (reader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.adaptiveLoadText must not be null");
        }
        char[] chars = new char[4096];
        ArrayList<char[]> buffers = null;
        int count = 0;
        int total = 0;
        while ((n = reader.read(chars, count, chars.length - count)) > 0) {
            count += n;
            if (total > 0xA00000) {
                throw new FileTooBigException("File too big " + reader);
            }
            total += n;
            if (count != chars.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<char[]>();
            }
            buffers.add(chars);
            int newLength = Math.min(0x100000, chars.length * 2);
            chars = new char[newLength];
            count = 0;
        }
        char[] result = new char[total];
        if (buffers != null) {
            for (char[] buffer : buffers) {
                System.arraycopy(buffer, 0, result, result.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(chars, 0, result, result.length - total, total);
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.adaptiveLoadText must not return null");
        }
        return result;
    }

    @NotNull
    public static byte[] adaptiveLoadBytes(@NotNull InputStream stream) throws IOException {
        int n;
        if (stream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.adaptiveLoadBytes must not be null");
        }
        byte[] bytes = new byte[4096];
        ArrayList<byte[]> buffers = null;
        int count = 0;
        int total = 0;
        while ((n = stream.read(bytes, count, bytes.length - count)) > 0) {
            count += n;
            if (total > 0xA00000) {
                throw new FileTooBigException("File too big " + stream);
            }
            total += n;
            if (count != bytes.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<byte[]>();
            }
            buffers.add(bytes);
            int newLength = Math.min(0x100000, bytes.length * 2);
            bytes = new byte[newLength];
            count = 0;
        }
        byte[] result = new byte[total];
        if (buffers != null) {
            for (byte[] buffer : buffers) {
                System.arraycopy(buffer, 0, result, result.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(bytes, 0, result, result.length - total, total);
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.adaptiveLoadBytes must not return null");
        }
        return result;
    }

    @NotNull
    public static File createTempDirectory(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.createTempDirectory must not be null");
        }
        File file = FileUtil.doCreateTempFile(prefix, suffix);
        file.delete();
        file.mkdir();
        file.deleteOnExit();
        File file2 = file;
        if (file2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.createTempDirectory must not return null");
        }
        return file2;
    }

    @NotNull
    public static File createTempDirectory(File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.createTempDirectory must not be null");
        }
        File file = FileUtil.doCreateTempFile(prefix, suffix, dir);
        file.delete();
        file.mkdir();
        file.deleteOnExit();
        File file2 = file;
        if (file2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.createTempDirectory must not return null");
        }
        return file2;
    }

    @NotNull
    public static File createTempFile(@NonNls File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean create) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.createTempFile must not be null");
        }
        File file = FileUtil.createTempFile(dir, prefix, suffix, create, true);
        if (file == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.createTempFile must not return null");
        }
        return file;
    }

    public static File createTempFile(@NonNls File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean create, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.createTempFile must not be null");
        }
        File file = FileUtil.doCreateTempFile(prefix, suffix, dir);
        file.delete();
        if (create) {
            file.createNewFile();
        }
        if (deleteOnExit) {
            file.deleteOnExit();
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.createTempFile must not be null");
        }
        File file = FileUtil.createTempFile(prefix, suffix, false);
        if (file == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.createTempFile must not return null");
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.createTempFile must not be null");
        }
        File file = FileUtil.doCreateTempFile(prefix, suffix);
        file.delete();
        file.createNewFile();
        if (deleteOnExit) {
            file.deleteOnExit();
        }
        File file2 = file;
        if (file2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.createTempFile must not return null");
        }
        return file2;
    }

    @NotNull
    private static File doCreateTempFile(String prefix, String suffix) throws IOException {
        File file = FileUtil.doCreateTempFile(prefix, suffix, new File(FileUtil.getTempDirectory()));
        if (file == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.doCreateTempFile must not return null");
        }
        return file;
    }

    @NotNull
    private static File doCreateTempFile(@NotNull String prefix, String suffix, File dir) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.doCreateTempFile must not be null");
        }
        dir.mkdirs();
        if (prefix.length() < 3) {
            prefix = (prefix + "___").substring(0, 3);
        }
        int exceptionsCount = 0;
        while (true) {
            File file;
            try {
                File temp = File.createTempFile(prefix, suffix, dir);
                file = FileUtil.normalizeFile(temp);
            }
            catch (IOException e) {
                if (++exceptionsCount < 100) continue;
                throw e;
            }
            if (file == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.doCreateTempFile must not return null");
            }
            return file;
        }
    }

    private static File normalizeFile(File temp) throws IOException {
        File canonical = temp.getCanonicalFile();
        return SystemInfo.isWindows && canonical.getAbsolutePath().contains(" ") ? temp.getAbsoluteFile() : canonical;
    }

    public static String getTempDirectory() {
        if (ourCanonicalTempPathCache == null) {
            ourCanonicalTempPathCache = FileUtil.calcCanonicalTempPath();
        }
        return ourCanonicalTempPathCache;
    }

    public static void resetCanonicalTempPathCache(String tempPath) {
        ourCanonicalTempPathCache = tempPath;
    }

    private static String calcCanonicalTempPath() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        try {
            String canonical = file.getCanonicalPath();
            if (!SystemInfo.isWindows || !canonical.contains(" ")) {
                return canonical;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.getAbsolutePath();
    }

    public static void asyncDelete(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.asyncDelete must not be null");
        }
        File tempFile = FileUtil.renameToTempFileOrDelete(file);
        if (tempFile == null) {
            return;
        }
        FileUtil.startDeletionThread(tempFile);
    }

    public static void asyncDelete(@NotNull Collection<File> files) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.asyncDelete must not be null");
        }
        ArrayList<File> tempFiles = new ArrayList<File>();
        for (File file : files) {
            File tempFile = FileUtil.renameToTempFileOrDelete(file);
            if (tempFile == null) continue;
            tempFiles.add(tempFile);
        }
        if (!tempFiles.isEmpty()) {
            FileUtil.startDeletionThread(tempFiles.toArray(new File[tempFiles.size()]));
        }
    }

    private static void startDeletionThread(final File ... tempFiles) {
        if (tempFiles == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.startDeletionThread must not be null");
        }
        Runnable deleteFilesTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread currentThread = Thread.currentThread();
                currentThread.setPriority(1);
                try {
                    for (File tempFile : tempFiles) {
                        FileUtil.delete(tempFile);
                    }
                }
                finally {
                    currentThread.setPriority(5);
                }
            }
        };
        try {
            Class<?> aClass = Class.forName("com.intellij.openapi.application.ApplicationManager");
            Method getApplicationMethod = aClass.getMethod("getApplication", new Class[0]);
            Object application = getApplicationMethod.invoke(null, new Object[0]);
            Method executeOnPooledThreadMethod = application.getClass().getMethod("executeOnPooledThread", Runnable.class);
            executeOnPooledThreadMethod.invoke(application, deleteFilesTask);
        }
        catch (Exception e) {
            Thread t = new Thread(deleteFilesTask, "File deletion thread");
            t.start();
        }
    }

    private static File renameToTempFileOrDelete(@NotNull File file) {
        String originalFileName;
        File tempFile;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.renameToTempFileOrDelete must not be null");
        }
        File tempDir = new File(FileUtil.getTempDirectory());
        boolean isSameDrive = true;
        if (SystemInfo.isWindows) {
            String tempDirDrive = tempDir.getAbsolutePath().substring(0, 2);
            String fileDrive = file.getAbsolutePath().substring(0, 2);
            isSameDrive = tempDirDrive.equalsIgnoreCase(fileDrive);
        }
        if (isSameDrive && file.renameTo(tempFile = FileUtil.getTempFile(originalFileName = file.getName(), tempDir))) {
            return tempFile;
        }
        FileUtil.delete(file);
        return null;
    }

    private static File getTempFile(@NotNull String originalFileName, @NotNull File parent) {
        int randomSuffix;
        if (originalFileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.getTempFile must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.getTempFile must not be null");
        }
        int i = randomSuffix = (int)(System.currentTimeMillis() % 1000L);
        String name;
        File tempFile;
        while ((tempFile = new File(parent, name = "___" + originalFileName + i + ASYNC_DELETE_EXTENSION)).exists()) {
            ++i;
        }
        return tempFile;
    }

    public static boolean delete(@NotNull File file) {
        File[] files;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.delete must not be null");
        }
        if (file.isDirectory() && !FileSystemUtil.isSymLink(file) && (files = file.listFiles()) != null) {
            for (File child : files) {
                if (FileUtil.delete(child)) continue;
                return false;
            }
        }
        for (int i = 0; i < 10; ++i) {
            if (file.delete() || !file.exists()) {
                return true;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean createParentDirs(@NotNull File file) {
        String parentDirPath;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.createParentDirs must not be null");
        }
        if (!file.exists() && (parentDirPath = file.getParent()) != null) {
            File parentFile = new File(parentDirPath);
            return parentFile.exists() && parentFile.isDirectory() || parentFile.mkdirs();
        }
        return true;
    }

    public static boolean createIfDoesntExist(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.createIfDoesntExist must not be null");
        }
        if (file.exists()) {
            return true;
        }
        try {
            if (!FileUtil.createParentDirs(file)) {
                return false;
            }
            FileOutputStream s = new FileOutputStream(file);
            ((OutputStream)s).close();
            return true;
        }
        catch (IOException e) {
            LOG.info(e);
            return false;
        }
    }

    public static boolean ensureCanCreateFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.ensureCanCreateFile must not be null");
        }
        if (file.exists()) {
            return file.canWrite();
        }
        if (!FileUtil.createIfDoesntExist(file)) {
            return false;
        }
        return FileUtil.delete(file);
    }

    public static void copy(@NotNull File fromFile, @NotNull File toFile) throws IOException {
        if (fromFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.copy must not be null");
        }
        if (toFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.copy must not be null");
        }
        FileUtil.performCopy(fromFile, toFile, true);
    }

    public static void copyContent(@NotNull File fromFile, @NotNull File toFile) throws IOException {
        if (fromFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.copyContent must not be null");
        }
        if (toFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.copyContent must not be null");
        }
        FileUtil.performCopy(fromFile, toFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performCopy(@NotNull File fromFile, @NotNull File toFile, boolean syncTimestamp) throws IOException {
        long timeStamp;
        FileOutputStream fos;
        if (fromFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.performCopy must not be null");
        }
        if (toFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.performCopy must not be null");
        }
        try {
            fos = new FileOutputStream(toFile);
        }
        catch (FileNotFoundException e) {
            File parentFile = toFile.getParentFile();
            if (parentFile == null) {
                IOException ioException = new IOException("parent file is null for " + toFile.getPath());
                ioException.initCause(e);
                throw ioException;
            }
            FileUtil.createParentDirs(toFile);
            fos = new FileOutputStream(toFile);
        }
        if (Patches.FILE_CHANNEL_TRANSFER_BROKEN || fromFile.length() > 0x500000L) {
            FileInputStream fis = new FileInputStream(fromFile);
            try {
                FileUtil.copy(fis, fos);
            }
            finally {
                fis.close();
                fos.close();
            }
        }
        FileChannel fromChannel = new FileInputStream(fromFile).getChannel();
        FileChannel toChannel = fos.getChannel();
        try {
            fromChannel.transferTo(0L, Long.MAX_VALUE, toChannel);
        }
        finally {
            fromChannel.close();
            toChannel.close();
        }
        if (syncTimestamp && !toFile.setLastModified(timeStamp = fromFile.lastModified())) {
            LOG.warn("Unable to set timestamp " + timeStamp + " to " + toFile);
        }
        if (SystemInfo.isUnix && fromFile.canExecute()) {
            int oldPermissions = FileSystemUtil.getPermissions(fromFile);
            int newPermissions = FileSystemUtil.getPermissions(toFile);
            if (oldPermissions != -1 && newPermissions != -1) {
                FileSystemUtil.setPermissions(toFile, oldPermissions | newPermissions);
            }
        }
    }

    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        int read;
        if (inputStream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.copy must not be null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.copy must not be null");
        }
        byte[] buffer = BUFFER.get();
        while ((read = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, read);
        }
    }

    public static void copy(@NotNull InputStream inputStream, int maxSize, @NotNull OutputStream outputStream) throws IOException {
        int read;
        if (inputStream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.copy must not be null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.copy must not be null");
        }
        byte[] buffer = BUFFER.get();
        for (int toRead = maxSize; toRead > 0 && (read = inputStream.read(buffer, 0, Math.min(buffer.length, toRead))) >= 0; toRead -= read) {
            outputStream.write(buffer, 0, read);
        }
    }

    public static void copyDir(@NotNull File fromDir, @NotNull File toDir) throws IOException {
        if (fromDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.copyDir must not be null");
        }
        if (toDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.copyDir must not be null");
        }
        FileUtil.copyDir(fromDir, toDir, true);
    }

    public static void copyDirContent(@NotNull File fromDir, @NotNull File toDir) throws IOException {
        File[] children;
        if (fromDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.copyDirContent must not be null");
        }
        if (toDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.copyDirContent must not be null");
        }
        for (File child : children = ObjectUtils.notNull(fromDir.listFiles(), ArrayUtil.EMPTY_FILE_ARRAY)) {
            File target = new File(toDir, child.getName());
            if (child.isFile()) {
                FileUtil.copy(child, target);
                continue;
            }
            FileUtil.copyDir(child, target, true);
        }
    }

    public static void copyDir(@NotNull File fromDir, @NotNull File toDir, boolean copySystemFiles) throws IOException {
        if (fromDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.copyDir must not be null");
        }
        if (toDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.copyDir must not be null");
        }
        FileUtil.copyDir(fromDir, toDir, copySystemFiles ? null : new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !StringUtil.startsWithChar(file.getName(), '.');
            }
        });
    }

    public static void copyDir(@NotNull File fromDir, @NotNull File toDir, @Nullable FileFilter filter) throws IOException {
        if (fromDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.copyDir must not be null");
        }
        if (toDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.copyDir must not be null");
        }
        if (!toDir.exists() && !toDir.mkdirs()) {
            throw new IOException(CommonBundle.message("exception.directory.can.not.create", toDir.getPath()));
        }
        if (FileUtil.isAncestor(fromDir, toDir, true)) {
            LOG.error(fromDir.getAbsolutePath() + " is ancestor of " + toDir + ". Can't copy to itself.");
            return;
        }
        File[] files = fromDir.listFiles();
        if (files == null) {
            throw new IOException(CommonBundle.message("exception.directory.is.invalid", fromDir.getPath()));
        }
        if (!fromDir.canRead()) {
            throw new IOException(CommonBundle.message("exception.directory.is.not.readable", fromDir.getPath()));
        }
        for (File file : files) {
            if (filter != null && !filter.accept(file)) continue;
            if (file.isDirectory()) {
                FileUtil.copyDir(file, new File(toDir, file.getName()), filter);
                continue;
            }
            FileUtil.copy(file, new File(toDir, file.getName()));
        }
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.getNameWithoutExtension must not be null");
        }
        String string = FileUtil.getNameWithoutExtension(file.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.getNameWithoutExtension must not return null");
        }
        return string;
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.getNameWithoutExtension must not be null");
        }
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.getNameWithoutExtension must not return null");
        }
        return string;
    }

    public static String createSequentFileName(@NotNull File aParentFolder, @NotNull @NonNls String aFilePrefix, @NotNull String aExtension) {
        if (aParentFolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.createSequentFileName must not be null");
        }
        if (aFilePrefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.createSequentFileName must not be null");
        }
        if (aExtension == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.createSequentFileName must not be null");
        }
        return FileUtil.findSequentNonexistentFile(aParentFolder, aFilePrefix, aExtension).getName();
    }

    public static File findSequentNonexistentFile(@NotNull File aParentFolder, @NotNull @NonNls String aFilePrefix, @NotNull String aExtension) {
        if (aParentFolder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.findSequentNonexistentFile must not be null");
        }
        if (aFilePrefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.findSequentNonexistentFile must not be null");
        }
        if (aExtension == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.findSequentNonexistentFile must not be null");
        }
        int postfix = 0;
        String ext = aExtension.isEmpty() ? "" : "." + aExtension;
        File candidate = new File(aParentFolder, aFilePrefix + ext);
        while (candidate.exists()) {
            candidate = new File(aParentFolder, aFilePrefix + Integer.toString(++postfix) + ext);
        }
        return candidate;
    }

    @NotNull
    public static String toSystemDependentName(@NonNls @NotNull String aFileName) {
        if (aFileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.toSystemDependentName must not be null");
        }
        String string = aFileName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.toSystemDependentName must not return null");
        }
        return string;
    }

    @NotNull
    public static String toSystemIndependentName(@NonNls @NotNull String aFileName) {
        if (aFileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.toSystemIndependentName must not be null");
        }
        String string = aFileName.replace('\\', '/');
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.toSystemIndependentName must not return null");
        }
        return string;
    }

    @NotNull
    public static String nameToCompare(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.nameToCompare must not be null");
        }
        String string = (SystemInfo.isFileSystemCaseSensitive ? name : name.toLowerCase()).replace('\\', '/');
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.nameToCompare must not return null");
        }
        return string;
    }

    public static String toCanonicalPath(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        path = path.replace(File.separatorChar, '/');
        StringTokenizer tok = new StringTokenizer(path, "/");
        Stack<String> stack = new Stack<String>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if ("..".equals(token)) {
                if (stack.isEmpty()) {
                    return null;
                }
                stack.pop();
                continue;
            }
            if (token.isEmpty() || ".".equals(token)) continue;
            stack.push(token);
        }
        StringBuilder result = new StringBuilder(path.length());
        if (path.charAt(0) == '/') {
            result.append("/");
        }
        for (int i = 0; i < stack.size(); ++i) {
            String str = (String)stack.get(i);
            if (i > 0) {
                result.append('/');
            }
            result.append(str);
        }
        return result.toString();
    }

    @NotNull
    public static String unquote(@NotNull String urlString) {
        if (urlString == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.unquote must not be null");
        }
        urlString = urlString.replace('/', File.separatorChar);
        String string = URLUtil.unescapePercentSequences(urlString);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.unquote must not return null");
        }
        return string;
    }

    public static boolean isFilePathAcceptable(@NotNull File root, @Nullable FileFilter fileFilter) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.isFilePathAcceptable must not be null");
        }
        File file = root;
        do {
            if (fileFilter == null || fileFilter.accept(file)) continue;
            return false;
        } while ((file = file.getParentFile()) != null);
        return true;
    }

    public static void rename(@NotNull File source, @NotNull File target) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.rename must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.rename must not be null");
        }
        if (source.renameTo(target)) {
            return;
        }
        if (!source.exists()) {
            return;
        }
        FileUtil.copy(source, target);
        FileUtil.delete(source);
    }

    public static boolean startsWith(@NotNull @NonNls String path, @NotNull @NonNls String start) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.startsWith must not be null");
        }
        if (start == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.startsWith must not be null");
        }
        return FileUtil.startsWith(path, start, SystemInfo.isFileSystemCaseSensitive);
    }

    public static boolean startsWith(@NotNull String path, @NotNull String start, boolean caseSensitive) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.startsWith must not be null");
        }
        if (start == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.startsWith must not be null");
        }
        int length1 = path.length();
        int length2 = start.length();
        if (length2 == 0) {
            return true;
        }
        if (length2 > length1) {
            return false;
        }
        if (!path.regionMatches(!caseSensitive, 0, start, 0, length2)) {
            return false;
        }
        if (length1 == length2) {
            return true;
        }
        char last2 = start.charAt(length2 - 1);
        char next1 = last2 == '/' || last2 == File.separatorChar ? path.charAt(length2 - 1) : path.charAt(length2);
        return next1 == '/' || next1 == File.separatorChar;
    }

    public static boolean pathsEqual(@NotNull String path1, @NotNull String path2) {
        if (path1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.pathsEqual must not be null");
        }
        if (path2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.pathsEqual must not be null");
        }
        return SystemInfo.isFileSystemCaseSensitive ? path1.equals(path2) : path1.equalsIgnoreCase(path2);
    }

    public static int comparePaths(@NotNull String path1, @NotNull String path2) {
        if (path1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.comparePaths must not be null");
        }
        if (path2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.comparePaths must not be null");
        }
        return SystemInfo.isFileSystemCaseSensitive ? path1.compareTo(path2) : path1.compareToIgnoreCase(path2);
    }

    public static int pathHashCode(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.pathHashCode must not be null");
        }
        return SystemInfo.isFileSystemCaseSensitive ? path.hashCode() : path.toLowerCase().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.getExtension must not be null");
        }
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        String string = fileName.substring(index + 1).toLowerCase();
        String string2 = string;
        if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.getExtension must not return null");
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String resolveShortWindowsName(@NotNull String path) throws IOException {
        String string;
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.resolveShortWindowsName must not be null");
        }
        if (SystemInfo.isWindows) {
            string = new File(path.replace(File.separatorChar, '/')).getCanonicalPath();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.resolveShortWindowsName must not return null");
            return string;
        }
        string = path;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.resolveShortWindowsName must not return null");
    }

    public static void collectMatchedFiles(@NotNull File root, @NotNull Pattern pattern, @NotNull List<File> outFiles) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.collectMatchedFiles must not be null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.collectMatchedFiles must not be null");
        }
        if (outFiles == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.collectMatchedFiles must not be null");
        }
        FileUtil.collectMatchedFiles(root, root, pattern, outFiles);
    }

    private static void collectMatchedFiles(@NotNull File absoluteRoot, @NotNull File root, @NotNull Pattern pattern, @NotNull List<File> files) {
        if (absoluteRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.collectMatchedFiles must not be null");
        }
        if (root == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.collectMatchedFiles must not be null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.collectMatchedFiles must not be null");
        }
        if (files == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.collectMatchedFiles must not be null");
        }
        File[] dirs = root.listFiles();
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            if (dir.isFile()) {
                String path = FileUtil.toSystemIndependentName(FileUtil.getRelativePath(absoluteRoot, dir));
                if (!pattern.matcher(path).matches()) continue;
                files.add(dir);
                continue;
            }
            FileUtil.collectMatchedFiles(absoluteRoot, dir, pattern, files);
        }
    }

    @RegExp
    @NotNull
    public static String convertAntToRegexp(@NotNull String antPattern) {
        if (antPattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.convertAntToRegexp must not be null");
        }
        String string = FileUtil.convertAntToRegexp(antPattern, true);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.convertAntToRegexp must not return null");
        }
        return string;
    }

    @RegExp
    @NotNull
    public static String convertAntToRegexp(@NotNull String antPattern, boolean ignoreStartingSlash) {
        boolean isTrailingSlash;
        int start;
        if (antPattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.convertAntToRegexp must not be null");
        }
        StringBuilder builder = new StringBuilder(antPattern.length());
        int asteriskCount = 0;
        boolean recursive = true;
        for (int idx = start = ignoreStartingSlash && (StringUtil.startsWithChar(antPattern, '/') || StringUtil.startsWithChar(antPattern, '\\')) ? 1 : 0; idx < antPattern.length(); ++idx) {
            char ch = antPattern.charAt(idx);
            if (ch == '*') {
                ++asteriskCount;
                continue;
            }
            boolean foundRecursivePattern = recursive && asteriskCount == 2 && (ch == '/' || ch == '\\');
            boolean asterisksFound = asteriskCount > 0;
            asteriskCount = 0;
            boolean bl = recursive = ch == '/' || ch == '\\';
            if (foundRecursivePattern) {
                builder.append("(?:[^/]+/)*?");
                continue;
            }
            if (asterisksFound) {
                builder.append("[^/]*?");
            }
            if (ch == '(' || ch == ')' || ch == '[' || ch == ']' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '+' || ch == '|') {
                builder.append('\\').append(ch);
                continue;
            }
            if (ch == '?') {
                builder.append("[^/]{1}");
                continue;
            }
            if (ch == '\\') {
                builder.append('/');
                continue;
            }
            builder.append(ch);
        }
        boolean bl = isTrailingSlash = builder.length() > 0 && builder.charAt(builder.length() - 1) == '/';
        if (asteriskCount == 0 && isTrailingSlash || recursive && asteriskCount == 2) {
            if (isTrailingSlash) {
                builder.setLength(builder.length() - 1);
            }
            if (builder.length() == 0) {
                builder.append(".*");
            } else {
                builder.append("(?:$|/.+)");
            }
        } else if (asteriskCount > 0) {
            builder.append("[^/]*?");
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.convertAntToRegexp must not return null");
        }
        return string;
    }

    public static boolean moveDirWithContent(@NotNull File fromDir, @NotNull File toDir) {
        if (fromDir == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.moveDirWithContent must not be null");
        }
        if (toDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.moveDirWithContent must not be null");
        }
        if (!toDir.exists()) {
            return fromDir.renameTo(toDir);
        }
        File[] files = fromDir.listFiles();
        if (files == null) {
            return false;
        }
        boolean success = true;
        for (File fromFile : files) {
            File toFile = new File(toDir, fromFile.getName());
            success = success && fromFile.renameTo(toFile);
        }
        fromDir.delete();
        return success;
    }

    @NotNull
    public static String sanitizeFileName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.sanitizeFileName must not be null");
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch <= '\u0000' || ch >= '\u00ff') continue;
            if (Character.isLetterOrDigit(ch)) {
                result.append(ch);
                continue;
            }
            result.append("_");
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.sanitizeFileName must not return null");
        }
        return string;
    }

    public static boolean canExecute(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.canExecute must not be null");
        }
        return file.canExecute();
    }

    public static boolean isSymbolicLink(File file) {
        return FileSystemUtil.isSymLink(file);
    }

    public static boolean isSymbolicLink(File parent, String name) {
        return FileSystemUtil.isSymLink(new File(parent, name));
    }

    public static void setReadOnlyAttribute(@NotNull String path, boolean readOnlyFlag) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.setReadOnlyAttribute must not be null");
        }
        File file = new File(path);
        boolean writableFlag = !readOnlyFlag;
        if (!file.setWritable(writableFlag) && file.canWrite() != writableFlag) {
            LOG.warn("Can't set writable attribute of '" + path + "' to " + readOnlyFlag);
        }
    }

    public static void setExecutableAttribute(@NotNull String path, boolean executableFlag) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.setExecutableAttribute must not be null");
        }
        File file = new File(path);
        if (!file.setExecutable(executableFlag) && file.canExecute() != executableFlag) {
            LOG.warn("Can't set executable attribute of '" + path + "' to " + executableFlag);
        }
    }

    public static void appendToFile(@NotNull File file, @NotNull String text) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.appendToFile must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.appendToFile must not be null");
        }
        FileUtil.writeToFile(file, text.getBytes("UTF-8"), true);
    }

    public static void writeToFile(@NotNull File file, @NotNull byte[] text) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.writeToFile must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.writeToFile must not be null");
        }
        FileUtil.writeToFile(file, text, false);
    }

    public static void writeToFile(@NotNull File file, @NotNull String text) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.writeToFile must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.writeToFile must not be null");
        }
        FileUtil.writeToFile(file, text.getBytes("UTF-8"), false);
    }

    public static void writeToFile(@NotNull File file, @NotNull byte[] text, int off, int len) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.writeToFile must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.writeToFile must not be null");
        }
        FileUtil.writeToFile(file, text, off, len, false);
    }

    public static void writeToFile(@NotNull File file, @NotNull byte[] text, boolean append) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.writeToFile must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.writeToFile must not be null");
        }
        FileUtil.writeToFile(file, text, 0, text.length, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(@NotNull File file, @NotNull byte[] text, int off, int len, boolean append) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.writeToFile must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.writeToFile must not be null");
        }
        FileUtil.createParentDirs(file);
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file, append));
        try {
            ((OutputStream)stream).write(text, off, len);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    public static boolean processFilesRecursively(@NotNull File root, @NotNull Processor<File> processor) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.processFilesRecursively must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.processFilesRecursively must not be null");
        }
        LinkedList<File> queue = new LinkedList<File>();
        queue.add(root);
        while (!queue.isEmpty()) {
            File[] children;
            File file = (File)queue.removeFirst();
            if (!processor.process(file)) {
                return false;
            }
            if (!file.isDirectory() || (children = file.listFiles()) == null) continue;
            ContainerUtil.addAll(queue, children);
        }
        return true;
    }

    @Nullable
    public static File findFirstThatExist(String ... paths) {
        if (paths == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.findFirstThatExist must not be null");
        }
        for (String path : paths) {
            File file;
            if (StringUtil.isEmptyOrSpaces(path) || !(file = new File(FileUtil.toSystemDependentName(path))).exists()) continue;
            return file;
        }
        return null;
    }

    @NotNull
    public static List<File> findFilesByMask(@NotNull Pattern pattern, @NotNull File dir) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.findFilesByMask must not be null");
        }
        if (dir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.findFilesByMask must not be null");
        }
        ArrayList<File> found = new ArrayList<File>();
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                found.addAll(FileUtil.findFilesByMask(pattern, file));
                continue;
            }
            if (!pattern.matcher(file.getName()).matches()) continue;
            found.add(file);
        }
        ArrayList<File> arrayList = found;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.findFilesByMask must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static List<File> findFilesOrDirsByMask(@NotNull Pattern pattern, @NotNull File dir) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.findFilesOrDirsByMask must not be null");
        }
        if (dir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/io/FileUtil.findFilesOrDirsByMask must not be null");
        }
        ArrayList<File> found = new ArrayList<File>();
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                found.addAll(FileUtil.findFilesOrDirsByMask(pattern, file));
            }
            if (!pattern.matcher(file.getName()).matches()) continue;
            found.add(file);
        }
        ArrayList<File> arrayList = found;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.findFilesOrDirsByMask must not return null");
        }
        return arrayList;
    }

    @Nullable
    public static String findFileInProvidedPath(String providedPath, String ... fileNames) {
        File file;
        if (StringUtil.isEmpty(providedPath)) {
            return "";
        }
        File providedFile = new File(providedPath);
        if (providedFile.exists()) {
            String name = providedFile.getName();
            for (String fileName : fileNames) {
                if (!name.equals(fileName)) continue;
                return FileUtil.toSystemDependentName(providedFile.getPath());
            }
        }
        if (providedFile.isDirectory()) {
            for (String fileName : fileNames) {
                file = new File(providedFile, fileName);
                if (!fileName.equals(file.getName()) || !file.exists()) continue;
                return FileUtil.toSystemDependentName(file.getPath());
            }
        }
        if ((providedFile = providedFile.getParentFile()) != null && providedFile.exists()) {
            for (String fileName : fileNames) {
                file = new File(providedFile, fileName);
                if (!fileName.equals(file.getName()) || !file.exists()) continue;
                return FileUtil.toSystemDependentName(file.getPath());
            }
        }
        return null;
    }

    public static boolean isAbsoluteFilePath(String path) {
        return FileUtil.isWindowsAbsolutePath(path) || FileUtil.isAbsolute(path);
    }

    public static boolean isWindowsAbsolutePath(String pathString) {
        return SystemInfo.isWindows && pathString.length() >= 2 && Character.isLetter(pathString.charAt(0)) && pathString.charAt(1) == ':';
    }

    @NotNull
    public static File generateRandomTemporaryPath() throws IOException {
        File file = new File(FileUtil.getTempDirectory(), UUID.randomUUID().toString());
        for (int i = 0; file.exists() && i < 5; ++i) {
            file = new File(FileUtil.getTempDirectory(), UUID.randomUUID().toString());
        }
        if (file.exists()) {
            throw new IOException("Couldn't generate unique random path.");
        }
        File file2 = FileUtil.normalizeFile(file);
        if (file2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/io/FileUtil.generateRandomTemporaryPath must not return null");
        }
        return file2;
    }

    @Nullable
    public static String getLocationRelativeToUserHome(String path) {
        if (path == null) {
            return null;
        }
        String _path = path;
        if (SystemInfo.isLinux || SystemInfo.isMac) {
            File projectDir = new File(path);
            File userHomeDir = new File(SystemProperties.getUserHome());
            if (FileUtil.isAncestor(userHomeDir, projectDir, true)) {
                _path = "~/" + FileUtil.getRelativePath(userHomeDir, projectDir);
            }
        }
        return _path;
    }

    public static boolean isHashBangLine(CharSequence firstCharsIfText, String marker) {
        if (firstCharsIfText == null) {
            return false;
        }
        int lineBreak = StringUtil.indexOf(firstCharsIfText, '\n');
        if (lineBreak < 0) {
            return false;
        }
        String firstLine = ((Object)firstCharsIfText.subSequence(0, lineBreak)).toString();
        if (!firstLine.startsWith("#!")) {
            return false;
        }
        return firstLine.contains(marker);
    }
}

