/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;

public class LowMemoryWatcher {
    private static final long MEM_THRESHOLD = 0x500000L;
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.LowMemoryWatcher");
    private static final ReferenceQueue<Object> ourRefQueue = new ReferenceQueue();
    private static SoftReference<Object> ourRef;
    private static final List<WeakReference<LowMemoryWatcher>> ourInstances;
    private final Forceable myForceable;

    public static LowMemoryWatcher register(Forceable forceable) {
        return new LowMemoryWatcher(forceable);
    }

    private LowMemoryWatcher(Forceable forceable) {
        this.myForceable = forceable;
        LowMemoryWatcher.updateRef();
        ourInstances.add(new WeakReference<LowMemoryWatcher>(this));
    }

    public void stop() {
        for (WeakReference<LowMemoryWatcher> ref : ourInstances) {
            if (ref.get() != this) continue;
            ourInstances.remove(ref);
            break;
        }
    }

    private void doCleanup() {
        if (this.myForceable.isDirty()) {
            this.myForceable.force();
        }
    }

    private static void updateRef() {
        ourRef = new SoftReference<Object>(new Object(), ourRefQueue);
    }

    static {
        ourInstances = ContainerUtil.createEmptyCOWList();
        Thread thread = new Thread("LowMemoryWatcher"){
            boolean shouldCleanup = false;

            @Override
            public void run() {
                LowMemoryWatcher.updateRef();
                HashSet<WeakReference> toRemove = new HashSet<WeakReference>();
                while (true) {
                    try {
                        while (true) {
                            ourRefQueue.remove();
                            LowMemoryWatcher.updateRef();
                            if (!this.shouldCleanup) {
                                Runtime runtime = Runtime.getRuntime();
                                this.shouldCleanup = runtime.maxMemory() - runtime.totalMemory() <= 0x500000L;
                            }
                            for (WeakReference instanceRef : ourInstances) {
                                LowMemoryWatcher watcher = (LowMemoryWatcher)instanceRef.get();
                                if (watcher == null) {
                                    toRemove.add(instanceRef);
                                    continue;
                                }
                                if (!this.shouldCleanup) continue;
                                try {
                                    watcher.doCleanup();
                                }
                                catch (Throwable e) {
                                    LOG.info(e);
                                }
                            }
                            if (toRemove.isEmpty()) continue;
                            ourInstances.removeAll(toRemove);
                            toRemove.clear();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setPriority(4);
        thread.setDaemon(true);
        thread.start();
    }

    public static abstract class ForceableAdapter
    implements Forceable {
        @Override
        public boolean isDirty() {
            return true;
        }
    }
}

