/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import org.jdom.Element;
import sun.reflect.Reflection;

public class JDOMExternalizableStringList
extends ArrayList<String>
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.JDOMExternalizableStringList");
    private static final String ATTR_LIST = "list";
    private static final String ATTR_LISTSIZE = "size";
    private static final String ATTR_ITEM = "item";
    private static final String ATTR_INDEX = "index";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_VALUE = "itemvalue";

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        this.clear();
        for (Object o : element.getChildren()) {
            int listSize;
            Element listElement = (Element)o;
            if (!ATTR_LIST.equals(listElement.getName())) continue;
            String sizeString = listElement.getAttributeValue(ATTR_LISTSIZE);
            try {
                listSize = Integer.parseInt(sizeString);
            }
            catch (NumberFormatException ex) {
                throw new InvalidDataException("Size " + sizeString + " found. Must be integer!");
            }
            for (int j = 0; j < listSize; ++j) {
                this.add(null);
            }
            ClassLoader classLoader = Reflection.getCallerClass((int)2).getClassLoader();
            for (Object o1 : listElement.getChildren()) {
                Class<?> itemClass;
                Element listItemElement = (Element)o1;
                if (!ATTR_ITEM.equals(listItemElement.getName())) {
                    throw new InvalidDataException("Unable to read list item. Unknown element found: " + listItemElement.getName());
                }
                String itemIndexString = listItemElement.getAttributeValue(ATTR_INDEX);
                String itemClassString = listItemElement.getAttributeValue(ATTR_CLASS);
                try {
                    itemClass = Class.forName(itemClassString, true, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    throw new InvalidDataException("Unable to read list item: unable to load class: " + itemClassString + " \n" + ex.getMessage());
                }
                String listItem = listItemElement.getAttributeValue(ATTR_VALUE);
                LOG.assertTrue(String.class.equals(itemClass));
                int index = Integer.parseInt(itemIndexString);
                if (index >= listSize) {
                    throw new InvalidDataException("Index out of list size: index " + index + ", size " + listSize);
                }
                this.set(index, listItem);
            }
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        int listSize = this.size();
        Element listElement = new Element(ATTR_LIST);
        listElement.setAttribute(ATTR_LISTSIZE, Integer.toString(listSize));
        element.addContent(listElement);
        for (int i = 0; i < listSize; ++i) {
            String listItem = (String)this.get(i);
            if (listItem == null) continue;
            Element itemElement = new Element(ATTR_ITEM);
            itemElement.setAttribute(ATTR_INDEX, Integer.toString(i));
            itemElement.setAttribute(ATTR_CLASS, listItem.getClass().getName());
            itemElement.setAttribute(ATTR_VALUE, DefaultJDOMExternalizer.filterXMLCharacters(listItem));
            listElement.addContent(itemElement);
        }
    }
}

