/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.FocusWatcher;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class Splitter
extends JPanel {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.ui.Splitter");
    @NonNls
    public static final String PROP_PROPORTION = "proportion";
    private int myDividerWidth;
    private boolean myVerticalSplit;
    private boolean myHonorMinimumSize = false;
    private final float myMinProp;
    private final float myMaxProp;
    protected float myProportion;
    private final Divider myDivider;
    private JComponent mySecondComponent;
    private JComponent myFirstComponent;
    private final FocusWatcher myFocusWatcher;
    private boolean myShowDividerIcon;
    private boolean myShowDividerControls;
    private static final Rectangle myNullBounds = new Rectangle();

    public Splitter() {
        this(false);
    }

    public Splitter(boolean vertical) {
        this(vertical, 0.5f);
    }

    public Splitter(boolean vertical, float proportion) {
        this(vertical, proportion, 0.0f, 1.0f);
    }

    public Splitter(boolean vertical, float proportion, float minProp, float maxProp) {
        this.myMinProp = minProp;
        this.myMaxProp = maxProp;
        LOG.assertTrue(minProp >= 0.0f);
        LOG.assertTrue(maxProp <= 1.0f);
        LOG.assertTrue(minProp <= maxProp);
        this.myVerticalSplit = vertical;
        this.myShowDividerControls = false;
        this.myShowDividerIcon = true;
        this.myHonorMinimumSize = true;
        this.myDivider = this.createDivider();
        this.setProportion(proportion);
        this.myDividerWidth = 7;
        super.add(this.myDivider);
        this.myFocusWatcher = new FocusWatcher();
        this.myFocusWatcher.install(this);
        this.setOpaque(false);
    }

    public void setShowDividerControls(boolean showDividerControls) {
        this.myShowDividerControls = showDividerControls;
        this.setOrientation(this.myVerticalSplit);
    }

    public void setShowDividerIcon(boolean showDividerIcon) {
        this.myShowDividerIcon = showDividerIcon;
        this.setOrientation(this.myVerticalSplit);
    }

    public void setResizeEnabled(boolean value) {
        this.myDivider.setResizeEnabled(value);
    }

    public boolean isShowDividerIcon() {
        return this.myShowDividerIcon;
    }

    public boolean isShowDividerControls() {
        return this.myShowDividerControls;
    }

    public boolean isHonorMinimumSize() {
        return this.myHonorMinimumSize;
    }

    public void setHonorComponentsMinimumSize(boolean honorMinimumSize) {
        this.myHonorMinimumSize = honorMinimumSize;
    }

    @Override
    public Component add(Component comp) {
        int childCount = this.getComponentCount();
        LOG.assertTrue(childCount >= 1);
        if (childCount > 3) {
            throw new IllegalStateException("" + childCount);
        }
        LOG.assertTrue(childCount <= 3);
        if (childCount == 1) {
            this.setFirstComponent((JComponent)comp);
        } else {
            this.setSecondComponent((JComponent)comp);
        }
        return comp;
    }

    public void dispose() {
        this.myFocusWatcher.deinstall(this);
    }

    protected Divider createDivider() {
        return new Divider();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && (this.myFirstComponent != null && this.myFirstComponent.isVisible() || this.mySecondComponent != null && this.mySecondComponent.isVisible());
    }

    @Override
    public Dimension getMinimumSize() {
        int dividerWidth = this.getDividerWidth();
        if (this.myFirstComponent != null && this.myFirstComponent.isVisible() && this.mySecondComponent != null && this.mySecondComponent.isVisible()) {
            Dimension firstMinSize = this.myFirstComponent.getMinimumSize();
            Dimension secondMinSize = this.mySecondComponent.getMinimumSize();
            return this.getOrientation() ? new Dimension(Math.max(firstMinSize.width, secondMinSize.width), firstMinSize.height + dividerWidth + secondMinSize.height) : new Dimension(firstMinSize.width + dividerWidth + secondMinSize.width, Math.max(firstMinSize.height, secondMinSize.height));
        }
        if (this.myFirstComponent != null && this.myFirstComponent.isVisible()) {
            return this.myFirstComponent.getMinimumSize();
        }
        if (this.mySecondComponent != null && this.mySecondComponent.isVisible()) {
            return this.mySecondComponent.getMinimumSize();
        }
        return super.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int dividerWidth = this.getDividerWidth();
        if (this.myFirstComponent != null && this.myFirstComponent.isVisible() && this.mySecondComponent != null && this.mySecondComponent.isVisible()) {
            Dimension firstPrefSize = this.myFirstComponent.getPreferredSize();
            Dimension secondPrefSize = this.mySecondComponent.getPreferredSize();
            return this.getOrientation() ? new Dimension(Math.max(firstPrefSize.width, secondPrefSize.width), firstPrefSize.height + dividerWidth + secondPrefSize.height) : new Dimension(firstPrefSize.width + dividerWidth + secondPrefSize.width, Math.max(firstPrefSize.height, secondPrefSize.height));
        }
        if (this.myFirstComponent != null && this.myFirstComponent.isVisible()) {
            return this.myFirstComponent.getPreferredSize();
        }
        if (this.mySecondComponent != null && this.mySecondComponent.isVisible()) {
            return this.mySecondComponent.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    @Override
    public void doLayout() {
        double componentSize;
        double width = this.getWidth();
        double height = this.getHeight();
        double d = componentSize = this.getOrientation() ? height : width;
        if (componentSize <= 0.0) {
            return;
        }
        if (!Splitter.isNull(this.myFirstComponent) && this.myFirstComponent.isVisible() && !Splitter.isNull(this.mySecondComponent) && this.mySecondComponent.isVisible()) {
            double secondComponentSize;
            double firstComponentSize;
            Rectangle firstRect = new Rectangle();
            Rectangle dividerRect = new Rectangle();
            Rectangle secondRect = new Rectangle();
            double dividerWidth = this.getDividerWidth();
            if (componentSize <= dividerWidth) {
                firstComponentSize = 0.0;
                secondComponentSize = 0.0;
                dividerWidth = componentSize;
            } else {
                firstComponentSize = this.myProportion * (float)(componentSize - dividerWidth);
                double d2 = secondComponentSize = this.getOrientation() ? height - firstComponentSize - dividerWidth : width - firstComponentSize - dividerWidth;
                if (this.isHonorMinimumSize()) {
                    double secondMinSize;
                    double firstMinSize = this.getOrientation() ? this.myFirstComponent.getMinimumSize().getHeight() : this.myFirstComponent.getMinimumSize().getWidth();
                    double d3 = secondMinSize = this.getOrientation() ? this.mySecondComponent.getMinimumSize().getHeight() : this.mySecondComponent.getMinimumSize().getWidth();
                    if (firstComponentSize + secondComponentSize < firstMinSize + secondMinSize) {
                        double proportion = firstMinSize / (firstMinSize + secondMinSize);
                        firstComponentSize = (int)(proportion * (double)((float)(componentSize - dividerWidth)));
                        secondComponentSize = this.getOrientation() ? height - firstComponentSize - dividerWidth : width - firstComponentSize - dividerWidth;
                    } else if (firstComponentSize < firstMinSize) {
                        secondComponentSize -= firstMinSize - firstComponentSize;
                        firstComponentSize = firstMinSize;
                    } else if (secondComponentSize < secondMinSize) {
                        firstComponentSize -= secondMinSize - secondComponentSize;
                        secondComponentSize = secondMinSize;
                    }
                }
            }
            this.myProportion = (float)(firstComponentSize / (firstComponentSize + secondComponentSize));
            firstComponentSize = Math.floor(firstComponentSize);
            secondComponentSize = Math.floor(secondComponentSize);
            if (this.getOrientation()) {
                secondComponentSize += (double)((int)(height - firstComponentSize - secondComponentSize - dividerWidth));
                firstRect.setBounds(0, 0, (int)width, (int)firstComponentSize);
                dividerRect.setBounds(0, (int)firstComponentSize, (int)width, (int)dividerWidth);
                secondRect.setBounds(0, (int)(firstComponentSize + dividerWidth), (int)width, (int)secondComponentSize);
            } else {
                secondComponentSize += (double)((int)(width - firstComponentSize - secondComponentSize - dividerWidth));
                firstRect.setBounds(0, 0, (int)firstComponentSize, (int)height);
                dividerRect.setBounds((int)firstComponentSize, 0, (int)dividerWidth, (int)height);
                secondRect.setBounds((int)(firstComponentSize + dividerWidth), 0, (int)secondComponentSize, (int)height);
            }
            this.myDivider.setVisible(true);
            this.myFirstComponent.setBounds(firstRect);
            this.myDivider.setBounds(dividerRect);
            this.mySecondComponent.setBounds(secondRect);
            this.myFirstComponent.revalidate();
            this.mySecondComponent.revalidate();
        } else if (!Splitter.isNull(this.myFirstComponent) && this.myFirstComponent.isVisible()) {
            Splitter.hideNull(this.mySecondComponent);
            this.myDivider.setVisible(false);
            this.myFirstComponent.setBounds(0, 0, (int)width, (int)height);
            this.myFirstComponent.revalidate();
        } else if (!Splitter.isNull(this.mySecondComponent) && this.mySecondComponent.isVisible()) {
            Splitter.hideNull(this.myFirstComponent);
            this.myDivider.setVisible(false);
            this.mySecondComponent.setBounds(0, 0, (int)width, (int)height);
            this.mySecondComponent.revalidate();
        } else {
            this.myDivider.setVisible(false);
            if (this.myFirstComponent != null) {
                this.myFirstComponent.setBounds(0, 0, 0, 0);
                this.myFirstComponent.revalidate();
            } else {
                Splitter.hideNull(this.myFirstComponent);
            }
            if (this.mySecondComponent != null) {
                this.mySecondComponent.setBounds(0, 0, 0, 0);
                this.mySecondComponent.revalidate();
            } else {
                Splitter.hideNull(this.mySecondComponent);
            }
        }
        this.myDivider.revalidate();
    }

    static boolean isNull(Component component) {
        return NullableComponent.Check.isNull(component);
    }

    static void hideNull(Component component) {
        if (component instanceof NullableComponent && !component.getBounds().equals(myNullBounds)) {
            component.setBounds(myNullBounds);
            component.validate();
        }
    }

    public int getDividerWidth() {
        return this.myDividerWidth;
    }

    public void setDividerWidth(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("Wrong divider width: " + width);
        }
        if (this.myDividerWidth != width) {
            this.myDividerWidth = width;
            this.revalidate();
            this.repaint();
        }
    }

    public float getProportion() {
        return this.myProportion;
    }

    public void setProportion(float proportion) {
        if (this.myProportion == proportion) {
            return;
        }
        if (proportion < 0.0f || proportion > 1.0f) {
            throw new IllegalArgumentException("Wrong proportion: " + proportion);
        }
        if (proportion < this.myMinProp) {
            proportion = this.myMinProp;
        }
        if (proportion > this.myMaxProp) {
            proportion = this.myMaxProp;
        }
        float oldProportion = this.myProportion;
        this.myProportion = proportion;
        this.firePropertyChange(PROP_PROPORTION, new Float(oldProportion), new Float(this.myProportion));
        this.revalidate();
        this.repaint();
    }

    public void swapComponents() {
        JComponent tmp = this.myFirstComponent;
        this.myFirstComponent = this.mySecondComponent;
        this.mySecondComponent = tmp;
        this.revalidate();
        this.repaint();
    }

    public boolean getOrientation() {
        return this.myVerticalSplit;
    }

    public void setOrientation(boolean verticalSplit) {
        this.myVerticalSplit = verticalSplit;
        this.myDivider.setOrientation(verticalSplit);
        this.revalidate();
        this.repaint();
    }

    public JComponent getFirstComponent() {
        return this.myFirstComponent;
    }

    public void setFirstComponent(@Nullable JComponent component) {
        if (this.myFirstComponent != component) {
            if (this.myFirstComponent != null) {
                this.remove(this.myFirstComponent);
            }
            this.myFirstComponent = component;
            if (this.myFirstComponent != null) {
                super.add(this.myFirstComponent);
            }
            this.revalidate();
            this.repaint();
        }
    }

    public JComponent getSecondComponent() {
        return this.mySecondComponent;
    }

    public JComponent getOtherComponent(Component comp) {
        if (comp.equals(this.getFirstComponent())) {
            return this.getSecondComponent();
        }
        if (comp.equals(this.getSecondComponent())) {
            return this.getFirstComponent();
        }
        LOG.error("invalid component");
        return this.getFirstComponent();
    }

    public void setSecondComponent(@Nullable JComponent component) {
        if (this.mySecondComponent != component) {
            if (this.mySecondComponent != null) {
                this.remove(this.mySecondComponent);
            }
            this.mySecondComponent = component;
            if (this.mySecondComponent != null) {
                super.add(this.mySecondComponent);
            }
            this.revalidate();
            this.repaint();
        }
    }

    public JPanel getDivider() {
        return this.myDivider;
    }

    public class Divider
    extends JPanel {
        private boolean myResizeEnabled;
        protected Point myPoint;

        public Divider() {
            super(new GridBagLayout());
            this.myResizeEnabled = true;
            this.setFocusable(false);
            this.enableEvents(48L);
            this.setOpaque(false);
            this.setOrientation(Splitter.this.myVerticalSplit);
        }

        private void setOrientation(boolean isVerticalSplit) {
            this.removeAll();
            this.setCursor(Splitter.this.getOrientation() ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(10));
            if (!Splitter.this.myShowDividerControls && !Splitter.this.myShowDividerIcon) {
                return;
            }
            Icon glueIcon = IconLoader.getIcon(isVerticalSplit ? "/general/splitGlueV.png" : "/general/splitGlueH.png");
            int leftInsetIcon = 1;
            boolean leftInsetArrow = false;
            int glueFill = isVerticalSplit ? 3 : 2;
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 13, new Insets(0, leftInsetIcon, 0, 0), 0, 0));
            if (Splitter.this.myShowDividerControls) {
                // empty if block
            }
            this.revalidate();
            this.repaint();
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
            if (!this.myResizeEnabled) {
                return;
            }
            if (506 == e.getID()) {
                this.myPoint = SwingUtilities.convertPoint(this, e.getPoint(), Splitter.this);
                if (Splitter.this.getOrientation()) {
                    if (this.getHeight() > 0) {
                        float proportion = Math.min(1.0f, Math.max(0.0f, Math.min(Math.max(this.getMinProportion(Splitter.this.myFirstComponent), (float)this.myPoint.y / (float)Splitter.this.getHeight()), 1.0f - this.getMinProportion(Splitter.this.mySecondComponent))));
                        Splitter.this.setProportion(proportion);
                    }
                } else if (this.getWidth() > 0) {
                    float proportion = Math.min(1.0f, Math.max(0.0f, Math.min(Math.max(this.getMinProportion(Splitter.this.myFirstComponent), (float)this.myPoint.x / (float)Splitter.this.getWidth()), 1.0f - this.getMinProportion(Splitter.this.mySecondComponent))));
                    Splitter.this.setProportion(proportion);
                }
            }
        }

        private float getMinProportion(JComponent component) {
            if (Splitter.this.isHonorMinimumSize() && component != null && Splitter.this.myFirstComponent != null && Splitter.this.myFirstComponent.isVisible() && Splitter.this.mySecondComponent != null && Splitter.this.mySecondComponent.isVisible()) {
                if (Splitter.this.getOrientation()) {
                    return (float)component.getMinimumSize().height / (float)(Splitter.this.getHeight() - Splitter.this.getDividerWidth());
                }
                return (float)component.getMinimumSize().width / (float)(Splitter.this.getWidth() - Splitter.this.getDividerWidth());
            }
            return 0.0f;
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (!this.myResizeEnabled) {
                return;
            }
            switch (e.getID()) {
                case 500: {
                    if (e.getClickCount() != 2) break;
                    Splitter.this.setProportion(0.5f);
                }
            }
        }

        public void setResizeEnabled(boolean resizeEnabled) {
            this.myResizeEnabled = resizeEnabled;
            if (!this.myResizeEnabled) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                this.setCursor(Splitter.this.getOrientation() ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(10));
            }
        }

        static /* synthetic */ float access$500(Divider x0, JComponent x1) {
            return x0.getMinProportion(x1);
        }
    }
}

