/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoadTextUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.fileEditor.impl.LoadTextUtil");
    private static final Key<String> DETECTED_LINE_SEPARATOR_KEY = Key.create("DETECTED_LINE_SEPARATOR_KEY");
    private static final Key<Boolean> CHARSET_WAS_DETECTED_FROM_BYTES = new Key("CHARSET_WAS_DETECTED_FROM_BYTES");

    private LoadTextUtil() {
    }

    @NotNull
    private static Pair<CharSequence, String> convertLineSeparators(@NotNull CharBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.convertLineSeparators must not be null");
        }
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        int length = buffer.length();
        char[] bufferArray = CharArrayUtil.fromSequenceWithoutCopying(buffer);
        for (int src = 0; src < length; ++src) {
            int c = bufferArray != null ? bufferArray[src] : buffer.charAt(src);
            switch (c) {
                case 13: {
                    buffer.put(dst++, '\n');
                    ++crCount;
                    break;
                }
                case 10: {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    buffer.put(dst++, '\n');
                    ++lfCount;
                    break;
                }
                default: {
                    buffer.put(dst++, (char)c);
                }
            }
            prev = c;
        }
        String detectedLineSeparator = null;
        if (crlfCount > crCount && crlfCount > lfCount) {
            detectedLineSeparator = "\r\n";
        } else if (crCount > lfCount) {
            detectedLineSeparator = "\r";
        } else if (lfCount > 0) {
            detectedLineSeparator = "\n";
        }
        CharBuffer result = buffer.length() == dst ? buffer : buffer.subSequence(0, dst);
        Pair<CharSequence, String> pair = Pair.create(result, detectedLineSeparator);
        if (pair == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.convertLineSeparators must not return null");
        }
        return pair;
    }

    private static Charset detectCharset(@NotNull VirtualFile virtualFile, @NotNull byte[] content) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.detectCharset must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.detectCharset must not be null");
        }
        if (virtualFile.isCharsetSet()) {
            return virtualFile.getCharset();
        }
        Charset charset = LoadTextUtil.doDetectCharset(virtualFile, content);
        Charset charset2 = charset = charset == null ? EncodingRegistry.getInstance().getDefaultCharset() : charset;
        if (EncodingRegistry.getInstance().isNative2Ascii(virtualFile)) {
            charset = Native2AsciiCharset.wrap(charset);
        }
        virtualFile.setCharset(charset);
        return charset;
    }

    @NotNull
    public static Charset detectCharsetAndSetBOM(@NotNull VirtualFile virtualFile, @NotNull byte[] content) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.detectCharsetAndSetBOM must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.detectCharsetAndSetBOM must not be null");
        }
        Charset charset = LoadTextUtil.doDetectCharsetAndSetBOM(virtualFile, content).getFirst();
        if (charset == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.detectCharsetAndSetBOM must not return null");
        }
        return charset;
    }

    @NotNull
    private static Pair<Charset, byte[]> doDetectCharsetAndSetBOM(@NotNull VirtualFile virtualFile, @NotNull byte[] content) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.doDetectCharsetAndSetBOM must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.doDetectCharsetAndSetBOM must not be null");
        }
        Charset charset = LoadTextUtil.detectCharset(virtualFile, content);
        Pair<Charset, byte[]> bomAndCharset = LoadTextUtil.getBOMAndCharset(content, charset);
        byte[] bom = (byte[])bomAndCharset.second;
        if (bom.length != 0) {
            virtualFile.setBOM(bom);
        }
        Pair<Charset, byte[]> pair = bomAndCharset;
        if (pair == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.doDetectCharsetAndSetBOM must not return null");
        }
        return pair;
    }

    private static Charset doDetectCharset(@NotNull VirtualFile virtualFile, @NotNull byte[] content) {
        Charset saved;
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.doDetectCharset must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.doDetectCharset must not be null");
        }
        Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessed = LoadTextUtil.guessFromContent(virtualFile, content, content.length);
        if (guessed != null && guessed.first != null) {
            return (Charset)guessed.first;
        }
        FileType fileType = virtualFile.getFileType();
        String charsetName = fileType.getCharset(virtualFile, content);
        if (charsetName == null && (saved = EncodingRegistry.getInstance().getEncoding(virtualFile, true)) != null) {
            return saved;
        }
        return CharsetToolkit.forName(charsetName);
    }

    @Nullable(value="null means no luck, otherwise it's tuple(guessed encoding, hint about content if was unable to guess, BOM)")
    public static Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessFromContent(VirtualFile virtualFile, byte[] content, int length) {
        EncodingRegistry settings = EncodingRegistry.getInstance();
        boolean shouldGuess = settings != null && settings.isUseUTFGuessing(virtualFile);
        CharsetToolkit toolkit = shouldGuess ? new CharsetToolkit(content, EncodingRegistry.getInstance().getDefaultCharset()) : null;
        LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, false);
        if (shouldGuess) {
            toolkit.setEnforce8Bit(true);
            Charset charset = toolkit.guessFromBOM();
            if (charset != null) {
                LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, true);
                byte[] bom = CharsetToolkit.getBom(charset);
                if (bom == null) {
                    bom = CharsetToolkit.UTF8_BOM;
                }
                return Trinity.create(charset, null, bom);
            }
            CharsetToolkit.GuessedEncoding guessed = toolkit.guessFromContent(length);
            if (guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
                LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, true);
                return Trinity.create(CharsetToolkit.UTF8_CHARSET, null, null);
            }
            return Trinity.create(null, guessed, null);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static Pair<Charset, byte[]> getBOMAndCharset(@NotNull byte[] content, Charset charset) {
        Pair<Charset, byte[]> pair;
        block12: {
            block11: {
                if (content == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getBOMAndCharset must not be null");
                }
                if (charset != null && charset.name().contains("UTF-8") && CharsetToolkit.hasUTF8Bom(content)) {
                    pair = Pair.create(charset, CharsetToolkit.UTF8_BOM);
                    if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getBOMAndCharset must not return null");
                    return pair;
                }
                if (!CharsetToolkit.hasUTF16LEBom(content)) break block11;
                pair = Pair.create(CharsetToolkit.UTF_16LE_CHARSET, CharsetToolkit.UTF16LE_BOM);
                if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getBOMAndCharset must not return null");
                return pair;
            }
            try {
                if (!CharsetToolkit.hasUTF16BEBom(content)) break block12;
                pair = Pair.create(CharsetToolkit.UTF_16BE_CHARSET, CharsetToolkit.UTF16BE_BOM);
                if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getBOMAndCharset must not return null");
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
            return pair;
        }
        if ((pair = Pair.create(charset, ArrayUtil.EMPTY_BYTE_ARRAY)) != null) return pair;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getBOMAndCharset must not return null");
    }

    public static Writer getWriter(@Nullable Project project, @NotNull VirtualFile virtualFile, Object requestor, @NotNull String text, long newModificationStamp) throws IOException {
        byte[] bom;
        Charset fromBom;
        Charset specified;
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getWriter must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getWriter must not be null");
        }
        Charset existing = virtualFile.getCharset();
        Charset charset = LoadTextUtil.chooseMostlyHarmlessCharset(existing, specified = LoadTextUtil.extractCharsetFromFileContent(project, virtualFile, text), text);
        if (charset != null) {
            if (!charset.equals(existing)) {
                virtualFile.setCharset(charset);
            }
            LoadTextUtil.setDetectedFromBytesFlagBack(virtualFile, charset, text);
        }
        Charset charset2 = fromBom = (bom = virtualFile.getBOM()) == null ? null : CharsetToolkit.guessFromBOM(bom);
        if (fromBom != null) {
            charset = fromBom;
        }
        OutputStream outputStream = virtualFile.getOutputStream(requestor, newModificationStamp, -1L);
        OutputStreamWriter writer = charset == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, charset);
        return outputStream instanceof ByteArrayOutputStream ? writer : new BufferedWriter(writer);
    }

    private static void setDetectedFromBytesFlagBack(@NotNull VirtualFile virtualFile, @NotNull Charset charset, @NotNull String text) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.setDetectedFromBytesFlagBack must not be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.setDetectedFromBytesFlagBack must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.setDetectedFromBytesFlagBack must not be null");
        }
        if (virtualFile.getBOM() != null) {
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, true);
            return;
        }
        byte[] content = text.getBytes(charset);
        CharsetToolkit.GuessedEncoding guessedEncoding = new CharsetToolkit(content).guessFromContent(content.length);
        if (guessedEncoding == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
            LoadTextUtil.setCharsetWasDetectedFromBytes(virtualFile, true);
        }
    }

    private static Charset chooseMostlyHarmlessCharset(Charset existing, Charset specified, String text) {
        if (existing == null) {
            return specified;
        }
        if (specified == null) {
            return existing;
        }
        if (specified.equals(existing)) {
            return specified;
        }
        if (LoadTextUtil.isSupported(specified, text)) {
            return specified;
        }
        if (LoadTextUtil.isSupported(existing, text)) {
            return existing;
        }
        return specified;
    }

    private static boolean isSupported(@NotNull Charset charset, @NotNull String str) {
        if (charset == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.isSupported must not be null");
        }
        if (str == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.isSupported must not be null");
        }
        if (!charset.canEncode()) {
            return false;
        }
        ByteBuffer out = charset.encode(str);
        CharBuffer buffer = charset.decode(out);
        return str.equals(buffer.toString());
    }

    public static Charset extractCharsetFromFileContent(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull String text) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.extractCharsetFromFileContent must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.extractCharsetFromFileContent must not be null");
        }
        Charset charset = LoadTextUtil.charsetFromContentOrNull(project, virtualFile, text);
        if (charset == null) {
            charset = virtualFile.getCharset();
        }
        return charset;
    }

    @Nullable(value="returns null if cannot determine from content")
    public static Charset charsetFromContentOrNull(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull String text) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.charsetFromContentOrNull must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.charsetFromContentOrNull must not be null");
        }
        FileType fileType = virtualFile.getFileType();
        if (fileType instanceof LanguageFileType) {
            return ((LanguageFileType)fileType).extractCharsetFromFileContent(project, virtualFile, text);
        }
        return null;
    }

    public static CharSequence loadText(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.loadText must not be null");
        }
        if (file instanceof LightVirtualFile) {
            CharSequence content = ((LightVirtualFile)file).getContent();
            if (StringUtil.indexOf(content, '\r') == -1) {
                return content;
            }
            CharBuffer buffer = CharBuffer.allocate(content.length());
            buffer.append(content);
            buffer.rewind();
            return (CharSequence)LoadTextUtil.convertLineSeparators((CharBuffer)buffer).first;
        }
        assert (!file.isDirectory()) : "'" + file.getPresentableUrl() + "' is directory";
        FileType fileType = file.getFileType();
        if (fileType.isBinary()) {
            BinaryFileDecompiler decompiler = (BinaryFileDecompiler)BinaryFileTypeDecompilers.INSTANCE.forFileType(fileType);
            if (decompiler != null) {
                CharSequence text = decompiler.decompile(file);
                StringUtil.assertValidSeparators(text);
                return text;
            }
            throw new IllegalArgumentException("Attempt to load text for binary file, that doesn't have decompiler plugged in: " + file.getPresentableUrl());
        }
        try {
            byte[] bytes = file.contentsToByteArray();
            return LoadTextUtil.getTextByBinaryPresentation(bytes, file);
        }
        catch (IOException e) {
            return ArrayUtil.EMPTY_CHAR_SEQUENCE;
        }
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not be null");
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not be null");
        }
        CharSequence charSequence = LoadTextUtil.getTextByBinaryPresentation(bytes, virtualFile, true);
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not return null");
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile, boolean rememberDetectedSeparators) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not be null");
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not be null");
        }
        Pair<Charset, byte[]> pair = LoadTextUtil.doDetectCharsetAndSetBOM(virtualFile, bytes);
        Charset charset = pair.getFirst();
        byte[] bom = pair.getSecond();
        int offset = bom == null ? 0 : bom.length;
        Pair<CharSequence, String> result = LoadTextUtil.convertBytes(bytes, charset, offset);
        if (rememberDetectedSeparators) {
            virtualFile.putUserData(DETECTED_LINE_SEPARATOR_KEY, result.getSecond());
        }
        CharSequence charSequence = result.getFirst();
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not return null");
        }
        return charSequence;
    }

    @Nullable
    public static String detectLineSeparator(@NotNull VirtualFile file, boolean checkFile) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.detectLineSeparator must not be null");
        }
        String lineSeparator = LoadTextUtil.getDetectedLineSeparator(file);
        if (lineSeparator == null && checkFile) {
            try {
                LoadTextUtil.getTextByBinaryPresentation(file.contentsToByteArray(), file);
                lineSeparator = LoadTextUtil.getDetectedLineSeparator(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return lineSeparator;
    }

    static String getDetectedLineSeparator(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getDetectedLineSeparator must not be null");
        }
        return file.getUserData(DETECTED_LINE_SEPARATOR_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeLineSeparator(@Nullable Project project, @Nullable Object requestor, @NotNull VirtualFile file, @NotNull String newLineSeparator) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.changeLineSeparator must not be null");
        }
        if (newLineSeparator == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.changeLineSeparator must not be null");
        }
        String lineSeparator = LoadTextUtil.getDetectedLineSeparator(file);
        if (lineSeparator != null && lineSeparator.equals(newLineSeparator)) {
            return;
        }
        CharSequence cs = LoadTextUtil.getTextByBinaryPresentation(file.contentsToByteArray(), file);
        lineSeparator = LoadTextUtil.getDetectedLineSeparator(file);
        if (lineSeparator == null || lineSeparator.equals(newLineSeparator)) {
            return;
        }
        if (!newLineSeparator.equals("\n")) {
            cs = StringUtil.convertLineSeparators(((Object)cs).toString(), newLineSeparator);
        }
        String text = ((Object)cs).toString();
        file.putUserData(DETECTED_LINE_SEPARATOR_KEY, newLineSeparator);
        Writer w = LoadTextUtil.getWriter(project, file, requestor, text, System.currentTimeMillis());
        try {
            w.write(text);
        }
        finally {
            w.close();
        }
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, Charset charset) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not be null");
        }
        Pair<Charset, byte[]> pair = LoadTextUtil.getBOMAndCharset(bytes, charset);
        byte[] bom = pair.getSecond();
        int offset = bom == null ? 0 : bom.length;
        Pair<CharSequence, String> result = LoadTextUtil.convertBytes(bytes, charset, offset);
        CharSequence charSequence = result.getFirst();
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.getTextByBinaryPresentation must not return null");
        }
        return charSequence;
    }

    @NotNull
    private static Pair<CharSequence, String> convertBytes(@NotNull byte[] bytes, Charset charset, int startOffset) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.convertBytes must not be null");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, startOffset, bytes.length - startOffset);
        if (charset == null) {
            charset = CharsetToolkit.getDefaultSystemCharset();
        }
        if (charset == null) {
            charset = Charset.forName("ISO-8859-1");
        }
        CharBuffer charBuffer = charset.decode(byteBuffer);
        Pair<CharSequence, String> pair = LoadTextUtil.convertLineSeparators(charBuffer);
        if (pair == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/LoadTextUtil.convertBytes must not return null");
        }
        return pair;
    }

    public static boolean wasCharsetDetectedFromBytes(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.wasCharsetDetectedFromBytes must not be null");
        }
        return virtualFile.getUserData(CHARSET_WAS_DETECTED_FROM_BYTES) != null;
    }

    public static void setCharsetWasDetectedFromBytes(@NotNull VirtualFile virtualFile, boolean flag) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/LoadTextUtil.setCharsetWasDetectedFromBytes must not be null");
        }
        virtualFile.putUserData(CHARSET_WAS_DETECTED_FROM_BYTES, flag ? Boolean.TRUE : null);
    }
}

