/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.ex.DisposableIterator;
import com.intellij.openapi.editor.impl.Interval;
import com.intellij.openapi.editor.impl.IntervalTree;
import com.intellij.openapi.editor.impl.MutableInterval;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.editor.impl.TextRangeInterval;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.WalkingState;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import gnu.trove.TLongHashSet;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class IntervalTreeImpl<T extends MutableInterval>
extends RedBlackTree<T>
implements IntervalTree<T> {
    private int keySize;
    protected final ReadWriteLock l = new ReentrantReadWriteLock();
    private final ReferenceQueue<T> myReferenceQueue = new ReferenceQueue();
    private int deadReferenceCount;
    private static final IntervalTreeGuide INTERVAL_TREE_GUIDE_INSTANCE = new IntervalTreeGuide();

    protected abstract int compareEqualStartIntervals(@NotNull IntervalNode<T> var1, @NotNull IntervalNode<T> var2);

    private void assertUnderWriteLock() {
        assert (IntervalTreeImpl.isAcquired(this.l.writeLock())) : this.l.writeLock();
    }

    private static boolean isAcquired(Lock l) {
        String s = l.toString();
        return s.contains("Locked by thread");
    }

    private void pushDeltaFromRoot(IntervalNode<T> node, NodeCachedOffsets cached) {
        if (node != null) {
            node.unpackCachedValuesTo(cached);
            if (cached.allDeltasUpAreNull && node.isValid() && cached.modCount == this.modCount) {
                return;
            }
            this.pushDeltaFromRoot((IntervalNode<T>)node.getParent(), cached);
            this.pushDelta(node, cached);
        }
    }

    @NotNull
    protected abstract IntervalNode<T> createNewNode(@NotNull T var1, int var2, int var3, boolean var4, boolean var5, int var6);

    protected abstract IntervalNode<T> lookupNode(@NotNull T var1);

    protected abstract void setNode(@NotNull T var1, IntervalNode<T> var2);

    private int compareNodes(@NotNull IntervalNode<T> i1, int delta1, @NotNull IntervalNode<T> i2, int delta2, @NotNull List<IntervalNode<T>> invalid) {
        int start2;
        int start1;
        if (i1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.compareNodes must not be null");
        }
        if (i2 == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.compareNodes must not be null");
        }
        if (invalid == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.compareNodes must not be null");
        }
        if (!i2.hasAliveKey(false)) {
            invalid.add(i2);
        }
        if ((start1 = i1.intervalStart() + delta1) != (start2 = i2.intervalStart() + delta2)) {
            return start1 - start2;
        }
        return this.compareEqualStartIntervals(i1, i2);
    }

    protected IntervalNode<T> getRoot() {
        return (IntervalNode)this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(@NotNull Processor<? super T> processor) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.process must not be null");
        }
        try {
            this.l.readLock().lock();
            this.checkMax(true);
            boolean bl = this.process(this.getRoot(), processor, this.modCount);
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private boolean process(IntervalNode<T> root, final Processor<? super T> processor, final int modCountBefore) {
        if (root == null) {
            return true;
        }
        WalkingState.TreeGuide<IntervalNode<T>> guide = IntervalTreeImpl.getGuide();
        return WalkingState.processAll(root, guide, new Processor<IntervalNode<T>>(){

            @Override
            public boolean process(IntervalNode<T> node) {
                if (!node.processAliveKeys(processor)) {
                    return false;
                }
                if (IntervalTreeImpl.this.modCount != modCountBefore) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processOverlappingWith(int start, int end, @NotNull Processor<? super T> processor) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.processOverlappingWith must not be null");
        }
        try {
            this.l.readLock().lock();
            this.checkMax(true);
            boolean bl = this.processOverlappingWith(this.getRoot(), start, end, processor, this.modCount, 0);
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private boolean processOverlappingWith(IntervalNode<T> root, int start, int end, Processor<? super T> processor, int modCountBefore, int deltaUpToRootExclusive) {
        boolean overlaps;
        if (root == null) {
            return true;
        }
        assert (root.isValid());
        int delta = deltaUpToRootExclusive + root.delta;
        if (start > this.maxEndOf(root, deltaUpToRootExclusive)) {
            return true;
        }
        if (!this.processOverlappingWith((IntervalNode<T>)root.getLeft(), start, end, processor, modCountBefore, delta)) {
            return false;
        }
        int myStartOffset = root.intervalStart() + delta;
        int myEndOffset = root.intervalEnd() + delta;
        boolean bl = overlaps = Math.max(myStartOffset, start) <= Math.min(myEndOffset, end);
        if (overlaps) {
            if (!root.processAliveKeys(processor)) {
                return false;
            }
            if (this.modCount != modCountBefore) {
                throw new ConcurrentModificationException();
            }
        }
        if (end < myStartOffset) {
            return true;
        }
        return this.processOverlappingWith((IntervalNode<T>)root.getRight(), start, end, processor, modCountBefore, delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processOverlappingWithOutside(int start, int end, @NotNull Processor<? super T> processor) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.processOverlappingWithOutside must not be null");
        }
        try {
            this.l.readLock().lock();
            this.checkMax(true);
            boolean bl = this.processOverlappingWithOutside(this.getRoot(), start, end, processor, this.modCount, 0);
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private boolean processOverlappingWithOutside(IntervalNode<T> root, int start, int end, @NotNull Processor<? super T> processor, int modCountBefore, int deltaUpToRootExclusive) {
        boolean toProcess;
        if (processor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.processOverlappingWithOutside must not be null");
        }
        if (root == null) {
            return true;
        }
        assert (root.isValid());
        int delta = deltaUpToRootExclusive + root.delta;
        int rootMaxEnd = this.maxEndOf(root, deltaUpToRootExclusive);
        int rootStartOffset = root.intervalStart() + delta;
        int rootEndOffset = root.intervalEnd() + delta;
        if (!this.processOverlappingWithOutside((IntervalNode<T>)root.getLeft(), start, end, processor, modCountBefore, delta)) {
            return false;
        }
        boolean bl = toProcess = rootStartOffset < start || rootEndOffset > end;
        if (toProcess) {
            if (!root.processAliveKeys(processor)) {
                return false;
            }
            if (this.modCount != modCountBefore) {
                throw new ConcurrentModificationException();
            }
        }
        if (rootStartOffset >= start && rootMaxEnd <= end) {
            return true;
        }
        return this.processOverlappingWithOutside((IntervalNode<T>)root.getRight(), start, end, processor, modCountBefore, delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processContaining(int offset, @NotNull Processor<? super T> processor) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.processContaining must not be null");
        }
        try {
            this.l.readLock().lock();
            this.checkMax(true);
            boolean bl = this.processContaining(this.getRoot(), offset, processor, this.modCount, 0);
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private boolean processContaining(IntervalNode<T> root, int offset, Processor<? super T> processor, int modCountBefore, int deltaUpToRootExclusive) {
        boolean overlaps;
        if (root == null) {
            return true;
        }
        assert (root.isValid());
        int delta = deltaUpToRootExclusive + root.delta;
        if (offset > this.maxEndOf(root, deltaUpToRootExclusive)) {
            return true;
        }
        if (!this.processContaining((IntervalNode<T>)root.getLeft(), offset, processor, modCountBefore, delta)) {
            return false;
        }
        int myStartOffset = root.intervalStart() + delta;
        int myEndOffset = root.intervalEnd() + delta;
        boolean bl = overlaps = myStartOffset <= offset && offset < myEndOffset;
        if (overlaps) {
            if (!root.processAliveKeys(processor)) {
                return false;
            }
            if (this.modCount != modCountBefore) {
                throw new ConcurrentModificationException();
            }
        }
        if (offset < myStartOffset) {
            return true;
        }
        return this.processContaining((IntervalNode<T>)root.getRight(), offset, processor, modCountBefore, delta);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    DisposableIterator<T> overlappingIterator(final int startOffset, final int endOffset) {
        DisposableIterator disposableIterator;
        ProperTextRange.assertProperRange(startOffset, endOffset, "");
        final IntervalNode<T> firstOverlap = this.findMinOverlappingWith(this.getRoot(), new TextRangeInterval(startOffset, endOffset), this.modCount, 0);
        if (firstOverlap == null) {
            disposableIterator = DisposableIterator.EMPTY;
            if (disposableIterator == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/IntervalTreeImpl.overlappingIterator must not return null");
            return disposableIterator;
        }
        final int firstOverlapDelta = firstOverlap.computeDeltaUpToRoot();
        final int firstOverlapStart = firstOverlap.intervalStart() + firstOverlapDelta;
        final int modCountBefore = this.modCount;
        this.l.readLock().lock();
        disposableIterator = new DisposableIterator<T>(){
            private IntervalNode<T> currentNode;
            private int deltaUpToRootExclusive;
            private int indexInCurrentList;
            private T current;
            {
                this.currentNode = firstOverlap;
                this.deltaUpToRootExclusive = firstOverlapDelta - firstOverlap.delta;
                this.indexInCurrentList = 0;
            }

            @Override
            public boolean hasNext() {
                MutableInterval t;
                if (this.current != null) {
                    return true;
                }
                if (this.currentNode == null) {
                    return false;
                }
                if (IntervalTreeImpl.this.modCount != modCountBefore) {
                    throw new ConcurrentModificationException();
                }
                while (this.indexInCurrentList != this.currentNode.intervals.size()) {
                    if ((t = (MutableInterval)this.currentNode.intervals.get(this.indexInCurrentList++).get()) == null) continue;
                    this.current = t;
                    return true;
                }
                this.indexInCurrentList = 0;
                while (true) {
                    this.currentNode = this.nextNode(this.currentNode);
                    if (this.currentNode == null) {
                        return false;
                    }
                    if (!IntervalTreeImpl.this.overlaps(this.currentNode, startOffset, endOffset, this.deltaUpToRootExclusive)) continue;
                    assert (this.currentNode.intervalStart() + this.deltaUpToRootExclusive + this.currentNode.delta >= firstOverlapStart);
                    this.indexInCurrentList = 0;
                    while (this.indexInCurrentList != this.currentNode.intervals.size()) {
                        if ((t = (MutableInterval)this.currentNode.intervals.get(this.indexInCurrentList++).get()) == null) continue;
                        this.current = t;
                        return true;
                    }
                    this.indexInCurrentList = 0;
                }
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object t = this.current;
                this.current = null;
                return t;
            }

            @Override
            public void remove() {
                throw new IncorrectOperationException();
            }

            @Override
            public void dispose() {
                IntervalTreeImpl.this.l.readLock().unlock();
            }

            private IntervalNode<T> nextNode(@NotNull IntervalNode<T> root) {
                int rightMaxEnd;
                if (root == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl$2.nextNode must not be null");
                }
                assert (root.isValid()) : root;
                int delta = this.deltaUpToRootExclusive + root.delta;
                int myMaxEnd = IntervalTreeImpl.this.maxEndOf(root, this.deltaUpToRootExclusive);
                if (startOffset > myMaxEnd) {
                    return null;
                }
                RedBlackTree.Node right = root.getRight();
                if (right != null && startOffset <= (rightMaxEnd = IntervalTreeImpl.this.maxEndOf((IntervalNode)right, delta))) {
                    int rightDelta = delta + ((IntervalNode)right).delta;
                    while (((IntervalNode)right).getLeft() != null && startOffset <= IntervalTreeImpl.this.maxEndOf((IntervalNode)((IntervalNode)right).getLeft(), rightDelta)) {
                        right = ((IntervalNode)right).getLeft();
                        rightDelta += ((IntervalNode)right).delta;
                    }
                    this.deltaUpToRootExclusive = rightDelta - ((IntervalNode)right).delta;
                    return right;
                }
                RedBlackTree.Node parent;
                while ((parent = root.getParent()) != null) {
                    if (((IntervalNode)parent).intervalStart() + this.deltaUpToRootExclusive > endOffset) {
                        return null;
                    }
                    this.deltaUpToRootExclusive -= ((IntervalNode)parent).delta;
                    if (((IntervalNode)parent).getLeft() == root) {
                        return parent;
                    }
                    root = parent;
                }
                return null;
            }
        };
        if (disposableIterator != null) return disposableIterator;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/IntervalTreeImpl.overlappingIterator must not return null");
    }

    private boolean overlaps(IntervalNode<T> root, int startOffset, int endOffset, int deltaUpToRootExclusive) {
        if (root == null) {
            return false;
        }
        int delta = root.delta + deltaUpToRootExclusive;
        int start = root.intervalStart() + delta;
        int end = root.intervalEnd() + delta;
        return Math.max(start, startOffset) <= Math.min(end, endOffset);
    }

    private IntervalNode<T> previous(@NotNull IntervalNode<T> node) {
        RedBlackTree.Node parent;
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.previous must not be null");
        }
        RedBlackTree.Node left = node.getLeft();
        if (left != null) {
            while (((IntervalNode)left).getRight() != null) {
                left = ((IntervalNode)left).getRight();
            }
            return left;
        }
        for (parent = node.getParent(); parent != null && ((IntervalNode)parent).getRight() != node; parent = ((IntervalNode)parent).getParent()) {
            node = parent;
        }
        return parent;
    }

    protected IntervalNode<T> findOrInsert(@NotNull IntervalNode<T> node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.findOrInsert must not be null");
        }
        this.assertUnderWriteLock();
        node.color = RedBlackTree.Color.RED;
        node.setParent(null);
        node.setValid(true);
        node.maxEnd = 0;
        node.clearDelta();
        node.setLeft(null);
        node.setRight(null);
        SmartList<IntervalNode<T>> gced = new SmartList<IntervalNode<T>>();
        NodeCachedOffsets cached = new NodeCachedOffsets();
        if (this.root == null) {
            this.root = node;
        } else {
            RedBlackTree.Node current = this.getRoot();
            while (true) {
                this.pushDelta((IntervalNode<T>)current, cached);
                int compResult = this.compareNodes(node, 0, (IntervalNode<T>)current, 0, (List<IntervalNode<T>>)gced);
                if (compResult == 0) {
                    return current;
                }
                if (compResult < 0) {
                    if (current.getLeft() == null) {
                        current.setLeft(node);
                        break;
                    }
                    current = current.getLeft();
                    continue;
                }
                if (current.getRight() == null) {
                    current.setRight(node);
                    break;
                }
                current = current.getRight();
            }
            node.setParent(current);
        }
        ((IntervalNode)node).setCachedValues(0, true, this.modCount);
        this.correctMaxUp(node, cached);
        this.onInsertNode();
        this.keySize += node.intervals.size();
        this.insertCase1(node);
        this.verifyProperties();
        this.deleteNodes(gced);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNodes(@NotNull List<IntervalNode<T>> collectedAway) {
        if (collectedAway == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.deleteNodes must not be null");
        }
        if (collectedAway.isEmpty()) {
            return;
        }
        try {
            this.l.writeLock().lock();
            for (IntervalNode<T> node : collectedAway) {
                this.removeNode(node);
            }
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntervalNode<T> addInterval(@NotNull T interval, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (interval == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.addInterval must not be null");
        }
        try {
            this.l.writeLock().lock();
            this.checkMax(true);
            this.processReferenceQueue();
            ++this.modCount;
            IntervalNode<T> newNode = this.createNewNode(interval, start, end, greedyToLeft, greedyToRight, layer);
            IntervalNode<T> insertedNode = this.findOrInsert(newNode);
            if (insertedNode == newNode) {
                this.setNode(interval, insertedNode);
            } else {
                insertedNode.addInterval(interval);
            }
            this.checkMax(true);
            this.checkBelongsToTheTree(interval, true);
            IntervalNode<T> intervalNode = insertedNode;
            return intervalNode;
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkMax(boolean assertInvalid) {
        if (!VERIFY) {
            return false;
        }
        try {
            this.l.readLock().lock();
            Ref<Boolean> allValid = new Ref<Boolean>(true);
            int[] keyCounter = new int[1];
            int[] nodeCounter = new int[1];
            TLongHashSet ids = new TLongHashSet(this.keySize);
            this.checkMax(this.getRoot(), 0, assertInvalid, allValid, keyCounter, nodeCounter, ids, true);
            if (assertInvalid) {
                assert (this.nodeSize() == nodeCounter[0]) : "node size: " + this.nodeSize() + "; actual: " + nodeCounter[0];
                assert (this.keySize == keyCounter[0]) : "key size: " + this.keySize + "; actual: " + keyCounter[0];
                assert (this.keySize >= this.nodeSize()) : this.keySize + "; " + this.nodeSize();
            }
            boolean bl = allValid.get();
            return bl;
        }
        finally {
            this.l.readLock().unlock();
        }
    }

    private Trinity<Integer, Integer, Integer> checkMax(IntervalNode<T> root, int deltaUpToRootExclusive, boolean assertInvalid, Ref<Boolean> allValid, int[] keyCounter, int[] nodeCounter, TLongHashSet ids, boolean allDeltasUpAreNull) {
        if (root == null) {
            return Trinity.create(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        NodeCachedOffsets cached = new NodeCachedOffsets();
        root.unpackCachedValuesTo(cached);
        if (cached.modCount == this.modCount) {
            assert (cached.allDeltasUpAreNull == (root.delta == 0 && allDeltasUpAreNull));
            assert (cached.deltaUpToRoot == root.delta + deltaUpToRootExclusive);
        }
        MutableInterval liveInterval = null;
        for (int i = root.intervals.size() - 1; i >= 0; --i) {
            MutableInterval t = (MutableInterval)root.intervals.get(i).get();
            if (t == null) continue;
            liveInterval = t;
            this.checkBelongsToTheTree(t, false);
            boolean added = ids.add(((RangeMarkerImpl)t).getId());
            assert (added) : t;
        }
        if (assertInvalid && liveInterval != null) {
            this.checkBelongsToTheTree(liveInterval, true);
        }
        keyCounter[0] = keyCounter[0] + root.intervals.size();
        nodeCounter[0] = nodeCounter[0] + 1;
        int delta = deltaUpToRootExclusive + (root.isValid() ? root.delta : 0);
        Trinity<Integer, Integer, Integer> l = this.checkMax((IntervalNode<T>)root.getLeft(), delta, assertInvalid, allValid, keyCounter, nodeCounter, ids, root.delta == 0 && allDeltasUpAreNull);
        int minLeftStart = (Integer)l.first;
        int maxLeftStart = (Integer)l.second;
        int maxLeftEnd = (Integer)l.third;
        Trinity<Integer, Integer, Integer> r = this.checkMax((IntervalNode<T>)root.getRight(), delta, assertInvalid, allValid, keyCounter, nodeCounter, ids, root.delta == 0 && allDeltasUpAreNull);
        int maxRightEnd = (Integer)r.third;
        int minRightStart = (Integer)r.first;
        int maxRightStart = (Integer)r.second;
        if (!root.isValid()) {
            allValid.set(false);
            if (assertInvalid) assert (false) : root;
            return Trinity.create(Math.min(minLeftStart, minRightStart), Math.max(maxLeftStart, maxRightStart), Math.max(maxRightEnd, maxLeftEnd));
        }
        RedBlackTree.Node parent = root.getParent();
        if (parent != null && assertInvalid && root.hasAliveKey(false)) {
            int c = this.compareNodes(root, delta, (IntervalNode<T>)parent, delta - root.delta, (List<IntervalNode<T>>)new SmartList<IntervalNode<T>>());
            assert (c != 0);
            assert (c < 0 && ((IntervalNode)parent).getLeft() == root || c > 0 && ((IntervalNode)parent).getRight() == root);
        }
        assert (delta + root.maxEnd == Math.max(maxLeftEnd, Math.max(maxRightEnd, delta + root.intervalEnd())));
        int myStartOffset = delta + root.intervalStart();
        assert (maxLeftStart <= myStartOffset);
        assert (minRightStart >= myStartOffset);
        assert (myStartOffset >= 0);
        assert (minLeftStart == Integer.MAX_VALUE || minLeftStart <= myStartOffset);
        assert (maxRightStart == Integer.MIN_VALUE || maxRightStart >= myStartOffset);
        int minStart = Math.min(minLeftStart, myStartOffset);
        int maxStart = Math.max(myStartOffset, Math.max(maxLeftStart, maxRightStart));
        assert (minStart <= maxStart);
        return Trinity.create(minStart, maxStart, root.maxEnd + delta);
    }

    @Override
    protected RedBlackTree.Node<T> maximumNode(RedBlackTree.Node<T> n) {
        RedBlackTree.Node root = (IntervalNode)n;
        NodeCachedOffsets cached = new NodeCachedOffsets();
        this.pushDelta((IntervalNode<T>)root.getParent(), cached);
        this.pushDelta((IntervalNode<T>)root, cached);
        while (root.getRight() != null) {
            root = root.getRight();
            this.pushDelta((IntervalNode<T>)root, cached);
        }
        return root;
    }

    protected void checkBelongsToTheTree(T interval, boolean assertInvalid) {
        IntervalNode<T> root = this.lookupNode(interval);
        if (root == null) {
            return;
        }
        assert (root.getTree() == this) : root.getTree() + "; this: " + this;
        if (!VERIFY) {
            return;
        }
        if (assertInvalid) {
            assert (!root.intervals.isEmpty());
            boolean contains = false;
            for (int i = root.intervals.size() - 1; i >= 0; --i) {
                MutableInterval key = (MutableInterval)root.intervals.get(i).get();
                if (key == null) continue;
                contains |= key == interval;
                IntervalNode<MutableInterval> node = this.lookupNode(key);
                assert (node == root) : node;
                assert (node.getTree() == this) : node;
            }
            assert (contains) : root.intervals + "; " + interval;
        }
        RedBlackTree.Node e = root;
        while (e.getParent() != null) {
            e = e.getParent();
        }
        assert (e == this.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeInterval(@NotNull T interval) {
        if (interval == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.removeInterval must not be null");
        }
        if (!interval.isValid()) {
            return false;
        }
        try {
            this.l.writeLock().lock();
            ++this.modCount;
            if (!interval.isValid()) {
                boolean bl = false;
                return bl;
            }
            this.checkBelongsToTheTree(interval, true);
            this.checkMax(true);
            this.processReferenceQueue();
            IntervalNode<T> node = this.lookupNode(interval);
            if (node == null) {
                boolean bl = false;
                return bl;
            }
            this.reportInvalidation(interval, "Explicit Dispose");
            ((IntervalNode)node).removeInterval(interval);
            this.setNode(interval, null);
            this.checkMax(true);
            boolean bl = true;
            return bl;
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    void removeNode(@NotNull IntervalNode<T> node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.removeNode must not be null");
        }
        this.deleteNode((RedBlackTree.Node<T>)node);
        RedBlackTree.Node parent = node.getParent();
        this.correctMaxUp((IntervalNode<T>)parent, new NodeCachedOffsets());
    }

    @Override
    protected void deleteNode(@NotNull RedBlackTree.Node<T> n) {
        if (n == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.deleteNode must not be null");
        }
        this.assertUnderWriteLock();
        IntervalNode node = (IntervalNode)n;
        NodeCachedOffsets cached = new NodeCachedOffsets();
        this.pushDeltaFromRoot(node, cached);
        this.assertAllDeltasAreNull(node, cached);
        super.deleteNode(n);
        this.keySize -= node.intervals.size();
        assert (this.keySize >= 0) : this.keySize;
    }

    @Override
    public int size() {
        return this.keySize;
    }

    protected boolean pushDelta(IntervalNode<T> root, NodeCachedOffsets cached) {
        if (root == null || !root.isValid()) {
            return true;
        }
        RedBlackTree.Node parent = root.getParent();
        this.assertAllDeltasAreNull((IntervalNode<T>)parent, cached);
        int delta = root.delta;
        ((IntervalNode)root).setCachedValues(0, true, 0);
        if (delta != 0) {
            root.setIntervalStart(root.intervalStart() + delta);
            root.setIntervalEnd(root.intervalEnd() + delta);
            root.maxEnd += delta;
            root.delta = 0;
            return this.incDelta((IntervalNode<T>)root.getLeft(), delta) & this.incDelta((IntervalNode<T>)root.getRight(), delta);
        }
        ((IntervalNode)root).setCachedValues(0, true, this.modCount);
        return true;
    }

    private boolean incDelta(IntervalNode<T> root, int delta) {
        if (root == null) {
            return true;
        }
        if (root.isValid()) {
            int newDelta = root.changeDelta(delta);
            return newDelta == 0;
        }
        return this.incDelta((IntervalNode<T>)root.getLeft(), delta) & this.incDelta((IntervalNode<T>)root.getRight(), delta);
    }

    @Override
    protected IntervalNode<T> swapWithMaxPred(RedBlackTree.Node<T> root, RedBlackTree.Node<T> maxPred) {
        this.checkMax(false);
        IntervalNode a = (IntervalNode)root;
        IntervalNode d = (IntervalNode)maxPred;
        RedBlackTree.Color acolor = a.color;
        RedBlackTree.Color dcolor = d.color;
        assert (!a.isValid() || a.delta == 0) : a.delta;
        for (RedBlackTree.Node n = a.getLeft(); n != null; n = ((IntervalNode)n).getRight()) {
            assert (!((IntervalNode)n).isValid() || ((IntervalNode)n).delta == 0) : ((IntervalNode)n).delta;
        }
        this.swapNodes(a, d);
        a.setValid(false);
        a.color = dcolor;
        d.color = acolor;
        this.correctMaxUp(a, new NodeCachedOffsets());
        this.checkMax(false);
        assert (a.delta == 0) : a.delta;
        assert (d.delta == 0) : d.delta;
        return a;
    }

    private void swapNodes(IntervalNode<T> n1, IntervalNode<T> n2) {
        RedBlackTree.Node l1 = n1.getLeft();
        RedBlackTree.Node r1 = n1.getRight();
        IntervalNode<T> p1 = n1.getParent();
        IntervalNode<T> l2 = n2.getLeft();
        IntervalNode<T> r2 = n2.getRight();
        RedBlackTree.Node p2 = n2.getParent();
        if (p1 != null) {
            if (p1.getLeft() == n1) {
                p1.setLeft(n2);
            } else {
                p1.setRight(n2);
            }
        } else {
            this.root = n2;
        }
        if (p2 != null) {
            if (((IntervalNode)p2).getLeft() == n2) {
                p2.setLeft(p2 == n1 ? l2 : n1);
            } else {
                p2.setRight(p2 == n1 ? r2 : n1);
            }
        } else {
            this.root = n1;
        }
        n1.setParent(p2 == n1 ? n2 : p2);
        n2.setParent(p1);
        n1.setLeft(l2);
        n2.setLeft(l1 == n2 ? n1 : l1);
        if (l1 != null) {
            l1.setParent(n2 == l1 ? p1 : n2);
        }
        if (r1 != null) {
            r1.setParent(n2);
        }
        n1.setRight(r2);
        n2.setRight(r1);
        if (l2 != null) {
            l2.setParent(n1);
        }
        if (r2 != null) {
            r2.setParent(n1);
        }
    }

    private int maxEndOf(IntervalNode<T> node, int deltaUpToRootExclusive) {
        if (node == null) {
            return 0;
        }
        if (node.isValid()) {
            return node.maxEnd + node.delta + deltaUpToRootExclusive;
        }
        return Math.max(this.maxEndOf((IntervalNode<T>)node.getLeft(), deltaUpToRootExclusive), this.maxEndOf((IntervalNode<T>)node.getRight(), deltaUpToRootExclusive));
    }

    protected void correctMax(@NotNull IntervalNode<T> node, int deltaUpToRoot) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.correctMax must not be null");
        }
        if (!node.isValid()) {
            return;
        }
        int realMax = Math.max(Math.max(this.maxEndOf((IntervalNode<T>)node.getLeft(), deltaUpToRoot), this.maxEndOf((IntervalNode<T>)node.getRight(), deltaUpToRoot)), deltaUpToRoot + node.intervalEnd());
        node.maxEnd = realMax - deltaUpToRoot;
    }

    private void correctMaxUp(IntervalNode<T> node, NodeCachedOffsets cached) {
        int delta;
        int n = delta = node == null ? 0 : node.computeDeltaUpToRoot(cached);
        assert (delta == 0) : delta;
        while (node != null) {
            if (node.isValid()) {
                int d = node.delta;
                this.correctMax((IntervalNode<T>)node, delta);
                delta -= d;
            }
            node = node.getParent();
        }
        assert (delta == 0) : delta;
    }

    @Override
    protected void rotateRight(RedBlackTree.Node<T> n) {
        this.checkMax(false);
        IntervalNode node1 = (IntervalNode)n;
        RedBlackTree.Node node2 = node1.getLeft();
        RedBlackTree.Node node3 = node1.getRight();
        NodeCachedOffsets cached = new NodeCachedOffsets();
        RedBlackTree.Node parent = node1.getParent();
        int deltaUp = parent == null ? 0 : ((IntervalNode)parent).computeDeltaUpToRoot(cached);
        this.pushDelta(node1, cached);
        this.pushDelta((IntervalNode<T>)node2, cached);
        this.pushDelta((IntervalNode<T>)node3, cached);
        super.rotateRight(node1);
        if (node3 != null) {
            this.correctMax((IntervalNode<T>)node3, deltaUp);
        }
        this.correctMax(node1, deltaUp);
        this.correctMax((IntervalNode<T>)node2, deltaUp);
        this.assertAllDeltasAreNull(node1, cached);
        this.assertAllDeltasAreNull((IntervalNode<T>)node2, cached);
        this.assertAllDeltasAreNull((IntervalNode<T>)node3, cached);
        this.checkMax(false);
    }

    @Override
    protected void rotateLeft(RedBlackTree.Node<T> n) {
        this.checkMax(false);
        IntervalNode node1 = (IntervalNode)n;
        RedBlackTree.Node node2 = node1.getLeft();
        RedBlackTree.Node node3 = node1.getRight();
        NodeCachedOffsets cached = new NodeCachedOffsets();
        RedBlackTree.Node parent = node1.getParent();
        int deltaUp = parent == null ? 0 : ((IntervalNode)parent).computeDeltaUpToRoot(cached);
        this.pushDelta(node1, cached);
        this.pushDelta((IntervalNode<T>)node2, cached);
        this.pushDelta((IntervalNode<T>)node3, cached);
        this.checkMax(false);
        super.rotateLeft(node1);
        if (node2 != null) {
            this.correctMax((IntervalNode<T>)node2, deltaUp);
        }
        this.correctMax(node1, deltaUp);
        this.correctMax((IntervalNode<T>)node3, deltaUp);
        this.assertAllDeltasAreNull(node1, cached);
        this.assertAllDeltasAreNull((IntervalNode<T>)node2, cached);
        this.assertAllDeltasAreNull((IntervalNode<T>)node3, cached);
        this.checkMax(false);
    }

    @Override
    protected void replaceNode(@NotNull RedBlackTree.Node<T> node, RedBlackTree.Node<T> child) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl.replaceNode must not be null");
        }
        IntervalNode myNode = (IntervalNode)node;
        NodeCachedOffsets cached = new NodeCachedOffsets();
        this.pushDelta(myNode, cached);
        this.pushDelta((IntervalNode)child, cached);
        super.replaceNode(node, child);
        if (child != null && myNode.isValid()) {
            ((IntervalNode)child).changeDelta(myNode.delta);
        }
    }

    private void assertAllDeltasAreNull(IntervalNode<T> node, NodeCachedOffsets cached) {
        if (node == null) {
            return;
        }
        if (!node.isValid()) {
            return;
        }
        assert (node.delta == 0);
        node.unpackCachedValuesTo(cached);
        assert (cached.modCount != this.modCount || cached.allDeltasUpAreNull);
    }

    private IntervalNode<T> findMinOverlappingWith(IntervalNode<T> root, Interval interval, int modCountBefore, int deltaUpToRootExclusive) {
        boolean overlaps;
        if (root == null) {
            return null;
        }
        assert (root.isValid());
        int delta = deltaUpToRootExclusive + root.delta;
        if (interval.intervalStart() > this.maxEndOf(root, deltaUpToRootExclusive)) {
            return null;
        }
        IntervalNode<T> inLeft = this.findMinOverlappingWith((IntervalNode<T>)root.getLeft(), interval, modCountBefore, delta);
        if (inLeft != null) {
            return inLeft;
        }
        int myStartOffset = root.intervalStart() + delta;
        int myEndOffset = root.intervalEnd() + delta;
        boolean bl = overlaps = Math.max(myStartOffset, interval.intervalStart()) <= Math.min(myEndOffset, interval.intervalEnd());
        if (overlaps) {
            return root;
        }
        if (this.modCount != modCountBefore) {
            throw new ConcurrentModificationException();
        }
        if (interval.intervalEnd() < myStartOffset) {
            return null;
        }
        return this.findMinOverlappingWith((IntervalNode<T>)root.getRight(), interval, modCountBefore, delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeData(T interval, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        try {
            this.l.writeLock().lock();
            IntervalNode<T> node = this.lookupNode(interval);
            if (node == null) {
                return;
            }
            int before = this.size();
            boolean nodeRemoved = ((IntervalNode)node).removeInterval(interval);
            assert (nodeRemoved || !node.intervals.isEmpty());
            IntervalNode<T> insertedNode = this.addInterval(interval, start, end, greedyToLeft, greedyToRight, layer);
            assert (node != insertedNode);
            int after = this.size();
            assert (before >= after) : before + ";" + after;
            this.checkBelongsToTheTree(interval, true);
            this.checkMax(true);
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    private void processReferenceQueue() {
        int dead = 0;
        while (this.myReferenceQueue.poll() != null) {
            ++dead;
        }
        this.deadReferenceCount += dead;
        if (this.deadReferenceCount > Math.max(1, this.size() / 3)) {
            this.purgeDeadNodes();
            this.deadReferenceCount = 0;
        }
    }

    private void purgeDeadNodes() {
        this.assertUnderWriteLock();
        SmartList<IntervalNode<T>> gced = new SmartList<IntervalNode<T>>();
        this.collectGced(this.getRoot(), gced);
        this.deleteNodes(gced);
        this.checkMax(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.process(new Processor<T>(){

            @Override
            public boolean process(T t) {
                IntervalTreeImpl.this.reportInvalidation(t, "Clear all");
                return true;
            }
        });
        this.l.writeLock().lock();
        try {
            super.clear();
            this.keySize = 0;
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    private void collectGced(IntervalNode<T> root, List<IntervalNode<T>> gced) {
        if (root == null) {
            return;
        }
        if (!root.hasAliveKey(true)) {
            gced.add(root);
        }
        this.collectGced((IntervalNode<T>)root.getLeft(), gced);
        this.collectGced((IntervalNode<T>)root.getRight(), gced);
    }

    private void printSorted() {
        this.printSorted(this.getRoot());
    }

    private void printSorted(IntervalNode<T> root) {
        if (root == null) {
            return;
        }
        this.printSorted((IntervalNode<T>)root.getLeft());
        System.out.println(root);
        this.printSorted((IntervalNode<T>)root.getRight());
    }

    void reportInvalidation(T markerEx, @NonNls Object reason) {
    }

    private static <T extends MutableInterval> WalkingState.TreeGuide<IntervalNode<T>> getGuide() {
        return INTERVAL_TREE_GUIDE_INSTANCE;
    }

    public int maxHeight() {
        return this.maxHeight(this.root);
    }

    private int maxHeight(RedBlackTree.Node<T> root) {
        return root == null ? 0 : 1 + Math.max(this.maxHeight(root.left), this.maxHeight(root.right));
    }

    private static class IntervalTreeGuide<T extends MutableInterval>
    implements WalkingState.TreeGuide<IntervalNode<T>> {
        private IntervalTreeGuide() {
        }

        @Override
        public IntervalNode<T> getNextSibling(@NotNull IntervalNode<T> element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalTreeGuide.getNextSibling must not be null");
            }
            RedBlackTree.Node parent = element.getParent();
            if (parent == null) {
                return null;
            }
            return ((IntervalNode)parent).getLeft() == element ? ((IntervalNode)parent).getRight() : null;
        }

        @Override
        public IntervalNode<T> getPrevSibling(@NotNull IntervalNode<T> element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalTreeGuide.getPrevSibling must not be null");
            }
            RedBlackTree.Node parent = element.getParent();
            if (parent == null) {
                return null;
            }
            return ((IntervalNode)parent).getRight() == element ? ((IntervalNode)parent).getLeft() : null;
        }

        @Override
        public IntervalNode<T> getFirstChild(@NotNull IntervalNode<T> element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalTreeGuide.getFirstChild must not be null");
            }
            RedBlackTree.Node left = element.getLeft();
            return left == null ? element.getRight() : left;
        }

        @Override
        public IntervalNode<T> getParent(@NotNull IntervalNode<T> element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalTreeGuide.getParent must not be null");
            }
            return element.getParent();
        }
    }

    static class NodeCachedOffsets {
        private int modCount;
        private int deltaUpToRoot;
        private boolean allDeltasUpAreNull;

        NodeCachedOffsets() {
        }
    }

    protected static class IntervalNode<E extends MutableInterval>
    extends RedBlackTree.Node<E>
    implements MutableInterval {
        private volatile int myStart;
        private volatile int myEnd;
        private volatile boolean isValid;
        protected final List<Getter<E>> intervals;
        protected int maxEnd;
        protected int delta;
        private volatile long cachedDeltaUpToRoot;
        private final IntervalTreeImpl<E> myIntervalTree;
        private static AtomicFieldUpdater<IntervalNode, Long> cachedDeltaUpdater = AtomicFieldUpdater.forLongField(IntervalNode.class);

        public IntervalNode(IntervalTreeImpl<E> intervalTree, @NotNull E key, int start, int end) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode.<init> must not be null");
            }
            this.isValid = true;
            this.myIntervalTree = intervalTree;
            this.myStart = start;
            this.myEnd = end;
            this.intervals = new SmartList<Getter<Getter<E>>>(this.createGetter(key));
        }

        @Override
        public IntervalNode<E> getLeft() {
            return (IntervalNode)this.left;
        }

        @Override
        public IntervalNode<E> getRight() {
            return (IntervalNode)this.right;
        }

        @Override
        public IntervalNode<E> getParent() {
            return (IntervalNode)this.parent;
        }

        @Override
        public boolean processAliveKeys(@NotNull Processor<? super E> processor) {
            if (processor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode.processAliveKeys must not be null");
            }
            for (int i = 0; i < this.intervals.size(); ++i) {
                Getter<E> interval = this.intervals.get(i);
                MutableInterval key = (MutableInterval)interval.get();
                if (key == null || processor.process(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean hasAliveKey(boolean purgeDead) {
            boolean hasAliveInterval = false;
            for (int i = this.intervals.size() - 1; i >= 0; --i) {
                Getter<E> interval = this.intervals.get(i);
                if (interval.get() != null) {
                    hasAliveInterval = true;
                    if (!purgeDead) break;
                    continue;
                }
                if (!purgeDead) continue;
                ((IntervalTreeImpl)this.myIntervalTree).assertUnderWriteLock();
                this.removeIntervalInternal(i);
            }
            return hasAliveInterval;
        }

        private boolean removeInterval(@NotNull E key) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode.removeInterval must not be null");
            }
            this.myIntervalTree.checkBelongsToTheTree(key, true);
            ((IntervalTreeImpl)this.myIntervalTree).assertUnderWriteLock();
            for (int i = this.intervals.size() - 1; i >= 0; --i) {
                Getter<E> interval = this.intervals.get(i);
                MutableInterval t = (MutableInterval)interval.get();
                if (t != key) continue;
                this.removeIntervalInternal(i);
                if (this.intervals.isEmpty()) {
                    this.myIntervalTree.removeNode(this);
                    return true;
                }
                return false;
            }
            assert (false) : "interval not found: " + key + "; " + this.intervals;
            return false;
        }

        public void removeIntervalInternal(int i) {
            this.intervals.remove(i);
            assert (((IntervalTreeImpl)this.myIntervalTree).keySize > 0) : IntervalTreeImpl.access$100(this.myIntervalTree);
            ((IntervalTreeImpl)this.myIntervalTree).keySize--;
        }

        public void addInterval(@NotNull E interval) {
            if (interval == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode.addInterval must not be null");
            }
            ((IntervalTreeImpl)this.myIntervalTree).assertUnderWriteLock();
            this.intervals.add(this.createGetter(interval));
            ((IntervalTreeImpl)this.myIntervalTree).keySize++;
            this.myIntervalTree.setNode(interval, this);
        }

        protected Getter<E> createGetter(@NotNull E interval) {
            if (interval == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/IntervalTreeImpl$IntervalNode.createGetter must not be null");
            }
            return new WeakReferencedGetter<E>(interval, ((IntervalTreeImpl)this.myIntervalTree).myReferenceQueue);
        }

        protected int computeDeltaUpToRoot() {
            return this.computeDeltaUpToRoot(new NodeCachedOffsets());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int computeDeltaUpToRoot(NodeCachedOffsets cached) {
            block7: while (this.isValid()) {
                int treeModCount = this.myIntervalTree.modCount;
                this.unpackCachedValuesTo(cached);
                if (cached.modCount == treeModCount) {
                    return cached.deltaUpToRoot;
                }
                try {
                    boolean allDeltasAreNull;
                    int deltaUp;
                    block17: {
                        this.myIntervalTree.l.readLock().lock();
                        RedBlackTree.Node node = this;
                        IntervalNode<E> treeRoot = this.myIntervalTree.getRoot();
                        if (treeRoot == null) {
                            int n = this.delta;
                            return n;
                        }
                        deltaUp = 0;
                        allDeltasAreNull = true;
                        int height = 0;
                        long path = 0L;
                        while (node != treeRoot) {
                            ((IntervalNode)node).unpackCachedValuesTo(cached);
                            if (((IntervalNode)node).isValid() && cached.modCount == treeModCount) {
                                deltaUp = cached.deltaUpToRoot - ((IntervalNode)node).delta;
                                allDeltasAreNull = cached.allDeltasUpAreNull;
                                break;
                            }
                            RedBlackTree.Node parent = ((IntervalNode)node).getParent();
                            if (parent == null) {
                                int n = deltaUp;
                                return n;
                            }
                            path = path << 1 | (long)(((IntervalNode)parent).getLeft() == node ? 0 : 1);
                            node = parent;
                            ++height;
                        }
                        assert (height < 63) : height;
                        do {
                            int nodeDelta;
                            if (((IntervalNode)node).isValid() && !((IntervalNode)node).tryToSetCachedValues(deltaUp += (nodeDelta = ((IntervalNode)node).delta), allDeltasAreNull &= nodeDelta == 0, treeModCount)) continue block7;
                            if (node == this) break block17;
                            node = (path & 1L) == 0L ? ((IntervalNode)node).getLeft() : ((IntervalNode)node).getRight();
                            path >>= 1;
                        } while (node != null);
                        int n = deltaUp;
                        return n;
                    }
                    assert (deltaUp == 0 || !allDeltasAreNull);
                    int n = deltaUp;
                    return n;
                }
                finally {
                    this.myIntervalTree.l.readLock().unlock();
                    continue;
                }
                break;
            }
            return 0;
        }

        protected int changeDelta(int change) {
            if (change != 0) {
                this.setCachedValues(0, false, 0);
                return this.delta += change;
            }
            return this.delta;
        }

        protected void clearDelta() {
            if (this.delta != 0) {
                this.setCachedValues(0, false, 0);
                this.delta = 0;
            }
        }

        @Override
        public int setIntervalStart(int start) {
            this.myStart = start;
            return this.myStart;
        }

        @Override
        public int setIntervalEnd(int end) {
            this.myEnd = end;
            return this.myEnd;
        }

        @Override
        public boolean isValid() {
            return this.isValid;
        }

        @Override
        public boolean setValid(boolean value) {
            this.isValid = value;
            return this.isValid;
        }

        @Override
        public int intervalStart() {
            return this.myStart;
        }

        @Override
        public int intervalEnd() {
            return this.myEnd;
        }

        public IntervalTreeImpl<E> getTree() {
            return this.myIntervalTree;
        }

        private void setCachedValues(int deltaUpToRoot, boolean allDeltaUpToRootAreNull, int modCount) {
            this.cachedDeltaUpToRoot = IntervalNode.packValues(deltaUpToRoot, allDeltaUpToRootAreNull, modCount);
        }

        private static long packValues(long deltaUpToRoot, boolean allDeltaUpToRootAreNull, int modCount) {
            return deltaUpToRoot << 33 | (allDeltaUpToRootAreNull ? 0x100000000L : 0L) | (long)modCount;
        }

        private boolean tryToSetCachedValues(int deltaUpToRoot, boolean allDeltasUpAreNull, int treeModCount) {
            if (this.myIntervalTree.modCount != treeModCount) {
                return false;
            }
            long newValue = IntervalNode.packValues(deltaUpToRoot, allDeltasUpAreNull, treeModCount);
            long oldValue = this.cachedDeltaUpToRoot;
            return cachedDeltaUpdater.compareAndSetLong(this, oldValue, newValue);
        }

        public void unpackCachedValuesTo(NodeCachedOffsets t) {
            long value = this.cachedDeltaUpToRoot;
            t.deltaUpToRoot = (int)(value >> 33);
            t.modCount = (int)value;
            t.allDeltasUpAreNull = (value >> 32 & 1L) != 0L;
        }

        @NonNls
        public String toString() {
            return "Node: " + this.intervals;
        }

        private static class WeakReferencedGetter<T>
        extends WeakReference<T>
        implements Getter<T> {
            public WeakReferencedGetter(T referent, ReferenceQueue<? super T> q) {
                super(referent, q);
            }

            @NonNls
            public String toString() {
                return "Ref: " + this.get();
            }
        }
    }
}

