/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.CharArray;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.editor.impl.PersistentRangeMarker;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentImpl
extends UserDataHolderBase
implements DocumentEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.impl.DocumentImpl");
    private final CopyOnWriteArrayList<DocumentListener> myDocumentListeners = ContainerUtil.createEmptyCOWList();
    private final RangeMarkerTree<RangeMarkerEx> myRangeMarkers = new RangeMarkerTree(this);
    private final List<RangeMarker> myGuardedBlocks = new ArrayList<RangeMarker>();
    private ReadonlyFragmentModificationHandler myReadonlyFragmentModificationHandler;
    private final LineSet myLineSet = new LineSet();
    private final CharArray myText = new MyCharArray();
    private boolean myIsReadOnly = false;
    private boolean isStripTrailingSpacesEnabled = true;
    private volatile long myModificationStamp;
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    private DocumentListener[] myCachedDocumentListeners;
    private final List<EditReadOnlyListener> myReadOnlyListeners = ContainerUtil.createEmptyCOWList();
    private int myCheckGuardedBlocks = 0;
    private boolean myGuardsSuppressed = false;
    private boolean myEventsHandling = false;
    private final boolean myAssertWriteAccess;
    private volatile boolean myDoingBulkUpdate = false;
    private boolean myAcceptSlashR = false;
    private boolean myChangeInProgress;

    public DocumentImpl(String text) {
        this((CharSequence)text);
    }

    public DocumentImpl(CharSequence chars) {
        this();
        this.assertValidSeparators(chars);
        this.myText.setText(this, chars);
        DocumentEventImpl event = new DocumentEventImpl(this, 0, null, null, -1L, true);
        this.myLineSet.documentCreated(event);
    }

    private DocumentImpl() {
        this(false);
    }

    public DocumentImpl(boolean forUseInNonAWTThread) {
        this.setCyclicBufferSize(0);
        this.setModificationStamp(LocalTimeCounter.currentTime());
        this.myAssertWriteAccess = !forUseInNonAWTThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAcceptSlashR(boolean accept) {
        try {
            boolean bl = this.myAcceptSlashR;
            return bl;
        }
        finally {
            this.myAcceptSlashR = accept;
        }
    }

    public char[] getRawChars() {
        return this.myText.getChars();
    }

    @Override
    @NotNull
    public char[] getChars() {
        char[] cArray = CharArrayUtil.fromSequence(this.getCharsSequence());
        if (cArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.getChars must not return null");
        }
        return cArray;
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
        this.isStripTrailingSpacesEnabled = isEnabled;
    }

    public boolean stripTrailingSpaces() {
        return this.stripTrailingSpaces(null, false, false, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stripTrailingSpaces(@Nullable Project project, boolean inChangedLinesOnly, boolean virtualSpaceEnabled, int caretLine, int caretOffset) {
        if (!this.isStripTrailingSpacesEnabled) {
            return true;
        }
        boolean markAsNeedsStrippingLater = false;
        CharSequence text = this.myText.getCharArray();
        RangeMarker caretMarker = caretOffset < 0 || caretOffset > this.getTextLength() ? null : this.createRangeMarker(caretOffset, caretOffset);
        try {
            for (int line = 0; line < this.myLineSet.getLineCount(); ++line) {
                char c;
                if (inChangedLinesOnly && !this.myLineSet.isModified(line)) continue;
                int whiteSpaceStart = -1;
                final int lineEnd = this.myLineSet.getLineEnd(line) - this.myLineSet.getSeparatorLength(line);
                int lineStart = this.myLineSet.getLineStart(line);
                int offset = lineEnd - 1;
                while (offset >= lineStart && ((c = text.charAt(offset)) == ' ' || c == '\t')) {
                    whiteSpaceStart = offset--;
                }
                if (whiteSpaceStart == -1) continue;
                if (!virtualSpaceEnabled && caretLine == line && caretMarker != null && caretMarker.getStartOffset() >= 0 && whiteSpaceStart < caretMarker.getStartOffset()) {
                    markAsNeedsStrippingLater = true;
                    continue;
                }
                final int finalStart = whiteSpaceStart;
                ApplicationManager.getApplication().runWriteAction(new DocumentRunnable(this, project){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                            @Override
                            public void run() {
                                DocumentImpl.this.deleteString(finalStart, lineEnd);
                            }
                        });
                    }
                });
                text = this.myText.getCharArray();
            }
        }
        finally {
            if (caretMarker != null) {
                caretMarker.dispose();
            }
        }
        return markAsNeedsStrippingLater;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        if (this.myIsReadOnly != isReadOnly) {
            this.myIsReadOnly = isReadOnly;
            this.myPropertyChangeSupport.firePropertyChange("writable", !isReadOnly, isReadOnly);
        }
    }

    public ReadonlyFragmentModificationHandler getReadonlyFragmentModificationHandler() {
        return this.myReadonlyFragmentModificationHandler;
    }

    public void setReadonlyFragmentModificationHandler(ReadonlyFragmentModificationHandler readonlyFragmentModificationHandler) {
        this.myReadonlyFragmentModificationHandler = readonlyFragmentModificationHandler;
    }

    @Override
    public boolean isWritable() {
        return !this.myIsReadOnly;
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.removeRangeMarker must not be null");
        }
        return this.myRangeMarkers.removeInterval(rangeMarker);
    }

    public void addRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.addRangeMarker must not be null");
        }
        this.myRangeMarkers.addInterval(rangeMarker, start, end, greedyToLeft, greedyToRight, layer);
    }

    public int getRangeMarkersSize() {
        return this.myRangeMarkers.size();
    }

    public int getRangeMarkersNodeSize() {
        return this.myRangeMarkers.nodeSize();
    }

    @Override
    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        LOG.assertTrue(startOffset <= endOffset, "Should be startOffset <= endOffset");
        RangeMarker block = this.createRangeMarker(startOffset, endOffset, true);
        this.myGuardedBlocks.add(block);
        RangeMarker rangeMarker = block;
        if (rangeMarker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.createGuardedBlock must not return null");
        }
        return rangeMarker;
    }

    @Override
    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.removeGuardedBlock must not be null");
        }
        this.myGuardedBlocks.remove(block);
    }

    @Override
    @NotNull
    public List<RangeMarker> getGuardedBlocks() {
        List<RangeMarker> list = this.myGuardedBlocks;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.getGuardedBlocks must not return null");
        }
        return list;
    }

    @Override
    public RangeMarker getOffsetGuard(int offset) {
        for (int i = 0; i < this.myGuardedBlocks.size(); ++i) {
            RangeMarker block = this.myGuardedBlocks.get(i);
            if (!DocumentImpl.offsetInRange(offset, block.getStartOffset(), block.getEndOffset())) continue;
            return block;
        }
        return null;
    }

    @Override
    public RangeMarker getRangeGuard(int start, int end) {
        for (RangeMarker block : this.myGuardedBlocks) {
            if (!DocumentImpl.rangesIntersect(start, true, block.getStartOffset(), block.isGreedyToLeft(), end, true, block.getEndOffset(), block.isGreedyToRight())) continue;
            return block;
        }
        return null;
    }

    @Override
    public void startGuardedBlockChecking() {
        ++this.myCheckGuardedBlocks;
    }

    @Override
    public void stopGuardedBlockChecking() {
        LOG.assertTrue(this.myCheckGuardedBlocks > 0, "Unpaired start/stopGuardedBlockChecking");
        --this.myCheckGuardedBlocks;
    }

    private static boolean offsetInRange(int offset, int start, int end) {
        return start <= offset && offset < end;
    }

    private static boolean rangesIntersect(int start0, boolean leftInclusive0, int start1, boolean leftInclusive1, int end0, boolean rightInclusive0, int end1, boolean rightInclusive1) {
        if (start0 > start1 || start0 == start1 && !leftInclusive0) {
            return DocumentImpl.rangesIntersect(start1, leftInclusive1, start0, leftInclusive0, end1, rightInclusive1, end0, rightInclusive0);
        }
        if (end0 == start1) {
            return leftInclusive1 && rightInclusive0;
        }
        return end0 > start1;
    }

    @Override
    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        RangeMarker rangeMarker = this.createRangeMarker(startOffset, endOffset, false);
        if (rangeMarker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.createRangeMarker must not return null");
        }
        return rangeMarker;
    }

    @Override
    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        if (0 > startOffset || startOffset > endOffset || endOffset > this.getTextLength()) {
            LOG.error("Incorrect offsets: startOffset=" + startOffset + ", endOffset=" + endOffset + ", text length=" + this.getTextLength());
        }
        RangeMarkerImpl rangeMarkerImpl = surviveOnExternalChange ? new PersistentRangeMarker(this, startOffset, endOffset, true) : new RangeMarkerImpl(this, startOffset, endOffset, true);
        if (rangeMarkerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.createRangeMarker must not return null");
        }
        return rangeMarkerImpl;
    }

    @Override
    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myModificationStamp = modificationStamp;
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.replaceText must not be null");
        }
        this.replaceString(0, this.getTextLength(), chars, newModificationStamp, true);
        this.clearLineModificationFlags();
    }

    @Override
    public int getListenersCount() {
        return this.myDocumentListeners.size();
    }

    @Override
    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.insertString must not be null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset);
        }
        if (offset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + "; documentLength: " + this.getTextLength() + "; " + s.subSequence(Math.max(0, s.length() - 20), s.length()));
        }
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        this.assertNotNestedModification();
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException(this);
        }
        if (s.length() == 0) {
            return;
        }
        RangeMarker marker = this.getRangeGuard(offset, offset);
        if (marker != null) {
            this.throwGuardedFragment(marker, offset, null, ((Object)s).toString());
        }
        this.myText.insert(this, s, offset);
    }

    @Override
    public void deleteString(int startOffset, int endOffset) {
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException(this);
        }
        if (startOffset == endOffset) {
            return;
        }
        this.assertNotNestedModification();
        CharSequence sToDelete = this.myText.substring(startOffset, endOffset);
        RangeMarker marker = this.getRangeGuard(startOffset, endOffset);
        if (marker != null) {
            this.throwGuardedFragment(marker, startOffset, ((Object)sToDelete).toString(), null);
        }
        this.myText.remove(this, startOffset, endOffset, sToDelete);
    }

    @Override
    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.replaceString must not be null");
        }
        this.replaceString(startOffset, endOffset, s, LocalTimeCounter.currentTime(), startOffset == 0 && endOffset == this.getTextLength());
    }

    private void replaceString(int startOffset, int endOffset, CharSequence s, long newModificationStamp, boolean wholeTextReplaced) {
        int newStartInString;
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException(this);
        }
        this.assertNotNestedModification();
        int newStringLength = s.length();
        CharSequence chars = this.getCharsSequence();
        int newEndInString = newStringLength;
        for (newStartInString = 0; newStartInString < newStringLength && startOffset < endOffset && s.charAt(newStartInString) == chars.charAt(startOffset); ++startOffset, ++newStartInString) {
        }
        while (endOffset > startOffset && newEndInString > newStartInString && s.charAt(newEndInString - 1) == chars.charAt(endOffset - 1)) {
            --newEndInString;
            --endOffset;
        }
        s = s.subSequence(newStartInString, newEndInString);
        CharSequence sToDelete = this.myText.substring(startOffset, endOffset);
        RangeMarker guard = this.getRangeGuard(startOffset, endOffset);
        if (guard != null) {
            this.throwGuardedFragment(guard, startOffset, ((Object)sToDelete).toString(), ((Object)s).toString());
        }
        this.myText.replace(this, startOffset, endOffset, sToDelete, s, newModificationStamp, wholeTextReplaced);
    }

    private void assertBounds(int startOffset, int endOffset) {
        if (startOffset < 0 || startOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong startOffset: " + startOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < 0 || endOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong endOffset: " + endOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < startOffset) {
            throw new IllegalArgumentException("endOffset < startOffset: " + endOffset + " < " + startOffset + "; documentLength: " + this.getTextLength());
        }
    }

    private void assertWriteAccess() {
        Application application;
        if (this.myAssertWriteAccess && (application = ApplicationManager.getApplication()) != null) {
            application.assertWriteAccessAllowed();
        }
    }

    private void assertValidSeparators(CharSequence s) {
        if (this.myAcceptSlashR) {
            return;
        }
        StringUtil.assertValidSeparators(s);
    }

    private void assertNotNestedModification() throws IllegalStateException {
        if (this.myChangeInProgress) {
            throw new IllegalStateException("Detected nested request for document modification from 'before change' callback!");
        }
    }

    private void throwGuardedFragment(RangeMarker guard, int offset, String oldString, String newString) {
        if (this.myCheckGuardedBlocks > 0 && !this.myGuardsSuppressed) {
            DocumentEventImpl event = new DocumentEventImpl(this, offset, oldString, newString, this.myModificationStamp, false);
            throw new ReadOnlyFragmentModificationException(event, guard);
        }
    }

    @Override
    public void suppressGuardedExceptions() {
        this.myGuardsSuppressed = true;
    }

    @Override
    public void unSuppressGuardedExceptions() {
        this.myGuardsSuppressed = false;
    }

    @Override
    public boolean isInEventsHandling() {
        return this.myEventsHandling;
    }

    @Override
    public void clearLineModificationFlags() {
        this.myLineSet.clearModificationFlags();
    }

    public void clearLineModificationFlagsExcept(int caretLine) {
        boolean wasModified = caretLine != -1 && this.myLineSet.isModified(caretLine);
        this.clearLineModificationFlags();
        if (wasModified) {
            this.myLineSet.setModified(caretLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private DocumentEvent beforeChangedUpdate(int offset, CharSequence oldString, CharSequence newString, boolean wholeTextReplaced) {
        this.myChangeInProgress = true;
        DocumentEvent documentEvent = this.doBeforeChangedUpdate(offset, oldString, newString, wholeTextReplaced);
        DocumentEvent documentEvent2 = documentEvent;
        if (documentEvent2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.beforeChangedUpdate must not return null");
        }
        return documentEvent2;
        finally {
            this.myChangeInProgress = false;
        }
    }

    @NotNull
    private DocumentEvent doBeforeChangedUpdate(int offset, CharSequence oldString, CharSequence newString, boolean wholeTextReplaced) {
        VirtualFile file;
        FileDocumentManager manager = FileDocumentManager.getInstance();
        if (manager != null && (file = manager.getFile(this)) != null && !file.isValid()) {
            LOG.error("File of this document has been deleted.");
        }
        DocumentEventImpl event = new DocumentEventImpl(this, offset, oldString, newString, this.myModificationStamp, wholeTextReplaced);
        if (!ShutDownTracker.isShutdownHookRunning()) {
            DocumentListener[] listeners = this.getCachedListeners();
            for (int i = listeners.length - 1; i >= 0; --i) {
                try {
                    listeners[i].beforeDocumentChange(event);
                    continue;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        this.myEventsHandling = true;
        DocumentEventImpl documentEventImpl = event;
        if (documentEventImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.doBeforeChangedUpdate must not return null");
        }
        return documentEventImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changedUpdate(DocumentEvent event, long newModificationStamp) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(event.toString());
            }
            this.myLineSet.changedUpdate(event);
            this.setModificationStamp(newModificationStamp);
            if (!ShutDownTracker.isShutdownHookRunning()) {
                DocumentListener[] listeners;
                for (DocumentListener listener : listeners = this.getCachedListeners()) {
                    try {
                        listener.documentChanged(event);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }
        }
        finally {
            this.myEventsHandling = false;
        }
    }

    @Override
    public String getText() {
        DocumentImpl.assertReadAccessToDocumentsAllowed();
        return this.myText.toString();
    }

    @Override
    @NotNull
    public String getText(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.getText must not be null");
        }
        DocumentImpl.assertReadAccessToDocumentsAllowed();
        String string = ((Object)this.myText.substring(range.getStartOffset(), range.getEndOffset())).toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.getText must not return null");
        }
        return string;
    }

    @Override
    public int getTextLength() {
        DocumentImpl.assertReadAccessToDocumentsAllowed();
        return this.myText.length();
    }

    private static void assertReadAccessToDocumentsAllowed() {
    }

    CharSequence getCharsNoThreadCheck() {
        return this.myText.getCharArray();
    }

    @Override
    @NotNull
    public CharSequence getCharsSequence() {
        DocumentImpl.assertReadAccessToDocumentsAllowed();
        CharSequence charSequence = this.myText.getCharArray();
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.getCharsSequence must not return null");
        }
        return charSequence;
    }

    @Override
    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.addDocumentListener must not be null");
        }
        this.myCachedDocumentListeners = null;
        boolean added = this.myDocumentListeners.addIfAbsent(listener);
        LOG.assertTrue(added, listener);
    }

    @Override
    public void addDocumentListener(final @NotNull DocumentListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.addDocumentListener must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.addDocumentListener must not be null");
        }
        this.addDocumentListener(listener);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                DocumentImpl.this.removeDocumentListener(listener);
            }
        });
    }

    @Override
    public void removeDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.removeDocumentListener must not be null");
        }
        this.myCachedDocumentListeners = null;
        boolean success = this.myDocumentListeners.remove(listener);
        if (!success) {
            LOG.error(String.format("Can't remove given document listener (%s). Registered listeners: %s", listener, this.myDocumentListeners));
        }
    }

    @Override
    public int getLineNumber(int offset) {
        DocumentImpl.assertReadAccessToDocumentsAllowed();
        int lineIndex = this.myLineSet.findLineIndex(offset);
        assert (lineIndex >= 0);
        return lineIndex;
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        LineIterator lineIterator = this.myLineSet.createIterator();
        if (lineIterator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.createLineIterator must not return null");
        }
        return lineIterator;
    }

    @Override
    public final int getLineStartOffset(int line) {
        DocumentImpl.assertReadAccessToDocumentsAllowed();
        if (line == 0) {
            return 0;
        }
        int lineStart = this.myLineSet.getLineStart(line);
        assert (lineStart >= 0);
        return lineStart;
    }

    @Override
    public final int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result = this.myLineSet.getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result >= 0);
        return result;
    }

    @Override
    public final int getLineSeparatorLength(int line) {
        int separatorLength = this.myLineSet.getSeparatorLength(line);
        assert (separatorLength >= 0);
        return separatorLength;
    }

    @Override
    public final int getLineCount() {
        int lineCount = this.myLineSet.getLineCount();
        assert (lineCount >= 0);
        return lineCount;
    }

    @NotNull
    private DocumentListener[] getCachedListeners() {
        DocumentListener[] cachedListeners = this.myCachedDocumentListeners;
        if (cachedListeners == null) {
            DocumentListener[] listeners = this.myDocumentListeners.toArray(new DocumentListener[this.myDocumentListeners.size()]);
            Arrays.sort(listeners, PrioritizedDocumentListener.COMPARATOR);
            cachedListeners = listeners;
            this.myCachedDocumentListeners = listeners;
        }
        if (cachedListeners == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.getCachedListeners must not return null");
        }
        return cachedListeners;
    }

    @Override
    public void fireReadOnlyModificationAttempt() {
        for (EditReadOnlyListener listener : this.myReadOnlyListeners) {
            listener.readOnlyModificationAttempt(this);
        }
    }

    @Override
    public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.addEditReadOnlyListener must not be null");
        }
        this.myReadOnlyListeners.add(listener);
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.removeEditReadOnlyListener must not be null");
        }
        this.myReadOnlyListeners.remove(listener);
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.addPropertyChangeListener must not be null");
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.removePropertyChangeListener must not be null");
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void setCyclicBufferSize(int bufferSize) {
        this.myText.setBufferSize(bufferSize);
    }

    @Override
    public void setText(final @NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.setText must not be null");
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DocumentImpl.this.replaceString(0, DocumentImpl.this.getTextLength(), text, LocalTimeCounter.currentTime(), true);
            }
        };
        if (CommandProcessor.getInstance().isUndoTransparentActionInProgress()) {
            runnable.run();
        } else {
            CommandProcessor.getInstance().executeCommand(null, runnable, "", DocCommandGroupId.noneGroupId(this));
        }
        this.clearLineModificationFlags();
    }

    @Override
    @NotNull
    public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.createRangeMarker must not be null");
        }
        RangeMarker rangeMarker = this.createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset());
        if (rangeMarker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.createRangeMarker must not return null");
        }
        return rangeMarker;
    }

    @Override
    public final boolean isInBulkUpdate() {
        return this.myDoingBulkUpdate;
    }

    @Override
    public final void setInBulkUpdate(boolean value) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myDoingBulkUpdate = value;
        this.myText.setDeferredChangeMode(value);
        if (value) {
            DocumentImpl.getPublisher().updateStarted(this);
        } else {
            DocumentImpl.getPublisher().updateFinished(this);
        }
    }

    private static DocumentBulkUpdateListener getPublisher() {
        return DocumentBulkUpdateListenerHolder.ourBulkChangePublisher;
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<RangeMarker> processor) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.processRangeMarkers must not be null");
        }
        return this.myRangeMarkers.process(processor);
    }

    @Override
    public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<RangeMarker> processor) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl.processRangeMarkersOverlappingWith must not be null");
        }
        return this.myRangeMarkers.processOverlappingWith(start, end, processor);
    }

    @NotNull
    public String dumpState() {
        StringBuilder result = new StringBuilder();
        result.append("deferred mode: ").append(this.myText.isDeferredChangeMode() ? "on" : "off");
        result.append(", intervals:\n");
        for (int line = 0; line < this.getLineCount(); ++line) {
            result.append(line).append(": ").append(this.getLineStartOffset(line)).append("-").append(this.getLineEndOffset(line)).append(", ");
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl.dumpState must not return null");
        }
        return string;
    }

    private static class MyCharArray
    extends CharArray {
        public MyCharArray() {
            super(0);
        }

        @Override
        @NotNull
        protected DocumentEvent beforeChangedUpdate(DocumentImpl subj, int offset, CharSequence oldString, CharSequence newString, boolean wholeTextReplaced) {
            DocumentEvent documentEvent = subj.beforeChangedUpdate(offset, oldString, newString, wholeTextReplaced);
            if (documentEvent == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/DocumentImpl$MyCharArray.beforeChangedUpdate must not return null");
            }
            return documentEvent;
        }

        @Override
        protected void afterChangedUpdate(@NotNull DocumentEvent event, long newModificationStamp) {
            if (event == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/DocumentImpl$MyCharArray.afterChangedUpdate must not be null");
            }
            ((DocumentImpl)event.getDocument()).changedUpdate(event, newModificationStamp);
        }
    }

    private static class DocumentBulkUpdateListenerHolder {
        private static final DocumentBulkUpdateListener ourBulkChangePublisher = ApplicationManager.getApplication().getMessageBus().syncPublisher(DocumentBulkUpdateListener.TOPIC);

        private DocumentBulkUpdateListenerHolder() {
        }
    }
}

