/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.BulkChangesMerger;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import com.intellij.openapi.editor.impl.TextChangesStorage;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceBackedByArray;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CharArray
implements CharSequenceBackedByArray {
    private static final boolean DISABLE_DEFERRED_PROCESSING = Boolean.getBoolean("idea.document.deny.deferred.changes");
    private static final boolean DEBUG_DEFERRED_PROCESSING = Boolean.getBoolean("idea.document.debug.bulk.processing");
    private static final Logger LOG = Logger.getInstance("#" + CharArray.class.getName());
    private static final int MAX_DEFERRED_CHANGES_NUMBER = 10000;
    private final AtomicReference<TextChangesStorage> myDeferredChangesStorage;
    private int myStart;
    private int myEnd;
    private int myCount;
    private CharSequence myOriginalSequence;
    private char[] myArray;
    private SoftReference<String> myStringRef;
    private int myBufferSize;
    private int myDeferredShift;
    private boolean myDeferredChangeMode;
    private final boolean myDebugDeferredProcessing;
    private CharArray myDebugArray;
    private List<TextChangeImpl> myDebugDeferredChanges;
    private String myDebugTextOnBatchUpdateStart;

    CharArray(int bufferSize) {
        this(bufferSize, new TextChangesStorage(), null, -1, -1);
    }

    private CharArray(int bufferSize, @NotNull TextChangesStorage deferredChangesStorage, @Nullable char[] data, int start, int end) {
        if (deferredChangesStorage == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.<init> must not be null");
        }
        this(bufferSize, deferredChangesStorage, data, start, end, DEBUG_DEFERRED_PROCESSING);
    }

    private CharArray(int bufferSize, @NotNull TextChangesStorage deferredChangesStorage, @Nullable char[] data, int start, int end, boolean debugDeferredProcessing) {
        if (deferredChangesStorage == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.<init> must not be null");
        }
        this.myDeferredChangesStorage = new AtomicReference();
        this.myEnd = -1;
        this.myCount = 0;
        this.myBufferSize = bufferSize;
        this.myDeferredChangesStorage.set(deferredChangesStorage);
        if (data == null) {
            this.myOriginalSequence = "";
        } else {
            this.myArray = data;
            this.myCount = end - start;
        }
        if (start >= 0 && end >= 0) {
            this.myStart = start;
            this.myEnd = end;
        }
        this.myDebugDeferredProcessing = debugDeferredProcessing;
        if (this.myDebugDeferredProcessing) {
            this.myDebugArray = new CharArray(bufferSize, new TextChangesStorage(), data == null ? null : Arrays.copyOf(data, data.length), start, end, false){

                @Override
                @NotNull
                protected DocumentEvent beforeChangedUpdate(DocumentImpl subj, int offset, CharSequence oldString, CharSequence newString, boolean wholeTextReplaced) {
                    DocumentEventImpl documentEventImpl = new DocumentEventImpl(subj, offset, oldString, newString, -1L, wholeTextReplaced);
                    if (documentEventImpl == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/CharArray$1.beforeChangedUpdate must not return null");
                    }
                    return documentEventImpl;
                }

                @Override
                protected void afterChangedUpdate(@NotNull DocumentEvent event, long newModificationStamp) {
                    if (event == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray$1.afterChangedUpdate must not be null");
                    }
                }
            };
            this.myDebugDeferredChanges = new ArrayList<TextChangeImpl>();
        }
    }

    public void setBufferSize(int bufferSize) {
        this.myBufferSize = bufferSize;
    }

    @NotNull
    protected abstract DocumentEvent beforeChangedUpdate(DocumentImpl var1, int var2, @Nullable CharSequence var3, @Nullable CharSequence var4, boolean var5);

    protected abstract void afterChangedUpdate(@NotNull DocumentEvent var1, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(@Nullable DocumentImpl subj, CharSequence chars) {
        this.myOriginalSequence = chars;
        this.myArray = null;
        this.myCount = chars.length();
        this.myStringRef = null;
        TextChangesStorage storage = this.myDeferredChangesStorage.get();
        storage.getLock().lock();
        try {
            if (this.isSubSequence()) {
                this.myDeferredChangesStorage.set(new TextChangesStorage());
                this.myStart = 0;
                this.myEnd = -1;
            } else {
                storage.clear();
            }
        }
        finally {
            storage.getLock().unlock();
        }
        if (subj != null) {
            this.trimToSize(subj);
        }
        if (this.myDebugDeferredProcessing) {
            this.myDebugArray.setText(subj, chars);
            this.myDebugDeferredChanges.clear();
        }
    }

    public void replace(DocumentImpl subj, int startOffset, int endOffset, CharSequence toDelete, CharSequence newString, long newModificationStamp, boolean wholeTextReplaced) {
        DocumentEvent event = this.beforeChangedUpdate(subj, startOffset, toDelete, newString, wholeTextReplaced);
        this.doReplace(startOffset += this.myStart, endOffset += this.myStart, newString);
        this.afterChangedUpdate(event, newModificationStamp);
    }

    private void doReplace(int startOffset, int endOffset, CharSequence newString) {
        this.prepareForModification();
        if (this.isDeferredChangeMode()) {
            this.storeChange(new TextChangeImpl(newString, startOffset, endOffset));
            if (this.myDebugDeferredProcessing) {
                this.myDebugArray.doReplace(startOffset, endOffset, newString);
            }
            return;
        }
        int newLength = newString.length();
        int oldLength = endOffset - startOffset;
        CharArrayUtil.getChars(newString, this.myArray, startOffset, Math.min(newLength, oldLength));
        if (newLength > oldLength) {
            this.doInsert(newString.subSequence(oldLength, newLength), endOffset);
        } else if (newLength < oldLength) {
            this.doRemove(startOffset + newLength, startOffset + oldLength);
        }
    }

    public void remove(DocumentImpl subj, int startIndex, int endIndex, CharSequence toDelete) {
        DocumentEvent event = this.beforeChangedUpdate(subj, startIndex, toDelete, null, false);
        this.doRemove(startIndex += this.myStart, endIndex += this.myStart);
        this.afterChangedUpdate(event, LocalTimeCounter.currentTime());
    }

    private void doRemove(int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            return;
        }
        this.prepareForModification();
        if (this.isDeferredChangeMode()) {
            this.storeChange(new TextChangeImpl("", startIndex, endIndex));
            if (this.myDebugDeferredProcessing) {
                this.myDebugArray.doRemove(startIndex, endIndex);
            }
            return;
        }
        if (endIndex < this.myCount) {
            System.arraycopy(this.myArray, endIndex, this.myArray, startIndex, this.myCount - endIndex);
        }
        this.myCount -= endIndex - startIndex;
    }

    public void insert(DocumentImpl subj, CharSequence s, int startIndex) {
        DocumentEvent event = this.beforeChangedUpdate(subj, startIndex, null, s, false);
        this.doInsert(s, startIndex += this.myStart);
        this.afterChangedUpdate(event, LocalTimeCounter.currentTime());
        this.trimToSize(subj);
    }

    private void doInsert(CharSequence s, int startIndex) {
        this.prepareForModification();
        if (this.isDeferredChangeMode()) {
            this.storeChange(new TextChangeImpl(s, startIndex));
            if (this.myDebugDeferredProcessing) {
                this.myDebugArray.doInsert(s, startIndex);
            }
            return;
        }
        int insertLength = s.length();
        this.myArray = CharArray.relocateArray(this.myArray, this.myCount + insertLength);
        if (startIndex < this.myCount) {
            System.arraycopy(this.myArray, startIndex, this.myArray, startIndex + insertLength, this.myCount - startIndex);
        }
        CharArrayUtil.getChars(s, this.myArray, startIndex);
        this.myCount += insertLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeChange(@NotNull TextChangeImpl change) {
        if (change == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.storeChange must not be null");
        }
        if (!change.isWithinBounds(this.length())) {
            LOG.error(String.format("Invalid change attempt detected - given change bounds are not within the current char array. Change: %d:%d-%d", change.getText().length(), change.getStart(), change.getEnd()), this.dumpState());
            return;
        }
        TextChangesStorage storage = this.myDeferredChangesStorage.get();
        storage.getLock().lock();
        try {
            this.doStoreChange(change);
        }
        finally {
            storage.getLock().unlock();
        }
    }

    private void doStoreChange(@NotNull TextChangeImpl change) {
        if (change == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.doStoreChange must not be null");
        }
        TextChangesStorage storage = this.myDeferredChangesStorage.get();
        if (storage.size() >= 10000) {
            this.flushDeferredChanged(storage);
        }
        storage.store(change);
        this.myDeferredShift += change.getDiff();
        if (this.myDebugDeferredProcessing) {
            this.myDebugDeferredChanges.add(change);
        }
    }

    private void prepareForModification() {
        if (this.myOriginalSequence != null) {
            this.myArray = new char[this.myOriginalSequence.length()];
            CharArrayUtil.getChars(this.myOriginalSequence, this.myArray, 0);
            this.myOriginalSequence = null;
        }
        this.myStringRef = null;
    }

    public CharSequence getCharArray() {
        if (this.myOriginalSequence != null) {
            return this.myOriginalSequence;
        }
        return this;
    }

    @Override
    public String toString() {
        String str;
        String string = str = this.myStringRef != null ? this.myStringRef.get() : null;
        if (str == null) {
            str = this.myOriginalSequence != null ? ((Object)this.myOriginalSequence).toString() : (!this.hasDeferredChanges() ? new String(this.myArray, this.myStart, this.myCount) : ((Object)this.substring(0, this.length())).toString());
            this.myStringRef = new SoftReference<String>(str);
        }
        if (this.myDebugDeferredProcessing && this.isDeferredChangeMode()) {
            String expected = this.myDebugArray.toString();
            this.checkStrings("toString()", expected, str);
        }
        return str;
    }

    @Override
    public final int length() {
        int expected;
        int result = this.myCount + this.myDeferredShift;
        if (this.myDebugDeferredProcessing && this.isDeferredChangeMode() && (expected = this.myDebugArray.length()) != result) {
            this.dumpDebugInfo(String.format("Incorrect length() processing. Expected: '%s', actual: '%s'", expected, result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final char charAt(int i) {
        char expected;
        char result;
        if (i < 0 || i >= this.length()) {
            throw new IndexOutOfBoundsException("Wrong offset: " + i + "; count:" + this.length());
        }
        i += this.myStart;
        if (this.myOriginalSequence != null) {
            return this.myOriginalSequence.charAt(i);
        }
        if (this.hasDeferredChanges()) {
            TextChangesStorage storage = this.myDeferredChangesStorage.get();
            storage.getLock().lock();
            try {
                result = storage.charAt(this.myArray, i);
            }
            finally {
                storage.getLock().unlock();
            }
        } else {
            result = this.myArray[i];
        }
        if (this.myDebugDeferredProcessing && this.isDeferredChangeMode() && (expected = this.myDebugArray.charAt(i)) != result) {
            this.dumpDebugInfo(String.format("Incorrect charAt() processing for index %d. Expected: '%c', actual: '%c'", i, Character.valueOf(expected), Character.valueOf(result)));
        }
        return result;
    }

    @Override
    public CharSequence subSequence(final int start, final int end) {
        if (start == 0 && end == this.length()) {
            return this;
        }
        if (this.myOriginalSequence != null) {
            return this.myOriginalSequence.subSequence(start, end);
        }
        if (this.hasDeferredChanges()) {
            return new CharArray(this.myBufferSize, this.myDeferredChangesStorage.get(), this.myArray, this.myStart + start, this.myStart + end){

                @Override
                @NotNull
                protected DocumentEvent beforeChangedUpdate(DocumentImpl subj, int offset, CharSequence oldString, CharSequence newString, boolean wholeTextReplaced) {
                    DocumentEventImpl documentEventImpl = new DocumentEventImpl(subj, offset, oldString, newString, LocalTimeCounter.currentTime(), wholeTextReplaced);
                    if (documentEventImpl == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/CharArray$2.beforeChangedUpdate must not return null");
                    }
                    return documentEventImpl;
                }

                @Override
                protected void afterChangedUpdate(@NotNull DocumentEvent event, long newModificationStamp) {
                    if (event == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray$2.afterChangedUpdate must not be null");
                    }
                }

                @Override
                public char[] getChars() {
                    char[] chars = CharArray.this.getChars();
                    char[] result = new char[end - start];
                    System.arraycopy(chars, start, result, 0, result.length);
                    return result;
                }
            };
        }
        return new CharArrayCharSequence(this.myArray, start, end);
    }

    private boolean isSubSequence() {
        return this.myEnd >= 0;
    }

    @Override
    public char[] getChars() {
        if (this.myOriginalSequence != null && this.myArray == null) {
            this.myArray = CharArrayUtil.fromSequence(this.myOriginalSequence);
        }
        this.flushDeferredChanged(this.myDeferredChangesStorage.get());
        if (this.myDebugDeferredProcessing && this.isDeferredChangeMode()) {
            char[] expected = this.myDebugArray.getChars();
            int max = this.length();
            for (int i = 0; i < max; ++i) {
                if (this.myArray[i] == expected[i]) continue;
                this.dumpDebugInfo(String.format("getChars(). Index: %d, expected: %c, actual: %c", i, Character.valueOf(expected[i]), Character.valueOf(this.myArray[i])));
                break;
            }
        }
        return this.myArray;
    }

    @Override
    public void getChars(char[] dst, int dstOffset) {
        this.flushDeferredChanged(this.myDeferredChangesStorage.get());
        if (this.myOriginalSequence != null) {
            CharArrayUtil.getChars(this.myOriginalSequence, dst, dstOffset);
        } else {
            System.arraycopy(this.myArray, this.myStart, dst, dstOffset, this.length());
        }
        if (this.myDebugDeferredProcessing && this.isDeferredChangeMode()) {
            char[] expected = new char[dst.length];
            this.myDebugArray.getChars(expected, dstOffset);
            int i = dstOffset;
            for (int j = this.myStart; i < dst.length && j < this.myArray.length; ++i, ++j) {
                if (expected[i] == this.myArray[j]) continue;
                this.dumpDebugInfo(String.format("getChars(char[], int). Given array of length %d, offset %d. Found char '%c' at index %d, expected to find '%c'", dst.length, dstOffset, Character.valueOf(this.myArray[j]), i, Character.valueOf(expected[i])));
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence substring(int start, int end) {
        CharSequence result;
        if (start == end) {
            return "";
        }
        if (this.myOriginalSequence == null) {
            TextChangesStorage storage = this.myDeferredChangesStorage.get();
            storage.getLock().lock();
            try {
                result = storage.substring(this.myArray, start + this.myStart, end + this.myStart);
            }
            finally {
                storage.getLock().unlock();
            }
        } else {
            result = this.myOriginalSequence.subSequence(start, end);
        }
        if (this.myDebugDeferredProcessing && this.isDeferredChangeMode()) {
            String expected = ((Object)this.myDebugArray.substring(start, end)).toString();
            this.checkStrings(String.format("substring(%d, %d)", start, end), expected, ((Object)result).toString());
        }
        return result;
    }

    private static char[] relocateArray(char[] array, int index) {
        if (index < array.length) {
            return array;
        }
        int newArraySize = array.length;
        if (newArraySize == 0) {
            newArraySize = 16;
        }
        while (newArraySize <= index) {
            newArraySize = newArraySize * 12 / 10 + 1;
        }
        char[] newArray = new char[newArraySize];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    private void trimToSize(DocumentImpl subj) {
        if (this.myBufferSize != 0 && this.length() > this.myBufferSize) {
            this.flushDeferredChanged(this.myDeferredChangesStorage.get());
            this.remove(subj, 0, this.myCount - this.myBufferSize, ((Object)this.getCharArray().subSequence(0, this.myCount - this.myBufferSize)).toString());
        }
    }

    public boolean isDeferredChangeMode() {
        return !DISABLE_DEFERRED_PROCESSING && this.myDeferredChangeMode;
    }

    public boolean hasDeferredChanges() {
        return !this.myDeferredChangesStorage.get().isEmpty();
    }

    public void setDeferredChangeMode(boolean deferredChangeMode) {
        if (deferredChangeMode && this.myDebugDeferredProcessing) {
            this.myDebugTextOnBatchUpdateStart = this.toString();
            this.myDebugArray.setText(null, this.myDebugTextOnBatchUpdateStart);
            this.myDebugDeferredChanges.clear();
        }
        this.myDeferredChangeMode = deferredChangeMode;
        if (!deferredChangeMode) {
            this.flushDeferredChanged(this.myDeferredChangesStorage.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDeferredChanged(@NotNull TextChangesStorage storage) {
        if (storage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.flushDeferredChanged must not be null");
        }
        storage.getLock().lock();
        try {
            this.doFlushDeferredChanged();
        }
        finally {
            storage.getLock().unlock();
        }
    }

    private void doFlushDeferredChanged() {
        boolean inPlace;
        TextChangesStorage storage = this.myDeferredChangesStorage.get();
        List<TextChangeImpl> changes = storage.getChanges();
        if (changes.isEmpty()) {
            return;
        }
        char[] beforeMerge = null;
        if (this.myDebugDeferredProcessing) {
            beforeMerge = new char[this.myArray.length];
            System.arraycopy(this.myArray, 0, beforeMerge, 0, this.myArray.length);
        }
        BulkChangesMerger changesMerger = BulkChangesMerger.INSTANCE;
        if (this.myArray.length < this.length()) {
            this.myArray = changesMerger.mergeToCharArray(this.myArray, this.myCount, changes);
            inPlace = false;
        } else {
            changesMerger.mergeInPlace(this.myArray, this.myCount, changes);
            inPlace = true;
        }
        if (this.myDebugDeferredProcessing) {
            int max = this.length();
            for (int i = 0; i < max; ++i) {
                if (this.myArray[i] == this.myDebugArray.myArray[i]) continue;
                this.dumpDebugInfo(String.format("flushDeferredChanged(). Index %d, expected: '%c', actual '%c'. Text before merge: '%s', merge inplace: %b", i, Character.valueOf(this.myDebugArray.myArray[i]), Character.valueOf(this.myArray[i]), Arrays.toString(beforeMerge), inPlace));
                break;
            }
        }
        this.myCount += this.myDeferredShift;
        this.myDeferredShift = 0;
        storage.clear();
        this.myDeferredChangeMode = false;
    }

    @NotNull
    public String dumpState() {
        String string = String.format("deferred changes mode: %b, length: %d (data array length: %d, deferred shift: %d); view offsets: [%d; %d]; deferred changes: %s", this.isDeferredChangeMode(), this.length(), this.myCount, this.myDeferredShift, this.myStart, this.myEnd, this.myDeferredChangesStorage);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/CharArray.dumpState must not return null");
        }
        return string;
    }

    private void checkStrings(@NotNull String operation, @NotNull String expected, @NotNull String actual) {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.checkStrings must not be null");
        }
        if (expected == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.checkStrings must not be null");
        }
        if (actual == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.checkStrings must not be null");
        }
        if (expected.equals(actual)) {
            return;
        }
        int max = Math.min(expected.length(), actual.length());
        for (int i = 0; i < max; ++i) {
            if (actual.charAt(i) == expected.charAt(i)) continue;
            this.dumpDebugInfo(String.format("Incorrect %s processing. Expected length: %d, actual length: %d. Unmatched symbol at %d - expected: '%c', actual: '%c', expected document: '%s', actual document: '%s'", operation, expected.length(), actual.length(), i, Character.valueOf(expected.charAt(i)), Character.valueOf(actual.charAt(i)), expected, actual));
            return;
        }
        this.dumpDebugInfo(String.format("Incorrect %s processing. Expected length: %d, actual length: %d, expected: '%s', actual: '%s'", operation, expected.length(), actual.length(), expected, actual));
    }

    private void dumpDebugInfo(@NotNull String problem) {
        if (problem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/CharArray.dumpDebugInfo must not be null");
        }
        LOG.error(String.format("Incorrect CharArray processing detected: '%s'. Start: %d, end: %d, text on batch update start: '%s', deferred changes history: %s, current deferred changes: %s", problem, this.myStart, this.myEnd, this.myDebugTextOnBatchUpdateStart, this.myDebugDeferredChanges, this.myDeferredChangesStorage));
    }
}

