/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.util.NotNullFunction;
import org.jetbrains.annotations.NotNull;

public class ServiceManager {
    private ServiceManager() {
    }

    public static <T> T getService(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/ServiceManager.getService must not be null");
        }
        return (T)ApplicationManager.getApplication().getPicoContainer().getComponentInstance((Object)serviceClass.getName());
    }

    public static <T> T getService(@NotNull Project project, @NotNull Class<T> serviceClass) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/ServiceManager.getService must not be null");
        }
        if (serviceClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/components/ServiceManager.getService must not be null");
        }
        return (T)project.getPicoContainer().getComponentInstance((Object)serviceClass.getName());
    }

    public static <T> NotNullLazyKey<T, Project> createLazyKey(final @NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/ServiceManager.createLazyKey must not be null");
        }
        return NotNullLazyKey.create("Service: " + serviceClass.getName(), new NotNullFunction<Project, T>(){

            @Override
            @NotNull
            public T fun(Project project) {
                Object t = ServiceManager.getService(project, serviceClass);
                if (t == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/components/ServiceManager$1.fun must not return null");
                }
                return t;
            }
        });
    }
}

