/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.text.StringUtil;

public abstract class AccessToken {
    public static final AccessToken EMPTY_ACCESS_TOKEN = new AccessToken(){

        @Override
        public void finish() {
        }
    };

    protected void acquired() {
        String id = this.id();
        if (id != null) {
            Thread thread = Thread.currentThread();
            thread.setName(thread.getName() + id);
        }
    }

    protected void released() {
        String id = this.id();
        if (id != null) {
            Thread thread = Thread.currentThread();
            String name = thread.getName();
            name = StringUtil.replace(name, id, "");
            thread.setName(name);
        }
    }

    private String id() {
        Class<?> aClass = this.getClass();
        String name = aClass.getName();
        while (name == null) {
            aClass = aClass.getSuperclass();
            name = aClass.getName();
        }
        name = name.substring(name.lastIndexOf(46) + 1);
        if (!(name = name.substring(name.lastIndexOf(36) + 1)).equals("AccessToken")) {
            return " [" + name + "]";
        }
        return null;
    }

    public abstract void finish();
}

