/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.BitUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.java.parser.DeclarationParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceParser {
    private final DeclarationParser myDeclarationParser;
    public static final int EAT_LAST_DOT = 1;
    public static final int ELLIPSIS = 2;
    public static final int WILDCARD = 4;
    public static final int DIAMONDS = 8;
    public static final int DISJUNCTIONS = 16;
    private static final TokenSet WILDCARD_KEYWORD_SET = TokenSet.create(JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.SUPER_KEYWORD);

    public ReferenceParser(DeclarationParser declarationParser) {
        this.myDeclarationParser = declarationParser;
    }

    public ReferenceParser() {
        this(new DeclarationParser());
    }

    @Nullable
    public PsiBuilder.Marker parseType(PsiBuilder builder, int flags) {
        TypeInfo typeInfo = this.parseTypeInfo(builder, flags);
        return typeInfo != null ? typeInfo.marker : null;
    }

    @Nullable
    public TypeInfo parseTypeInfo(PsiBuilder builder, int flags) {
        TypeInfo typeInfo = this.parseTypeInfo(builder, BitUtil.isSet(flags, 1), BitUtil.isSet(flags, 4), false, BitUtil.isSet(flags, 8), BitUtil.isSet(flags, 2));
        if (typeInfo != null && BitUtil.isSet(flags, 16) && builder.getTokenType() == JavaTokenType.OR) {
            typeInfo.marker = typeInfo.marker.precede();
            while (builder.getTokenType() == JavaTokenType.OR) {
                builder.advanceLexer();
                if (builder.getTokenType() != JavaTokenType.IDENTIFIER) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                }
                this.parseTypeInfo(builder, BitUtil.isSet(flags, 1), BitUtil.isSet(flags, 4), false, BitUtil.isSet(flags, 8), BitUtil.isSet(flags, 2));
            }
            typeInfo.marker.done(JavaElementType.TYPE);
        }
        return typeInfo;
    }

    @Nullable
    private TypeInfo parseTypeInfo(PsiBuilder builder, boolean eatLastDot, boolean wildcard, boolean badWildcard, boolean diamonds, boolean ellipsis) {
        if (builder.getTokenType() == null) {
            return null;
        }
        TypeInfo typeInfo = new TypeInfo();
        boolean annotationsSupported = JavaParserUtil.areTypeAnnotationsSupported(builder);
        PsiBuilder.Marker type = builder.mark();
        if (annotationsSupported) {
            this.myDeclarationParser.parseAnnotations(builder);
        }
        IElementType tokenType = builder.getTokenType();
        if (PsiBuilderUtil.expect(builder, ElementType.PRIMITIVE_TYPE_BIT_SET)) {
            typeInfo.isPrimitive = true;
        } else if (tokenType == JavaTokenType.IDENTIFIER) {
            this.parseJavaCodeReference(builder, eatLastDot, true, annotationsSupported, false, false, false, diamonds, typeInfo);
        } else {
            if ((wildcard || badWildcard) && tokenType == JavaTokenType.QUEST) {
                type.drop();
                typeInfo.marker = this.parseWildcardType(builder, wildcard);
                return typeInfo.marker != null ? typeInfo : null;
            }
            if (diamonds && tokenType == JavaTokenType.GT) {
                JavaParserUtil.emptyElement(builder, JavaElementType.DIAMOND_TYPE);
                type.done(JavaElementType.TYPE);
                typeInfo.marker = type;
                return typeInfo;
            }
            type.drop();
            return null;
        }
        while (true) {
            type.done(JavaElementType.TYPE);
            if (annotationsSupported) {
                this.myDeclarationParser.parseAnnotations(builder);
            }
            PsiBuilder.Marker bracket = builder.mark();
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.LBRACKET)) {
                bracket.drop();
                break;
            }
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.RBRACKET)) {
                bracket.rollbackTo();
                break;
            }
            bracket.drop();
            typeInfo.isArray = true;
            type = type.precede();
        }
        if (ellipsis && builder.getTokenType() == JavaTokenType.ELLIPSIS) {
            type = type.precede();
            builder.advanceLexer();
            type.done(JavaElementType.TYPE);
            typeInfo.isVarArg = true;
        }
        typeInfo.marker = type;
        return typeInfo;
    }

    @NotNull
    private PsiBuilder.Marker parseWildcardType(PsiBuilder builder, boolean wildcard) {
        PsiBuilder.Marker type = builder.mark();
        builder.advanceLexer();
        if (PsiBuilderUtil.expect(builder, WILDCARD_KEYWORD_SET) && this.parseTypeInfo(builder, 1) == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.type", new Object[0]));
        }
        if (wildcard) {
            type.done(JavaElementType.TYPE);
        } else {
            type.error(JavaErrorMessages.message("wildcard.not.expected", new Object[0]));
        }
        PsiBuilder.Marker marker = type;
        if (marker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/ReferenceParser.parseWildcardType must not return null");
        }
        return marker;
    }

    @Nullable
    public PsiBuilder.Marker parseJavaCodeReference(PsiBuilder builder, boolean eatLastDot, boolean parameterList, boolean annotations, boolean isNew, boolean diamonds) {
        return this.parseJavaCodeReference(builder, eatLastDot, parameterList, annotations, false, false, isNew, diamonds, new TypeInfo());
    }

    public boolean parseImportCodeReference(PsiBuilder builder, boolean isStatic) {
        TypeInfo typeInfo = new TypeInfo();
        this.parseJavaCodeReference(builder, true, false, false, true, isStatic, false, false, typeInfo);
        return !typeInfo.hasErrors;
    }

    @Nullable
    private PsiBuilder.Marker parseJavaCodeReference(PsiBuilder builder, boolean eatLastDot, boolean parameterList, boolean annotations, boolean isImport, boolean isStaticImport, boolean isNew, boolean diamonds, TypeInfo typeInfo) {
        PsiBuilder.Marker refElement = builder.mark();
        if (annotations) {
            this.myDeclarationParser.parseAnnotations(builder);
        }
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            refElement.rollbackTo();
            if (isImport) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            }
            typeInfo.hasErrors = true;
            return null;
        }
        if (parameterList) {
            typeInfo.isParameterized = this.parseReferenceParameterList(builder, true, diamonds);
        } else if (!isStaticImport || builder.getTokenType() == JavaTokenType.DOT) {
            JavaParserUtil.emptyElement(builder, JavaElementType.REFERENCE_PARAMETER_LIST);
        }
        while (builder.getTokenType() == JavaTokenType.DOT) {
            boolean hasIdentifier;
            refElement.done(JavaElementType.JAVA_CODE_REFERENCE);
            if (isNew && !diamonds && typeInfo.isParameterized) {
                return refElement;
            }
            PsiBuilder.Marker dotPos = builder.mark();
            builder.advanceLexer();
            if (PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
                hasIdentifier = true;
            } else {
                if (isImport && PsiBuilderUtil.expect(builder, JavaTokenType.ASTERISK)) {
                    dotPos.drop();
                    return refElement;
                }
                if (!eatLastDot) {
                    dotPos.rollbackTo();
                    return refElement;
                }
                hasIdentifier = false;
            }
            dotPos.drop();
            PsiBuilder.Marker prevElement = refElement;
            refElement = refElement.precede();
            if (!hasIdentifier) {
                typeInfo.hasErrors = true;
                if (isImport) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("import.statement.identifier.or.asterisk.expected.", new Object[0]));
                    refElement.drop();
                    return prevElement;
                }
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                JavaParserUtil.emptyElement(builder, JavaElementType.REFERENCE_PARAMETER_LIST);
                break;
            }
            if (parameterList) {
                typeInfo.isParameterized = this.parseReferenceParameterList(builder, true, diamonds);
                continue;
            }
            if (isStaticImport && builder.getTokenType() != JavaTokenType.DOT) continue;
            JavaParserUtil.emptyElement(builder, JavaElementType.REFERENCE_PARAMETER_LIST);
        }
        refElement.done(isStaticImport ? JavaElementType.IMPORT_STATIC_REFERENCE : JavaElementType.JAVA_CODE_REFERENCE);
        return refElement;
    }

    public boolean parseReferenceParameterList(PsiBuilder builder, boolean wildcard, boolean diamonds) {
        boolean isOk;
        PsiBuilder.Marker list;
        block5: {
            list = builder.mark();
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.LT)) {
                list.done(JavaElementType.REFERENCE_PARAMETER_LIST);
                return false;
            }
            isOk = true;
            do {
                if (this.parseTypeInfo(builder, true, wildcard, true, diamonds, false) == null) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                } else {
                    IElementType tokenType = builder.getTokenType();
                    if (WILDCARD_KEYWORD_SET.contains(tokenType)) {
                        this.parseReferenceList(builder, tokenType, null, JavaTokenType.AND);
                    }
                }
                if (PsiBuilderUtil.expect(builder, JavaTokenType.GT)) break block5;
            } while (JavaParserUtil.expectOrError(builder, JavaTokenType.COMMA, "expected.gt.or.comma"));
            isOk = false;
        }
        list.done(JavaElementType.REFERENCE_PARAMETER_LIST);
        return isOk;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiBuilder.Marker parseTypeParameters(PsiBuilder builder) {
        PsiBuilder.Marker marker;
        PsiBuilder.Marker list = builder.mark();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LT)) {
            list.done(JavaElementType.TYPE_PARAMETER_LIST);
            marker = list;
            if (marker == null) throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/ReferenceParser.parseTypeParameters must not return null");
            return marker;
        }
        do {
            PsiBuilder.Marker param;
            if ((param = this.parseTypeParameter(builder)) != null) continue;
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.type.parameter", new Object[0]));
        } while (PsiBuilderUtil.expect(builder, JavaTokenType.COMMA));
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.GT)) {
            if (builder.getTokenType() == JavaTokenType.IDENTIFIER) {
                if (PsiBuilderUtil.nextTokenType(builder) == JavaTokenType.GT) {
                    PsiBuilder.Marker errorElement = builder.mark();
                    builder.advanceLexer();
                    errorElement.error(JavaErrorMessages.message("unexpected.identifier", new Object[0]));
                    builder.advanceLexer();
                } else {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.gt", new Object[0]));
                }
            } else {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.gt", new Object[0]));
            }
        }
        list.done(JavaElementType.TYPE_PARAMETER_LIST);
        marker = list;
        if (marker != null) return marker;
        throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/ReferenceParser.parseTypeParameters must not return null");
    }

    @Nullable
    public PsiBuilder.Marker parseTypeParameter(PsiBuilder builder) {
        PsiBuilder.Marker param = builder.mark();
        this.myDeclarationParser.parseAnnotations(builder);
        boolean wild = PsiBuilderUtil.expect(builder, JavaTokenType.QUEST);
        if (!wild && !PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            param.rollbackTo();
            return null;
        }
        this.parseReferenceList(builder, JavaTokenType.EXTENDS_KEYWORD, JavaElementType.EXTENDS_BOUND_LIST, JavaTokenType.AND);
        if (!wild) {
            param.done(JavaElementType.TYPE_PARAMETER);
        } else {
            param.error(JavaErrorMessages.message("wildcard.not.expected", new Object[0]));
        }
        return param;
    }

    @NotNull
    public PsiBuilder.Marker parseReferenceList(PsiBuilder builder, IElementType start, @Nullable IElementType type, IElementType delimiter) {
        PsiBuilder.Marker element = builder.mark();
        if (PsiBuilderUtil.expect(builder, start)) {
            do {
                PsiBuilder.Marker classReference;
                if ((classReference = this.parseJavaCodeReference(builder, true, true, true, false, false)) != null) continue;
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
            } while (PsiBuilderUtil.expect(builder, delimiter));
        }
        if (type != null) {
            element.done(type);
        } else {
            element.error(JavaErrorMessages.message("bound.not.expected", new Object[0]));
        }
        PsiBuilder.Marker marker = element;
        if (marker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/parser/ReferenceParser.parseReferenceList must not return null");
        }
        return marker;
    }

    public static class TypeInfo {
        public boolean isPrimitive = false;
        public boolean isParameterized = false;
        public boolean isArray = false;
        public boolean isVarArg = false;
        public boolean hasErrors = false;
        public PsiBuilder.Marker marker = null;
    }
}

