/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lang.java.parser.JavaParsers;
import com.intellij.openapi.util.Key;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavadocParser {
    private static final TokenSet TAG_VALUES_SET = TokenSet.create(JavaDocTokenType.DOC_TAG_VALUE_TOKEN, JavaDocTokenType.DOC_TAG_VALUE_COMMA, JavaDocTokenType.DOC_TAG_VALUE_DOT, JavaDocTokenType.DOC_TAG_VALUE_LPAREN, JavaDocTokenType.DOC_TAG_VALUE_RPAREN, JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN, JavaDocTokenType.DOC_TAG_VALUE_LT, JavaDocTokenType.DOC_TAG_VALUE_GT);
    private static final TokenSet INLINE_TAG_BORDERS_SET = TokenSet.create(JavaDocTokenType.DOC_INLINE_TAG_START, JavaDocTokenType.DOC_INLINE_TAG_END);
    public static final TokenSet SKIP_TOKENS = TokenSet.create(JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS);
    @NonNls
    private static final String SEE_TAG = "@see";
    @NonNls
    private static final String LINK_TAG = "@link";
    @NonNls
    private static final String LINK_PLAIN_TAG = "@linkplain";
    @NonNls
    private static final String THROWS_TAG = "@throws";
    @NonNls
    private static final String EXCEPTION_TAG = "@exception";
    @NonNls
    private static final String PARAM_TAG = "@param";
    @NonNls
    private static final String VALUE_TAG = "@value";
    private static final Key<Integer> BRACE_SCOPE_KEY = Key.create("Javadoc.Parser.Brace.Scope");

    private JavadocParser() {
    }

    public static void parseJavadocReference(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/parser/JavadocParser.parseJavadocReference must not be null");
        }
        JavaParsers.REFERENCE_PARSER.parseJavaCodeReference(builder, true, true, false, false, false);
        JavadocParser.swallowTokens(builder);
    }

    public static void parseJavadocType(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/parser/JavadocParser.parseJavadocType must not be null");
        }
        JavaParsers.REFERENCE_PARSER.parseType(builder, 7);
        JavadocParser.swallowTokens(builder);
    }

    private static void swallowTokens(PsiBuilder builder) {
        while (!builder.eof()) {
            builder.advanceLexer();
        }
    }

    public static void parseDocCommentText(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/parser/JavadocParser.parseDocCommentText must not be null");
        }
        builder.enforceCommentTokens(SKIP_TOKENS);
        while (!builder.eof()) {
            IElementType tokenType = JavadocParser.getTokenType(builder);
            if (tokenType == JavaDocTokenType.DOC_TAG_NAME) {
                JavadocParser.parseTag(builder);
                continue;
            }
            JavadocParser.parseDataItem(builder, null, false);
        }
    }

    private static void parseTag(@NotNull PsiBuilder builder) {
        IElementType tokenType;
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/parser/JavadocParser.parseTag must not be null");
        }
        String tagName = builder.getTokenText();
        PsiBuilder.Marker tag = builder.mark();
        builder.advanceLexer();
        while ((tokenType = JavadocParser.getTokenType(builder)) != null && tokenType != JavaDocTokenType.DOC_TAG_NAME && tokenType != JavaDocTokenType.DOC_COMMENT_END) {
            JavadocParser.parseDataItem(builder, tagName, false);
        }
        tag.done(JavaDocElementType.DOC_TAG);
    }

    private static void parseDataItem(@NotNull PsiBuilder builder, @Nullable String tagName, boolean isInline) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/parser/JavadocParser.parseDataItem must not be null");
        }
        IElementType tokenType = JavadocParser.getTokenType(builder);
        if (tokenType == JavaDocTokenType.DOC_INLINE_TAG_START) {
            int braceScope = JavadocParser.getBraceScope(builder);
            if (braceScope > 0) {
                JavadocParser.setBraceScope(builder, braceScope + 1);
                builder.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
                builder.advanceLexer();
                return;
            }
            PsiBuilder.Marker tag = builder.mark();
            builder.advanceLexer();
            tokenType = JavadocParser.getTokenType(builder);
            if (tokenType != JavaDocTokenType.DOC_TAG_NAME && tokenType != JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                tag.rollbackTo();
                builder.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
                builder.advanceLexer();
                return;
            }
            JavadocParser.setBraceScope(builder, braceScope + 1);
            String inlineTagName = "";
            while (true) {
                if ((tokenType = JavadocParser.getTokenType(builder)) == JavaDocTokenType.DOC_TAG_NAME) {
                    inlineTagName = builder.getTokenText();
                } else if (tokenType == null || tokenType == JavaDocTokenType.DOC_COMMENT_END) break;
                JavadocParser.parseDataItem(builder, inlineTagName, true);
                if (tokenType != JavaDocTokenType.DOC_INLINE_TAG_END) continue;
                braceScope = JavadocParser.getBraceScope(builder);
                if (braceScope > 0) {
                    JavadocParser.setBraceScope(builder, --braceScope);
                }
                if (braceScope == 0) break;
            }
            tag.done(JavaDocElementType.DOC_INLINE_TAG);
        } else if (TAG_VALUES_SET.contains(tokenType)) {
            if (SEE_TAG.equals(tagName) && !isInline || LINK_TAG.equals(tagName) && isInline) {
                JavadocParser.parseSeeTagValue(builder);
            } else if (JavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_1_4) && LINK_PLAIN_TAG.equals(tagName) && isInline) {
                JavadocParser.parseSeeTagValue(builder);
            } else if (!isInline && (THROWS_TAG.equals(tagName) || EXCEPTION_TAG.equals(tagName))) {
                PsiBuilder.Marker tagValue = builder.mark();
                builder.remapCurrentToken(JavaDocElementType.DOC_REFERENCE_HOLDER);
                builder.advanceLexer();
                tagValue.done(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
            } else if (!isInline && tagName != null && tagName.equals(PARAM_TAG)) {
                JavadocParser.parseSimpleTagValue(builder, true);
            } else if (JavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_1_5) && VALUE_TAG.equals(tagName) && isInline) {
                JavadocParser.parseSeeTagValue(builder);
            } else {
                JavadocParser.parseSimpleTagValue(builder, false);
            }
        } else {
            JavadocParser.remapAndAdvance(builder);
        }
    }

    private static void parseSeeTagValue(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/parser/JavadocParser.parseSeeTagValue must not be null");
        }
        IElementType tokenType = JavadocParser.getTokenType(builder);
        if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            JavadocParser.parseMethodRef(builder, builder.mark());
        } else if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            PsiBuilder.Marker refStart = builder.mark();
            builder.remapCurrentToken(JavaDocElementType.DOC_REFERENCE_HOLDER);
            builder.advanceLexer();
            if (JavadocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
                JavadocParser.parseMethodRef(builder, refStart);
            } else {
                refStart.drop();
            }
        } else {
            PsiBuilder.Marker tagValue = builder.mark();
            builder.advanceLexer();
            tagValue.done(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
        }
    }

    private static void parseMethodRef(@NotNull PsiBuilder builder, @NotNull PsiBuilder.Marker refStart) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/parser/JavadocParser.parseMethodRef must not be null");
        }
        if (refStart == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/java/parser/JavadocParser.parseMethodRef must not be null");
        }
        builder.advanceLexer();
        if (JavadocParser.getTokenType(builder) != JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            refStart.done(JavaDocElementType.DOC_METHOD_OR_FIELD_REF);
            return;
        }
        builder.advanceLexer();
        if (JavadocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_LPAREN) {
            IElementType tokenType;
            builder.advanceLexer();
            PsiBuilder.Marker subValue = builder.mark();
            while (TAG_VALUES_SET.contains(tokenType = JavadocParser.getTokenType(builder))) {
                if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                    builder.remapCurrentToken(JavaDocElementType.DOC_TYPE_HOLDER);
                    builder.advanceLexer();
                    while (TAG_VALUES_SET.contains(tokenType = JavadocParser.getTokenType(builder)) && tokenType != JavaDocTokenType.DOC_TAG_VALUE_COMMA && tokenType != JavaDocTokenType.DOC_TAG_VALUE_RPAREN) {
                        builder.advanceLexer();
                    }
                    continue;
                }
                if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_RPAREN) {
                    subValue.done(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
                    builder.advanceLexer();
                    refStart.done(JavaDocElementType.DOC_METHOD_OR_FIELD_REF);
                    return;
                }
                builder.advanceLexer();
            }
            subValue.done(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
        }
        refStart.done(JavaDocElementType.DOC_METHOD_OR_FIELD_REF);
    }

    private static void parseSimpleTagValue(@NotNull PsiBuilder builder, boolean parameter) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/parser/JavadocParser.parseSimpleTagValue must not be null");
        }
        PsiBuilder.Marker tagValue = builder.mark();
        while (TAG_VALUES_SET.contains(JavadocParser.getTokenType(builder))) {
            builder.advanceLexer();
        }
        tagValue.done(parameter ? JavaDocElementType.DOC_PARAMETER_REF : JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
    }

    @Nullable
    private static IElementType getTokenType(@NotNull PsiBuilder builder) {
        IElementType tokenType;
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/parser/JavadocParser.getTokenType must not be null");
        }
        while ((tokenType = builder.getTokenType()) == JavaDocTokenType.DOC_SPACE) {
            builder.remapCurrentToken(TokenType.WHITE_SPACE);
            builder.advanceLexer();
        }
        return tokenType;
    }

    private static int getBraceScope(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/parser/JavadocParser.getBraceScope must not be null");
        }
        Integer braceScope = builder.getUserDataUnprotected(BRACE_SCOPE_KEY);
        return braceScope != null ? braceScope : 0;
    }

    private static void setBraceScope(@NotNull PsiBuilder builder, int braceScope) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/parser/JavadocParser.setBraceScope must not be null");
        }
        builder.putUserDataUnprotected(BRACE_SCOPE_KEY, braceScope);
    }

    private static void remapAndAdvance(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/java/parser/JavadocParser.remapAndAdvance must not be null");
        }
        if (INLINE_TAG_BORDERS_SET.contains(builder.getTokenType()) && JavadocParser.getBraceScope(builder) != 1) {
            builder.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
        }
        builder.advanceLexer();
    }
}

