/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.source.PsiJavaFileImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JavaParserDefinition
implements ParserDefinition {
    @Override
    @NotNull
    public Lexer createLexer(Project project) {
        LanguageLevel languageLevel = LanguageLevelProjectExtension.getInstance(project).getLanguageLevel();
        Lexer lexer = JavaParserDefinition.createLexer(languageLevel);
        if (lexer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.createLexer must not return null");
        }
        return lexer;
    }

    @NotNull
    public static Lexer createLexer(LanguageLevel languageLevel) {
        JavaLexer javaLexer = new JavaLexer(languageLevel);
        if (javaLexer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.createLexer must not return null");
        }
        return javaLexer;
    }

    @Override
    public IFileElementType getFileNodeType() {
        return JavaStubElementTypes.JAVA_FILE;
    }

    @Override
    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = ElementType.JAVA_WHITESPACE_BIT_SET;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.getWhitespaceTokens must not return null");
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = ElementType.JAVA_COMMENT_BIT_SET;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.getCommentTokens must not return null");
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.create(JavaElementType.LITERAL_EXPRESSION);
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.getStringLiteralElements must not return null");
        }
        return tokenSet;
    }

    @Override
    @NotNull
    public PsiParser createParser(Project project) {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    @Override
    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof JavaStubElementType) {
            Object PsiT = ((JavaStubElementType)type).createPsi(node);
            if (PsiT == null) {
                throw new IllegalStateException("@NotNull method com/intellij/lang/java/JavaParserDefinition.createElement must not return null");
            }
            return PsiT;
        }
        throw new IllegalStateException("Incorrect node for JavaParserDefinition: " + node + " (" + type + ")");
    }

    @Override
    public PsiFile createFile(FileViewProvider viewProvider) {
        return new PsiJavaFileImpl(viewProvider);
    }

    @Override
    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        String text;
        PsiFile containingFile = left.getTreeParent().getPsi().getContainingFile();
        JavaLexer lexer = containingFile instanceof PsiJavaFile ? new JavaLexer(((PsiJavaFile)containingFile).getLanguageLevel()) : new JavaLexer(LanguageLevel.HIGHEST);
        if (right.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            return ParserDefinition.SpaceRequirements.MUST_NOT;
        }
        if (left.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            return ParserDefinition.SpaceRequirements.MUST_NOT;
        }
        ParserDefinition.SpaceRequirements spaceRequirements = LanguageUtil.canStickTokensTogetherByLexer(left, right, lexer);
        if (left.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        if (left.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA && (text = left.getText()).length() > 0 && Character.isWhitespace(text.charAt(text.length() - 1))) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        if (right.getElementType() == JavaDocTokenType.DOC_COMMENT_DATA ? (text = right.getText()).length() > 0 && Character.isWhitespace(text.charAt(0)) : right.getElementType() == JavaDocTokenType.DOC_INLINE_TAG_END) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        return spaceRequirements;
    }
}

