/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ForeignLeafType;
import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.TokenWrapper;
import com.intellij.lang.WhitespaceSkippedCallback;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.impl.ASTNodeBuilder;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.CustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.ILeafElementType;
import com.intellij.psi.tree.ILightLazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.LimitedPool;
import com.intellij.util.containers.Stack;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import com.intellij.util.text.CharArrayUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBuilderImpl
extends UserDataHolderBase
implements PsiBuilder,
ASTNodeBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.lang.impl.PsiBuilderImpl");
    public static final Key<TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState>> CUSTOM_COMPARATOR = Key.create("CUSTOM_COMPARATOR");
    private final Project myProject;
    private PsiFile myFile;
    private int[] myLexStarts;
    private IElementType[] myLexTypes;
    private int myCurrentLexeme;
    private final MyList myProduction;
    private final Lexer myLexer;
    private final TokenSet myWhitespaces;
    private TokenSet myComments;
    private CharTable myCharTable;
    private final CharSequence myText;
    private final char[] myTextArray;
    private boolean myDebugMode;
    private int myLexemeCount;
    private boolean myTokenTypeChecked;
    private ITokenTypeRemapper myRemapper;
    private WhitespaceSkippedCallback myWhitespaceSkippedCallback;
    private final ASTNode myOriginalTree;
    private final MyTreeStructure myParentLightTree;
    private static TokenSet ourAnyLanguageWhitespaceTokens = TokenSet.EMPTY;
    private Map<Key, Object> myUserData;
    private final LimitedPool<StartMarker> START_MARKERS;
    private final LimitedPool<DoneMarker> DONE_MARKERS;
    private static final WhitespacesAndCommentsBinder DEFAULT_LEFT_EDGE_TOKEN_BINDER = new WhitespacesAndCommentsBinder(){

        @Override
        public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            return tokens.size();
        }
    };
    private static final WhitespacesAndCommentsBinder DEFAULT_RIGHT_EDGE_TOKEN_BINDER = new WhitespacesAndCommentsBinder(){

        @Override
        public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            return 0;
        }
    };
    @NonNls
    private static final String UNBALANCED_MESSAGE = "Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem";

    public static void registerWhitespaceToken(IElementType type) {
        ourAnyLanguageWhitespaceTokens = TokenSet.orSet(ourAnyLanguageWhitespaceTokens, TokenSet.create(type));
    }

    public PsiBuilderImpl(@NotNull Project project, PsiFile containingFile, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, CharTable charTable, @NotNull CharSequence text, @Nullable ASTNode originalTree, @Nullable MyTreeStructure parentLightTree) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        if (parserDefinition == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        if (lexer == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        this(project, containingFile, parserDefinition.getWhitespaceTokens(), parserDefinition.getCommentTokens(), lexer, charTable, text, originalTree, parentLightTree);
    }

    public PsiBuilderImpl(Project project, PsiFile containingFile, @NotNull TokenSet whiteSpaces, @NotNull TokenSet comments, @NotNull Lexer lexer, CharTable charTable, @NotNull CharSequence text, @Nullable ASTNode originalTree, @Nullable MyTreeStructure parentLightTree) {
        if (whiteSpaces == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        if (comments == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        if (lexer == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        this.myProduction = new MyList();
        this.myDebugMode = false;
        this.myLexemeCount = 0;
        this.myUserData = null;
        this.START_MARKERS = new LimitedPool<StartMarker>(2000, new LimitedPool.ObjectFactory<StartMarker>(){

            @Override
            public StartMarker create() {
                return new StartMarker();
            }

            @Override
            public void cleanup(StartMarker startMarker) {
                startMarker.clean();
            }
        });
        this.DONE_MARKERS = new LimitedPool<DoneMarker>(2000, new LimitedPool.ObjectFactory<DoneMarker>(){

            @Override
            public DoneMarker create() {
                return new DoneMarker();
            }

            @Override
            public void cleanup(DoneMarker doneMarker) {
                doneMarker.clean();
            }
        });
        this.myProject = project;
        this.myFile = containingFile;
        this.myText = text;
        this.myTextArray = CharArrayUtil.fromSequenceWithoutCopying(text);
        this.myLexer = lexer;
        this.myWhitespaces = whiteSpaces;
        this.myComments = comments;
        this.myCharTable = charTable;
        this.myOriginalTree = originalTree;
        this.myParentLightTree = parentLightTree;
        this.cacheLexemes();
    }

    public PsiBuilderImpl(@NotNull Project project, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @NotNull ASTNode chameleon, @NotNull CharSequence text) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        if (parserDefinition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        if (lexer == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        if (chameleon == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        this(project, SharedImplUtil.getContainingFile(chameleon), parserDefinition, lexer, SharedImplUtil.findCharTableByTree(chameleon), text, chameleon.getUserData(BlockSupport.TREE_TO_BE_REPARSED), null);
    }

    public PsiBuilderImpl(@NotNull Project project, @NotNull ParserDefinition parserDefinition, @NotNull Lexer lexer, @NotNull LighterLazyParseableNode chameleon, @NotNull CharSequence text) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        if (parserDefinition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        if (lexer == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        if (chameleon == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.<init> must not be null");
        }
        this(project, chameleon.getContainingFile(), parserDefinition, lexer, chameleon.getCharTable(), text, null, ((LazyParseableToken)chameleon).myParent);
    }

    private void cacheLexemes() {
        int approxLexCount = Math.max(10, this.myText.length() / 5);
        this.myLexStarts = new int[approxLexCount];
        this.myLexTypes = new IElementType[approxLexCount];
        this.myLexer.start(this.myText);
        int i = 0;
        int offset = 0;
        while (true) {
            int tokenStart;
            ProgressIndicatorProvider.checkCanceled();
            IElementType type = this.myLexer.getTokenType();
            if (type == null) break;
            if (i >= this.myLexTypes.length - 1) {
                this.resizeLexemes(i * 3 / 2);
            }
            if ((tokenStart = this.myLexer.getTokenStart()) < offset) {
                StringBuilder sb = new StringBuilder();
                IElementType tokenType = this.myLexer.getTokenType();
                sb.append("Token sequence broken").append("\n  this: '").append(this.myLexer.getTokenText()).append("' (").append(tokenType).append(':').append(tokenType != null ? tokenType.getLanguage() : null).append(") ").append(tokenStart).append(":").append(this.myLexer.getTokenEnd());
                if (i > 0) {
                    int prevStart = this.myLexStarts[i - 1];
                    sb.append("\n  prev: '").append(this.myText.subSequence(prevStart, offset)).append("' (").append(this.myLexTypes[i - 1]).append(':').append(this.myLexTypes[i - 1].getLanguage()).append(") ").append(prevStart).append(":").append(offset);
                }
                int quoteStart = Math.max(tokenStart - 256, 0);
                int quoteEnd = Math.min(tokenStart + 256, this.myText.length());
                sb.append("\n  quote: [").append(quoteStart).append(':').append(quoteEnd).append("] '").append(this.myText.subSequence(quoteStart, quoteEnd)).append('\'');
                LOG.error(sb);
            }
            this.myLexStarts[i] = offset = tokenStart;
            this.myLexTypes[i] = type;
            ++i;
            this.myLexer.advance();
        }
        this.myLexStarts[i] = this.myText.length();
        this.myLexemeCount = i;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void enforceCommentTokens(TokenSet tokens) {
        this.myComments = tokens;
    }

    @Override
    @Nullable
    public LighterASTNode getLatestDoneMarker() {
        for (int index = this.myProduction.size() - 1; index >= 0; --index) {
            ProductionMarker marker = (ProductionMarker)this.myProduction.get(index);
            if (!(marker instanceof DoneMarker)) continue;
            return ((DoneMarker)marker).myStart;
        }
        return null;
    }

    @Override
    public IElementType getElementType(int lexemIndex) {
        return lexemIndex < this.myLexemeCount && lexemIndex >= 0 ? this.myLexTypes[lexemIndex] : null;
    }

    private PsiBuilder.Marker precede(StartMarker marker) {
        int idx = this.myProduction.lastIndexOf(marker);
        if (idx < 0) {
            LOG.error("Cannot precede dropped or rolled-back marker");
        }
        StartMarker pre = this.createMarker(marker.myLexemeIndex);
        this.myProduction.add(idx, pre);
        return pre;
    }

    @Override
    public CharSequence getOriginalText() {
        return this.myText;
    }

    @Override
    public IElementType getTokenType() {
        if (this.eof()) {
            return null;
        }
        if (this.myRemapper != null) {
            IElementType type = this.myLexTypes[this.myCurrentLexeme];
            this.myLexTypes[this.myCurrentLexeme] = type = this.myRemapper.filter(type, this.myLexStarts[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme + 1], this.myLexer.getBufferSequence());
            return type;
        }
        return this.myLexTypes[this.myCurrentLexeme];
    }

    @Override
    public void setTokenTypeRemapper(ITokenTypeRemapper remapper) {
        this.myRemapper = remapper;
    }

    @Override
    public void remapCurrentToken(IElementType type) {
        this.myLexTypes[this.myCurrentLexeme] = type;
    }

    @Override
    @Nullable
    public IElementType lookAhead(int steps) {
        if (this.eof()) {
            return null;
        }
        int cur = this.myCurrentLexeme;
        while (steps > 0) {
            ++cur;
            while (cur < this.myLexemeCount && this.whitespaceOrComment(this.myLexTypes[cur])) {
                ++cur;
            }
            --steps;
        }
        return cur < this.myLexemeCount ? this.myLexTypes[cur] : null;
    }

    @Override
    public IElementType rawLookup(int steps) {
        int cur = this.myCurrentLexeme + steps;
        return cur < this.myLexemeCount && cur >= 0 ? this.myLexTypes[cur] : null;
    }

    @Override
    public int rawTokenTypeStart(int steps) {
        int cur = this.myCurrentLexeme + steps;
        if (cur < 0) {
            return -1;
        }
        if (cur >= this.myLexemeCount) {
            return this.getOriginalText().length();
        }
        return this.myLexStarts[cur];
    }

    @Override
    public void setWhitespaceSkippedCallback(WhitespaceSkippedCallback callback) {
        this.myWhitespaceSkippedCallback = callback;
    }

    @Override
    public void advanceLexer() {
        if (this.eof()) {
            return;
        }
        if (!this.myTokenTypeChecked) {
            LOG.assertTrue(this.eof(), "Probably a bug: eating token without its type checking");
        }
        this.myTokenTypeChecked = false;
        ++this.myCurrentLexeme;
        ProgressIndicatorProvider.checkCanceled();
    }

    private void skipWhitespace() {
        while (this.myCurrentLexeme < this.myLexemeCount && this.whitespaceOrComment(this.myLexTypes[this.myCurrentLexeme])) {
            this.onSkip(this.myLexTypes[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme], this.myCurrentLexeme + 1 < this.myLexemeCount ? this.myLexStarts[this.myCurrentLexeme + 1] : this.myText.length());
            ++this.myCurrentLexeme;
        }
    }

    private void onSkip(IElementType type, int start, int end) {
        if (this.myWhitespaceSkippedCallback != null) {
            this.myWhitespaceSkippedCallback.onSkip(type, start, end);
        }
    }

    @Override
    public int getCurrentOffset() {
        if (this.eof()) {
            return this.getOriginalText().length();
        }
        return this.myLexStarts[this.myCurrentLexeme];
    }

    @Override
    @Nullable
    public String getTokenText() {
        if (this.eof()) {
            return null;
        }
        IElementType type = this.getTokenType();
        if (type instanceof TokenWrapper) {
            return ((TokenWrapper)type).getValue();
        }
        return ((Object)this.myText.subSequence(this.myLexStarts[this.myCurrentLexeme], this.myLexStarts[this.myCurrentLexeme + 1])).toString();
    }

    private void resizeLexemes(int newSize) {
        int count = Math.min(newSize, this.myLexTypes.length);
        int[] newStarts = new int[newSize + 1];
        System.arraycopy(this.myLexStarts, 0, newStarts, 0, count);
        this.myLexStarts = newStarts;
        IElementType[] newTypes = new IElementType[newSize];
        System.arraycopy(this.myLexTypes, 0, newTypes, 0, count);
        this.myLexTypes = newTypes;
    }

    private boolean whitespaceOrComment(IElementType token) {
        return this.myWhitespaces.contains(token) || this.myComments.contains(token);
    }

    @Override
    public PsiBuilder.Marker mark() {
        if (!this.myProduction.isEmpty()) {
            this.skipWhitespace();
        }
        StartMarker marker = this.createMarker(this.myCurrentLexeme);
        this.myProduction.add(marker);
        return marker;
    }

    private StartMarker createMarker(int lexemeIndex) {
        StartMarker marker = this.START_MARKERS.alloc();
        marker.myLexemeIndex = lexemeIndex;
        marker.myBuilder = this;
        if (this.myDebugMode) {
            marker.myDebugAllocationPosition = new Throwable("Created at the following trace.");
        }
        return marker;
    }

    @Override
    public final boolean eof() {
        if (!this.markTokenTypeChecked()) {
            this.skipWhitespace();
        }
        return this.myCurrentLexeme >= this.myLexemeCount;
    }

    public boolean markTokenTypeChecked() {
        if (!this.myTokenTypeChecked) {
            this.myTokenTypeChecked = true;
            return false;
        }
        return true;
    }

    private void rollbackTo(PsiBuilder.Marker marker) {
        this.myCurrentLexeme = ((StartMarker)marker).myLexemeIndex;
        this.markTokenTypeChecked();
        int idx = this.myProduction.lastIndexOf(marker);
        if (idx < 0) {
            LOG.error("The marker must be added before rolled back to.");
        }
        this.myProduction.removeRange(idx, this.myProduction.size());
        this.START_MARKERS.recycle((StartMarker)marker);
    }

    public void drop(PsiBuilder.Marker marker) {
        boolean removed;
        DoneMarker doneMarker = ((StartMarker)marker).myDoneMarker;
        if (doneMarker != null) {
            this.myProduction.remove(this.myProduction.lastIndexOf(doneMarker));
            this.DONE_MARKERS.recycle(doneMarker);
        }
        boolean bl = removed = this.myProduction.remove(this.myProduction.lastIndexOf(marker)) == marker;
        if (!removed) {
            LOG.error("The marker must be added before it is dropped.");
        }
        this.START_MARKERS.recycle((StartMarker)marker);
    }

    public void error(PsiBuilder.Marker marker, String message) {
        this.doValidityChecks(marker, null);
        DoneWithErrorMarker doneMarker = new DoneWithErrorMarker((StartMarker)marker, this.myCurrentLexeme, message);
        boolean tieToTheLeft = this.isEmpty(((StartMarker)marker).myLexemeIndex, this.myCurrentLexeme);
        if (tieToTheLeft) {
            ((StartMarker)marker).myEdgeTokenBinder = DEFAULT_RIGHT_EDGE_TOKEN_BINDER;
        }
        ((StartMarker)marker).myDoneMarker = doneMarker;
        this.myProduction.add(doneMarker);
    }

    public void errorBefore(PsiBuilder.Marker marker, String message, PsiBuilder.Marker before) {
        this.doValidityChecks(marker, before);
        int beforeIndex = this.myProduction.lastIndexOf(before);
        DoneWithErrorMarker doneMarker = new DoneWithErrorMarker((StartMarker)marker, ((StartMarker)before).myLexemeIndex, message);
        boolean tieToTheLeft = this.isEmpty(((StartMarker)marker).myLexemeIndex, ((StartMarker)before).myLexemeIndex);
        if (tieToTheLeft) {
            ((StartMarker)marker).myEdgeTokenBinder = DEFAULT_RIGHT_EDGE_TOKEN_BINDER;
        }
        ((StartMarker)marker).myDoneMarker = doneMarker;
        this.myProduction.add(beforeIndex, doneMarker);
    }

    public void done(PsiBuilder.Marker marker) {
        boolean tieToTheLeft;
        this.doValidityChecks(marker, null);
        DoneMarker doneMarker = this.DONE_MARKERS.alloc();
        doneMarker.myStart = (StartMarker)marker;
        doneMarker.myLexemeIndex = this.myCurrentLexeme;
        boolean bl = tieToTheLeft = doneMarker.myStart.myType.isLeftBound() && this.isEmpty(((StartMarker)marker).myLexemeIndex, this.myCurrentLexeme);
        if (tieToTheLeft) {
            ((StartMarker)marker).myEdgeTokenBinder = DEFAULT_RIGHT_EDGE_TOKEN_BINDER;
        }
        ((StartMarker)marker).myDoneMarker = doneMarker;
        this.myProduction.add(doneMarker);
    }

    public void doneBefore(PsiBuilder.Marker marker, PsiBuilder.Marker before) {
        boolean tieToTheLeft;
        this.doValidityChecks(marker, before);
        int beforeIndex = this.myProduction.lastIndexOf(before);
        DoneMarker doneMarker = this.DONE_MARKERS.alloc();
        doneMarker.myLexemeIndex = ((StartMarker)before).myLexemeIndex;
        doneMarker.myStart = (StartMarker)marker;
        boolean bl = tieToTheLeft = doneMarker.myStart.myType.isLeftBound() && this.isEmpty(((StartMarker)marker).myLexemeIndex, ((StartMarker)before).myLexemeIndex);
        if (tieToTheLeft) {
            ((StartMarker)marker).myEdgeTokenBinder = DEFAULT_RIGHT_EDGE_TOKEN_BINDER;
        }
        ((StartMarker)marker).myDoneMarker = doneMarker;
        this.myProduction.add(beforeIndex, doneMarker);
    }

    private boolean isEmpty(int startIdx, int endIdx) {
        for (int i = startIdx; i < endIdx; ++i) {
            IElementType token = this.myLexTypes[i];
            if (this.whitespaceOrComment(token)) continue;
            return false;
        }
        return true;
    }

    public void collapse(PsiBuilder.Marker marker) {
        this.done(marker);
        ((StartMarker)marker).myDoneMarker.myCollapse = true;
    }

    private void doValidityChecks(PsiBuilder.Marker marker, @Nullable PsiBuilder.Marker before) {
        DoneMarker doneMarker = ((StartMarker)marker).myDoneMarker;
        if (doneMarker != null) {
            LOG.error("Marker already done.");
        }
        if (!this.myDebugMode) {
            return;
        }
        int idx = this.myProduction.lastIndexOf(marker);
        if (idx < 0) {
            LOG.error("Marker has never been added.");
        }
        int endIdx = this.myProduction.size();
        if (before != null) {
            endIdx = this.myProduction.lastIndexOf(before);
            if (endIdx < 0) {
                LOG.error("'Before' marker has never been added.");
            }
            if (idx > endIdx) {
                LOG.error("'Before' marker precedes this one.");
            }
        }
        for (int i = endIdx - 1; i > idx; --i) {
            StartMarker otherMarker;
            Object item = this.myProduction.get(i);
            if (!(item instanceof StartMarker) || (otherMarker = (StartMarker)item).myDoneMarker != null) continue;
            Throwable debugAllocOther = otherMarker.myDebugAllocationPosition;
            Throwable debugAllocThis = ((StartMarker)marker).myDebugAllocationPosition;
            if (debugAllocOther != null) {
                Throwable currentTrace = new Throwable();
                ExceptionUtil.makeStackTraceRelative(debugAllocThis, currentTrace).printStackTrace(System.err);
                ExceptionUtil.makeStackTraceRelative(debugAllocOther, currentTrace).printStackTrace(System.err);
            }
            LOG.error("Another not done marker added after this one. Must be done before this.");
        }
    }

    @Override
    public void error(String messageText) {
        ProductionMarker lastMarker = (ProductionMarker)this.myProduction.get(this.myProduction.size() - 1);
        if (lastMarker instanceof ErrorItem && lastMarker.myLexemeIndex == this.myCurrentLexeme) {
            return;
        }
        this.myProduction.add(new ErrorItem(this, messageText, this.myCurrentLexeme));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ASTNode getTreeBuilt() {
        try {
            ASTNode aSTNode = this.buildTree();
            return aSTNode;
        }
        finally {
            int myProductionSize = this.myProduction.size();
            for (int i = 0; i < myProductionSize; ++i) {
                ProductionMarker marker = (ProductionMarker)this.myProduction.get(i);
                if (marker instanceof StartMarker) {
                    this.START_MARKERS.recycle((StartMarker)marker);
                    continue;
                }
                if (!(marker instanceof DoneMarker)) continue;
                this.DONE_MARKERS.recycle((DoneMarker)marker);
            }
        }
    }

    private ASTNode buildTree() {
        boolean isTooDeep;
        StartMarker rootMarker = this.prepareLightTree();
        boolean bl = isTooDeep = this.myFile != null && BlockSupport.isTooDeep(this.myFile.getOriginalFile());
        if (this.myOriginalTree != null && !isTooDeep) {
            DiffLog diffLog = this.merge(this.myOriginalTree, rootMarker);
            throw new BlockSupport.ReparsedSuccessfullyException(diffLog);
        }
        ASTNode rootNode = this.createRootAST(rootMarker);
        this.bind(rootMarker, (CompositeElement)rootNode);
        if (isTooDeep && !(rootNode instanceof FileElement)) {
            ASTNode childNode = rootNode.getFirstChildNode();
            childNode.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
        }
        return rootNode;
    }

    @Override
    public FlyweightCapableTreeStructure<LighterASTNode> getLightTree() {
        StartMarker rootMarker = this.prepareLightTree();
        return new MyTreeStructure(rootMarker, this.myParentLightTree);
    }

    private ASTNode createRootAST(StartMarker rootMarker) {
        CompositeElement rootNode;
        IElementType type = rootMarker.getTokenType();
        CompositeElement compositeElement = rootNode = type instanceof ILazyParseableElementType ? ASTFactory.lazy((ILazyParseableElementType)type, null) : PsiBuilderImpl.createComposite(rootMarker);
        if (this.myCharTable == null) {
            CharTable charTable = this.myCharTable = rootNode instanceof FileElement ? ((FileElement)rootNode).getCharTable() : new CharTableImpl();
        }
        if (!(rootNode instanceof FileElement)) {
            rootNode.putUserData(CharTable.CHAR_TABLE_KEY, this.myCharTable);
        }
        return rootNode;
    }

    @NotNull
    private DiffLog merge(@NotNull ASTNode oldRoot, @NotNull StartMarker newRoot) {
        if (oldRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.merge must not be null");
        }
        if (newRoot == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.merge must not be null");
        }
        DiffLog diffLog = new DiffLog();
        ConvertFromTokensToASTBuilder builder = new ConvertFromTokensToASTBuilder(newRoot, diffLog);
        MyTreeStructure treeStructure = new MyTreeStructure(newRoot, null);
        MyComparator comparator = new MyComparator(this.getUserDataUnprotected(CUSTOM_COMPARATOR), treeStructure);
        ProgressIndicatorProvider provider = ProgressIndicatorProvider.getInstance();
        ProgressIndicator indicator = provider != null ? provider.getProgressIndicator() : null;
        BlockSupportImpl.diffTrees(oldRoot, builder, comparator, treeStructure, indicator);
        DiffLog diffLog2 = diffLog;
        if (diffLog2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderImpl.merge must not return null");
        }
        return diffLog2;
    }

    @NotNull
    private StartMarker prepareLightTree() {
        this.markTokenTypeChecked();
        this.balanceWhiteSpaces();
        LOG.assertTrue(!this.myProduction.isEmpty(), "Parser produced no markers. Text:\n" + this.myText);
        StartMarker rootMarker = (StartMarker)this.myProduction.get(0);
        rootMarker.myNext = null;
        rootMarker.myParent = rootMarker.myFirstChild = (rootMarker.myLastChild = null);
        StartMarker curNode = rootMarker;
        Stack<StartMarker> nodes = new Stack<StartMarker>();
        nodes.push(rootMarker);
        int lastErrorIndex = -1;
        int maxDepth = 0;
        int curDepth = 0;
        for (int i = 1; i < this.myProduction.size(); ++i) {
            int curToken;
            ProductionMarker item = (ProductionMarker)this.myProduction.get(i);
            if (curNode == null) {
                LOG.error("Unexpected end of the production");
            }
            item.myParent = curNode;
            if (item instanceof StartMarker) {
                StartMarker marker = (StartMarker)item;
                marker.myNext = null;
                marker.myFirstChild = (marker.myLastChild = null);
                curNode.addChild(marker);
                nodes.push(curNode);
                curNode = marker;
                if (++curDepth <= maxDepth) continue;
                maxDepth = curDepth;
                continue;
            }
            if (item instanceof DoneMarker) {
                if (((DoneMarker)item).myStart != curNode) {
                    LOG.error(UNBALANCED_MESSAGE);
                }
                curNode = (StartMarker)nodes.pop();
                --curDepth;
                continue;
            }
            if (!(item instanceof ErrorItem) || (curToken = item.myLexemeIndex) == lastErrorIndex) continue;
            lastErrorIndex = curToken;
            curNode.addChild(item);
        }
        if (this.myCurrentLexeme < this.myLexemeCount) {
            List<IElementType> missed = CollectionFactory.arrayList(this.myLexTypes, this.myCurrentLexeme, this.myLexemeCount);
            LOG.error("Tokens " + missed + " were not inserted into the tree. " + (this.myFile != null ? this.myFile.getLanguage() + ", " : "") + "Text:\n" + this.myText);
        }
        if (((StartMarker)rootMarker).myDoneMarker.myLexemeIndex < this.myLexemeCount) {
            List<IElementType> missed = CollectionFactory.arrayList(this.myLexTypes, ((StartMarker)rootMarker).myDoneMarker.myLexemeIndex, this.myLexemeCount);
            LOG.error("Tokens " + missed + " are outside of root element \"" + rootMarker.myType + "\". Text:\n" + this.myText);
        }
        if (this.myLexStarts.length <= this.myCurrentLexeme + 1) {
            this.resizeLexemes(this.myCurrentLexeme + 1);
        }
        this.myLexStarts[this.myCurrentLexeme] = this.myText.length();
        this.myLexStarts[this.myCurrentLexeme + 1] = 0;
        this.myLexTypes[this.myCurrentLexeme] = null;
        LOG.assertTrue(curNode == rootMarker, UNBALANCED_MESSAGE);
        this.checkTreeDepth(maxDepth, rootMarker.getTokenType() instanceof IFileElementType);
        StartMarker startMarker = rootMarker;
        if (startMarker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderImpl.prepareLightTree must not return null");
        }
        return startMarker;
    }

    private void balanceWhiteSpaces() {
        for (int i = 1; i < this.myProduction.size() - 1; ++i) {
            int wsEndIndex;
            int idx;
            ProductionMarker item = (ProductionMarker)this.myProduction.get(i);
            if (item instanceof StartMarker && ((StartMarker)item).myDoneMarker == null) {
                LOG.error(UNBALANCED_MESSAGE);
            }
            int prevProductionLexIndex = ((ProductionMarker)this.myProduction.get((int)(i - 1))).myLexemeIndex;
            for (idx = item.myLexemeIndex; idx > prevProductionLexIndex && this.whitespaceOrComment(this.myLexTypes[idx - 1]); --idx) {
            }
            final int wsStartIndex = idx;
            for (wsEndIndex = item.myLexemeIndex; wsEndIndex < this.myLexemeCount && this.whitespaceOrComment(this.myLexTypes[wsEndIndex]); ++wsEndIndex) {
            }
            List<IElementType> wsTokens = CollectionFactory.arrayList(this.myLexTypes, wsStartIndex, wsEndIndex);
            boolean atEnd = wsStartIndex == 0 || wsEndIndex == this.myLexemeCount;
            WhitespacesAndCommentsBinder.TokenTextGetter getter = new WhitespacesAndCommentsBinder.TokenTextGetter(){

                @Override
                public CharSequence get(int i) {
                    return PsiBuilderImpl.this.myText.subSequence(PsiBuilderImpl.this.myLexStarts[wsStartIndex + i], PsiBuilderImpl.this.myLexStarts[wsStartIndex + i + 1]);
                }
            };
            item.myLexemeIndex = wsStartIndex + item.myEdgeTokenBinder.getEdgePosition(wsTokens, atEnd, getter);
        }
    }

    private void checkTreeDepth(int maxDepth, boolean isFileRoot) {
        if (this.myFile == null) {
            return;
        }
        PsiFile file = this.myFile.getOriginalFile();
        Boolean flag = file.getUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED);
        if (maxDepth > BlockSupport.INCREMENTAL_REPARSE_DEPTH_LIMIT) {
            if (!Boolean.TRUE.equals(flag)) {
                file.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
            }
        } else if (isFileRoot && flag != null) {
            file.putUserData(BlockSupport.TREE_DEPTH_LIMIT_EXCEEDED, null);
        }
    }

    private void bind(StartMarker rootMarker, CompositeElement rootNode) {
        StartMarker curMarker = rootMarker;
        CompositeElement curNode = rootNode;
        int lexIndex = rootMarker.myLexemeIndex;
        ProductionMarker item = rootMarker.myFirstChild != null ? rootMarker.myFirstChild : rootMarker.myDoneMarker;
        while (true) {
            lexIndex = this.insertLeaves(lexIndex, item.myLexemeIndex, curNode);
            if (item == rootMarker.myDoneMarker) break;
            if (item instanceof StartMarker) {
                StartMarker marker = (StartMarker)item;
                if (!marker.myDoneMarker.myCollapse) {
                    curMarker = marker;
                    CompositeElement childNode = PsiBuilderImpl.createComposite(marker);
                    curNode.rawAddChildrenWithoutNotifications(childNode);
                    curNode = childNode;
                    item = marker.myFirstChild != null ? marker.myFirstChild : marker.myDoneMarker;
                    continue;
                }
                lexIndex = this.collapseLeaves(curNode, marker);
            } else if (item instanceof ErrorItem) {
                CompositeElement errorElement = Factory.createErrorElement(((ErrorItem)item).myMessage);
                curNode.rawAddChildrenWithoutNotifications(errorElement);
            } else if (item instanceof DoneMarker) {
                curMarker = (StartMarker)((DoneMarker)((DoneMarker)item)).myStart.myParent;
                curNode = curNode.getTreeParent();
                item = ((DoneMarker)item).myStart;
            }
            item = item.myNext != null ? item.myNext : curMarker.myDoneMarker;
        }
    }

    private int insertLeaves(int curToken, int lastIdx, CompositeElement curNode) {
        lastIdx = Math.min(lastIdx, this.myLexemeCount);
        while (curToken < lastIdx) {
            ProgressIndicatorProvider.checkCanceled();
            int start = this.myLexStarts[curToken];
            int end = this.myLexStarts[curToken + 1];
            if (start < end || this.myLexTypes[curToken] instanceof ILeafElementType) {
                IElementType type = this.myLexTypes[curToken];
                TreeElement leaf = this.createLeaf(type, start, end);
                curNode.rawAddChildrenWithoutNotifications(leaf);
            }
            ++curToken;
        }
        return curToken;
    }

    private int collapseLeaves(CompositeElement ast, StartMarker startMarker) {
        int start = this.myLexStarts[startMarker.myLexemeIndex];
        int end = this.myLexStarts[((StartMarker)startMarker).myDoneMarker.myLexemeIndex];
        TreeElement leaf = this.createLeaf(startMarker.myType, start, end);
        ast.rawAddChildrenWithoutNotifications(leaf);
        return ((StartMarker)startMarker).myDoneMarker.myLexemeIndex;
    }

    private static CompositeElement createComposite(StartMarker marker) {
        IElementType type = marker.myType;
        if (type == TokenType.ERROR_ELEMENT) {
            String message = marker.myDoneMarker instanceof DoneWithErrorMarker ? ((DoneWithErrorMarker)marker.myDoneMarker).myMessage : null;
            return Factory.createErrorElement(message);
        }
        if (type == null) {
            throw new RuntimeException(UNBALANCED_MESSAGE);
        }
        return ASTFactory.composite(type);
    }

    @Nullable
    public static String getErrorMessage(LighterASTNode node) {
        StartMarker marker;
        if (node instanceof ErrorItem) {
            return ((ErrorItem)node).myMessage;
        }
        if (node instanceof StartMarker && (marker = (StartMarker)node).myType == TokenType.ERROR_ELEMENT && marker.myDoneMarker instanceof DoneWithErrorMarker) {
            return ((DoneWithErrorMarker)marker.myDoneMarker).myMessage;
        }
        return null;
    }

    @Override
    public void setDebugMode(boolean dbgMode) {
        this.myDebugMode = dbgMode;
    }

    public Lexer getLexer() {
        return this.myLexer;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private TreeElement createLeaf(IElementType type, int start, int end) {
        TreeElement treeElement;
        CharSequence text = this.myCharTable.intern(this.myText, start, end);
        if (this.myWhitespaces.contains(type)) {
            treeElement = new PsiWhiteSpaceImpl(text);
            if (treeElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderImpl.createLeaf must not return null");
            return treeElement;
        }
        if (type instanceof CustomParsingType) {
            treeElement = (TreeElement)((CustomParsingType)type).parse(text, this.myCharTable);
            if (treeElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderImpl.createLeaf must not return null");
            return treeElement;
        }
        if (type instanceof ILazyParseableElementType) {
            treeElement = ASTFactory.lazy((ILazyParseableElementType)type, text);
            if (treeElement == null) throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderImpl.createLeaf must not return null");
            return treeElement;
        }
        treeElement = ASTFactory.leaf(type, text);
        if (treeElement != null) return treeElement;
        throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderImpl.createLeaf must not return null");
    }

    @Override
    public <T> T getUserDataUnprotected(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.getUserDataUnprotected must not be null");
        }
        if (key == FileContextUtil.CONTAINING_FILE_KEY) {
            return (T)this.myFile;
        }
        return (T)(this.myUserData != null ? this.myUserData.get(key) : null);
    }

    @Override
    public <T> void putUserDataUnprotected(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl.putUserDataUnprotected must not be null");
        }
        if (this.myUserData == null) {
            this.myUserData = CollectionFactory.hashMap();
        }
        this.myUserData.put(key, value);
    }

    private static class MyList
    extends ArrayList<ProductionMarker> {
        private static final Field ourElementDataField;
        private Object[] cachedElementData;

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }

        MyList() {
            super(256);
        }

        @Override
        public int lastIndexOf(Object o) {
            if (this.cachedElementData == null) {
                return super.lastIndexOf(o);
            }
            for (int i = this.size() - 1; i >= 0; --i) {
                if (this.cachedElementData[i] != o) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void ensureCapacity(int minCapacity) {
            if (this.cachedElementData == null || minCapacity >= this.cachedElementData.length) {
                super.ensureCapacity(minCapacity);
                this.initCachedField();
            }
        }

        private void initCachedField() {
            if (ourElementDataField == null) {
                return;
            }
            try {
                this.cachedElementData = (Object[])ourElementDataField.get(this);
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }

        static {
            Field f;
            try {
                f = ArrayList.class.getDeclaredField("elementData");
                f.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                f = null;
            }
            ourElementDataField = f;
        }
    }

    private static class ASTConverter
    implements Convertor<Node, ASTNode> {
        private final StartMarker myRoot;

        public ASTConverter(StartMarker root) {
            this.myRoot = root;
        }

        @Override
        public ASTNode convert(Node n) {
            if (n instanceof Token) {
                Token token = (Token)n;
                return token.myBuilder.createLeaf(token.getTokenType(), token.myTokenStart, token.myTokenEnd);
            }
            if (n instanceof ErrorItem) {
                return Factory.createErrorElement(((ErrorItem)n).myMessage);
            }
            StartMarker startMarker = (StartMarker)n;
            CompositeElement composite = n == this.myRoot ? (CompositeElement)this.myRoot.myBuilder.createRootAST(this.myRoot) : PsiBuilderImpl.createComposite(startMarker);
            startMarker.myBuilder.bind(startMarker, composite);
            return composite;
        }
    }

    private static class MyTreeStructure
    implements FlyweightCapableTreeStructure<LighterASTNode> {
        private final LimitedPool<Token> myPool;
        private final LimitedPool<LazyParseableToken> myLazyPool;
        private final StartMarker myRoot;
        private int count;

        public MyTreeStructure(@NotNull StartMarker root, @Nullable MyTreeStructure parentTree) {
            if (root == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure.<init> must not be null");
            }
            if (parentTree == null) {
                this.myPool = new LimitedPool<Token>(1000, new LimitedPool.ObjectFactory<Token>(){

                    @Override
                    public void cleanup(Token token) {
                        token.clean();
                    }

                    @Override
                    public Token create() {
                        return new TokenNode();
                    }
                });
                this.myLazyPool = new LimitedPool<LazyParseableToken>(200, new LimitedPool.ObjectFactory<LazyParseableToken>(){

                    @Override
                    public void cleanup(LazyParseableToken token) {
                        token.clean();
                    }

                    @Override
                    public LazyParseableToken create() {
                        return new LazyParseableToken();
                    }
                });
            } else {
                this.myPool = parentTree.myPool;
                this.myLazyPool = parentTree.myLazyPool;
            }
            this.myRoot = root;
        }

        @Override
        @NotNull
        public LighterASTNode getRoot() {
            StartMarker startMarker = this.myRoot;
            if (startMarker == null) {
                throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure.getRoot must not return null");
            }
            return startMarker;
        }

        @Override
        public LighterASTNode getParent(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure.getParent must not be null");
            }
            if (node instanceof StartMarker) {
                return ((StartMarker)node).myParent;
            }
            throw new UnsupportedOperationException("Unknown node type: " + node);
        }

        @Override
        @NotNull
        public LighterASTNode prepareForGetChildren(@NotNull LighterASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure.prepareForGetChildren must not be null");
            }
            LighterASTNode lighterASTNode = node;
            if (lighterASTNode == null) {
                throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure.prepareForGetChildren must not return null");
            }
            return lighterASTNode;
        }

        @Override
        public int getChildren(@NotNull LighterASTNode item, @NotNull Ref<LighterASTNode[]> into) {
            if (item == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure.getChildren must not be null");
            }
            if (into == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$MyTreeStructure.getChildren must not be null");
            }
            if (item instanceof LazyParseableToken) {
                FlyweightCapableTreeStructure<LighterASTNode> tree = ((LazyParseableToken)item).parseContents();
                LighterASTNode root = tree.getRoot();
                return tree.getChildren(tree.prepareForGetChildren(root), into);
            }
            if (item instanceof Token || item instanceof ErrorItem) {
                return 0;
            }
            StartMarker marker = (StartMarker)item;
            this.count = 0;
            ProductionMarker child = marker.myFirstChild;
            int lexIndex = marker.myLexemeIndex;
            while (child != null) {
                lexIndex = this.insertLeaves(lexIndex, child.myLexemeIndex, into, marker.myBuilder);
                if (child instanceof StartMarker && ((StartMarker)child).myDoneMarker.myCollapse) {
                    int lastIndex = ((StartMarker)((StartMarker)child)).myDoneMarker.myLexemeIndex;
                    this.insertLeaf(into, child.getTokenType(), marker.myBuilder, child.myLexemeIndex, lastIndex);
                } else {
                    this.ensureCapacity(into);
                    into.get()[this.count++] = child;
                }
                if (child instanceof StartMarker) {
                    lexIndex = ((StartMarker)((StartMarker)child)).myDoneMarker.myLexemeIndex;
                }
                child = child.myNext;
            }
            this.insertLeaves(lexIndex, ((StartMarker)marker).myDoneMarker.myLexemeIndex, into, marker.myBuilder);
            return this.count;
        }

        public void disposeChildren(LighterASTNode[] nodes, int count) {
            if (nodes == null) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                LighterASTNode node = nodes[i];
                if (node instanceof LazyParseableToken) {
                    this.myLazyPool.recycle((LazyParseableToken)node);
                    continue;
                }
                if (!(node instanceof Token)) continue;
                this.myPool.recycle((Token)node);
            }
        }

        private void ensureCapacity(Ref<LighterASTNode[]> into) {
            LighterASTNode[] old = into.get();
            if (old == null) {
                old = new LighterASTNode[10];
                into.set(old);
            } else if (this.count >= old.length) {
                LighterASTNode[] newStore = new LighterASTNode[this.count * 3 / 2];
                System.arraycopy(old, 0, newStore, 0, this.count);
                into.set(newStore);
            }
        }

        private int insertLeaves(int curToken, int lastIdx, Ref<LighterASTNode[]> into, PsiBuilderImpl builder) {
            lastIdx = Math.min(lastIdx, builder.myLexemeCount);
            while (curToken < lastIdx) {
                this.insertLeaf(into, builder.myLexTypes[curToken], builder, curToken, curToken + 1);
                ++curToken;
            }
            return curToken;
        }

        private void insertLeaf(Ref<LighterASTNode[]> into, IElementType type, PsiBuilderImpl builder, int startLexemIndex, int endLexemIndex) {
            Token lexeme;
            int end;
            int start = builder.myLexStarts[startLexemIndex];
            if (start > (end = builder.myLexStarts[endLexemIndex]) || start == end && !(type instanceof ILeafElementType)) {
                return;
            }
            if (type instanceof ILightLazyParseableElementType) {
                lexeme = this.myLazyPool.alloc();
                LazyParseableToken lazyParseableToken = (LazyParseableToken)lexeme;
                lazyParseableToken.myParent = this;
                lazyParseableToken.myStartIndex = startLexemIndex;
                lazyParseableToken.myEndIndex = endLexemIndex;
            } else {
                lexeme = this.myPool.alloc();
            }
            lexeme.myBuilder = builder;
            lexeme.myTokenType = type;
            lexeme.myTokenStart = start;
            lexeme.myTokenEnd = end;
            this.ensureCapacity(into);
            into.get()[this.count++] = lexeme;
        }
    }

    private static class MyComparator
    implements ShallowNodeComparator<ASTNode, LighterASTNode> {
        private final TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> custom;
        private final MyTreeStructure myTreeStructure;

        private MyComparator(TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> custom, MyTreeStructure treeStructure) {
            this.custom = custom;
            this.myTreeStructure = treeStructure;
        }

        @Override
        public ThreeState deepEqual(ASTNode oldNode, LighterASTNode newNode) {
            boolean newIsErrorElement;
            ProgressIndicatorProvider.checkCanceled();
            boolean oldIsErrorElement = oldNode instanceof PsiErrorElement;
            boolean bl = newIsErrorElement = newNode.getTokenType() == TokenType.ERROR_ELEMENT;
            if (oldIsErrorElement != newIsErrorElement) {
                return ThreeState.NO;
            }
            if (oldIsErrorElement && newIsErrorElement) {
                PsiErrorElement e1 = (PsiErrorElement)((Object)oldNode);
                return Comparing.equal(e1.getErrorDescription(), PsiBuilderImpl.getErrorMessage(newNode)) ? ThreeState.UNSURE : ThreeState.NO;
            }
            if (newNode instanceof Token) {
                IElementType type = newNode.getTokenType();
                Token token = (Token)newNode;
                if (oldNode instanceof ForeignLeafPsiElement) {
                    return type instanceof ForeignLeafType && ((ForeignLeafType)type).getValue().equals(oldNode.getText()) ? ThreeState.YES : ThreeState.NO;
                }
                if (oldNode instanceof LeafElement) {
                    if (type instanceof ForeignLeafType) {
                        return ThreeState.NO;
                    }
                    return ((LeafElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : ThreeState.NO;
                }
                if (type instanceof ILightLazyParseableElementType) {
                    return ((TreeElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : (TreeUtil.isCollapsedChameleon(oldNode) ? ThreeState.NO : ThreeState.UNSURE);
                }
                if (oldNode.getElementType() instanceof ILazyParseableElementType && type instanceof ILazyParseableElementType || oldNode.getElementType() instanceof CustomParsingType && type instanceof CustomParsingType) {
                    return ((TreeElement)oldNode).textMatches(token.getText()) ? ThreeState.YES : ThreeState.NO;
                }
            }
            if (this.custom != null) {
                return this.custom.fun(oldNode, newNode, this.myTreeStructure);
            }
            return ThreeState.UNSURE;
        }

        @Override
        public boolean typesEqual(ASTNode n1, LighterASTNode n2) {
            if (n1 instanceof PsiWhiteSpaceImpl) {
                return ourAnyLanguageWhitespaceTokens.contains(n2.getTokenType()) || n2 instanceof Token && ((Token)n2).myBuilder.myWhitespaces.contains(n2.getTokenType());
            }
            return MyComparator.derefToken(n1.getElementType()) == MyComparator.derefToken(n2.getTokenType());
        }

        public static IElementType derefToken(IElementType probablyWrapper) {
            if (probablyWrapper instanceof TokenWrapper) {
                return MyComparator.derefToken(((TokenWrapper)probablyWrapper).getDelegate());
            }
            return probablyWrapper;
        }

        @Override
        public boolean hashCodesEqual(ASTNode n1, LighterASTNode n2) {
            PsiErrorElement e1;
            if (n1 instanceof LeafElement && n2 instanceof Token) {
                boolean isForeign1 = n1 instanceof ForeignLeafPsiElement;
                boolean isForeign2 = n2.getTokenType() instanceof ForeignLeafType;
                if (isForeign1 != isForeign2) {
                    return false;
                }
                if (isForeign1 && isForeign2) {
                    return n1.getText().equals(((ForeignLeafType)n2.getTokenType()).getValue());
                }
                return ((LeafElement)n1).textMatches(((Token)n2).getText());
            }
            if (n1 instanceof PsiErrorElement && n2.getTokenType() == TokenType.ERROR_ELEMENT && !Comparing.equal((e1 = (PsiErrorElement)((Object)n1)).getErrorDescription(), PsiBuilderImpl.getErrorMessage(n2))) {
                return false;
            }
            return ((TreeElement)n1).hc() == ((Node)n2).hc();
        }
    }

    private static class ConvertFromTokensToASTBuilder
    implements DiffTreeChangeBuilder<ASTNode, LighterASTNode> {
        private final DiffTreeChangeBuilder<ASTNode, ASTNode> myDelegate;
        private final ASTConverter myConverter;

        public ConvertFromTokensToASTBuilder(StartMarker rootNode, DiffTreeChangeBuilder<ASTNode, ASTNode> delegate) {
            this.myDelegate = delegate;
            this.myConverter = new ASTConverter(rootNode);
        }

        @Override
        public void nodeDeleted(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
            if (oldParent == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder.nodeDeleted must not be null");
            }
            if (oldNode == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder.nodeDeleted must not be null");
            }
            this.myDelegate.nodeDeleted(oldParent, oldNode);
        }

        @Override
        public void nodeInserted(@NotNull ASTNode oldParent, @NotNull LighterASTNode newNode, int pos) {
            if (oldParent == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder.nodeInserted must not be null");
            }
            if (newNode == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder.nodeInserted must not be null");
            }
            this.myDelegate.nodeInserted(oldParent, this.myConverter.convert((Node)newNode), pos);
        }

        @Override
        public void nodeReplaced(@NotNull ASTNode oldChild, @NotNull LighterASTNode newChild) {
            if (oldChild == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder.nodeReplaced must not be null");
            }
            if (newChild == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderImpl$ConvertFromTokensToASTBuilder.nodeReplaced must not be null");
            }
            ASTNode converted = this.myConverter.convert((Node)newChild);
            this.myDelegate.nodeReplaced(oldChild, converted);
        }
    }

    private static class ErrorItem
    extends ProductionMarker {
        private final PsiBuilderImpl myBuilder;
        private String myMessage;

        public ErrorItem(PsiBuilderImpl builder, String message, int idx) {
            this.myBuilder = builder;
            this.myMessage = message;
            this.myLexemeIndex = idx;
            this.myEdgeTokenBinder = DEFAULT_RIGHT_EDGE_TOKEN_BINDER;
        }

        @Override
        public void clean() {
            super.clean();
            this.myMessage = null;
        }

        @Override
        public int hc() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return this.myBuilder.myLexStarts[this.myLexemeIndex];
        }

        @Override
        public int getStartOffset() {
            return this.myBuilder.myLexStarts[this.myLexemeIndex];
        }

        @Override
        public IElementType getTokenType() {
            return TokenType.ERROR_ELEMENT;
        }
    }

    private static class DoneWithErrorMarker
    extends DoneMarker {
        private String myMessage;

        public DoneWithErrorMarker(StartMarker marker, int currentLexeme, String message) {
            super(marker, currentLexeme);
            this.myMessage = message;
        }

        @Override
        public void clean() {
            super.clean();
            this.myMessage = null;
        }
    }

    private static class DoneMarker
    extends ProductionMarker {
        private StartMarker myStart;
        private boolean myCollapse = false;

        public DoneMarker() {
            this.myEdgeTokenBinder = DEFAULT_RIGHT_EDGE_TOKEN_BINDER;
        }

        public DoneMarker(StartMarker marker, int currentLexeme) {
            this();
            this.myLexemeIndex = currentLexeme;
            this.myStart = marker;
        }

        @Override
        public void clean() {
            super.clean();
            this.myStart = null;
            this.myEdgeTokenBinder = DEFAULT_RIGHT_EDGE_TOKEN_BINDER;
        }

        @Override
        public int hc() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        @Override
        public IElementType getTokenType() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        @Override
        public int getEndOffset() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }

        @Override
        public int getStartOffset() {
            throw new UnsupportedOperationException("Shall not be called on this kind of markers");
        }
    }

    private static class LazyParseableToken
    extends Token
    implements LighterLazyParseableNode,
    ASTNodeBuilder.ASTUnparsedNodeMarker {
        private MyTreeStructure myParent;
        private FlyweightCapableTreeStructure<LighterASTNode> myParsed;
        private int myStartIndex;
        private int myEndIndex;

        private LazyParseableToken() {
        }

        @Override
        public void clean() {
            super.clean();
            this.myParent = null;
            this.myParsed = null;
        }

        @Override
        public PsiFile getContainingFile() {
            return this.myBuilder.myFile;
        }

        @Override
        public CharTable getCharTable() {
            return this.myBuilder.myCharTable;
        }

        public FlyweightCapableTreeStructure<LighterASTNode> parseContents() {
            if (this.myParsed == null) {
                this.myParsed = ((ILightLazyParseableElementType)((Object)this.getTokenType())).parseContents(this);
            }
            return this.myParsed;
        }

        @Override
        public ASTNodeBuilder getBuilder() {
            return this.myBuilder;
        }

        @Override
        public int getStartLexemIndex() {
            return this.myStartIndex;
        }

        @Override
        public int getEndLexemIndex() {
            return this.myEndIndex;
        }
    }

    private static class TokenNode
    extends Token
    implements LighterASTTokenNode {
        private TokenNode() {
        }
    }

    private static abstract class Token
    extends Node {
        protected PsiBuilderImpl myBuilder;
        private IElementType myTokenType;
        private int myTokenStart;
        private int myTokenEnd;
        private int myHC = -1;

        private Token() {
        }

        public void clean() {
            this.myBuilder = null;
            this.myHC = -1;
        }

        @Override
        public int hc() {
            if (this.myHC == -1) {
                int hc = 0;
                if (this.myTokenType instanceof TokenWrapper) {
                    String value = ((TokenWrapper)this.myTokenType).getValue();
                    for (int i = 0; i < value.length(); ++i) {
                        hc += value.charAt(i);
                    }
                } else {
                    int start = this.myTokenStart;
                    int end = this.myTokenEnd;
                    CharSequence buf = this.myBuilder.myText;
                    char[] bufArray = this.myBuilder.myTextArray;
                    for (int i = start; i < end; ++i) {
                        hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                    }
                }
                this.myHC = hc;
            }
            return this.myHC;
        }

        @Override
        public int getEndOffset() {
            return this.myTokenEnd;
        }

        @Override
        public int getStartOffset() {
            return this.myTokenStart;
        }

        public CharSequence getText() {
            if (this.myTokenType instanceof TokenWrapper) {
                return ((TokenWrapper)this.myTokenType).getValue();
            }
            return this.myBuilder.myText.subSequence(this.myTokenStart, this.myTokenEnd);
        }

        @Override
        public IElementType getTokenType() {
            return this.myTokenType;
        }
    }

    private static class StartMarker
    extends ProductionMarker
    implements PsiBuilder.Marker {
        private PsiBuilderImpl myBuilder;
        private IElementType myType;
        private DoneMarker myDoneMarker;
        private Throwable myDebugAllocationPosition;
        private ProductionMarker myFirstChild;
        private ProductionMarker myLastChild;
        private int myHC = -1;

        private StartMarker() {
            this.myEdgeTokenBinder = DEFAULT_LEFT_EDGE_TOKEN_BINDER;
        }

        @Override
        public void clean() {
            super.clean();
            this.myBuilder = null;
            this.myType = null;
            this.myDoneMarker = null;
            this.myDebugAllocationPosition = null;
            this.myLastChild = null;
            this.myFirstChild = null;
            this.myHC = -1;
            this.myEdgeTokenBinder = DEFAULT_LEFT_EDGE_TOKEN_BINDER;
        }

        @Override
        public int hc() {
            if (this.myHC == -1) {
                PsiBuilderImpl builder = this.myBuilder;
                int hc = 0;
                CharSequence buf = builder.myText;
                char[] bufArray = builder.myTextArray;
                ProductionMarker child = this.myFirstChild;
                int lexIdx = this.myLexemeIndex;
                while (child != null) {
                    int lastLeaf = child.myLexemeIndex;
                    for (int i = builder.myLexStarts[lexIdx]; i < builder.myLexStarts[lastLeaf]; ++i) {
                        hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                    }
                    lexIdx = lastLeaf;
                    hc += child.hc();
                    if (child instanceof StartMarker) {
                        lexIdx = ((StartMarker)child).myDoneMarker.myLexemeIndex;
                    }
                    child = child.myNext;
                }
                for (int i = builder.myLexStarts[lexIdx]; i < builder.myLexStarts[this.myDoneMarker.myLexemeIndex]; ++i) {
                    hc += bufArray != null ? bufArray[i] : buf.charAt(i);
                }
                this.myHC = hc;
            }
            return this.myHC;
        }

        @Override
        public int getStartOffset() {
            return this.myBuilder.myLexStarts[this.myLexemeIndex];
        }

        @Override
        public int getEndOffset() {
            return this.myBuilder.myLexStarts[this.myDoneMarker.myLexemeIndex];
        }

        public void addChild(ProductionMarker node) {
            if (this.myFirstChild == null) {
                this.myFirstChild = node;
                this.myLastChild = node;
            } else {
                this.myLastChild.myNext = node;
                this.myLastChild = node;
            }
        }

        @Override
        public PsiBuilder.Marker precede() {
            return this.myBuilder.precede(this);
        }

        @Override
        public void drop() {
            this.myBuilder.drop(this);
        }

        @Override
        public void rollbackTo() {
            this.myBuilder.rollbackTo(this);
        }

        @Override
        public void done(IElementType type) {
            this.myType = type;
            this.myBuilder.done(this);
        }

        @Override
        public void collapse(IElementType type) {
            this.myType = type;
            this.myBuilder.collapse(this);
        }

        @Override
        public void doneBefore(IElementType type, PsiBuilder.Marker before) {
            this.myType = type;
            this.myBuilder.doneBefore(this, before);
        }

        @Override
        public void doneBefore(IElementType type, PsiBuilder.Marker before, String errorMessage) {
            StartMarker marker = (StartMarker)before;
            this.myBuilder.myProduction.add(this.myBuilder.myProduction.lastIndexOf(marker), new ErrorItem(this.myBuilder, errorMessage, marker.myLexemeIndex));
            this.doneBefore(type, before);
        }

        @Override
        public void error(String message) {
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.error(this, message);
        }

        @Override
        public void errorBefore(String message, PsiBuilder.Marker before) {
            this.myType = TokenType.ERROR_ELEMENT;
            this.myBuilder.errorBefore(this, message, before);
        }

        @Override
        public IElementType getTokenType() {
            return this.myType;
        }

        @Override
        public void setCustomEdgeTokenBinders(WhitespacesAndCommentsBinder left, WhitespacesAndCommentsBinder right) {
            if (left != null) {
                this.myEdgeTokenBinder = left;
            }
            if (right != null) {
                if (this.myDoneMarker == null) {
                    throw new IllegalArgumentException("Cannot set right-edge processor for unclosed marker");
                }
                this.myDoneMarker.myEdgeTokenBinder = right;
            }
        }
    }

    public static abstract class ProductionMarker
    extends Node {
        protected int myLexemeIndex;
        protected WhitespacesAndCommentsBinder myEdgeTokenBinder;
        protected ProductionMarker myParent;
        protected ProductionMarker myNext;

        public void clean() {
            this.myLexemeIndex = 0;
            this.myNext = null;
            this.myParent = null;
        }
    }

    private static abstract class Node
    implements LighterASTNode {
        private Node() {
        }

        public abstract int hc();
    }
}

