/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nullable;

public abstract class ListCellRendererWrapper<T>
implements ListCellRenderer {
    private final ListCellRenderer myOriginalRenderer;
    private Icon myIcon;
    private String myText;
    private String myToolTipText;
    private Color myForeground;

    public ListCellRendererWrapper(JComboBox comboBox) {
        this.myOriginalRenderer = comboBox.getRenderer();
    }

    public ListCellRendererWrapper(ListCellRenderer listCellRenderer) {
        this.myOriginalRenderer = listCellRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        try {
            Object t = value;
            this.customize(list, t, index, isSelected, cellHasFocus);
            Component component = this.myOriginalRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (component instanceof JLabel) {
                JLabel label = (JLabel)component;
                label.setIcon(this.myIcon);
                if (this.myText != null) {
                    label.setText(this.myText);
                }
                if (this.myForeground != null) {
                    label.setForeground(this.myForeground);
                }
                label.setToolTipText(this.myToolTipText);
            }
            Component component2 = component;
            return component2;
        }
        finally {
            this.myIcon = null;
            this.myText = null;
            this.myToolTipText = null;
        }
    }

    public abstract void customize(JList var1, T var2, int var3, boolean var4, boolean var5);

    public final void setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
    }

    public final void setText(@Nullable String text) {
        this.myText = text;
    }

    public final void setToolTipText(String toolTipText) {
        this.myToolTipText = toolTipText;
    }

    public void setForeground(Color foreground) {
        this.myForeground = foreground;
    }
}

