/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.rmi.RemoteCastable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.containers.ConcurrentFactoryMap;
import gnu.trove.THashMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.Remote;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RemoteUtil {
    private static final ConcurrentFactoryMap<Pair<Class<?>, Class<?>>, Map<Method, Method>> ourRemoteToLocalMap = new ConcurrentFactoryMap<Pair<Class<?>, Class<?>>, Map<Method, Method>>(){

        @Override
        protected Map<Method, Method> create(Pair<Class<?>, Class<?>> key) {
            THashMap map = new THashMap();
            for (Method method : ((Class)key.second).getMethods()) {
                Method m = null;
                block1: for (Method candidate : ((Class)key.first).getMethods()) {
                    Class<?>[] mpts;
                    Class<?>[] cpts;
                    if (!candidate.getName().equals(method.getName()) || (cpts = candidate.getParameterTypes()).length != (mpts = method.getParameterTypes()).length) continue;
                    for (int i = 0; i < mpts.length; ++i) {
                        Class<?> cpt = cpts[i];
                        Class<?> mpt = mpts[i];
                        if (!cpt.isAssignableFrom(mpt)) continue block1;
                    }
                    m = candidate;
                    break;
                }
                if (m == null) continue;
                map.put((Object)method, m);
            }
            return map;
        }
    };

    RemoteUtil() {
    }

    public static <T> T castToLocal(final Object remote, final Class<T> clazz) {
        final ClassLoader loader = clazz.getClassLoader();
        Object proxy = Proxy.newProxyInstance(loader, new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke(remote, args);
                }
                Method m = (Method)((Map)ourRemoteToLocalMap.get(Pair.create(remote.getClass(), clazz))).get(method);
                if (m == null) {
                    throw new NoSuchMethodError(method.getName() + " in " + remote.getClass());
                }
                try {
                    Object result = m.invoke(remote, args);
                    if (result instanceof Remote) {
                        return RemoteUtil.castToLocal(result, RemoteUtil.tryFixReturnType(result, method.getReturnType(), loader));
                    }
                    return result;
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw cause;
                    }
                    if (cause instanceof Error) {
                        throw cause;
                    }
                    if (RemoteUtil.canThrow(cause, method)) {
                        throw cause;
                    }
                    throw new RuntimeException(cause);
                }
            }
        });
        return (T)proxy;
    }

    private static Class<?> tryFixReturnType(Object result, Class<?> returnType, ClassLoader loader) throws Exception {
        if (returnType.isInterface()) {
            return returnType;
        }
        if (result instanceof RemoteCastable) {
            String className = ((RemoteCastable)result).getCastToClassName();
            return Class.forName(className, true, loader);
        }
        return returnType;
    }

    public static <T> T substituteClassLoader(final T remote, final ClassLoader classLoader) throws Exception {
        return RemoteUtil.executeWithClassLoader(new ThrowableComputable<T, Exception>(){

            @Override
            public T compute() {
                Object proxy = Proxy.newProxyInstance(classLoader, remote.getClass().getInterfaces(), new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
                        return RemoteUtil.executeWithClassLoader(new ThrowableComputable<Object, Exception>(){

                            @Override
                            public Object compute() throws Exception {
                                try {
                                    Object result = method.invoke(remote, args);
                                    if (result instanceof Remote) {
                                        if (result instanceof RemoteCastable) {
                                            return RemoteUtil.castToLocal(result, RemoteUtil.tryFixReturnType(result, method.getReturnType(), classLoader));
                                        }
                                        return RemoteUtil.substituteClassLoader(result, classLoader);
                                    }
                                    return result;
                                }
                                catch (InvocationTargetException e) {
                                    Throwable cause = e.getCause();
                                    if (cause instanceof RuntimeException) {
                                        throw (RuntimeException)cause;
                                    }
                                    if (cause instanceof Error) {
                                        throw (Error)cause;
                                    }
                                    if (RemoteUtil.canThrow(cause, method)) {
                                        throw (Exception)cause;
                                    }
                                    throw new RuntimeException(cause);
                                }
                            }
                        }, classLoader);
                    }
                });
                return proxy;
            }
        }, classLoader);
    }

    private static boolean canThrow(Throwable cause, Method method) {
        for (Class<?> each : method.getExceptionTypes()) {
            if (!each.isInstance(cause)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithClassLoader(ThrowableComputable<T, Exception> action, ClassLoader classLoader) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader prev = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(classLoader);
            T t = action.compute();
            return t;
        }
        finally {
            thread.setContextClassLoader(prev);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Throwable unwrap(@NotNull Throwable e) {
        Throwable throwable;
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/rmi/RemoteUtil.unwrap must not be null");
        }
        for (Throwable candidate = e; candidate != null; candidate = candidate.getCause()) {
            Class<?> clazz = candidate.getClass();
            if (clazz == InvocationTargetException.class || clazz == UndeclaredThrowableException.class) continue;
            throwable = candidate;
            if (throwable == null) throw new IllegalStateException("@NotNull method com/intellij/execution/rmi/RemoteUtil.unwrap must not return null");
            return throwable;
        }
        throwable = e;
        if (throwable != null) return throwable;
        throw new IllegalStateException("@NotNull method com/intellij/execution/rmi/RemoteUtil.unwrap must not return null");
    }
}

