/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CollectionQuery;
import com.intellij.util.Query;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJavaFileManager
extends PackageIndex
implements JavaFileManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.core.CoreJavaFileManager");
    private final CoreLocalFileSystem myLocalFileSystem;
    private final CoreJarFileSystem myJarFileSystem;
    private final List<File> myClasspath = new ArrayList<File>();
    private VirtualFile[] myClasspathRoots = null;
    private final PsiManager myPsiManager;

    public CoreJavaFileManager(PsiManager psiManager, CoreLocalFileSystem localFileSystem, CoreJarFileSystem jarFileSystem) {
        this.myPsiManager = psiManager;
        this.myLocalFileSystem = localFileSystem;
        this.myJarFileSystem = jarFileSystem;
    }

    private VirtualFile[] roots() {
        VirtualFile[] answer = this.myClasspathRoots;
        if (answer == null) {
            ArrayList<VirtualFile> answerList = new ArrayList<VirtualFile>(this.myClasspath.size());
            for (File root : this.myClasspath) {
                VirtualFile rootVfs = this.calcRoot(root);
                if (rootVfs == null) continue;
                answerList.add(rootVfs);
            }
            answer = answerList.toArray(new VirtualFile[answerList.size()]);
            this.myClasspathRoots = answer;
        }
        return answer;
    }

    @Nullable
    private VirtualFile calcRoot(File root) {
        if (root.isFile()) {
            return this.myJarFileSystem.findFileByPath(root.getPath() + "!/");
        }
        return this.myLocalFileSystem.findFileByPath(root.getPath());
    }

    @Override
    public PsiPackage findPackage(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaFileManager.findPackage must not be null");
        }
        List<VirtualFile> files = this.findDirectoriesByPackageName(packageName);
        if (files.size() > 0) {
            return new PsiPackageImpl(this.myPsiManager, packageName);
        }
        return null;
    }

    private List<VirtualFile> findDirectoriesByPackageName(String packageName) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        String dirName = packageName.replace(".", "/");
        for (VirtualFile root : this.roots()) {
            VirtualFile classDir = root.findFileByRelativePath(dirName);
            if (classDir == null) continue;
            result.add(classDir);
        }
        return result;
    }

    @Nullable
    public PsiPackage getPackage(PsiDirectory dir) {
        File ioFile = new File(dir.getVirtualFile().getPath());
        for (File root : this.myClasspath) {
            if (!FileUtil.isAncestor(root, ioFile, false)) continue;
            String relativePath = FileUtil.getRelativePath(root.getPath(), ioFile.getPath(), '.');
            return new PsiPackageImpl(this.myPsiManager, relativePath);
        }
        return null;
    }

    @Override
    public VirtualFile[] getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaFileManager.getDirectoriesByPackageName must not be null");
        }
        return this.getDirsByPackageName(packageName, includeLibrarySources).toArray((VirtualFile[])VirtualFile.EMPTY_ARRAY);
    }

    @Override
    public Query<VirtualFile> getDirsByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaFileManager.getDirsByPackageName must not be null");
        }
        return new CollectionQuery<VirtualFile>(this.findDirectoriesByPackageName(packageName));
    }

    @Override
    public PsiClass findClass(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaFileManager.findClass must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/core/CoreJavaFileManager.findClass must not be null");
        }
        for (VirtualFile root : this.roots()) {
            PsiClass psiClass = CoreJavaFileManager.findClassInClasspathRoot(qName, root, this.myPsiManager);
            if (psiClass == null) continue;
            return psiClass;
        }
        return null;
    }

    @Nullable
    public static PsiClass findClassInClasspathRoot(String qName, VirtualFile root, PsiManager psiManager) {
        String rootClassName;
        String pathComponent;
        VirtualFile child;
        int dot;
        String pathRest = qName;
        VirtualFile cur = root;
        while ((dot = pathRest.indexOf(46)) >= 0 && (child = cur.findChild(pathComponent = pathRest.substring(0, dot))) != null) {
            pathRest = pathRest.substring(dot + 1);
            cur = child;
        }
        String className = pathRest.replace('.', '$');
        int bucks = className.indexOf(36);
        if (bucks < 0) {
            rootClassName = className;
        } else {
            rootClassName = className.substring(0, bucks);
            className = className.substring(bucks + 1);
        }
        VirtualFile vFile = cur.findChild(rootClassName + ".class");
        if (vFile == null) {
            vFile = cur.findChild(rootClassName + ".java");
        }
        if (vFile != null) {
            PsiClass[] classes;
            if (!vFile.isValid()) {
                LOG.error("Invalid child of valid parent: " + vFile.getPath() + "; " + root.isValid() + " path=" + root.getPath());
                return null;
            }
            PsiFile file = psiManager.findFile(vFile);
            if (file instanceof PsiClassOwner && (classes = ((PsiClassOwner)file).getClasses()).length == 1) {
                PsiClass curClass = classes[0];
                if (bucks > 0) {
                    int b;
                    do {
                        String component;
                        PsiClass inner;
                        if ((inner = curClass.findInnerClassByName(component = (b = className.indexOf("$")) < 0 ? className : className.substring(0, b), false)) == null) {
                            return null;
                        }
                        curClass = inner;
                        className = className.substring(b + 1);
                    } while (b >= 0);
                }
                return curClass;
            }
        }
        return null;
    }

    @Override
    public PsiClass[] findClasses(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaFileManager.findClasses must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/core/CoreJavaFileManager.findClasses must not be null");
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (VirtualFile file : this.roots()) {
            PsiClass psiClass = CoreJavaFileManager.findClassInClasspathRoot(qName, file, this.myPsiManager);
            if (psiClass == null) continue;
            result.add(psiClass);
        }
        return result.toArray(new PsiClass[result.size()]);
    }

    @Override
    public Collection<String> getNonTrivialPackagePrefixes() {
        return Collections.emptyList();
    }

    @Override
    public void initialize() {
    }

    public void addToClasspath(File path) {
        this.myClasspath.add(path);
        this.myClasspathRoots = null;
    }
}

