/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreASTFactory;
import com.intellij.core.CoreEncodingRegistry;
import com.intellij.core.CoreFileTypeRegistry;
import com.intellij.core.CoreProjectScopeBuilder;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockDumbService;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.mock.MockFileIndexFacade;
import com.intellij.mock.MockProject;
import com.intellij.mock.MockReferenceProvidersRegistry;
import com.intellij.mock.MockResolveScopeManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.ContentBasedFileSubstitutor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.openapi.vfs.newvfs.FileSystemPersistence;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiCachedValuesFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.PsiDirectoryFactoryImpl;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.search.ProjectScopeBuilder;
import com.intellij.psi.stubs.CoreStubTreeLoader;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.Function;
import com.intellij.util.messages.impl.MessageBusImpl;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class CoreEnvironment {
    private final CoreFileTypeRegistry myFileTypeRegistry;
    private final CoreEncodingRegistry myEncodingRegistry;
    protected final MockApplication myApplication;
    protected MockProject myProject;
    private final CoreLocalFileSystem myLocalFileSystem;
    protected final CoreJarFileSystem myJarFileSystem;
    protected final MockFileIndexFacade myFileIndexFacade;
    protected final PsiManagerImpl myPsiManager;

    public CoreEnvironment(Disposable parentDisposable) {
        Extensions.cleanRootArea(parentDisposable);
        this.myFileTypeRegistry = new CoreFileTypeRegistry();
        this.myEncodingRegistry = new CoreEncodingRegistry();
        this.myApplication = new MockApplication(parentDisposable);
        ApplicationManager.setApplication(this.myApplication, new StaticGetter<FileTypeRegistry>(this.myFileTypeRegistry), new StaticGetter<EncodingRegistry>(this.myEncodingRegistry), parentDisposable);
        this.myLocalFileSystem = new CoreLocalFileSystem();
        this.myJarFileSystem = new CoreJarFileSystem();
        Extensions.registerAreaClass("IDEA_PROJECT", null);
        this.myProject = new MockProject((PicoContainer)this.myApplication.getPicoContainer(), parentDisposable);
        MutablePicoContainer appContainer = this.myApplication.getPicoContainer();
        this.registerComponentInstance(appContainer, FileDocumentManager.class, new MockFileDocumentManagerImpl(new Function<CharSequence, Document>(){

            @Override
            public Document fun(CharSequence charSequence) {
                return new DocumentImpl(charSequence);
            }
        }, null));
        this.registerComponentInstance(appContainer, VirtualFileManager.class, new VirtualFileManagerImpl(new VirtualFileSystem[]{this.myLocalFileSystem, this.myJarFileSystem}, new MessageBusImpl(this.myApplication, null), new FileSystemPersistence(){

            @Override
            public void refresh(boolean asynchronous, Runnable postAction, @NotNull ModalityState modalityState) {
                if (modalityState == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/core/CoreEnvironment$2.refresh must not be null");
                }
            }

            @Override
            public int getCheapFileSystemModificationCount() {
                return 0;
            }
        }));
        this.myApplication.registerService(DefaultASTFactory.class, new CoreASTFactory());
        this.myApplication.registerService(PsiBuilderFactory.class, new PsiBuilderFactoryImpl());
        this.myApplication.registerService(ReferenceProvidersRegistry.class, new MockReferenceProvidersRegistry());
        this.myApplication.registerService(StubTreeLoader.class, new CoreStubTreeLoader());
        this.registerExtensionPoint(Extensions.getRootArea(), ContentBasedFileSubstitutor.EP_NAME, ContentBasedFileSubstitutor.class);
        this.registerExtensionPoint(Extensions.getRootArea(), "com.intellij.filetype.stubBuilder", FileTypeExtensionPoint.class);
        this.myFileIndexFacade = new MockFileIndexFacade(this.myProject);
        MutablePicoContainer projectContainer = this.myProject.getPicoContainer();
        PsiModificationTrackerImpl modificationTracker = new PsiModificationTrackerImpl(this.myProject);
        this.myProject.registerService(PsiModificationTracker.class, modificationTracker);
        this.myProject.registerService(FileIndexFacade.class, this.myFileIndexFacade);
        this.myProject.registerService(ResolveScopeManager.class, new MockResolveScopeManager(this.myProject));
        this.myProject.registerService(ResolveCache.class, new ResolveCache(null));
        this.registerProjectExtensionPoint(PsiTreeChangePreprocessor.EP_NAME, PsiTreeChangePreprocessor.class);
        this.myPsiManager = new PsiManagerImpl(this.myProject, null, null, this.myFileIndexFacade, null, modificationTracker);
        ((FileManagerImpl)this.myPsiManager.getFileManager()).markInitialized();
        this.registerComponentInstance(projectContainer, PsiManager.class, this.myPsiManager);
        this.myProject.registerService(PsiFileFactory.class, new PsiFileFactoryImpl(this.myPsiManager));
        this.myProject.registerService(CachedValuesManager.class, new CachedValuesManagerImpl(this.myProject, new PsiCachedValuesFactory(this.myPsiManager)));
        this.myProject.registerService(PsiDirectoryFactory.class, new PsiDirectoryFactoryImpl(this.myPsiManager));
        this.myProject.registerService(ProjectScopeBuilder.class, new CoreProjectScopeBuilder(this.myProject, this.myFileIndexFacade));
        this.myProject.registerService(DumbService.class, new MockDumbService(this.myProject));
    }

    public Project getProject() {
        return this.myProject;
    }

    public void registerFileType(FileType fileType, String extension) {
        this.myFileTypeRegistry.registerFileType(fileType, extension);
    }

    public void registerParserDefinition(ParserDefinition definition) {
        this.addExplicitExtension(LanguageParserDefinitions.INSTANCE, definition.getFileNodeType().getLanguage(), definition);
    }

    protected <T> void registerComponentInstance(MutablePicoContainer container, Class<T> key, T implementation) {
        container.unregisterComponent(key);
        container.registerComponentInstance(key, implementation);
    }

    protected <T> void addExplicitExtension(final LanguageExtension<T> instance, final Language language, final T object) {
        instance.addExplicitExtension(language, object);
        Disposer.register(this.myProject, new Disposable(){

            @Override
            public void dispose() {
                instance.removeExplicitExtension(language, object);
            }
        });
    }

    protected <T> void addExplicitExtension(final FileTypeExtension<T> instance, final FileType fileType, final T object) {
        instance.addExplicitExtension(fileType, object);
        Disposer.register(this.myProject, new Disposable(){

            @Override
            public void dispose() {
                instance.removeExplicitExtension(fileType, object);
            }
        });
    }

    protected <T> void addExtension(ExtensionPointName<T> name, final T extension) {
        final ExtensionPoint<T> extensionPoint = Extensions.getRootArea().getExtensionPoint(name);
        extensionPoint.registerExtension(extension);
        Disposer.register(this.myProject, new Disposable(){

            @Override
            public void dispose() {
                extensionPoint.unregisterExtension(extension);
            }
        });
    }

    protected <T> void registerExtensionPoint(ExtensionsArea area, ExtensionPointName<T> extensionPointName, Class<? extends T> aClass) {
        String name = extensionPointName.getName();
        this.registerExtensionPoint(area, name, aClass);
    }

    protected <T> void registerExtensionPoint(ExtensionsArea area, String name, Class<? extends T> aClass) {
        if (!area.hasExtensionPoint(name)) {
            ExtensionPoint.Kind kind = aClass.isInterface() || (aClass.getModifiers() & 0x400) != 0 ? ExtensionPoint.Kind.INTERFACE : ExtensionPoint.Kind.BEAN_CLASS;
            area.registerExtensionPoint(name, aClass.getName(), kind);
        }
    }

    protected <T> void registerProjectExtensionPoint(ExtensionPointName<T> extensionPointName, Class<? extends T> aClass) {
        this.registerExtensionPoint(Extensions.getArea(this.myProject), extensionPointName, aClass);
    }

    public CoreLocalFileSystem getLocalFileSystem() {
        return this.myLocalFileSystem;
    }

    public CoreJarFileSystem getJarFileSystem() {
        return this.myJarFileSystem;
    }

    public void addLibraryRoot(VirtualFile file) {
        this.myFileIndexFacade.addLibraryRoot(file);
    }
}

