/*
 * Decompiled with CFR 0.152.
 */
package std.util;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import jet.Function0;
import jet.Function1;
import jet.Function2;
import jet.IntRange;
import jet.Tuple0;
import jet.Tuple2;
import jet.TypeCastException;
import jet.runtime.Intrinsics;
import jet.runtime.Ranges;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import std.util.namespace$groupBy$list$1;
import std.util.namespace$withIndices$1;

public class namespace {
    @JetMethod(typeParameters="<T:?Ljava/lang/Object;R:?Ljava/lang/Object;>", returnType="Ljava/util/Collection<TR;>;")
    public static final <T, R> Collection<R> map(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver, @JetValueParameter(name="result", hasDefaultValue=true, type="Ljava/util/Collection<TR;>;") Collection<R> result, @JetValueParameter(name="transform", type="Ljet/Function1<TT;TR;>;") Function1<T, R> transform) {
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T item = iterator2.next();
                result.add(transform.invoke(item));
            }
        }
        return result;
    }

    public static Collection map$default(Iterable iterable, Collection collection, Function1 function1, int n) {
        return namespace.map(iterable, (n & 1) != 0 ? (Collection)new ArrayList() : collection, function1);
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;U::Ljava/util/Collection<-TT;>;>", returnType="TU;")
    public static final <T, U extends Collection<? super T>> U to(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Iterator<TT;>;") Iterator<T> this$receiver, @JetValueParameter(name="container", type="TU;") U container) {
        while (this$receiver.hasNext()) {
            container.add(this$receiver.next());
        }
        return container;
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/ArrayList<TT;>;")
    public static final <T> ArrayList<T> toArrayList(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Iterator<TT;>;") Iterator<T> this$receiver) {
        return (ArrayList)namespace.to(this$receiver, (Collection)new ArrayList());
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/LinkedList<TT;>;")
    public static final <T> LinkedList<T> toLinkedList(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Iterator<TT;>;") Iterator<T> this$receiver) {
        return (LinkedList)namespace.to(this$receiver, (Collection)new LinkedList());
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/HashSet<TT;>;")
    public static final <T> HashSet<T> toHashSet(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Iterator<TT;>;") Iterator<T> this$receiver) {
        return (HashSet)namespace.to(this$receiver, (Collection)new HashSet());
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/LinkedHashSet<TT;>;")
    public static final <T> LinkedHashSet<T> toLinkedHashSet(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Iterator<TT;>;") Iterator<T> this$receiver) {
        return (LinkedHashSet)namespace.to(this$receiver, (Collection)new LinkedHashSet());
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/TreeSet<TT;>;")
    public static final <T> TreeSet<T> toTreeSet(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Iterator<TT;>;") Iterator<T> this$receiver) {
        return (TreeSet)namespace.to(this$receiver, (Collection)new TreeSet());
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;R:?Ljava/lang/Object;>", returnType="Ljava/util/Collection<TR;>;")
    public static final <T, R> Collection<R> map(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Collection<TT;>;") Collection<T> this$receiver, @JetValueParameter(name="result", hasDefaultValue=true, type="Ljava/util/Collection<TR;>;") Collection<R> result, @JetValueParameter(name="transform", type="Ljet/Function1<TT;TR;>;") Function1<T, R> transform) {
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T item = iterator2.next();
                result.add(transform.invoke(item));
            }
        }
        return result;
    }

    public static Collection map$default(Collection collection, Collection collection2, Function1 function1, int n) {
        return namespace.map(collection, (n & 1) != 0 ? (Collection)new ArrayList(namespace.getSize(collection)) : collection2, function1);
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Z")
    public static final <T> boolean notEmpty(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Collection<TT;>;") Collection<T> this$receiver) {
        return !this$receiver.isEmpty();
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/Collection<TT;>;")
    public static final <T> Collection<T> notNull(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Ljava/util/Collection<TT;>;") Collection<T> this$receiver) {
        Collection collection;
        boolean bl = true;
        if (this$receiver == null) {
            bl = false;
        }
        if (bl) {
            collection = this$receiver;
        } else {
            List list2 = Collections.EMPTY_LIST;
            if (!(list2 instanceof Collection)) {
                throw new TypeCastException();
            }
            collection = list2;
        }
        return collection;
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Z")
    public static final <T> boolean any(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<TT;Ljava/lang/Boolean;>;") Function1<T, Boolean> predicate) {
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T elem = iterator2.next();
                if (!predicate.invoke(elem).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Z")
    public static final <T> boolean all(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<TT;Ljava/lang/Boolean;>;") Function1<T, Boolean> predicate) {
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T elem = iterator2.next();
                if (predicate.invoke(elem).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="I")
    public static final <T> int count(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<TT;Ljava/lang/Boolean;>;") Function1<T, Boolean> predicate) {
        int answer = 0;
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T elem = iterator2.next();
                if (!predicate.invoke(elem).booleanValue()) continue;
                ++answer;
            }
        }
        return answer;
    }

    @JetMethod(nullableReturnType=true, typeParameters="<T:?Ljava/lang/Object;>", returnType="?TT;")
    public static final <T> T find(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver, @JetValueParameter(name="predicate", type="Ljet/Function1<TT;Ljava/lang/Boolean;>;") Function1<T, Boolean> predicate) {
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T elem = iterator2.next();
                if (!predicate.invoke(elem).booleanValue()) continue;
                return elem;
            }
        }
        return null;
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/Collection<TT;>;")
    public static final <T> Collection<T> filter(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver, @JetValueParameter(name="result", hasDefaultValue=true, type="Ljava/util/Collection<TT;>;") Collection<T> result, @JetValueParameter(name="predicate", type="Ljet/Function1<TT;Ljava/lang/Boolean;>;") Function1<T, Boolean> predicate) {
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T elem = iterator2.next();
                if (!predicate.invoke(elem).booleanValue()) continue;
                result.add(elem);
            }
        }
        return result;
    }

    public static Collection filter$default(Iterable iterable, Collection collection, Function1 function1, int n) {
        return namespace.filter(iterable, (n & 1) != 0 ? (Collection)new ArrayList() : collection, function1);
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/Collection<TT;>;")
    public static final <T> Collection<T> filterNot(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver, @JetValueParameter(name="result", hasDefaultValue=true, type="Ljava/util/Collection<TT;>;") Collection<T> result, @JetValueParameter(name="predicate", type="Ljet/Function1<TT;Ljava/lang/Boolean;>;") Function1<T, Boolean> predicate) {
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T elem = iterator2.next();
                if (predicate.invoke(elem).booleanValue()) continue;
                result.add(elem);
            }
        }
        return result;
    }

    public static Collection filterNot$default(Iterable iterable, Collection collection, Function1 function1, int n) {
        return namespace.filterNot(iterable, (n & 1) != 0 ? (Collection)new ArrayList() : collection, function1);
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;out R:?Ljava/lang/Object;>", returnType="Ljava/util/Collection<TR;>;")
    public static final <T, R> Collection<R> flatMap(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver, @JetValueParameter(name="result", hasDefaultValue=true, type="Ljava/util/Collection<TR;>;") Collection<R> result, @JetValueParameter(name="transform", type="Ljet/Function1<TT;Ljava/util/Collection<TR;>;>;") Function1<T, Collection<R>> transform) {
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                Iterator<R> iterator3;
                T elem = iterator2.next();
                Collection<R> coll = transform.invoke(elem);
                boolean bl = true;
                if (coll == null) {
                    bl = false;
                }
                if (!bl || (iterator3 = coll.iterator()) == null) continue;
                while (iterator3.hasNext()) {
                    R r = iterator3.next();
                    result.add(r);
                }
            }
        }
        return result;
    }

    public static Collection flatMap$default(Iterable iterable, Collection collection, Function1 function1, int n) {
        return namespace.flatMap(iterable, (n & 1) != 0 ? (Collection)new ArrayList() : collection, function1);
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="V")
    public static final <T> void foreach(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver, @JetValueParameter(name="operation", type="Ljet/Function1<TT;Ljet/Tuple0;>;") Function1<T, Tuple0> operation) {
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T elem = iterator2.next();
                operation.invoke(elem);
            }
        }
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="TT;")
    public static final <T> T fold(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver, @JetValueParameter(name="initial", type="TT;") T initial, @JetValueParameter(name="operation", type="Ljet/Function2<TT;TT;TT;>;") Function2<T, T, T> operation) {
        T answer = initial;
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T elem = iterator2.next();
                answer = operation.invoke(answer, elem);
            }
        }
        return answer;
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="TT;")
    public static final <T> T foldRight(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver, @JetValueParameter(name="initial", type="TT;") T initial, @JetValueParameter(name="operation", type="Ljet/Function2<TT;TT;TT;>;") Function2<T, T, T> operation) {
        List<T> reversed = namespace.reverse(this$receiver);
        return namespace.fold((Iterable)reversed, initial, operation);
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;K:?Ljava/lang/Object;>", returnType="Ljava/util/Map<TK;Ljava/util/List<TT;>;>;")
    public static final <T, K> Map<K, List<T>> groupBy(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver, @JetValueParameter(name="result", hasDefaultValue=true, type="Ljava/util/Map<TK;Ljava/util/List<TT;>;>;") Map<K, List<T>> result, @JetValueParameter(name="toKey", type="Ljet/Function1<TT;TK;>;") Function1<T, K> toKey) {
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T elem = iterator2.next();
                K key = toKey.invoke(elem);
                List<T> list2 = namespace.getOrPut(result, key, namespace$groupBy$list$1.$getInstance());
                list2.add(elem);
            }
        }
        return result;
    }

    public static Map groupBy$default(Iterable iterable, Map map, Function1 function1, int n) {
        return namespace.groupBy(iterable, (n & 1) != 0 ? (Map)new HashMap() : map, function1);
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/lang/String;")
    public static final <T> String join(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver, @JetValueParameter(name="separator", type="Ljava/lang/String;") String separator, @JetValueParameter(name="prefix", hasDefaultValue=true, type="Ljava/lang/String;") String prefix, @JetValueParameter(name="postfix", hasDefaultValue=true, type="Ljava/lang/String;") String postfix) {
        StringBuilder buffer = new StringBuilder(prefix);
        int first = 1;
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                Object object;
                T elem = iterator2.next();
                if (first != 0) {
                    first = 0;
                    object = Tuple0.INSTANCE;
                } else {
                    object = buffer.append(separator);
                }
                buffer.append(elem);
            }
        }
        buffer.append(postfix);
        String string = buffer.toString();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    public static String join$default(Iterable iterable, String string, String string2, String string3, int n) {
        return namespace.join(iterable, string, (n & 2) != 0 ? "" : string2, (n & 4) != 0 ? "" : string3);
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/List<TT;>;")
    public static final <T> List<T> reverse(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver) {
        LinkedList<T> answer = new LinkedList<T>();
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T elem = iterator2.next();
                answer.addFirst(elem);
            }
        }
        return answer;
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;C::Ljava/util/Collection<TT;>;>", returnType="TC;")
    public static final <T, C extends Collection<T>> C to(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver, @JetValueParameter(name="result", type="TC;") C result) {
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T elem = iterator2.next();
                result.add(elem);
            }
        }
        return result;
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/LinkedList<TT;>;")
    public static final <T> LinkedList<T> toLinkedList(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver) {
        return (LinkedList)namespace.to(this$receiver, (Collection)new LinkedList());
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/List<TT;>;")
    public static final <T> List<T> toList(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver) {
        return (ArrayList)namespace.to(this$receiver, (Collection)new ArrayList());
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/Set<TT;>;")
    public static final <T> Set<T> toSet(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver) {
        return (HashSet)namespace.to(this$receiver, (Collection)new HashSet());
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/SortedSet<TT;>;")
    public static final <T> SortedSet<T> toSortedSet(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver) {
        return (TreeSet)namespace.to(this$receiver, (Collection)new TreeSet());
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="I")
    public static final <T> int count(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver) {
        if (this$receiver instanceof Collection) {
            return ((Collection)this$receiver).size();
        }
        int number = 0;
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T elem = iterator2.next();
                ++number;
            }
        }
        return number;
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="TT;")
    public static final <T> T first(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver) {
        if (this$receiver instanceof AbstractList) {
            return (T)((AbstractList)this$receiver).get(0);
        }
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 == null) {
            Intrinsics.throwNpe();
        }
        return iterator2.next();
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="TT;")
    public static final <T> T last(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver) {
        if (this$receiver instanceof List) {
            return (T)((List)this$receiver).get(((List)this$receiver).size() - 1);
        }
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 == null) {
            Intrinsics.throwNpe();
        }
        Iterator<T> iterator3 = iterator2;
        T last = iterator3.next();
        while (iterator3.hasNext()) {
            last = iterator3.next();
        }
        return last;
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Z")
    public static final <T> boolean contains(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver, @JetValueParameter(name="item", type="TT;") T item) {
        std.io.namespace.println("!!!!!");
        if (this$receiver instanceof AbstractCollection) {
            return ((AbstractCollection)this$receiver).contains(item);
        }
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T elem;
                T t = elem = iterator2.next();
                if (!(t != null ? t.equals(item) : false)) continue;
                return true;
            }
        }
        return false;
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/lang/Iterable<Ljet/Tuple2<+Ljava/lang/Integer;+TT;>;>;")
    public static final <T> Iterable<Tuple2<? extends Integer, ? extends T>> withIndices(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver) {
        return new namespace$withIndices$1(this$receiver);
    }

    @JetMethod(kind=1, propertyType="I")
    public static final int getSize(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Collection<+?Ljava/lang/Object;>;") Collection<? extends Object> this$receiver) {
        return this$receiver.size();
    }

    @JetMethod(kind=1, propertyType="Z")
    public static final boolean getEmpty(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Collection<+?Ljava/lang/Object;>;") Collection<? extends Object> this$receiver) {
        return this$receiver.isEmpty();
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/ArrayList<TT;>;")
    public static final <T> ArrayList<T> arrayList(T ... values) {
        return (ArrayList)std.namespace.to(values, (Collection)new ArrayList(values.length));
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/LinkedList<TT;>;")
    public static final <T> LinkedList<T> linkedList(T ... values) {
        return (LinkedList)std.namespace.to(values, (Collection)new LinkedList());
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/HashSet<TT;>;")
    public static final <T> HashSet<T> hashSet(T ... values) {
        return (HashSet)std.namespace.to(values, (Collection)new HashSet(values.length));
    }

    @JetMethod(typeParameters="<K:?Ljava/lang/Object;V:?Ljava/lang/Object;>", returnType="Ljava/util/HashMap<TK;TV;>;")
    public static final <K, V> HashMap<K, V> hashMap() {
        return new HashMap();
    }

    @JetMethod(typeParameters="<K:?Ljava/lang/Object;V:?Ljava/lang/Object;>", returnType="Ljava/util/SortedMap<TK;TV;>;")
    public static final <K, V> SortedMap<K, V> sortedMap() {
        return new TreeMap();
    }

    @JetMethod(kind=1, propertyType="Ljet/IntRange;")
    public static final IntRange getIndices(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Collection<+?Ljava/lang/Object;>;") Collection<? extends Object> this$receiver) {
        return Ranges.upTo(0, namespace.getSize(this$receiver) - 1);
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="[TT;")
    public static final <T> T[] toArray(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Collection<TT;>;") Collection<T> this$receiver) {
        Object[] answer = new Object[namespace.getSize(this$receiver)];
        int idx = 0;
        Iterator<T> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                T elem = iterator2.next();
                answer[idx++] = elem;
            }
        }
        if (!(answer instanceof Object[])) {
            throw new TypeCastException();
        }
        return answer;
    }

    @JetMethod(typeParameters="<in T::Ljava/lang/Comparable<TT;>;>", returnType="Ljava/util/List<TT;>;")
    public static final <T extends Comparable<T>> List<T> toSortedList(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver) {
        return namespace.sort(namespace.toList(this$receiver));
    }

    @JetMethod(typeParameters="<in T::Ljava/lang/Comparable<TT;>;>", returnType="Ljava/util/List<TT;>;")
    public static final <T extends Comparable<T>> List<T> toSortedList(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<TT;>;") Iterable<T> this$receiver, @JetValueParameter(name="comparator", type="Ljava/util/Comparator<TT;>;") Comparator<T> comparator) {
        return namespace.sort(namespace.toList(this$receiver), comparator);
    }

    @JetMethod(typeParameters="<in T::Ljava/lang/Comparable<TT;>;>", returnType="Ljava/util/List<TT;>;")
    public static final <T extends Comparable<T>> List<T> sort(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/List<TT;>;") List<T> this$receiver) {
        Collections.sort(this$receiver);
        return this$receiver;
    }

    @JetMethod(typeParameters="<in T::Ljava/lang/Comparable<TT;>;>", returnType="Ljava/util/List<TT;>;")
    public static final <T extends Comparable<T>> List<T> sort(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/List<TT;>;") List<T> this$receiver, @JetValueParameter(name="comparator", type="Ljava/util/Comparator<TT;>;") Comparator<T> comparator) {
        Collections.sort(this$receiver, comparator);
        return this$receiver;
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/List<TT;>;")
    public static final <T> List<T> notNull(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Ljava/util/List<TT;>;") List<T> this$receiver) {
        List list2;
        boolean bl = true;
        if (this$receiver == null) {
            bl = false;
        }
        if (bl) {
            list2 = this$receiver;
        } else {
            List list3 = Collections.EMPTY_LIST;
            if (!(list3 instanceof List)) {
                throw new TypeCastException();
            }
            list2 = list3;
        }
        return list2;
    }

    @JetMethod(typeParameters="<T:?Ljava/lang/Object;>", returnType="Ljava/util/Set<TT;>;")
    public static final <T> Set<T> notNull(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Ljava/util/Set<TT;>;") Set<T> this$receiver) {
        Set set;
        boolean bl = true;
        if (this$receiver == null) {
            bl = false;
        }
        if (bl) {
            set = this$receiver;
        } else {
            Set set2 = Collections.EMPTY_SET;
            if (!(set2 instanceof Set)) {
                throw new TypeCastException();
            }
            set = set2;
        }
        return set;
    }

    @JetMethod(kind=1, typeParameters="<T:?Ljava/lang/Object;>", propertyType="?TT;")
    public static final <T> T getHead(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/List<TT;>;") List<T> this$receiver) {
        return this$receiver.get(0);
    }

    @JetMethod(kind=1, typeParameters="<T:?Ljava/lang/Object;>", propertyType="?TT;")
    public static final <T> T getFirst(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/List<TT;>;") List<T> this$receiver) {
        return namespace.getHead(this$receiver);
    }

    @JetMethod(kind=1, typeParameters="<T:?Ljava/lang/Object;>", propertyType="?TT;")
    public static final <T> T getTail(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/List<TT;>;") List<T> this$receiver) {
        int s = namespace.getSize((Collection<? extends Object>)this$receiver);
        return s > 0 ? (T)this$receiver.get(s - 1) : null;
    }

    @JetMethod(kind=1, typeParameters="<T:?Ljava/lang/Object;>", propertyType="?TT;")
    public static final <T> T getLast(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/List<TT;>;") List<T> this$receiver) {
        return namespace.getTail(this$receiver);
    }

    @JetMethod(kind=1, propertyType="I")
    public static final int getSize(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Map<+?Ljava/lang/Object;+?Ljava/lang/Object;>;") Map<? extends Object, ? extends Object> this$receiver) {
        return this$receiver.size();
    }

    @JetMethod(kind=1, propertyType="Z")
    public static final boolean getEmpty(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Map<+?Ljava/lang/Object;+?Ljava/lang/Object;>;") Map<? extends Object, ? extends Object> this$receiver) {
        return this$receiver.isEmpty();
    }

    @JetMethod(typeParameters="<K:?Ljava/lang/Object;V:?Ljava/lang/Object;>", returnType="TV;")
    public static final <K, V> V set(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Map<TK;TV;>;") Map<K, V> this$receiver, @JetValueParameter(name="key", type="TK;") K key, @JetValueParameter(name="value", type="TV;") V value) {
        return this$receiver.put(key, value);
    }

    @JetMethod(typeParameters="<K:?Ljava/lang/Object;V:?Ljava/lang/Object;>", returnType="Ljava/util/Map<TK;TV;>;")
    public static final <K, V> Map<K, V> notNull(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Ljava/util/Map<TK;TV;>;") Map<K, V> this$receiver) {
        Map map;
        boolean bl = true;
        if (this$receiver == null) {
            bl = false;
        }
        if (bl) {
            map = this$receiver;
        } else {
            Map map2 = Collections.EMPTY_MAP;
            if (!(map2 instanceof Map)) {
                throw new TypeCastException();
            }
            map = map2;
        }
        return map;
    }

    @JetMethod(typeParameters="<K:?Ljava/lang/Object;V:?Ljava/lang/Object;>", returnType="TV;")
    public static final <K, V> V getOrElse(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Map<TK;TV;>;") Map<K, V> this$receiver, @JetValueParameter(name="key", type="TK;") K key, @JetValueParameter(name="defaultValue", type="Ljet/Function0<TV;>;") Function0<V> defaultValue) {
        V current = this$receiver.get(key);
        boolean bl = true;
        if (current == null) {
            bl = false;
        }
        if (bl) {
            return current;
        }
        return defaultValue.invoke();
    }

    @JetMethod(typeParameters="<K:?Ljava/lang/Object;V:?Ljava/lang/Object;>", returnType="TV;")
    public static final <K, V> V getOrPut(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Map<TK;TV;>;") Map<K, V> this$receiver, @JetValueParameter(name="key", type="TK;") K key, @JetValueParameter(name="defaultValue", type="Ljet/Function0<TV;>;") Function0<V> defaultValue) {
        V current = this$receiver.get(key);
        boolean bl = true;
        if (current == null) {
            bl = false;
        }
        if (bl) {
            return current;
        }
        V answer = defaultValue.invoke();
        this$receiver.put(key, answer);
        return answer;
    }

    @JetMethod(returnType="J")
    public static final long measureTimeMillis(@JetValueParameter(name="block", type="Ljet/Function0<Ljet/Tuple0;>;") Function0<Tuple0> block) {
        long start = System.currentTimeMillis();
        block.invoke();
        return System.currentTimeMillis() - start;
    }

    @JetMethod(returnType="J")
    public static final long measureTimeNano(@JetValueParameter(name="block", type="Ljet/Function0<Ljet/Tuple0;>;") Function0<Tuple0> block) {
        long start = System.nanoTime();
        block.invoke();
        return System.nanoTime() - start;
    }
}

