/*
 * Decompiled with CFR 0.152.
 */
package std.dom;

import java.io.StringWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jet.ExtensionFunction0;
import jet.Tuple0;
import jet.TypeCastException;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import std.dom.ElementListAsList;
import std.dom.NodeListAsList;
import std.dom.namespace$get$1;
import std.dom.namespace$get$2;

public class namespace {
    @JetMethod(kind=1, propertyType="?Lorg/w3c/dom/Element;")
    public static final Element getRootElement(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Lorg/w3c/dom/Document;") Document this$receiver) {
        boolean bl = true;
        if (this$receiver == null) {
            bl = false;
        }
        return bl ? this$receiver.getDocumentElement() : (Element)null;
    }

    @JetMethod(kind=1, propertyType="Ljava/lang/String;")
    public static final String getText(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Node;") Node this$receiver) {
        if (this$receiver instanceof Element) {
            return namespace.getText((Element)this$receiver);
        }
        String string = this$receiver.getNodeValue();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @JetMethod(kind=1, propertyType="Ljava/lang/String;")
    public static final void setText(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Node;") Node this$receiver, @JetValueParameter(name="value", type="Ljava/lang/String;") String value) {
        Tuple0 tuple0;
        if (this$receiver instanceof Element) {
            namespace.setText((Element)this$receiver, value);
            tuple0 = Tuple0.INSTANCE;
        } else {
            this$receiver.setNodeValue(value);
            tuple0 = Tuple0.INSTANCE;
        }
    }

    @JetMethod(kind=1, propertyType="Ljava/lang/String;")
    public static final String getText(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Element;") Element this$receiver) {
        StringBuilder buffer = new StringBuilder();
        NodeList nodeList = this$receiver.getChildNodes();
        boolean bl = true;
        if (nodeList == null) {
            bl = false;
        }
        if (bl) {
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = nodeList.item(i);
                boolean bl2 = true;
                if (node == null) {
                    bl2 = false;
                }
                if (!bl2) continue;
                boolean bl3 = !(node.getNodeType() == Node.TEXT_NODE) ? node.getNodeType() == Node.CDATA_SECTION_NODE : true;
                if (!bl3) continue;
                buffer.append(node.getNodeValue());
            }
        }
        String string = buffer.toString();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @JetMethod(kind=1, propertyType="Ljava/lang/String;")
    public static final void setText(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Element;") Element this$receiver, @JetValueParameter(name="value", type="Ljava/lang/String;") String value) {
        this$receiver.setAttribute("id", value);
    }

    @JetMethod(kind=1, propertyType="Ljava/lang/String;")
    public static final String getId(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Element;") Element this$receiver) {
        String string = this$receiver.getAttribute("id");
        if (string == null) {
            string = "";
        }
        return string;
    }

    @JetMethod(kind=1, propertyType="Ljava/lang/String;")
    public static final void setId(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Element;") Element this$receiver, @JetValueParameter(name="value", type="Ljava/lang/String;") String value) {
        this$receiver.setAttribute("id", value);
        this$receiver.setIdAttribute("id", true);
    }

    @JetMethod(kind=1, propertyType="Ljava/lang/String;")
    public static final String getStyle(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Element;") Element this$receiver) {
        String string = this$receiver.getAttribute("style");
        if (string == null) {
            string = "";
        }
        return string;
    }

    @JetMethod(kind=1, propertyType="Ljava/lang/String;")
    public static final void setStyle(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Element;") Element this$receiver, @JetValueParameter(name="value", type="Ljava/lang/String;") String value) {
        this$receiver.setAttribute("style", value);
    }

    @JetMethod(kind=1, propertyType="Ljava/lang/String;")
    public static final String getCssClass(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Element;") Element this$receiver) {
        String string = this$receiver.getAttribute("class");
        if (string == null) {
            string = "";
        }
        return string;
    }

    @JetMethod(kind=1, propertyType="Ljava/lang/String;")
    public static final void setCssClass(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Element;") Element this$receiver, @JetValueParameter(name="value", type="Ljava/lang/String;") String value) {
        this$receiver.setAttribute("class", value);
    }

    @JetMethod(returnType="Z")
    public static final boolean hasClass(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Element;") Element this$receiver, @JetValueParameter(name="cssClass", type="Ljava/lang/String;") String cssClass) {
        String c = namespace.getCssClass(this$receiver);
        boolean bl = true;
        if (c == null) {
            bl = false;
        }
        return bl ? std.namespace.matches(c, "(^|" + "\\" + "s+)" + cssClass + "(" + "$" + "|" + "\\" + "s+)") : false;
    }

    @JetMethod(returnType="Ljava/util/List<Lorg/w3c/dom/Element;>;")
    public static final List<Element> get(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Lorg/w3c/dom/Document;") Document this$receiver, @JetValueParameter(name="selector", type="Ljava/lang/String;") String selector) {
        List<Element> list2;
        Document document = this$receiver;
        Element root = document != null ? document.getDocumentElement() : null;
        boolean bl = true;
        if (root == null) {
            bl = false;
        }
        if (bl) {
            if (selector.equals("*")) {
                list2 = namespace.getElements(this$receiver);
            } else if (std.namespace.startsWith(selector, ".")) {
                list2 = std.util.namespace.toList(std.util.namespace.filter$default(namespace.getElements(this$receiver), null, new namespace$get$1(selector), 1));
            } else {
                if (std.namespace.startsWith(selector, "#")) {
                    List<Element> list3;
                    String id = std.namespace.substring(selector, 1);
                    Document document2 = this$receiver;
                    Element element = document2 != null ? document2.getElementById(id) : null;
                    boolean bl2 = true;
                    if (element == null) {
                        bl2 = false;
                    }
                    if (bl2) {
                        List<Element> list4 = Collections.singletonList(element);
                        if (list4 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (!(list4 instanceof List)) {
                            throw new TypeCastException();
                        }
                        list3 = list4;
                    } else {
                        List<Element> list5 = Collections.EMPTY_LIST;
                        if (list5 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (!(list5 instanceof List)) {
                            throw new TypeCastException();
                        }
                        list3 = list5;
                    }
                    return list3;
                }
                Document document3 = this$receiver;
                list2 = namespace.toElementList(document3 != null ? document3.getElementsByTagName(selector) : null);
            }
        } else {
            List<Element> list6 = Collections.EMPTY_LIST;
            if (!(list6 instanceof List)) {
                throw new TypeCastException();
            }
            list2 = list6;
        }
        return list2;
    }

    @JetMethod(returnType="Ljava/util/List<Lorg/w3c/dom/Element;>;")
    public static final List<Element> get(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Element;") Element this$receiver, @JetValueParameter(name="selector", type="Ljava/lang/String;") String selector) {
        List<Element> list2;
        if (selector.equals("*")) {
            list2 = namespace.getElements(this$receiver);
        } else if (std.namespace.startsWith(selector, ".")) {
            list2 = std.util.namespace.toList(std.util.namespace.filter$default(namespace.getElements(this$receiver), null, new namespace$get$2(selector), 1));
        } else {
            if (std.namespace.startsWith(selector, "#")) {
                List<Element> list3;
                Document document = this$receiver.getOwnerDocument();
                Element element = document != null ? document.getElementById(std.namespace.substring(selector, 1)) : null;
                boolean bl = true;
                if (element == null) {
                    bl = false;
                }
                if (bl) {
                    List<Element> list4 = Collections.singletonList(element);
                    if (list4 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!(list4 instanceof List)) {
                        throw new TypeCastException();
                    }
                    list3 = list4;
                } else {
                    List<Element> list5 = Collections.EMPTY_LIST;
                    if (list5 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!(list5 instanceof List)) {
                        throw new TypeCastException();
                    }
                    list3 = list5;
                }
                return list3;
            }
            list2 = namespace.toElementList(this$receiver.getElementsByTagName(selector));
        }
        return list2;
    }

    @JetMethod(nullableReturnType=true, returnType="?Ljava/lang/String;")
    public static final String attribute(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Lorg/w3c/dom/Element;") Element this$receiver, @JetValueParameter(name="name", type="Ljava/lang/String;") String name) {
        Element element = this$receiver;
        return element != null ? element.getAttribute(name) : null;
    }

    @JetMethod(returnType="Ljava/util/List<Lorg/w3c/dom/Node;>;")
    public static final List<Node> children(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Lorg/w3c/dom/Element;") Element this$receiver) {
        Element element = this$receiver;
        return namespace.toList(element != null ? element.getChildNodes() : null);
    }

    @JetMethod(kind=1, propertyType="Ljava/util/List<Lorg/w3c/dom/Element;>;")
    public static final List<Element> getElements(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Lorg/w3c/dom/Document;") Document this$receiver) {
        Document document = this$receiver;
        return namespace.toElementList(document != null ? document.getElementsByTagName("*") : null);
    }

    @JetMethod(kind=1, propertyType="Ljava/util/List<Lorg/w3c/dom/Element;>;")
    public static final List<Element> getElements(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Lorg/w3c/dom/Element;") Element this$receiver) {
        Element element = this$receiver;
        return namespace.toElementList(element != null ? element.getElementsByTagName("*") : null);
    }

    @JetMethod(returnType="Ljava/util/List<Lorg/w3c/dom/Element;>;")
    public static final List<Element> elementsByTagNameNS(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Lorg/w3c/dom/Element;") Element this$receiver, @JetValueParameter(name="namespaceUri", nullable=true, type="?Ljava/lang/String;") String namespaceUri, @JetValueParameter(name="localName", nullable=true, type="?Ljava/lang/String;") String localName) {
        Element element = this$receiver;
        return namespace.toElementList(element != null ? element.getElementsByTagNameNS(namespaceUri, localName) : null);
    }

    @JetMethod(returnType="Ljava/util/List<Lorg/w3c/dom/Element;>;")
    public static final List<Element> elementsByTagNameNS(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Lorg/w3c/dom/Document;") Document this$receiver, @JetValueParameter(name="namespaceUri", nullable=true, type="?Ljava/lang/String;") String namespaceUri, @JetValueParameter(name="localName", nullable=true, type="?Ljava/lang/String;") String localName) {
        Document document = this$receiver;
        return namespace.toElementList(document != null ? document.getElementsByTagNameNS(namespaceUri, localName) : null);
    }

    @JetMethod(kind=1, propertyType="?Lorg/w3c/dom/Node;")
    public static final Node getHead(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Lorg/w3c/dom/NodeList;") NodeList this$receiver) {
        boolean bl = true;
        if (this$receiver == null) {
            bl = false;
        }
        return (bl ? this$receiver.getLength() > 0 : false) ? this$receiver.item(0) : (Node)null;
    }

    @JetMethod(kind=1, propertyType="?Lorg/w3c/dom/Node;")
    public static final Node getFirst(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Lorg/w3c/dom/NodeList;") NodeList this$receiver) {
        return namespace.getHead(this$receiver);
    }

    @JetMethod(kind=1, propertyType="?Lorg/w3c/dom/Node;")
    public static final Node getTail(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Lorg/w3c/dom/NodeList;") NodeList this$receiver) {
        boolean bl = true;
        if (this$receiver != null) {
            bl = false;
        }
        if (bl) {
            return null;
        }
        int s = this$receiver.getLength();
        return s > 0 ? this$receiver.item(s - 1) : (Node)null;
    }

    @JetMethod(kind=1, propertyType="?Lorg/w3c/dom/Node;")
    public static final Node getLast(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Lorg/w3c/dom/NodeList;") NodeList this$receiver) {
        return namespace.getTail(this$receiver);
    }

    @JetMethod(returnType="Ljava/util/List<Lorg/w3c/dom/Node;>;")
    public static final List<Node> toList(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Lorg/w3c/dom/NodeList;") NodeList this$receiver) {
        List list2;
        boolean bl = true;
        if (this$receiver != null) {
            bl = false;
        }
        if (bl) {
            List list3 = Collections.EMPTY_LIST;
            if (!(list3 instanceof List)) {
                throw new TypeCastException();
            }
            list2 = list3;
        } else {
            list2 = new NodeListAsList(this$receiver);
        }
        return list2;
    }

    @JetMethod(returnType="Ljava/util/List<Lorg/w3c/dom/Element;>;")
    public static final List<Element> toElementList(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Lorg/w3c/dom/NodeList;") NodeList this$receiver) {
        List list2;
        boolean bl = true;
        if (this$receiver != null) {
            bl = false;
        }
        if (bl) {
            List list3 = Collections.EMPTY_LIST;
            if (!(list3 instanceof List)) {
                throw new TypeCastException();
            }
            list2 = list3;
        } else {
            list2 = new ElementListAsList(this$receiver);
        }
        return list2;
    }

    @JetMethod(returnType="Ljava/lang/String;")
    public static final String toXmlString(@JetValueParameter(name="this$receiver", nullable=true, receiver=true, type="?Lorg/w3c/dom/NodeList;") NodeList this$receiver, @JetValueParameter(name="xmlDeclaration", hasDefaultValue=true, type="Z") boolean xmlDeclaration) {
        boolean bl = true;
        if (this$receiver != null) {
            bl = false;
        }
        return bl ? "" : namespace.toXmlString((Iterable<Node>)namespace.toList(this$receiver), xmlDeclaration);
    }

    public static String toXmlString$default(NodeList nodeList, boolean bl, int n) {
        return namespace.toXmlString(nodeList, (n & 1) != 0 ? false : (boolean)bl);
    }

    @JetMethod(returnType="Lorg/w3c/dom/Node;")
    public static final Node plus(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Node;") Node this$receiver, @JetValueParameter(name="child", nullable=true, type="?Lorg/w3c/dom/Node;") Node child) {
        boolean bl = true;
        if (child == null) {
            bl = false;
        }
        if (bl) {
            this$receiver.appendChild(child);
        }
        return this$receiver;
    }

    @JetMethod(returnType="Lorg/w3c/dom/Element;")
    public static final Element plus(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Element;") Element this$receiver, @JetValueParameter(name="text", nullable=true, type="?Ljava/lang/String;") String text) {
        return namespace.addText$default(this$receiver, text, null, 2);
    }

    @JetMethod(returnType="Lorg/w3c/dom/Element;")
    public static final Element plusAssign(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Element;") Element this$receiver, @JetValueParameter(name="text", nullable=true, type="?Ljava/lang/String;") String text) {
        return namespace.addText$default(this$receiver, text, null, 2);
    }

    @JetMethod(returnType="Lorg/w3c/dom/Element;")
    public static final Element createElement(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Document;") Document this$receiver, @JetValueParameter(name="name", type="Ljava/lang/String;") String name, @JetValueParameter(name="init", type="Ljet/ExtensionFunction0<Lorg/w3c/dom/Element;Ljet/Tuple0;>;") ExtensionFunction0<Element, Tuple0> init) {
        Element element = this$receiver.createElement(name);
        if (element == null) {
            Intrinsics.throwNpe();
        }
        Element elem = element;
        init.invoke(elem);
        return elem;
    }

    @JetMethod(returnType="Lorg/w3c/dom/Element;")
    public static final Element createElement(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Element;") Element this$receiver, @JetValueParameter(name="name", type="Ljava/lang/String;") String name, @JetValueParameter(name="doc", hasDefaultValue=true, nullable=true, type="?Lorg/w3c/dom/Document;") Document doc, @JetValueParameter(name="init", type="Ljet/ExtensionFunction0<Lorg/w3c/dom/Element;Ljet/Tuple0;>;") ExtensionFunction0<Element, Tuple0> init) {
        Element element = namespace.ownerDocument(this$receiver, doc).createElement(name);
        if (element == null) {
            Intrinsics.throwNpe();
        }
        Element elem = element;
        init.invoke(elem);
        return elem;
    }

    public static Element createElement$default(Element element, String string, Document document, ExtensionFunction0 extensionFunction0, int n) {
        return namespace.createElement(element, string, (n & 2) != 0 ? (Document)null : document, extensionFunction0);
    }

    @JetMethod(returnType="Lorg/w3c/dom/Document;")
    public static final Document ownerDocument(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Node;") Node this$receiver, @JetValueParameter(name="doc", hasDefaultValue=true, nullable=true, type="?Lorg/w3c/dom/Document;") Document doc) {
        Document document;
        if (this$receiver instanceof Document) {
            Node node = this$receiver;
            if (!(node instanceof Document)) {
                throw new TypeCastException();
            }
            document = (Document)node;
        } else {
            boolean bl = true;
            if (doc != null) {
                bl = false;
            }
            document = bl ? this$receiver.getOwnerDocument() : doc;
        }
        Document answer = document;
        boolean bl = true;
        if (answer != null) {
            bl = false;
        }
        if (bl) {
            throw (Throwable)new IllegalArgumentException("Element does not have an ownerDocument and none was provided for: " + this$receiver);
        }
        return answer;
    }

    public static Document ownerDocument$default(Node node, Document document, int n) {
        return namespace.ownerDocument(node, (n & 1) != 0 ? (Document)null : document);
    }

    @JetMethod(returnType="Lorg/w3c/dom/Element;")
    public static final Element addElement(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Document;") Document this$receiver, @JetValueParameter(name="name", type="Ljava/lang/String;") String name, @JetValueParameter(name="init", type="Ljet/ExtensionFunction0<Lorg/w3c/dom/Element;Ljet/Tuple0;>;") ExtensionFunction0<Element, Tuple0> init) {
        Element child = namespace.createElement(this$receiver, name, init);
        this$receiver.appendChild(child);
        return child;
    }

    @JetMethod(returnType="Lorg/w3c/dom/Element;")
    public static final Element addElement(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Element;") Element this$receiver, @JetValueParameter(name="name", type="Ljava/lang/String;") String name, @JetValueParameter(name="doc", hasDefaultValue=true, nullable=true, type="?Lorg/w3c/dom/Document;") Document doc, @JetValueParameter(name="init", type="Ljet/ExtensionFunction0<Lorg/w3c/dom/Element;Ljet/Tuple0;>;") ExtensionFunction0<Element, Tuple0> init) {
        Element child = namespace.createElement(this$receiver, name, doc, init);
        this$receiver.appendChild(child);
        return child;
    }

    public static Element addElement$default(Element element, String string, Document document, ExtensionFunction0 extensionFunction0, int n) {
        return namespace.addElement(element, string, (n & 2) != 0 ? (Document)null : document, extensionFunction0);
    }

    @JetMethod(returnType="Lorg/w3c/dom/Element;")
    public static final Element addText(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Element;") Element this$receiver, @JetValueParameter(name="text", nullable=true, type="?Ljava/lang/String;") String text, @JetValueParameter(name="doc", hasDefaultValue=true, nullable=true, type="?Lorg/w3c/dom/Document;") Document doc) {
        boolean bl = true;
        if (text == null) {
            bl = false;
        }
        if (bl) {
            Text child = namespace.ownerDocument(this$receiver, doc).createTextNode(text);
            this$receiver.appendChild(child);
        }
        return this$receiver;
    }

    public static Element addText$default(Element element, String string, Document document, int n) {
        return namespace.addText(element, string, (n & 2) != 0 ? (Document)null : document);
    }

    @JetMethod(returnType="Lorg/w3c/dom/Document;")
    public static final Document createDocument(@JetValueParameter(name="builder", type="Ljavax/xml/parsers/DocumentBuilder;") DocumentBuilder builder) {
        Document document = builder.newDocument();
        if (document == null) {
            Intrinsics.throwNpe();
        }
        return document;
    }

    @JetMethod(returnType="Lorg/w3c/dom/Document;")
    public static final Document createDocument(@JetValueParameter(name="builderFactory", hasDefaultValue=true, type="Ljavax/xml/parsers/DocumentBuilderFactory;") DocumentBuilderFactory builderFactory) {
        DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
        if (documentBuilder == null) {
            Intrinsics.throwNpe();
        }
        return namespace.createDocument(documentBuilder);
    }

    public static Document createDocument$default(DocumentBuilderFactory documentBuilderFactory, int n) {
        DocumentBuilderFactory documentBuilderFactory2;
        if ((n & 1) != 0) {
            documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            if (documentBuilderFactory2 == null) {
                Intrinsics.throwNpe();
            }
        } else {
            documentBuilderFactory2 = documentBuilderFactory;
        }
        return namespace.createDocument(documentBuilderFactory2);
    }

    @JetMethod(returnType="Ljavax/xml/transform/Transformer;")
    public static final Transformer createTransformer(@JetValueParameter(name="source", hasDefaultValue=true, nullable=true, type="?Ljavax/xml/transform/Source;") Source source, @JetValueParameter(name="factory", hasDefaultValue=true, type="Ljavax/xml/transform/TransformerFactory;") TransformerFactory factory) {
        Transformer transformer;
        boolean bl = true;
        if (source == null) {
            bl = false;
        }
        Transformer transformer2 = transformer = bl ? factory.newTransformer(source) : factory.newTransformer();
        if (transformer2 == null) {
            Intrinsics.throwNpe();
        }
        return transformer2;
    }

    public static Transformer createTransformer$default(Source source, TransformerFactory transformerFactory, int n) {
        TransformerFactory transformerFactory2;
        Source source2 = (n & 1) != 0 ? (Source)null : source;
        if ((n & 2) != 0) {
            transformerFactory2 = TransformerFactory.newInstance();
            if (transformerFactory2 == null) {
                Intrinsics.throwNpe();
            }
        } else {
            transformerFactory2 = transformerFactory;
        }
        return namespace.createTransformer(source2, transformerFactory2);
    }

    @JetMethod(returnType="Ljava/lang/String;")
    public static final String toXmlString(@JetValueParameter(name="this$receiver", receiver=true, type="Lorg/w3c/dom/Node;") Node this$receiver, @JetValueParameter(name="xmlDeclaration", hasDefaultValue=true, type="Z") boolean xmlDeclaration) {
        return namespace.nodeToXmlString(this$receiver, xmlDeclaration);
    }

    public static String toXmlString$default(Node node, boolean bl, int n) {
        return namespace.toXmlString(node, (n & 1) != 0 ? node instanceof Document : bl);
    }

    @JetMethod(returnType="Ljava/lang/String;")
    public static final String toXmlString(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Iterable<Lorg/w3c/dom/Node;>;") Iterable<Node> this$receiver, @JetValueParameter(name="xmlDeclaration", hasDefaultValue=true, type="Z") boolean xmlDeclaration) {
        StringBuilder builder = new StringBuilder();
        Iterator<Node> iterator2 = this$receiver.iterator();
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                Node n = iterator2.next();
                builder.append(namespace.toXmlString(n, xmlDeclaration));
            }
        }
        String string = builder.toString();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    public static String toXmlString$default(Iterable iterable, boolean bl, int n) {
        return namespace.toXmlString(iterable, (n & 1) != 0 ? false : (boolean)bl);
    }

    @JetMethod(returnType="Ljava/lang/String;")
    public static final String nodeToXmlString(@JetValueParameter(name="node", type="Lorg/w3c/dom/Node;") Node node, @JetValueParameter(name="xmlDeclaration", type="Z") boolean xmlDeclaration) {
        Transformer transformer = namespace.createTransformer$default(null, null, 3);
        transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, xmlDeclaration ? "no" : "yes");
        StringWriter buffer = new StringWriter();
        transformer.transform(new DOMSource(node), new StreamResult(buffer));
        String string = buffer.toString();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }
}

