/*
 * Decompiled with CFR 0.152.
 */
package std.concurrent;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jet.ExtensionFunction0;
import jet.Function0;
import jet.Tuple0;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import std.concurrent.namespace$createTask$1;
import std.concurrent.namespace$execute$1;
import std.concurrent.namespace$thread$thread$1;
import std.concurrent.namespace$write$1;
import std.concurrent.namespace$write$2;

public class namespace {
    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="TT;")
    public static final <T> T withLock(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/concurrent/locks/Lock;") Lock this$receiver, @JetValueParameter(name="action", type="Ljet/Function0<TT;>;") Function0<T> action) {
        this$receiver.lock();
        try {
            T t = action.invoke();
            this$receiver.unlock();
            return t;
        }
        catch (Throwable throwable) {
            this$receiver.unlock();
            throw throwable;
        }
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="TT;")
    public static final <T> T read(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/concurrent/locks/ReentrantReadWriteLock;") ReentrantReadWriteLock this$receiver, @JetValueParameter(name="action", type="Ljet/Function0<TT;>;") Function0<T> action) {
        ReentrantReadWriteLock.ReadLock readLock = this$receiver.readLock();
        if (readLock == null) {
            Intrinsics.throwNpe();
        }
        ReentrantReadWriteLock.ReadLock rl = readLock;
        rl.lock();
        try {
            T t = action.invoke();
            rl.unlock();
            return t;
        }
        catch (Throwable throwable) {
            rl.unlock();
            throw throwable;
        }
    }

    @JetMethod(typeParameters="<erased T:?Ljava/lang/Object;>", returnType="TT;")
    public static final <T> T write(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/concurrent/locks/ReentrantReadWriteLock;") ReentrantReadWriteLock this$receiver, @JetValueParameter(name="action", type="Ljet/Function0<TT;>;") Function0<T> action) {
        ReentrantReadWriteLock.ReadLock readLock = this$receiver.readLock();
        if (readLock == null) {
            Intrinsics.throwNpe();
        }
        ReentrantReadWriteLock.ReadLock rl = readLock;
        int readCount = this$receiver.getWriteHoldCount() == 0 ? this$receiver.getReadHoldCount() : 0;
        std.namespace.times(readCount, new namespace$write$1(rl));
        ReentrantReadWriteLock.WriteLock writeLock = this$receiver.writeLock();
        if (writeLock == null) {
            Intrinsics.throwNpe();
        }
        ReentrantReadWriteLock.WriteLock wl = writeLock;
        wl.lock();
        try {
            T t = action.invoke();
            std.namespace.times(readCount, new namespace$write$2(rl));
            wl.unlock();
            return t;
        }
        catch (Throwable throwable) {
            std.namespace.times(readCount, new namespace$write$2(rl));
            wl.unlock();
            throw throwable;
        }
    }

    @JetMethod(kind=1, propertyType="Ljava/lang/Thread;")
    public static final Thread getCurrentThread() {
        Thread thread2 = Thread.currentThread();
        if (thread2 == null) {
            Intrinsics.throwNpe();
        }
        return thread2;
    }

    @JetMethod(kind=1, propertyType="Ljava/lang/String;")
    public static final String getName(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Thread;") Thread this$receiver) {
        String string = this$receiver.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @JetMethod(kind=1, propertyType="Ljava/lang/String;")
    public static final void setName(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Thread;") Thread this$receiver, @JetValueParameter(name="name", type="Ljava/lang/String;") String name) {
        this$receiver.setName(name);
    }

    @JetMethod(kind=1, propertyType="Z")
    public static final boolean getDaemon(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Thread;") Thread this$receiver) {
        return this$receiver.isDaemon();
    }

    @JetMethod(kind=1, propertyType="Z")
    public static final void setDaemon(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Thread;") Thread this$receiver, @JetValueParameter(name="on", type="Z") boolean on) {
        this$receiver.setDaemon(on);
    }

    @JetMethod(kind=1, propertyType="Z")
    public static final boolean getAlive(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Thread;") Thread this$receiver) {
        return this$receiver.isAlive();
    }

    @JetMethod(kind=1, propertyType="I")
    public static final int getPriority(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Thread;") Thread this$receiver) {
        return this$receiver.getPriority();
    }

    @JetMethod(kind=1, propertyType="I")
    public static final void setPriority(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Thread;") Thread this$receiver, @JetValueParameter(name="prio", type="I") int prio) {
        this$receiver.setPriority(prio);
    }

    @JetMethod(kind=1, propertyType="?Ljava/lang/ClassLoader;")
    public static final ClassLoader getContextClassLoader(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Thread;") Thread this$receiver) {
        return this$receiver.getContextClassLoader();
    }

    @JetMethod(kind=1, propertyType="?Ljava/lang/ClassLoader;")
    public static final void setContextClassLoader(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/lang/Thread;") Thread this$receiver, @JetValueParameter(name="loader", nullable=true, type="?Ljava/lang/ClassLoader;") ClassLoader loader) {
        this$receiver.setContextClassLoader(loader);
    }

    @JetMethod(returnType="Ljava/lang/Thread;")
    public static final Thread thread(@JetValueParameter(name="start", hasDefaultValue=true, type="Z") boolean start, @JetValueParameter(name="daemon", hasDefaultValue=true, type="Z") boolean daemon, @JetValueParameter(name="contextClassLoader", hasDefaultValue=true, nullable=true, type="?Ljava/lang/ClassLoader;") ClassLoader contextClassLoader, @JetValueParameter(name="name", hasDefaultValue=true, nullable=true, type="?Ljava/lang/String;") String name, @JetValueParameter(name="priority", hasDefaultValue=true, type="I") int priority, @JetValueParameter(name="block", type="Ljet/Function0<Ljet/Tuple0;>;") Function0<Tuple0> block) {
        namespace$thread$thread$1 thread2 = new namespace$thread$thread$1(block);
        if (daemon) {
            thread2.setDaemon(true);
        }
        if (priority > 0) {
            thread2.setPriority(priority);
        }
        boolean bl = true;
        if (name == null) {
            bl = false;
        }
        if (bl) {
            thread2.setName(name);
        }
        boolean bl2 = true;
        if (contextClassLoader == null) {
            bl2 = false;
        }
        if (bl2) {
            thread2.setContextClassLoader(contextClassLoader);
        }
        if (start) {
            thread2.start();
        }
        return thread2;
    }

    public static Thread thread$default(boolean bl, boolean bl2, ClassLoader classLoader, String string, int n, Function0 function0, int n2) {
        return namespace.thread((n2 & 1) != 0 ? true : (boolean)bl, (n2 & 2) != 0 ? false : (boolean)bl2, (n2 & 4) != 0 ? (ClassLoader)null : classLoader, (n2 & 8) != 0 ? (String)null : string, (n2 & 0x10) != 0 ? -1 : n, function0);
    }

    @JetMethod(returnType="V")
    public static final void execute(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/concurrent/Executor;") Executor this$receiver, @JetValueParameter(name="action", type="Ljet/Function0<Ljet/Tuple0;>;") Function0<Tuple0> action) {
        this$receiver.execute(new namespace$execute$1(action));
    }

    @JetMethod(returnType="Ljava/util/TimerTask;")
    public static final TimerTask schedule(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Timer;") Timer this$receiver, @JetValueParameter(name="delay", type="J") long delay, @JetValueParameter(name="action", type="Ljet/ExtensionFunction0<Ljava/util/TimerTask;Ljet/Tuple0;>;") ExtensionFunction0<TimerTask, Tuple0> action) {
        TimerTask task = namespace.createTask(action);
        this$receiver.schedule(task, delay);
        return task;
    }

    @JetMethod(returnType="Ljava/util/TimerTask;")
    public static final TimerTask schedule(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Timer;") Timer this$receiver, @JetValueParameter(name="time", type="Ljava/util/Date;") Date time, @JetValueParameter(name="action", type="Ljet/ExtensionFunction0<Ljava/util/TimerTask;Ljet/Tuple0;>;") ExtensionFunction0<TimerTask, Tuple0> action) {
        TimerTask task = namespace.createTask(action);
        this$receiver.schedule(task, time);
        return task;
    }

    @JetMethod(returnType="Ljava/util/TimerTask;")
    public static final TimerTask schedule(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Timer;") Timer this$receiver, @JetValueParameter(name="delay", type="J") long delay, @JetValueParameter(name="period", type="J") long period, @JetValueParameter(name="action", type="Ljet/ExtensionFunction0<Ljava/util/TimerTask;Ljet/Tuple0;>;") ExtensionFunction0<TimerTask, Tuple0> action) {
        TimerTask task = namespace.createTask(action);
        this$receiver.schedule(task, delay, period);
        return task;
    }

    @JetMethod(returnType="Ljava/util/TimerTask;")
    public static final TimerTask schedule(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Timer;") Timer this$receiver, @JetValueParameter(name="time", type="Ljava/util/Date;") Date time, @JetValueParameter(name="period", type="J") long period, @JetValueParameter(name="action", type="Ljet/ExtensionFunction0<Ljava/util/TimerTask;Ljet/Tuple0;>;") ExtensionFunction0<TimerTask, Tuple0> action) {
        TimerTask task = namespace.createTask(action);
        this$receiver.schedule(task, time, period);
        return task;
    }

    @JetMethod(returnType="Ljava/util/TimerTask;")
    public static final TimerTask scheduleAtFixedRate(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Timer;") Timer this$receiver, @JetValueParameter(name="delay", type="J") long delay, @JetValueParameter(name="period", type="J") long period, @JetValueParameter(name="action", type="Ljet/ExtensionFunction0<Ljava/util/TimerTask;Ljet/Tuple0;>;") ExtensionFunction0<TimerTask, Tuple0> action) {
        TimerTask task = namespace.createTask(action);
        this$receiver.scheduleAtFixedRate(task, delay, period);
        return task;
    }

    @JetMethod(returnType="Ljava/util/TimerTask;")
    public static final TimerTask scheduleAtFixedRate(@JetValueParameter(name="this$receiver", receiver=true, type="Ljava/util/Timer;") Timer this$receiver, @JetValueParameter(name="time", type="Ljava/util/Date;") Date time, @JetValueParameter(name="period", type="J") long period, @JetValueParameter(name="action", type="Ljet/ExtensionFunction0<Ljava/util/TimerTask;Ljet/Tuple0;>;") ExtensionFunction0<TimerTask, Tuple0> action) {
        TimerTask task = namespace.createTask(action);
        this$receiver.scheduleAtFixedRate(task, time, period);
        return task;
    }

    @JetMethod(returnType="Ljava/util/Timer;")
    public static final Timer timer(@JetValueParameter(name="name", hasDefaultValue=true, nullable=true, type="?Ljava/lang/String;") String name, @JetValueParameter(name="daemon", hasDefaultValue=true, type="Z") boolean daemon, @JetValueParameter(name="initialDelay", hasDefaultValue=true, type="J") long initialDelay, @JetValueParameter(name="period", type="J") long period, @JetValueParameter(name="action", type="Ljet/ExtensionFunction0<Ljava/util/TimerTask;Ljet/Tuple0;>;") ExtensionFunction0<TimerTask, Tuple0> action) {
        boolean bl = true;
        if (name != null) {
            bl = false;
        }
        Timer timer = bl ? new Timer(daemon) : new Timer(name, daemon);
        namespace.schedule(timer, initialDelay, period, action);
        return timer;
    }

    public static Timer timer$default(String string, boolean bl, long l, long l2, ExtensionFunction0 extensionFunction0, int n) {
        return namespace.timer((n & 1) != 0 ? (String)null : string, (n & 2) != 0 ? false : (boolean)bl, (n & 4) != 0 ? (long)0 : l, l2, (ExtensionFunction0<TimerTask, Tuple0>)extensionFunction0);
    }

    @JetMethod(returnType="Ljava/util/Timer;")
    public static final Timer timer(@JetValueParameter(name="name", hasDefaultValue=true, nullable=true, type="?Ljava/lang/String;") String name, @JetValueParameter(name="daemon", hasDefaultValue=true, type="Z") boolean daemon, @JetValueParameter(name="startAt", type="Ljava/util/Date;") Date startAt, @JetValueParameter(name="period", type="J") long period, @JetValueParameter(name="action", type="Ljet/ExtensionFunction0<Ljava/util/TimerTask;Ljet/Tuple0;>;") ExtensionFunction0<TimerTask, Tuple0> action) {
        boolean bl = true;
        if (name != null) {
            bl = false;
        }
        Timer timer = bl ? new Timer(daemon) : new Timer(name, daemon);
        namespace.schedule(timer, startAt, period, action);
        return timer;
    }

    public static Timer timer$default(String string, boolean bl, Date date, long l, ExtensionFunction0 extensionFunction0, int n) {
        return namespace.timer((n & 1) != 0 ? (String)null : string, (n & 2) != 0 ? false : (boolean)bl, date, l, (ExtensionFunction0<TimerTask, Tuple0>)extensionFunction0);
    }

    @JetMethod(returnType="Ljava/util/Timer;")
    public static final Timer fixedRateTimer(@JetValueParameter(name="name", hasDefaultValue=true, nullable=true, type="?Ljava/lang/String;") String name, @JetValueParameter(name="daemon", hasDefaultValue=true, type="Z") boolean daemon, @JetValueParameter(name="initialDelay", hasDefaultValue=true, type="J") long initialDelay, @JetValueParameter(name="period", type="J") long period, @JetValueParameter(name="action", type="Ljet/ExtensionFunction0<Ljava/util/TimerTask;Ljet/Tuple0;>;") ExtensionFunction0<TimerTask, Tuple0> action) {
        boolean bl = true;
        if (name != null) {
            bl = false;
        }
        Timer timer = bl ? new Timer(daemon) : new Timer(name, daemon);
        namespace.scheduleAtFixedRate(timer, initialDelay, period, action);
        return timer;
    }

    public static Timer fixedRateTimer$default(String string, boolean bl, long l, long l2, ExtensionFunction0 extensionFunction0, int n) {
        return namespace.fixedRateTimer((n & 1) != 0 ? (String)null : string, (n & 2) != 0 ? false : (boolean)bl, (n & 4) != 0 ? (long)0 : l, l2, (ExtensionFunction0<TimerTask, Tuple0>)extensionFunction0);
    }

    @JetMethod(returnType="Ljava/util/Timer;")
    public static final Timer fixedRateTimer(@JetValueParameter(name="name", hasDefaultValue=true, nullable=true, type="?Ljava/lang/String;") String name, @JetValueParameter(name="daemon", hasDefaultValue=true, type="Z") boolean daemon, @JetValueParameter(name="startAt", type="Ljava/util/Date;") Date startAt, @JetValueParameter(name="period", type="J") long period, @JetValueParameter(name="action", type="Ljet/ExtensionFunction0<Ljava/util/TimerTask;Ljet/Tuple0;>;") ExtensionFunction0<TimerTask, Tuple0> action) {
        boolean bl = true;
        if (name != null) {
            bl = false;
        }
        Timer timer = bl ? new Timer(daemon) : new Timer(name, daemon);
        namespace.scheduleAtFixedRate(timer, startAt, period, action);
        return timer;
    }

    public static Timer fixedRateTimer$default(String string, boolean bl, Date date, long l, ExtensionFunction0 extensionFunction0, int n) {
        return namespace.fixedRateTimer((n & 1) != 0 ? (String)null : string, (n & 2) != 0 ? false : (boolean)bl, date, l, (ExtensionFunction0<TimerTask, Tuple0>)extensionFunction0);
    }

    @JetMethod(returnType="Ljava/util/TimerTask;")
    public static final TimerTask createTask(@JetValueParameter(name="action", type="Ljet/ExtensionFunction0<Ljava/util/TimerTask;Ljet/Tuple0;>;") ExtensionFunction0<TimerTask, Tuple0> action) {
        return new namespace$createTask$1(action);
    }
}

