/*
 * Decompiled with CFR 0.152.
 */
package std.concurrent;

import java.util.NoSuchElementException;
import jet.Tuple2;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import std.concurrent.FunctionalList;

@JetClass(signature="<T:?Ljava/lang/Object;>Ljava/lang/Object;")
public final class FunctionalQueue<T> {
    final FunctionalList input;
    final FunctionalList output;

    @JetMethod(kind=1, propertyType="I")
    public final int getSize() {
        return this.input.getSize() + this.output.getSize();
    }

    @JetMethod(kind=1, propertyType="Z")
    public final boolean getEmpty() {
        return this.getSize() == 0;
    }

    @JetMethod(returnType="Lstd/concurrent/FunctionalQueue<TT;>;")
    public final FunctionalQueue<T> add(@JetValueParameter(name="element", type="TT;") T element) {
        return new FunctionalQueue<T>(this.input.add(element), this.output);
    }

    @JetMethod(returnType="Lstd/concurrent/FunctionalQueue<TT;>;")
    public final FunctionalQueue<T> addFirst(@JetValueParameter(name="element", type="TT;") T element) {
        return new FunctionalQueue<T>(this.input, this.output.add(element));
    }

    @JetMethod(returnType="Ljet/Tuple2<+TT;+Lstd/concurrent/FunctionalQueue<TT;>;>;")
    public final Tuple2<? extends T, ? extends FunctionalQueue<T>> removeFirst() {
        Tuple2 tuple2;
        if (this.output.getEmpty()) {
            if (this.input.getEmpty()) {
                throw (Throwable)new NoSuchElementException();
            }
            tuple2 = new FunctionalQueue(FunctionalList.$classobj.emptyList(), this.input.reversed()).removeFirst();
        } else {
            tuple2 = new Tuple2((Object)this.output.getHead(), new FunctionalQueue<T>(this.input, this.output.getTail()));
        }
        return tuple2;
    }

    @JetMethod(kind=1, propertyType="Lstd/concurrent/FunctionalList<TT;>;")
    public FunctionalList getInput() {
        return this.input;
    }

    @JetMethod(kind=1, propertyType="Lstd/concurrent/FunctionalList<TT;>;")
    public FunctionalList getOutput() {
        return this.output;
    }

    @JetConstructor
    public FunctionalQueue(@JetValueParameter(name="input", hasDefaultValue=true) FunctionalList<T> functionalList, @JetValueParameter(name="output", hasDefaultValue=true) FunctionalList<T> functionalList2) {
        this.input = functionalList;
        this.output = functionalList2;
    }

    public FunctionalQueue(FunctionalList functionalList, FunctionalList functionalList2, int n) {
        this((n & 1) != 0 ? (FunctionalList)FunctionalList.$classobj.emptyList() : functionalList, (n & 2) != 0 ? (FunctionalList)FunctionalList.$classobj.emptyList() : functionalList2);
    }
}

