/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.rt.signature;

import jet.typeinfo.TypeInfoVariance;
import org.jetbrains.jet.rt.signature.JetSignatureVariance;
import org.jetbrains.jet.rt.signature.JetSignatureVisitor;

public class JetSignatureReader {
    private final String signature;

    public JetSignatureReader(String signature) {
        this.signature = signature;
    }

    public void accept(JetSignatureVisitor v) {
        String signature = this.signature;
        int len = signature.length();
        int pos = this.acceptFormalTypeParameters(v);
        if (signature.charAt(pos) == '(') {
            ++pos;
            while (signature.charAt(pos) != ')') {
                pos = JetSignatureReader.parseType(signature, pos, v.visitParameterType());
            }
            pos = JetSignatureReader.parseType(signature, pos + 1, v.visitReturnType());
            while (pos < len) {
                pos = JetSignatureReader.parseType(signature, pos + 1, v.visitExceptionType());
            }
        } else {
            pos = JetSignatureReader.parseType(signature, pos, v.visitSuperclass());
            while (pos < len) {
                pos = JetSignatureReader.parseType(signature, pos, v.visitInterface());
            }
        }
        if (pos != signature.length()) {
            throw new IllegalStateException();
        }
    }

    public int acceptFormalTypeParameters(JetSignatureVisitor v) {
        int pos;
        if (this.signature.length() > 0 && this.signature.charAt(0) == '<') {
            char c;
            pos = 1;
            do {
                TypeInfoVariance variance;
                boolean reified = true;
                if (this.signature.substring(pos).startsWith("erased ")) {
                    reified = false;
                    pos += "erased ".length();
                }
                if (this.signature.substring(pos).startsWith("in ")) {
                    variance = TypeInfoVariance.IN;
                    pos += "in ".length();
                } else if (this.signature.substring(pos).startsWith("out ")) {
                    variance = TypeInfoVariance.OUT;
                    pos += "out ".length();
                } else {
                    variance = TypeInfoVariance.INVARIANT;
                    pos += "".length();
                }
                int end = this.signature.indexOf(58, pos);
                if (end < 0) {
                    throw new IllegalStateException();
                }
                String typeParameterName = this.signature.substring(pos, end);
                if (typeParameterName.isEmpty()) {
                    throw new IllegalStateException("incorrect signature: " + this.signature);
                }
                JetSignatureVisitor parameterVisitor = v.visitFormalTypeParameter(typeParameterName, variance, reified);
                pos = end + 1;
                c = this.signature.charAt(pos);
                if (c == 'L' || c == '[' || c == 'T' || c == '?') {
                    pos = JetSignatureReader.parseType(this.signature, pos, parameterVisitor.visitClassBound());
                }
                while ((c = this.signature.charAt(pos)) == ':') {
                    ++pos;
                    pos = JetSignatureReader.parseType(this.signature, pos, parameterVisitor.visitInterfaceBound());
                }
                parameterVisitor.visitFormalTypeParameterEnd();
            } while (c != '>');
            ++pos;
        } else {
            pos = 0;
        }
        return pos;
    }

    public void acceptFormalTypeParametersOnly(JetSignatureVisitor v) {
        int r = this.acceptFormalTypeParameters(v);
        if (r != this.signature.length()) {
            throw new IllegalStateException();
        }
    }

    public int acceptType(JetSignatureVisitor v) {
        return JetSignatureReader.parseType(this.signature, 0, v);
    }

    public void acceptTypeOnly(JetSignatureVisitor v) {
        int r = this.acceptType(v);
        if (r != this.signature.length()) {
            throw new IllegalStateException();
        }
    }

    private static int parseType(String signature, int pos, JetSignatureVisitor v) {
        if (signature.length() == 0) {
            throw new IllegalStateException();
        }
        boolean nullable = false;
        if (signature.charAt(pos) == '?') {
            nullable = true;
        }
        int n = ++pos;
        ++pos;
        char c = signature.charAt(n);
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                v.visitBaseType(c, nullable);
                return pos;
            }
            case '[': {
                return JetSignatureReader.parseType(signature, pos, v.visitArrayType(nullable));
            }
            case 'T': {
                int end = signature.indexOf(59, pos);
                v.visitTypeVariable(signature.substring(pos, end), nullable);
                return end + 1;
            }
            case 'L': 
            case 'M': {
                boolean forceReal = signature.charAt(pos - 1) == 'M';
                int start = pos;
                boolean visited = false;
                boolean inner = false;
                while (true) {
                    c = signature.charAt(pos++);
                    block6 : switch (c) {
                        case '.': 
                        case ';': {
                            String name;
                            if (!visited) {
                                name = signature.substring(start, pos - 1);
                                if (inner) {
                                    v.visitInnerClassType(name, nullable);
                                } else {
                                    v.visitClassType(name, nullable, forceReal);
                                }
                            }
                            if (c == ';') {
                                v.visitEnd();
                                return pos;
                            }
                            start = pos;
                            visited = false;
                            inner = true;
                            break;
                        }
                        case '<': {
                            String name = signature.substring(start, pos - 1);
                            if (inner) {
                                v.visitInnerClassType(name, nullable);
                            } else {
                                v.visitClassType(name, nullable, forceReal);
                            }
                            visited = true;
                            block16: while (true) {
                                c = signature.charAt(pos);
                                switch (c) {
                                    case '>': {
                                        break block6;
                                    }
                                    case '*': {
                                        ++pos;
                                        v.visitTypeArgument();
                                        continue block16;
                                    }
                                    case '+': 
                                    case '-': {
                                        pos = JetSignatureReader.parseType(signature, pos + 1, v.visitTypeArgument(JetSignatureVariance.parseVariance(c)));
                                        continue block16;
                                    }
                                }
                                pos = JetSignatureReader.parseType(signature, pos, v.visitTypeArgument(JetSignatureVariance.INVARIANT));
                            }
                        }
                    }
                }
            }
        }
        throw new IllegalStateException();
    }
}

