/*
 * Decompiled with CFR 0.152.
 */
package jet.runtime;

import jet.BooleanIterator;
import jet.ByteIterator;
import jet.CharIterator;
import jet.DoubleIterator;
import jet.FloatIterator;
import jet.IntIterator;
import jet.Iterator;
import jet.LongIterator;
import jet.ShortIterator;

public abstract class ArrayIterator<T>
implements Iterator<T> {
    private final int size;
    protected int index;

    protected ArrayIterator(int size) {
        this.size = size;
    }

    @Override
    public boolean getHasNext() {
        return this.index < this.size;
    }

    public static <T> Iterator<T> iterator(T[] array) {
        return new GenericIterator(array);
    }

    public static ByteIterator iterator(byte[] array) {
        return new ArrayByteIterator(array);
    }

    public static ShortIterator iterator(short[] array) {
        return new ArrayShortIterator(array);
    }

    public static IntIterator iterator(int[] array) {
        return new ArrayIntegerIterator(array);
    }

    public static LongIterator iterator(long[] array) {
        return new ArrayLongIterator(array);
    }

    public static FloatIterator iterator(float[] array) {
        return new ArrayFloatIterator(array);
    }

    public static DoubleIterator iterator(double[] array) {
        return new ArrayDoubleIterator(array);
    }

    public static CharIterator iterator(char[] array) {
        return new ArrayCharacterIterator(array);
    }

    public static BooleanIterator iterator(boolean[] array) {
        return new ArrayBooleanIterator(array);
    }

    private static class ArrayBooleanIterator
    extends BooleanIterator {
        private final boolean[] array;
        private int index;

        @Override
        public boolean getHasNext() {
            return this.index < this.array.length;
        }

        private ArrayBooleanIterator(boolean[] array) {
            this.array = array;
        }

        @Override
        public boolean nextBoolean() {
            return this.array[this.index++];
        }
    }

    private static class ArrayCharacterIterator
    extends CharIterator {
        private final char[] array;
        private int index;

        @Override
        public boolean getHasNext() {
            return this.index < this.array.length;
        }

        private ArrayCharacterIterator(char[] array) {
            this.array = array;
        }

        @Override
        public char nextChar() {
            return this.array[this.index++];
        }
    }

    private static class ArrayDoubleIterator
    extends DoubleIterator {
        private final double[] array;
        private int index;

        @Override
        public boolean getHasNext() {
            return this.index < this.array.length;
        }

        private ArrayDoubleIterator(double[] array) {
            this.array = array;
        }

        @Override
        public double nextDouble() {
            return this.array[this.index++];
        }
    }

    private static class ArrayFloatIterator
    extends FloatIterator {
        private final float[] array;
        private int index;

        @Override
        public boolean getHasNext() {
            return this.index < this.array.length;
        }

        private ArrayFloatIterator(float[] array) {
            this.array = array;
        }

        @Override
        public float nextFloat() {
            return this.array[this.index++];
        }
    }

    private static class ArrayLongIterator
    extends LongIterator {
        private final long[] array;
        private int index;

        @Override
        public boolean getHasNext() {
            return this.index < this.array.length;
        }

        private ArrayLongIterator(long[] array) {
            this.array = array;
        }

        @Override
        public long nextLong() {
            return this.array[this.index++];
        }
    }

    private static class ArrayIntegerIterator
    extends IntIterator {
        private final int[] array;
        private int index;

        @Override
        public boolean getHasNext() {
            return this.index < this.array.length;
        }

        private ArrayIntegerIterator(int[] array) {
            this.array = array;
        }

        @Override
        public int nextInt() {
            return this.array[this.index++];
        }
    }

    private static class ArrayShortIterator
    extends ShortIterator {
        private final short[] array;
        private int index;

        @Override
        public boolean getHasNext() {
            return this.index < this.array.length;
        }

        private ArrayShortIterator(short[] array) {
            this.array = array;
        }

        @Override
        public short nextShort() {
            return this.array[this.index++];
        }
    }

    private static class ArrayByteIterator
    extends ByteIterator {
        private final byte[] array;
        private int index;

        @Override
        public boolean getHasNext() {
            return this.index < this.array.length;
        }

        private ArrayByteIterator(byte[] array) {
            this.array = array;
        }

        @Override
        public byte nextByte() {
            return this.array[this.index++];
        }
    }

    private static class GenericIterator<T>
    extends ArrayIterator<T> {
        private final T[] array;

        private GenericIterator(T[] array) {
            super(array.length);
            this.array = array;
        }

        @Override
        public T next() {
            return this.array[this.index++];
        }
    }
}

