/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.Range;
import jet.ShortIterable;
import jet.ShortIterator;

public final class ShortRange
implements Range<Short>,
ShortIterable {
    private final short start;
    private final int count;
    public static final ShortRange empty = new ShortRange(0, 0);

    public ShortRange(short startValue, int count) {
        this.start = startValue;
        this.count = count;
    }

    public ShortIterator step(int step) {
        if (step < 0) {
            return new MyIterator(this.getEnd(), -this.count, -step);
        }
        return new MyIterator(this.start, this.count, step);
    }

    @Override
    public boolean contains(Short item) {
        if (item == null) {
            return false;
        }
        if (this.count >= 0) {
            return item >= this.start && item < this.start + this.count;
        }
        return item <= this.start && item > this.start + this.count;
    }

    public boolean getIsReversed() {
        return this.count < 0;
    }

    public short getStart() {
        return this.start;
    }

    public int getIteratorStart() {
        return this.count == 0 ? (short)1 : this.start;
    }

    public short getEnd() {
        return (short)(this.count < 0 ? this.start + this.count + 1 : (this.count == 0 ? 0 : this.start + this.count - 1));
    }

    public int getSize() {
        return this.count < 0 ? -this.count : this.count;
    }

    public ShortRange minus() {
        return new ShortRange(this.getEnd(), -this.count);
    }

    @Override
    public ShortIterator iterator() {
        return new MyIterator(this.start, this.count, 1);
    }

    public static ShortRange count(int length) {
        return new ShortRange(0, length);
    }

    private static class MyIterator
    extends ShortIterator {
        private short cur;
        private int step;
        private int count;
        private final boolean reversed;

        public MyIterator(short startValue, int count, int step) {
            this.cur = startValue;
            this.step = step;
            if (count < 0) {
                this.reversed = true;
                count = -count;
                startValue = (short)(startValue + count);
            } else {
                this.reversed = false;
            }
            this.count = count;
        }

        @Override
        public boolean getHasNext() {
            return this.count > 0;
        }

        @Override
        public short nextShort() {
            this.count -= this.step;
            if (this.reversed) {
                this.cur = (short)(this.cur - this.step);
                return (short)(this.cur + this.step);
            }
            this.cur = (short)(this.cur + this.step);
            return (short)(this.cur - this.step);
        }
    }
}

