/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.CharIterable;
import jet.CharIterator;
import jet.Range;

public final class CharRange
implements Range<Character>,
CharIterable {
    private final char start;
    private final int count;
    public static final CharRange empty = new CharRange('\u0000', 0);

    public CharRange(char startValue, int count) {
        this.start = startValue;
        this.count = count;
    }

    @Override
    public boolean contains(Character item) {
        if (item == null) {
            return false;
        }
        if (this.count >= 0) {
            return item.charValue() >= this.start && item.charValue() < this.start + this.count;
        }
        return item.charValue() <= this.start && item.charValue() > this.start + this.count;
    }

    public boolean getIsReversed() {
        return this.count < 0;
    }

    public char getStart() {
        return this.start;
    }

    public char getIteratorStart() {
        return this.count == 0 ? (char)'\u0001' : this.start;
    }

    public char getEnd() {
        return (char)(this.count < 0 ? this.start + this.count + 1 : (this.count == 0 ? 0 : this.start + this.count - 1));
    }

    public int getSize() {
        return this.count < 0 ? -this.count : this.count;
    }

    public CharRange minus() {
        return new CharRange(this.getEnd(), -this.count);
    }

    public CharIterator step(int step) {
        if (step < 0) {
            return new MyIterator(this.getEnd(), -this.count, -step);
        }
        return new MyIterator(this.start, this.count, step);
    }

    @Override
    public CharIterator iterator() {
        return new MyIterator(this.start, this.count, 1);
    }

    public static CharRange count(int length) {
        return new CharRange('\u0000', length);
    }

    private static class MyIterator
    extends CharIterator {
        private char cur;
        private int step;
        private int count;
        private final boolean reversed;

        public MyIterator(char startValue, int count, int step) {
            this.cur = startValue;
            this.step = step;
            if (count < 0) {
                this.reversed = true;
                count = -count;
                startValue = (char)(startValue + count);
            } else {
                this.reversed = false;
            }
            this.count = count;
        }

        @Override
        public boolean getHasNext() {
            return this.count > 0;
        }

        @Override
        public char nextChar() {
            this.count -= this.step;
            if (this.reversed) {
                this.cur = (char)(this.cur - this.step);
                return (char)(this.cur + this.step);
            }
            this.cur = (char)(this.cur + this.step);
            return (char)(this.cur - this.step);
        }
    }
}

