/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.ByteIterable;
import jet.ByteIterator;
import jet.Range;

public final class ByteRange
implements Range<Byte>,
ByteIterable {
    private final byte start;
    private final int count;
    public static final ByteRange empty = new ByteRange(0, 0);

    public ByteRange(byte startValue, int count) {
        this.start = startValue;
        this.count = count;
    }

    @Override
    public boolean contains(Byte item) {
        if (item == null) {
            return false;
        }
        if (this.count >= 0) {
            return item >= this.start && item < this.start + this.count;
        }
        return item <= this.start && item > this.start + this.count;
    }

    public boolean getIsReversed() {
        return this.count < 0;
    }

    public byte getStart() {
        return this.start;
    }

    public byte getIteratorStart() {
        return this.count == 0 ? (byte)1 : this.start;
    }

    public byte getEnd() {
        return (byte)(this.count < 0 ? this.start + this.count + 1 : (this.count == 0 ? 0 : this.start + this.count - 1));
    }

    public int getSize() {
        return this.count < 0 ? -this.count : this.count;
    }

    public ByteIterator step(int step) {
        if (step < 0) {
            return new MyIterator(this.getEnd(), -this.count, -step);
        }
        return new MyIterator(this.start, this.count, step);
    }

    public ByteRange minus() {
        return new ByteRange(this.getEnd(), -this.count);
    }

    @Override
    public ByteIterator iterator() {
        return new MyIterator(this.start, this.count, 1);
    }

    public static ByteRange count(int length) {
        return new ByteRange(0, length);
    }

    private static class MyIterator
    extends ByteIterator {
        private byte cur;
        private int step;
        private int count;
        private final boolean reversed;

        public MyIterator(byte startValue, int count, int step) {
            this.cur = startValue;
            this.step = step;
            if (count < 0) {
                this.reversed = true;
                count = -count;
                startValue = (byte)(startValue + count);
            } else {
                this.reversed = false;
            }
            this.count = count;
        }

        @Override
        public boolean getHasNext() {
            return this.count > 0;
        }

        @Override
        public byte nextByte() {
            this.count -= this.step;
            if (this.reversed) {
                this.cur = (byte)(this.cur - this.step);
                return (byte)(this.cur + this.step);
            }
            this.cur = (byte)(this.cur + this.step);
            return (byte)(this.cur - this.step);
        }
    }
}

