package org.jzy3d.plot3d.primitives;


import org.jzy3d.colors.IMultiColorable;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;


/** 
 * A composite implementation of a parallelepiped, meaning it can be decomposed into
 * distinct primitive for polygon ordering.
 */
public class CompositeParallelepiped extends AbstractComposite implements ISingleColorable, IMultiColorable{
	
	/** Initialize a parallelepiped.*/
	public CompositeParallelepiped(){
		super();
	}
	
	/** Initialize a parallelepiped.*/
	public CompositeParallelepiped(BoundingBox3d b){
		super();
		setData(b);	
	}
	
	/** Set the parallelepiped data.*/
	public void setData(BoundingBox3d box){
	    if(bbox==null)
	        bbox = box;
	    else{
    		bbox.reset();
    		bbox.add(box);
	    }
	    
		quads = new Polygon[6];
		
		quads[0] = getPolygon();
		quads[0].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmin(), bbox.getZmax()))); 
		quads[0].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmin(), bbox.getZmin()))); 
		quads[0].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmax(), bbox.getZmin()))); 
		quads[0].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmax(), bbox.getZmax()))); 
		
		quads[1] = getPolygon();
		quads[1].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmax(), bbox.getZmax()))); 
		quads[1].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmax(), bbox.getZmin()))); 
		quads[1].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmin(), bbox.getZmin()))); 
		quads[1].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmin(), bbox.getZmax()))); 

		quads[2] = getPolygon();
		quads[2].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmax(), bbox.getZmax()))); 
		quads[2].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmax(), bbox.getZmin()))); 
		quads[2].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmax(), bbox.getZmin()))); 
		quads[2].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmax(), bbox.getZmax()))); 

		quads[3] = getPolygon();
		quads[3].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmin(), bbox.getZmax()))); 
		quads[3].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmin(), bbox.getZmin()))); 
		quads[3].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmin(), bbox.getZmin()))); 
		quads[3].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmin(), bbox.getZmax()))); 

		quads[4] = getPolygon();
		quads[4].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmin(), bbox.getZmax()))); 
		quads[4].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmin(), bbox.getZmax()))); 
		quads[4].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmax(), bbox.getZmax()))); 
		quads[4].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmax(), bbox.getZmax()))); 

		quads[5] = getPolygon();
		quads[5].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmin(), bbox.getZmin()))); 
		quads[5].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmin(), bbox.getZmin()))); 
		quads[5].add(new Point(new Coord3d(bbox.getXmin(), bbox.getYmax(), bbox.getZmin()))); 
		quads[5].add(new Point(new Coord3d(bbox.getXmax(), bbox.getYmax(), bbox.getZmin()))); 
		
		for(Polygon p: quads)
		    add(p);
	}
	
	protected Polygon getPolygon(){
	    return new Polygon();
	}
	
	private Polygon quads[];
}
