/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.compiler.support;

import griffon.plugins.jzy3d.GriffonChart3D;
import org.codehaus.griffon.compiler.GriffonCompilerContext;
import org.codehaus.griffon.compiler.SourceUnitCollector;
import org.codehaus.griffon.compiler.support.GriffonArtifactASTTransformation;
import org.codehaus.griffon.compiler.support.GriffonChart3DASTInjector;
import org.codehaus.griffon.runtime.jzy3d.AbstractGriffonChart3D;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class GriffonChart3DASTTransformation
extends GriffonArtifactASTTransformation {
    private static final Logger LOG = LoggerFactory.getLogger(GriffonChart3DASTTransformation.class);
    private static final String ARTIFACT_PATH = "charts";
    private static final ClassNode GRIFFON_CHART3D_CLASS = ClassHelper.makeWithoutCaching(GriffonChart3D.class);
    private static final ClassNode ABSTRACT_GRIFFON_CHART3D_CLASS = ClassHelper.makeWithoutCaching(AbstractGriffonChart3D.class);

    public static boolean isChart3DArtifact(ClassNode classNode, SourceUnit source) {
        if (classNode == null || source == null) {
            return false;
        }
        return ARTIFACT_PATH.equals(GriffonCompilerContext.getArtifactPath((SourceUnit)source)) && classNode.getName().endsWith("Chart3D");
    }

    protected void transform(ClassNode classNode, SourceUnit source, String artifactPath) {
        if (!GriffonChart3DASTTransformation.isChart3DArtifact(classNode, source)) {
            return;
        }
        this.doTransform(classNode);
    }

    private void doTransform(ClassNode classNode) {
        ClassNode superClass = classNode.getSuperClass();
        if (ClassHelper.OBJECT_TYPE.equals((Object)superClass)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting " + ABSTRACT_GRIFFON_CHART3D_CLASS.getName() + " as the superclass of " + classNode.getName());
            }
            classNode.setSuperClass(ABSTRACT_GRIFFON_CHART3D_CLASS);
        } else if (!classNode.implementsInterface(GRIFFON_CHART3D_CLASS)) {
            this.inject(classNode, superClass);
        }
    }

    private void inject(ClassNode classNode, ClassNode superClass) {
        SourceUnit superSource = SourceUnitCollector.getInstance().getSourceUnit(superClass);
        if (GriffonChart3DASTTransformation.isChart3DArtifact(superClass, superSource)) {
            return;
        }
        if (superSource == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Injecting " + GRIFFON_CHART3D_CLASS.getName() + " behavior to " + classNode.getName());
            }
            classNode.addInterface(GRIFFON_CHART3D_CLASS);
            GriffonChart3DASTInjector injector = new GriffonChart3DASTInjector();
            injector.inject(classNode, "chart3d");
        } else {
            this.doTransform(superClass);
        }
    }
}

