/*
 * Decompiled with CFR 0.152.
 */
package com.grahamedgecombe.jterminal;

import com.grahamedgecombe.jterminal.TerminalCell;
import com.grahamedgecombe.jterminal.TerminalModel;
import com.grahamedgecombe.jterminal.vt100.Vt100TerminalModel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class JTerminal
extends JComponent {
    private static final long serialVersionUID = 2871625194146986567L;
    private JScrollBar scrollBar;
    private TerminalModel model;

    public JTerminal() {
        this(new Vt100TerminalModel());
    }

    public JTerminal(TerminalModel model) {
        this.setModel(model);
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 0));
        int rows = this.model.getRows();
        int bufferSize = this.model.getBufferSize();
        if (bufferSize > rows) {
            this.scrollBar = new JScrollBar(1, 0, rows, 0, bufferSize + 1);
            this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent evt) {
                    JTerminal.this.repaint();
                }
            });
            this.add("After", this.scrollBar);
        }
        this.add("Center", new Terminal());
        this.repaint();
    }

    public TerminalModel getModel() {
        return this.model;
    }

    public void setModel(TerminalModel model) {
        if (model == null) {
            throw new NullPointerException("model");
        }
        this.model = model;
    }

    public void println(String str) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        this.print(str.concat("\r\n"));
    }

    public void print(String str) {
        this.model.print(str);
    }

    private class Terminal
    extends JComponent {
        private static final int CELL_WIDTH = 8;
        private static final int CELL_HEIGHT = 12;
        private final Font font = new Font("Monospaced", 0, 12);
        private static final long serialVersionUID = 8832602559840777008L;

        private Terminal() {
            this.setDoubleBuffered(true);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(JTerminal.this.model.getColumns() * 8, JTerminal.this.model.getRows() * 12);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public void paint(Graphics g) {
            int start;
            g.setFont(this.font);
            int width = JTerminal.this.model.getColumns();
            int height = JTerminal.this.model.getBufferSize();
            g.setColor(JTerminal.this.model.getDefaultBackgroundColor());
            g.fillRect(0, 0, width * 8, height * 12);
            for (int y = start = JTerminal.this.scrollBar == null ? 0 : JTerminal.this.scrollBar.getValue(); y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    boolean cursorHere;
                    TerminalCell cell = JTerminal.this.model.getCell(x, y);
                    boolean bl = cursorHere = JTerminal.this.model.getCursorRow() == y && JTerminal.this.model.getCursorColumn() == x;
                    if (cursorHere && cell == null) {
                        cell = new TerminalCell(' ', JTerminal.this.model.getDefaultBackgroundColor(), JTerminal.this.model.getDefaultForegroundColor());
                    }
                    if (cell == null) continue;
                    int px = x * 8;
                    int py = (y - start) * 12;
                    g.setColor(cursorHere ? cell.getForegroundColor() : cell.getBackgroundColor());
                    g.fillRect(px, py, 8, 12);
                    g.setColor(cursorHere ? cell.getBackgroundColor() : cell.getForegroundColor());
                    g.drawChars(new char[]{cell.getCharacter()}, 0, 1, px, py + 12);
                }
            }
        }
    }
}

