/*
 * Decompiled with CFR 0.152.
 */
package com.grahamedgecombe.jterminal.vt100;

import com.grahamedgecombe.jterminal.AbstractTerminalModel;
import com.grahamedgecombe.jterminal.TerminalCell;
import com.grahamedgecombe.jterminal.bell.BellStrategy;
import com.grahamedgecombe.jterminal.bell.NopBellStrategy;
import com.grahamedgecombe.jterminal.vt100.AnsiControlSequence;
import com.grahamedgecombe.jterminal.vt100.AnsiControlSequenceListener;
import com.grahamedgecombe.jterminal.vt100.AnsiControlSequenceParser;
import com.grahamedgecombe.jterminal.vt100.SgrColor;
import java.awt.Color;

public class Vt100TerminalModel
extends AbstractTerminalModel {
    private static final int DEFAULT_COLUMNS = 80;
    private static final int DEFAULT_ROWS = 25;
    private static final int TAB_WIDTH = 8;
    private static final boolean DEFAULT_FOREGROUND_BOLD = false;
    private static final boolean DEFAULT_BACKGROUND_BOLD = false;
    private static final int DEFAULT_FOREGROUND_COLOR = 7;
    private static final int DEFAULT_BACKGROUND_COLOR = 0;
    private final AnsiControlSequenceListener listener = new Vt100Listener();
    private final AnsiControlSequenceParser parser = new AnsiControlSequenceParser(this.listener);
    private BellStrategy bellStrategy = new NopBellStrategy();
    private TerminalCell[][] cells;
    private int columns;
    private int rows;
    private int bufferSize;
    private int cursorRow = 0;
    private int cursorColumn = 0;
    private boolean foregroundBold = false;
    private boolean backgroundBold = false;
    private int foregroundColor = 7;
    private int backgroundColor = 0;

    public Vt100TerminalModel() {
        this(80, 25);
    }

    public Vt100TerminalModel(int columns, int rows) {
        this(columns, rows, rows);
    }

    public Vt100TerminalModel(int columns, int rows, int bufferSize) {
        if (columns < 0 || rows < 0 || bufferSize < 0) {
            throw new IllegalArgumentException("Zero or positive values only allowed for columns, rows and buffer size.");
        }
        if (bufferSize < rows) {
            throw new IllegalArgumentException("The buffer is too small");
        }
        this.columns = columns;
        this.rows = rows;
        this.bufferSize = bufferSize;
        this.init();
    }

    private void init() {
        this.cells = new TerminalCell[this.bufferSize][this.columns];
    }

    @Override
    public int getCursorRow() {
        return this.cursorRow;
    }

    @Override
    public void setCursorRow(int row) {
        if (row < 0 || row >= this.bufferSize) {
            throw new IllegalArgumentException("row out of range");
        }
        this.cursorRow = row;
    }

    @Override
    public int getCursorColumn() {
        return this.cursorColumn;
    }

    @Override
    public void setCursorColumn(int column) {
        if (column < 0 || column >= this.columns) {
            throw new IllegalArgumentException("column out of range");
        }
        this.cursorColumn = column;
    }

    @Override
    public TerminalCell getCell(int column, int row) {
        if (column < 0 || row < 0 || column >= this.columns || row >= this.bufferSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.cells[row][column];
    }

    @Override
    public void setCell(int column, int row, TerminalCell cell) {
        if (column < 0 || row < 0 || column >= this.columns || row >= this.bufferSize) {
            throw new IndexOutOfBoundsException();
        }
        this.cells[row][column] = cell;
    }

    @Override
    public void print(String str) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        this.parser.parse(str);
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public BellStrategy getBellStrategy() {
        return this.bellStrategy;
    }

    @Override
    public void setBellStrategy(BellStrategy strategy) {
        if (strategy == null) {
            throw new NullPointerException("strategy");
        }
        this.bellStrategy = strategy;
    }

    @Override
    public Color getDefaultBackgroundColor() {
        boolean bg = false;
        return SgrColor.COLOR_NORMAL[0];
    }

    @Override
    public Color getDefaultForegroundColor() {
        int fg = 7;
        return SgrColor.COLOR_NORMAL[7];
    }

    private class Vt100Listener
    implements AnsiControlSequenceListener {
        private int savedCursorRow = -1;
        private int savedCursorColumn = -1;

        private Vt100Listener() {
        }

        @Override
        public void parsedControlSequence(AnsiControlSequence seq) {
            char command = seq.getCommand();
            String[] parameters = seq.getParameters();
            switch (command) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': {
                    int n = 1;
                    if (parameters.length == 1) {
                        n = Integer.parseInt(parameters[0]);
                    }
                    if (command == 'A') {
                        Vt100TerminalModel.this.moveCursorUp(n);
                        break;
                    }
                    if (command == 'B') {
                        Vt100TerminalModel.this.moveCursorDown(n);
                        break;
                    }
                    if (command == 'C') {
                        Vt100TerminalModel.this.moveCursorForward(n);
                        break;
                    }
                    if (command != 'D') break;
                    Vt100TerminalModel.this.moveCursorBack(n);
                    break;
                }
                case 'E': 
                case 'F': {
                    int n = 1;
                    if (parameters.length == 1) {
                        n = Integer.parseInt(parameters[0]);
                    }
                    if (command == 'E') {
                        Vt100TerminalModel.this.moveCursorDown(n);
                    } else if (command == 'F') {
                        Vt100TerminalModel.this.moveCursorUp(n);
                    }
                    Vt100TerminalModel.this.setCursorColumn(0);
                    break;
                }
                case 'G': {
                    if (parameters.length != 1) break;
                    int n = Integer.parseInt(parameters[0]);
                    Vt100TerminalModel.this.setCursorColumn(n - 1);
                    break;
                }
                case 'H': 
                case 'f': {
                    if (parameters.length != 2) break;
                    int n = 1;
                    int m = 1;
                    if (parameters[0].length() > 0) {
                        n = Integer.parseInt(parameters[0]);
                    }
                    if (parameters[1].length() > 0) {
                        m = Integer.parseInt(parameters[1]);
                    }
                    Vt100TerminalModel.this.setCursorRow(n - 1);
                    Vt100TerminalModel.this.setCursorColumn(m - 1);
                    break;
                }
                case 'J': {
                    int n = 0;
                    if (parameters.length == 1) {
                        n = Integer.parseInt(parameters[0]);
                    }
                    if (n == 0) {
                        int column = Vt100TerminalModel.this.cursorColumn;
                        for (int row = Vt100TerminalModel.this.cursorRow; row < Vt100TerminalModel.this.rows; ++row) {
                            while (column < Vt100TerminalModel.this.columns) {
                                ((Vt100TerminalModel)Vt100TerminalModel.this).cells[row][column] = null;
                                ++column;
                            }
                            column = 0;
                        }
                        break;
                    }
                    if (n == 1) {
                        int column = Vt100TerminalModel.this.cursorColumn;
                        for (int row = Vt100TerminalModel.this.cursorRow; row >= 0; --row) {
                            while (column >= 0) {
                                ((Vt100TerminalModel)Vt100TerminalModel.this).cells[row][column] = null;
                                --column;
                            }
                            column = Vt100TerminalModel.this.columns - 1;
                        }
                        break;
                    }
                    if (n != 2) break;
                    Vt100TerminalModel.this.clear();
                    break;
                }
                case 'K': {
                    int n = 0;
                    if (parameters.length == 1) {
                        n = Integer.parseInt(parameters[0]);
                    }
                    if (n == 0) {
                        for (int row = Vt100TerminalModel.this.cursorRow; row < Vt100TerminalModel.this.rows; ++row) {
                            ((Vt100TerminalModel)Vt100TerminalModel.this).cells[row][((Vt100TerminalModel)Vt100TerminalModel.this).cursorColumn] = null;
                        }
                    } else if (n == 1) {
                        for (int row = Vt100TerminalModel.this.cursorRow; row >= 0; --row) {
                            ((Vt100TerminalModel)Vt100TerminalModel.this).cells[row][((Vt100TerminalModel)Vt100TerminalModel.this).cursorColumn] = null;
                        }
                    } else {
                        if (n != 2) break;
                        for (int column = 0; column < Vt100TerminalModel.this.columns; ++column) {
                            ((Vt100TerminalModel)Vt100TerminalModel.this).cells[((Vt100TerminalModel)Vt100TerminalModel.this).cursorRow][column] = null;
                        }
                    }
                    break;
                }
                case 'm': {
                    if (parameters.length == 0) {
                        parameters = new String[]{"0"};
                    }
                    for (String parameter : parameters) {
                        if (parameter.equals("0")) {
                            Vt100TerminalModel.this.foregroundColor = 7;
                            Vt100TerminalModel.this.backgroundColor = 0;
                            Vt100TerminalModel.this.backgroundBold = false;
                            Vt100TerminalModel.this.foregroundBold = false;
                            continue;
                        }
                        if (parameter.equals("2")) {
                            Vt100TerminalModel.this.backgroundBold = true;
                            Vt100TerminalModel.this.foregroundBold = true;
                            continue;
                        }
                        if (parameter.equals("22")) {
                            Vt100TerminalModel.this.backgroundBold = false;
                            Vt100TerminalModel.this.foregroundBold = false;
                            continue;
                        }
                        if (!parameter.startsWith("3") && !parameter.startsWith("4") || parameter.length() != 2) continue;
                        int color = Integer.parseInt(parameter.substring(1));
                        if (parameter.startsWith("3")) {
                            Vt100TerminalModel.this.foregroundColor = color;
                            continue;
                        }
                        if (!parameter.startsWith("4")) continue;
                        Vt100TerminalModel.this.backgroundColor = color;
                    }
                    break;
                }
                case 'u': {
                    if (this.savedCursorColumn == -1 || this.savedCursorRow == -1) break;
                    Vt100TerminalModel.this.cursorColumn = this.savedCursorColumn;
                    Vt100TerminalModel.this.cursorRow = this.savedCursorRow;
                    break;
                }
                case 's': {
                    this.savedCursorColumn = Vt100TerminalModel.this.cursorColumn;
                    this.savedCursorRow = Vt100TerminalModel.this.cursorRow;
                }
            }
        }

        @Override
        public void parsedString(String str) {
            block8: for (char ch : str.toCharArray()) {
                switch (ch) {
                    case '\u0000': {
                        continue block8;
                    }
                    case '\r': {
                        Vt100TerminalModel.this.cursorColumn = 0;
                        continue block8;
                    }
                    case '\n': {
                        Vt100TerminalModel.this.cursorColumn = 0;
                        Vt100TerminalModel.this.cursorRow++;
                        continue block8;
                    }
                    case '\t': {
                        while (++Vt100TerminalModel.this.cursorColumn % 8 != 0) {
                        }
                        continue block8;
                    }
                    case '\u007f': {
                        if (Vt100TerminalModel.this.cursorColumn <= 0) continue block8;
                        ((Vt100TerminalModel)Vt100TerminalModel.this).cells[((Vt100TerminalModel)Vt100TerminalModel.this).cursorRow][--((Vt100TerminalModel)Vt100TerminalModel.this).cursorColumn] = null;
                        continue block8;
                    }
                    case '\u0007': {
                        Vt100TerminalModel.this.bellStrategy.soundBell();
                        continue block8;
                    }
                    default: {
                        if (Vt100TerminalModel.this.cursorColumn >= Vt100TerminalModel.this.columns) {
                            Vt100TerminalModel.this.cursorColumn = 0;
                            Vt100TerminalModel.this.cursorRow++;
                        }
                        if (Vt100TerminalModel.this.cursorRow >= Vt100TerminalModel.this.bufferSize) {
                            int i;
                            for (i = 1; i < Vt100TerminalModel.this.bufferSize; ++i) {
                                System.arraycopy(Vt100TerminalModel.this.cells[i], 0, Vt100TerminalModel.this.cells[i - 1], 0, Vt100TerminalModel.this.columns);
                            }
                            for (i = 0; i < Vt100TerminalModel.this.columns; ++i) {
                                ((Vt100TerminalModel)Vt100TerminalModel.this).cells[((Vt100TerminalModel)Vt100TerminalModel.this).bufferSize - 1][i] = null;
                            }
                            Vt100TerminalModel.this.cursorRow--;
                        }
                        Color back = Vt100TerminalModel.this.backgroundBold ? SgrColor.COLOR_BRIGHT[Vt100TerminalModel.this.backgroundColor] : SgrColor.COLOR_NORMAL[Vt100TerminalModel.this.backgroundColor];
                        Color fore = Vt100TerminalModel.this.foregroundBold ? SgrColor.COLOR_BRIGHT[Vt100TerminalModel.this.foregroundColor] : SgrColor.COLOR_NORMAL[Vt100TerminalModel.this.foregroundColor];
                        ((Vt100TerminalModel)Vt100TerminalModel.this).cells[((Vt100TerminalModel)Vt100TerminalModel.this).cursorRow][((Vt100TerminalModel)Vt100TerminalModel.this).cursorColumn++] = new TerminalCell(ch, back, fore);
                    }
                }
            }
        }
    }
}

