/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.ast;

import griffon.plugins.jpa.DefaultJpaProvider;
import griffon.plugins.jpa.JpaAware;
import griffon.plugins.jpa.JpaContributionHandler;
import griffon.plugins.jpa.JpaProvider;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.core.handlers.JpaAwareConstants;
import org.codehaus.griffon.ast.AbstractASTTransformation;
import org.codehaus.griffon.ast.GriffonASTUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class JpaAwareASTTransformation
extends AbstractASTTransformation
implements JpaAwareConstants {
    private static final Logger LOG = LoggerFactory.getLogger(JpaAwareASTTransformation.class);
    private static final ClassNode JPA_CONTRIBUTION_HANDLER_CNODE = JpaAwareASTTransformation.makeClassSafe(JpaContributionHandler.class);
    private static final ClassNode JPA_AWARE_CNODE = JpaAwareASTTransformation.makeClassSafe(JpaAware.class);
    private static final ClassNode JPA_PROVIDER_CNODE = JpaAwareASTTransformation.makeClassSafe(JpaProvider.class);
    private static final ClassNode DEFAULT_JPA_PROVIDER_CNODE = JpaAwareASTTransformation.makeClassSafe(DefaultJpaProvider.class);
    private static final String[] DELEGATING_METHODS = new String[]{"withJpa"};

    public static boolean hasJpaAwareAnnotation(AnnotatedNode node) {
        for (AnnotationNode annotation : node.getAnnotations()) {
            if (!JPA_AWARE_CNODE.equals((Object)annotation.getClassNode())) continue;
            return true;
        }
        return false;
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.checkNodesForAnnotationAndType(nodes[0], nodes[1]);
        JpaAwareASTTransformation.addJpaContributionIfNeeded(source, (ClassNode)nodes[1]);
    }

    public static void addJpaContributionIfNeeded(SourceUnit source, ClassNode classNode) {
        if (JpaAwareASTTransformation.needsJpaContribution(classNode, source)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Injecting " + JpaContributionHandler.class.getName() + " into " + classNode.getName());
            }
            JpaAwareASTTransformation.apply(classNode);
        }
    }

    protected static boolean needsJpaContribution(ClassNode declaringClass, SourceUnit sourceUnit) {
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        boolean found4 = false;
        for (ClassNode consideredClass = declaringClass; consideredClass != null; consideredClass = consideredClass.getSuperClass()) {
            for (MethodNode method : consideredClass.getMethods()) {
                found1 = method.getName().equals("withJpa") && method.getParameters().length == 1;
                found2 = method.getName().equals("withJpa") && method.getParameters().length == 2;
                found3 = method.getName().equals("setJpaProvider") && method.getParameters().length == 1;
                boolean bl = found4 = method.getName().equals("getJpaProvider") && method.getParameters().length == 0;
                if (!found1 || !found2 || !found3 || !found4) continue;
                return false;
            }
        }
        if (found1 || found2 || found3 || found4) {
            sourceUnit.getErrorCollector().addErrorAndContinue((Message)new SimpleMessage("@JpaAware cannot be processed on " + declaringClass.getName() + " because some but not all of methods from " + JpaContributionHandler.class.getName() + " were declared in the current class or super classes.", (ProcessingUnit)sourceUnit));
            return false;
        }
        return true;
    }

    public static void apply(ClassNode declaringClass) {
        GriffonASTUtils.injectInterface((ClassNode)declaringClass, (ClassNode)JPA_CONTRIBUTION_HANDLER_CNODE);
        FieldNode providerField = declaringClass.addField("this$jpaProvider", 4098, JPA_PROVIDER_CNODE, JpaAwareASTTransformation.defaultJpaProviderInstance());
        GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)new MethodNode("getJpaProvider", 1, JPA_PROVIDER_CNODE, Parameter.EMPTY_ARRAY, GriffonASTUtils.NO_EXCEPTIONS, GriffonASTUtils.returns((Expression)GriffonASTUtils.field((FieldNode)providerField))));
        GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)new MethodNode("setJpaProvider", 1, ClassHelper.VOID_TYPE, GriffonASTUtils.params((Parameter[])new Parameter[]{GriffonASTUtils.param((ClassNode)JPA_PROVIDER_CNODE, (String)"provider")}), GriffonASTUtils.NO_EXCEPTIONS, (Statement)GriffonASTUtils.block((Statement[])new Statement[]{GriffonASTUtils.ifs_no_return((Expression)GriffonASTUtils.cmp((Expression)GriffonASTUtils.var((String)"provider"), (Expression)ConstantExpression.NULL), (Statement)GriffonASTUtils.assigns((Expression)GriffonASTUtils.field((FieldNode)providerField), (Expression)JpaAwareASTTransformation.defaultJpaProviderInstance()), (Statement)GriffonASTUtils.assigns((Expression)GriffonASTUtils.field((FieldNode)providerField), (Expression)GriffonASTUtils.var((String)"provider")))})));
        for (MethodNode method : JPA_CONTRIBUTION_HANDLER_CNODE.getMethods()) {
            if (Arrays.binarySearch(DELEGATING_METHODS, method.getName()) < 0) continue;
            ArrayList<VariableExpression> variables = new ArrayList<VariableExpression>();
            Parameter[] parameters = new Parameter[method.getParameters().length];
            for (int i = 0; i < method.getParameters().length; ++i) {
                Parameter p = method.getParameters()[i];
                parameters[i] = new Parameter(JpaAwareASTTransformation.makeClassSafe((ClassNode)p.getType()), p.getName());
                parameters[i].getType().setGenericsTypes(p.getType().getGenericsTypes());
                variables.add(GriffonASTUtils.var((String)p.getName()));
            }
            ClassNode returnType = JpaAwareASTTransformation.makeClassSafe((ClassNode)method.getReturnType());
            returnType.setGenericsTypes(method.getReturnType().getGenericsTypes());
            returnType.setGenericsPlaceHolder(method.getReturnType().isGenericsPlaceHolder());
            MethodNode newMethod = new MethodNode(method.getName(), 1, returnType, parameters, GriffonASTUtils.NO_EXCEPTIONS, GriffonASTUtils.returns((Expression)GriffonASTUtils.call((Expression)GriffonASTUtils.field((FieldNode)providerField), (String)method.getName(), (ArgumentListExpression)GriffonASTUtils.args(variables))));
            newMethod.setGenericsTypes(method.getGenericsTypes());
            GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)newMethod);
        }
    }

    private static Expression defaultJpaProviderInstance() {
        return GriffonASTUtils.call((ClassNode)DEFAULT_JPA_PROVIDER_CNODE, (String)"getInstance", (ArgumentListExpression)GriffonASTUtils.NO_ARGS);
    }

    static {
        Arrays.sort(DELEGATING_METHODS);
    }
}

