/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.jpa;

import griffon.plugins.jpa.JpaProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJpaProvider
implements JpaProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJpaProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withJpa(Closure<R> closure) {
        return this.withJpa(DEFAULT, closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R withJpa(String persistenceUnit, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)persistenceUnit)) {
            persistenceUnit = DEFAULT;
        }
        if (closure != null) {
            try (EntityManager em = this.getEntityManager(persistenceUnit);){
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Executing statement on persistenceUnit '" + persistenceUnit + "'");
                }
                Object object = closure.call(new Object[]{persistenceUnit, em});
                return (R)object;
            }
        }
        return null;
    }

    @Override
    public <R> R withJpa(CallableWithArgs<R> callable) {
        return this.withJpa(DEFAULT, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R withJpa(String persistenceUnit, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)persistenceUnit)) {
            persistenceUnit = DEFAULT;
        }
        if (callable != null) {
            try (EntityManager em = this.getEntityManager(persistenceUnit);){
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Executing statement on persistenceUnit '" + persistenceUnit + "'");
                }
                callable.setArgs(new Object[]{persistenceUnit, em});
                Object object = callable.call();
                return (R)object;
            }
        }
        return null;
    }

    protected abstract EntityManager getEntityManager(String var1);
}

