/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.impl.awt;

import com.jogamp.newt.Window;
import java.awt.Canvas;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.awt.AWTGraphicsConfiguration;
import javax.media.nativewindow.awt.AWTGraphicsDevice;
import javax.media.nativewindow.awt.AWTGraphicsScreen;

public class AWTCanvas
extends Canvas {
    private GraphicsDevice device;
    private GraphicsConfiguration chosen;
    private AWTGraphicsConfiguration awtConfig;
    private CapabilitiesChooser chooser = null;
    private CapabilitiesImmutable capabilities;
    private boolean displayConfigChanged = false;
    private static boolean disableBackgroundEraseInitialized;
    private static Method disableBackgroundEraseMethod;
    static /* synthetic */ Class class$java$awt$Canvas;

    public AWTCanvas(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesChooser capabilitiesChooser) {
        if (null == capabilitiesImmutable) {
            throw new NativeWindowException("Capabilities null");
        }
        this.capabilities = capabilitiesImmutable;
        this.chooser = capabilitiesChooser;
    }

    public AWTGraphicsConfiguration getAWTGraphicsConfiguration() {
        return this.awtConfig;
    }

    public boolean hasDeviceChanged() {
        boolean bl = this.displayConfigChanged;
        this.displayConfigChanged = false;
        return bl;
    }

    public void addNotify() {
        super.addNotify();
        this.disableBackgroundErase();
        GraphicsConfiguration graphicsConfiguration = super.getGraphicsConfiguration();
        if (null != graphicsConfiguration) {
            this.device = graphicsConfiguration.getDevice();
        }
        this.awtConfig = AWTCanvas.chooseGraphicsConfiguration(this.capabilities, this.capabilities, this.chooser, this.device);
        if (Window.DEBUG_IMPLEMENTATION) {
            Exception exception = new Exception("Info: Created Config: " + this.awtConfig);
            exception.printStackTrace();
        }
        if (null != this.awtConfig) {
            this.chosen = this.awtConfig.getGraphicsConfiguration();
        }
        if (null == this.awtConfig) {
            throw new NativeWindowException("Error: AWTGraphicsConfiguration is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        try {
            this.dispose();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.removeNotify();
            throw throwable;
        }
        super.removeNotify();
    }

    private void dispose() {
        if (null != this.awtConfig) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.awtConfig.getNativeGraphicsConfiguration().getScreen().getDevice();
            String string = null;
            if (Window.DEBUG_IMPLEMENTATION) {
                string = abstractGraphicsDevice.toString();
            }
            boolean bl = abstractGraphicsDevice.close();
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("AWTCanvas.dispose(): closed GraphicsDevice: " + string + ", result: " + bl);
            }
        }
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = super.getGraphicsConfiguration();
        if (graphicsConfiguration != null && this.chosen != null && !this.chosen.equals(graphicsConfiguration)) {
            if (!this.chosen.getDevice().getIDstring().equals(graphicsConfiguration.getDevice().getIDstring())) {
                GraphicsConfiguration graphicsConfiguration2;
                AWTGraphicsConfiguration aWTGraphicsConfiguration = AWTCanvas.chooseGraphicsConfiguration(this.awtConfig.getChosenCapabilities(), this.awtConfig.getRequestedCapabilities(), this.chooser, graphicsConfiguration.getDevice());
                GraphicsConfiguration graphicsConfiguration3 = graphicsConfiguration2 = null != aWTGraphicsConfiguration ? aWTGraphicsConfiguration.getGraphicsConfiguration() : null;
                if (Window.DEBUG_IMPLEMENTATION) {
                    Exception exception = new Exception("Info: Call Stack: " + Thread.currentThread().getName());
                    exception.printStackTrace();
                    System.err.println("!!! Created Config (n): HAVE    GC " + this.chosen);
                    System.err.println("!!! Created Config (n): THIS    GC " + graphicsConfiguration);
                    System.err.println("!!! Created Config (n): Choosen GC " + graphicsConfiguration2);
                    System.err.println("!!! Created Config (n): HAVE    CF " + this.awtConfig);
                    System.err.println("!!! Created Config (n): Choosen CF " + aWTGraphicsConfiguration);
                    System.err.println("!!! Created Config (n): EQUALS CAPS " + aWTGraphicsConfiguration.getChosenCapabilities().equals(this.awtConfig.getChosenCapabilities()));
                }
                if (graphicsConfiguration2 != null) {
                    this.chosen = graphicsConfiguration2;
                    if (!aWTGraphicsConfiguration.getChosenCapabilities().equals(this.awtConfig.getChosenCapabilities())) {
                        this.displayConfigChanged = true;
                    }
                    this.awtConfig = aWTGraphicsConfiguration;
                }
            }
            return this.chosen;
        }
        if (graphicsConfiguration == null) {
            return this.chosen;
        }
        return graphicsConfiguration;
    }

    private static AWTGraphicsConfiguration chooseGraphicsConfiguration(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, GraphicsDevice graphicsDevice) {
        AbstractGraphicsScreen abstractGraphicsScreen = AWTGraphicsScreen.createScreenDevice((GraphicsDevice)graphicsDevice, (int)0);
        AWTGraphicsConfiguration aWTGraphicsConfiguration = (AWTGraphicsConfiguration)GraphicsConfigurationFactory.getFactory((Class)AWTGraphicsDevice.class).chooseGraphicsConfiguration(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, abstractGraphicsScreen);
        if (aWTGraphicsConfiguration == null) {
            throw new NativeWindowException("Error: Couldn't fetch AWTGraphicsConfiguration");
        }
        return aWTGraphicsConfiguration;
    }

    private void disableBackgroundErase() {
        if (!disableBackgroundEraseInitialized) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            Class<?> clazz = AWTCanvas.this.getToolkit().getClass();
                            while (clazz != null && disableBackgroundEraseMethod == null) {
                                try {
                                    disableBackgroundEraseMethod = clazz.getDeclaredMethod("disableBackgroundErase", class$java$awt$Canvas == null ? AWTCanvas.class$("java.awt.Canvas") : class$java$awt$Canvas);
                                    disableBackgroundEraseMethod.setAccessible(true);
                                }
                                catch (Exception exception) {
                                    clazz = clazz.getSuperclass();
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            disableBackgroundEraseInitialized = true;
        }
        if (disableBackgroundEraseMethod != null) {
            try {
                disableBackgroundEraseMethod.invoke((Object)this.getToolkit(), this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

