/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.impl;

import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.event.NEWTEventConsumer;
import com.jogamp.newt.event.ScreenModeListener;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.newt.impl.Debug;
import com.jogamp.newt.impl.DisplayImpl;
import com.jogamp.newt.impl.OffscreenWindow;
import com.jogamp.newt.impl.ScreenImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.SurfaceUpdatedListener;
import javax.media.nativewindow.util.DimensionReadOnly;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.util.Rectangle;

public abstract class WindowImpl
implements Window,
NEWTEventConsumer {
    public static final boolean DEBUG_TEST_REPARENT_INCOMPATIBLE = Debug.isPropertyDefined("newt.test.Window.reparent.incompatible", true);
    private RecursiveLock windowLock = new RecursiveLock();
    private long windowHandle;
    private ScreenImpl screen;
    private boolean screenReferenceAdded = false;
    private NativeWindow parentWindow;
    private long parentWindowHandle;
    protected AbstractGraphicsConfiguration config;
    protected CapabilitiesImmutable capsRequested;
    protected CapabilitiesChooser capabilitiesChooser = null;
    protected boolean fullscreen;
    protected boolean visible;
    protected boolean hasFocus;
    protected int width;
    protected int height;
    protected int x;
    protected int y;
    protected int nfs_width;
    protected int nfs_height;
    protected int nfs_x;
    protected int nfs_y;
    protected String title = "Newt Window";
    protected boolean undecorated = false;
    private LifecycleHook lifecycleHook = null;
    private DestroyAction destroyAction = new DestroyAction();
    private boolean handleDestroyNotify = true;
    private ReparentActionRecreate reparentActionRecreate = new ReparentActionRecreate();
    private RequestFocusAction requestFocusAction = new RequestFocusAction();
    private Window.FocusRunnable focusAction = null;
    private Object surfaceUpdatedListenersLock = new Object();
    private ArrayList surfaceUpdatedListeners;
    private Object childWindowsLock = new Object();
    private ArrayList childWindows;
    private ArrayList mouseListeners;
    private int mouseButtonPressed;
    private long lastMousePressed;
    private int lastMouseClickCount;
    private ArrayList keyListeners;
    private ArrayList windowListeners;
    private boolean repaintQueued = false;
    ScreenModeListenerImpl screenModeListenerImpl = new ScreenModeListenerImpl();

    private void initializeStates() {
        this.invalidate(true);
        this.childWindows = new ArrayList();
        this.surfaceUpdatedListeners = new ArrayList();
        this.windowListeners = new ArrayList();
        this.mouseListeners = new ArrayList();
        this.mouseButtonPressed = 0;
        this.lastMousePressed = 0L;
        this.lastMouseClickCount = 0;
        this.keyListeners = new ArrayList();
    }

    public static void init(String string) {
        if ("MacOSX".equals(string)) {
            try {
                WindowImpl.getWindowClass(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static Class getWindowClass(String string) throws ClassNotFoundException {
        Class<?> clazz = NewtFactory.getCustomClass(string, "Window");
        if (null == clazz) {
            if ("EGL".equals(string)) {
                clazz = Class.forName("com.jogamp.newt.impl.opengl.kd.KDWindow");
            } else if ("Windows".equals(string)) {
                clazz = Class.forName("com.jogamp.newt.impl.windows.WindowsWindow");
            } else if ("MacOSX".equals(string)) {
                clazz = Class.forName("com.jogamp.newt.impl.macosx.MacWindow");
            } else if ("X11".equals(string)) {
                clazz = Class.forName("com.jogamp.newt.impl.x11.X11Window");
            } else if ("AWT".equals(string)) {
                clazz = Class.forName("com.jogamp.newt.impl.awt.AWTWindow");
            } else {
                throw new NativeWindowException("Unknown window type \"" + string + "\"");
            }
        }
        return clazz;
    }

    public static WindowImpl create(NativeWindow nativeWindow, long l, Screen screen, CapabilitiesImmutable capabilitiesImmutable) {
        try {
            Class clazz = capabilitiesImmutable.isOnscreen() ? WindowImpl.getWindowClass(screen.getDisplay().getType()) : OffscreenWindow.class;
            WindowImpl windowImpl = (WindowImpl)clazz.newInstance();
            windowImpl.initializeStates();
            windowImpl.parentWindow = nativeWindow;
            windowImpl.parentWindowHandle = l;
            windowImpl.screen = (ScreenImpl)screen;
            windowImpl.capsRequested = (CapabilitiesImmutable)capabilitiesImmutable.cloneMutable();
            windowImpl.setUndecorated(0L != l);
            return windowImpl;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new NativeWindowException(throwable);
        }
    }

    public static WindowImpl create(Object[] objectArray, Screen screen, CapabilitiesImmutable capabilitiesImmutable) {
        try {
            Class clazz = WindowImpl.getWindowClass(screen.getDisplay().getType());
            Class[] classArray = WindowImpl.getCustomConstructorArgumentTypes(clazz);
            if (null == classArray) {
                throw new NativeWindowException("WindowClass " + clazz + " doesn't support custom arguments in constructor");
            }
            int n = WindowImpl.verifyConstructorArgumentTypes(classArray, objectArray);
            if (n < objectArray.length) {
                throw new NativeWindowException("WindowClass " + clazz + " constructor mismatch at argument #" + n + "; Constructor: " + WindowImpl.getTypeStrList(classArray) + ", arguments: " + WindowImpl.getArgsStrList(objectArray));
            }
            WindowImpl windowImpl = (WindowImpl)ReflectionUtil.createInstance((Class)clazz, (Class[])classArray, (Object[])objectArray);
            windowImpl.initializeStates();
            windowImpl.screen = (ScreenImpl)screen;
            windowImpl.capsRequested = (CapabilitiesImmutable)capabilitiesImmutable.cloneMutable();
            return windowImpl;
        }
        catch (Throwable throwable) {
            throw new NativeWindowException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createNative() {
        block7: {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.createNative() START (" + WindowImpl.getThreadName() + ", " + this + ")");
            }
            if (null != this.parentWindow && 1 >= this.parentWindow.lockSurface()) {
                throw new NativeWindowException("Parent surface lock: not ready: " + this.parentWindow);
            }
            try {
                if (this.validateParentWindowHandle()) {
                    if (this.screenReferenceAdded) {
                        throw new InternalError("XXX");
                    }
                    this.screen.addReference();
                    this.screenReferenceAdded = true;
                    this.createNativeImpl();
                    this.setVisibleImpl(true, this.x, this.y, this.width, this.height);
                    this.screen.addScreenModeListener(this.screenModeListenerImpl);
                    this.setTitleImpl(this.title);
                }
                Object var2_1 = null;
                if (null == this.parentWindow) break block7;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (null == this.parentWindow) throw throwable;
                this.parentWindow.unlockSurface();
                throw throwable;
            }
            this.parentWindow.unlockSurface();
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.createNative() END (" + WindowImpl.getThreadName() + ", " + this + ")");
        }
        if (0L == this.windowHandle) return false;
        return true;
    }

    private void removeScreenReference() {
        if (this.screenReferenceAdded) {
            this.screenReferenceAdded = false;
            this.screen.removeReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndInvalidate() {
        this.windowLock.lock();
        try {
            if (null != this.screen) {
                Display display;
                if (0L != this.windowHandle) {
                    this.screen.removeScreenModeListener(this.screenModeListenerImpl);
                    this.closeNativeImpl();
                    this.removeScreenReference();
                }
                if (null != (display = this.screen.getDisplay())) {
                    display.validateEDT();
                }
            }
            this.invalidate(false);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.windowLock.unlock();
            throw throwable;
        }
        this.windowLock.unlock();
    }

    private boolean validateParentWindowHandle() {
        if (null != this.parentWindow) {
            this.parentWindowHandle = WindowImpl.getNativeWindowHandle(this.parentWindow);
            return 0L != this.parentWindowHandle;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getNativeWindowHandle(NativeWindow nativeWindow) {
        long l = 0L;
        if (null != nativeWindow) {
            boolean bl;
            block10: {
                bl = false;
                if (1 < nativeWindow.lockSurface()) {
                    bl = true;
                    try {
                        try {
                            l = nativeWindow.getWindowHandle();
                            if (0L == l) {
                                throw new NativeWindowException("Parent native window handle is NULL, after succesful locking: " + nativeWindow);
                            }
                            Object var6_3 = null;
                        }
                        catch (NativeWindowException nativeWindowException) {
                            if (DEBUG_IMPLEMENTATION) {
                                System.err.println("Window.getNativeWindowHandle: not successful yet: " + (Object)((Object)nativeWindowException));
                            }
                            Object var6_4 = null;
                            nativeWindow.unlockSurface();
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        nativeWindow.unlockSurface();
                        throw throwable;
                    }
                    nativeWindow.unlockSurface();
                }
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.getNativeWindowHandle: locked " + bl + ", " + nativeWindow);
            }
        }
        return l;
    }

    protected int lockSurfaceImpl() {
        return 3;
    }

    protected void unlockSurfaceImpl() {
    }

    protected abstract void createNativeImpl();

    protected abstract void closeNativeImpl();

    protected abstract void requestFocusImpl(boolean var1);

    protected abstract void setVisibleImpl(boolean var1, int var2, int var3, int var4, int var5);

    protected abstract boolean reconfigureWindowImpl(int var1, int var2, int var3, int var4, boolean var5, int var6, int var7);

    protected void setTitleImpl(String string) {
    }

    protected abstract Point getLocationOnScreenImpl(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int lockSurface() {
        int n;
        block5: {
            n = 1;
            this.windowLock.lock();
            if (this.isNativeValid()) {
                AbstractGraphicsDevice abstractGraphicsDevice = this.screen.getDisplay().getGraphicsDevice();
                abstractGraphicsDevice.lock();
                try {
                    n = this.lockSurfaceImpl();
                    Object var4_3 = null;
                    if (1 != n) break block5;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (1 == n) {
                        abstractGraphicsDevice.unlock();
                    }
                    throw throwable;
                }
                abstractGraphicsDevice.unlock();
            }
        }
        if (1 == n) {
            this.windowLock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unlockSurface() {
        this.windowLock.validateLocked();
        AbstractGraphicsDevice abstractGraphicsDevice = this.screen.getDisplay().getGraphicsDevice();
        try {
            this.unlockSurfaceImpl();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            abstractGraphicsDevice.unlock();
            throw throwable;
        }
        abstractGraphicsDevice.unlock();
        this.windowLock.unlock();
    }

    public final boolean isSurfaceLockedByOtherThread() {
        return this.windowLock.isLockedByOtherThread();
    }

    public final boolean isSurfaceLocked() {
        return this.windowLock.isLocked();
    }

    public final Thread getSurfaceLockOwner() {
        return this.windowLock.getOwner();
    }

    public long getSurfaceHandle() {
        return this.windowHandle;
    }

    public boolean surfaceSwap() {
        return false;
    }

    public AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config;
    }

    public final long getDisplayHandle() {
        return this.getScreen().getDisplay().getHandle();
    }

    public final int getScreenIndex() {
        return this.getScreen().getIndex();
    }

    public final NativeWindow getParent() {
        return this.parentWindow;
    }

    public final long getWindowHandle() {
        return this.windowHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocationOnScreen(Point point) {
        if (this.isNativeValid()) {
            Point point2;
            this.windowLock.lock();
            try {
                point2 = this.getLocationOnScreenImpl(0, 0);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.windowLock.unlock();
                throw throwable;
            }
            this.windowLock.unlock();
            if (null != point2) {
                if (null != point) {
                    point.translate(point2.getX(), point2.getY());
                    return point;
                }
                return point2;
            }
        }
        if (null != point) {
            point.translate(this.getX(), this.getY());
        } else {
            point = new Point(this.getX(), this.getY());
        }
        if (null != this.parentWindow) {
            this.parentWindow.getLocationOnScreen(point);
        }
        return point;
    }

    public final boolean isNativeValid() {
        return null != this.getScreen() && 0L != this.getWindowHandle();
    }

    public final boolean isValid() {
        return null != this.getScreen();
    }

    public final Screen getScreen() {
        return this.screen;
    }

    public void setVisible(boolean bl) {
        if (this.isValid()) {
            Object object;
            if (0L == this.windowHandle && bl && 0 >= this.width * this.height) {
                return;
            }
            if (DEBUG_IMPLEMENTATION) {
                object = new String("Window setVisible: START (" + WindowImpl.getThreadName() + ") " + this.x + "/" + this.y + " " + this.width + "x" + this.height + ", fs " + this.fullscreen + ", windowHandle " + WindowImpl.toHexString(this.windowHandle) + ", visible: " + this.visible + " -> " + bl + ", parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle) + ", parentWindow " + (null != this.parentWindow));
                System.err.println((String)object);
                Thread.dumpStack();
            }
            object = new VisibleAction(bl);
            this.runOnEDTIfAvail(true, (Runnable)object);
        }
    }

    public void setSize(int n, int n2) {
        if (this.isValid()) {
            SetSizeActionImpl setSizeActionImpl = new SetSizeActionImpl(n, n2);
            this.runOnEDTIfAvail(true, setSizeActionImpl);
            switch (setSizeActionImpl.getVisibleAction()) {
                case 1: {
                    this.setVisible(false);
                    break;
                }
                case 2: {
                    this.setVisible(true);
                }
            }
        }
    }

    public void destroy() {
        if (this.isValid()) {
            if (DEBUG_IMPLEMENTATION) {
                String string = new String("Window.destroy() START " + WindowImpl.getThreadName());
                System.err.println(string);
            }
            boolean bl = false;
            if (null != this.lifecycleHook) {
                bl = this.lifecycleHook.pauseRenderingAction();
            }
            if (null != this.lifecycleHook) {
                this.lifecycleHook.destroyActionPreLock();
            }
            this.runOnEDTIfAvail(true, this.destroyAction);
            if (bl) {
                this.lifecycleHook.resumeRenderingAction();
            }
        }
    }

    public final void invalidate() {
        this.destroy();
        this.invalidate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidate(boolean bl) {
        this.windowLock.lock();
        try {
            Object object;
            if (DEBUG_IMPLEMENTATION || DEBUG_WINDOW_EVENT) {
                object = new String("!!! Window Invalidate(unrecoverable: " + bl + ") " + WindowImpl.getThreadName());
                System.err.println((String)object);
            }
            object = this.childWindowsLock;
            synchronized (object) {
                if (null != this.childWindows && this.childWindows.size() > 0) {
                    ArrayList arrayList = (ArrayList)this.childWindows.clone();
                    while (arrayList.size() > 0) {
                        NativeWindow nativeWindow = (NativeWindow)arrayList.remove(0);
                        if (!(nativeWindow instanceof WindowImpl)) continue;
                        ((WindowImpl)nativeWindow).invalidate(bl);
                    }
                }
            }
            if (null != this.lifecycleHook) {
                this.lifecycleHook.invalidate(bl);
            }
            this.windowHandle = 0L;
            this.visible = false;
            this.fullscreen = false;
            this.hasFocus = false;
            if (bl) {
                if (null != this.parentWindow && this.parentWindow instanceof Window) {
                    ((Window)this.parentWindow).removeChild(this);
                }
                this.screen = null;
                object = this.childWindowsLock;
                synchronized (object) {
                    this.childWindows = null;
                }
                object = this.surfaceUpdatedListenersLock;
                synchronized (object) {
                    this.surfaceUpdatedListeners = null;
                }
                this.windowListeners = null;
                this.mouseListeners = null;
                this.keyListeners = null;
                this.parentWindowHandle = 0L;
                this.parentWindow = null;
                this.capsRequested = null;
                this.lifecycleHook = null;
                this.width = 128;
                this.height = 128;
                this.x = 0;
                this.y = 0;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.windowLock.unlock();
            throw throwable;
        }
        this.windowLock.unlock();
    }

    public final int reparentWindow(NativeWindow nativeWindow) {
        return this.reparentWindow(nativeWindow, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reparentWindow(NativeWindow nativeWindow, boolean bl) {
        int n = -1;
        if (this.isValid()) {
            boolean bl2 = false;
            if (null != this.lifecycleHook) {
                bl2 = this.lifecycleHook.pauseRenderingAction();
            }
            try {
                ReparentActionImpl reparentActionImpl = new ReparentActionImpl(nativeWindow, bl);
                this.runOnEDTIfAvail(true, reparentActionImpl);
                n = reparentActionImpl.getStrategy();
                Object var7_6 = null;
                if (bl2) {
                    this.lifecycleHook.resumeRenderingAction();
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (bl2) {
                    this.lifecycleHook.resumeRenderingAction();
                }
                throw throwable;
            }
        }
        return n;
    }

    public CapabilitiesChooser setCapabilitiesChooser(CapabilitiesChooser capabilitiesChooser) {
        CapabilitiesChooser capabilitiesChooser2 = this.capabilitiesChooser;
        this.capabilitiesChooser = capabilitiesChooser;
        return capabilitiesChooser2;
    }

    public final CapabilitiesImmutable getChosenCapabilities() {
        return this.config.getNativeGraphicsConfiguration().getChosenCapabilities();
    }

    public final CapabilitiesImmutable getRequestedCapabilities() {
        return this.capsRequested;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        if (string == null) {
            string = "";
        }
        this.title = string;
        if (0L != this.getWindowHandle()) {
            this.setTitleImpl(string);
        }
    }

    public void setUndecorated(boolean bl) {
        if (this.isValid()) {
            DecorationActionImpl decorationActionImpl = new DecorationActionImpl(bl);
            this.runOnEDTIfAvail(true, decorationActionImpl);
            this.sendWindowEvent(100);
        }
    }

    public boolean isUndecorated() {
        return 0L != this.parentWindowHandle || this.undecorated || this.fullscreen;
    }

    public void requestFocus() {
        this.enqueueRequestFocus(true);
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final boolean isFullscreen() {
        return this.fullscreen;
    }

    public boolean hasDeviceChanged() {
        return false;
    }

    public LifecycleHook getLifecycleHook() {
        return this.lifecycleHook;
    }

    public LifecycleHook setLifecycleHook(LifecycleHook lifecycleHook) {
        LifecycleHook lifecycleHook2 = this.lifecycleHook;
        this.lifecycleHook = lifecycleHook;
        return lifecycleHook2;
    }

    public Object getWrappedWindow() {
        return null;
    }

    public void setHandleDestroyNotify(boolean bl) {
        this.handleDestroyNotify = bl;
    }

    protected final long getParentWindowHandle() {
        return this.parentWindowHandle;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName() + "[Config " + this.config + "\n, " + this.screen + "\n, ParentWindow " + this.parentWindow + "\n, ParentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle) + "\n, WindowHandle " + WindowImpl.toHexString(this.getWindowHandle()) + "\n, SurfaceHandle " + WindowImpl.toHexString(this.getSurfaceHandle()) + " (lockedExt " + this.isSurfaceLockedByOtherThread() + ")" + "\n, Pos " + this.getX() + "/" + this.getY() + ", size " + this.getWidth() + "x" + this.getHeight() + "\n, Visible " + this.isVisible() + "\n, Undecorated " + this.undecorated + "\n, Fullscreen " + this.fullscreen + "\n, WrappedWindow " + this.getWrappedWindow() + "\n, ChildWindows " + this.childWindows.size());
        stringBuffer.append(", SurfaceUpdatedListeners num " + this.surfaceUpdatedListeners.size() + " [");
        for (n = 0; n < this.surfaceUpdatedListeners.size(); ++n) {
            stringBuffer.append(this.surfaceUpdatedListeners.get(n) + ", ");
        }
        stringBuffer.append("], WindowListeners num " + this.windowListeners.size() + " [");
        for (n = 0; n < this.windowListeners.size(); ++n) {
            stringBuffer.append(this.windowListeners.get(n) + ", ");
        }
        stringBuffer.append("], MouseListeners num " + this.mouseListeners.size() + " [");
        for (n = 0; n < this.mouseListeners.size(); ++n) {
            stringBuffer.append(this.mouseListeners.get(n) + ", ");
        }
        stringBuffer.append("], KeyListeners num " + this.keyListeners.size() + " [");
        for (n = 0; n < this.keyListeners.size(); ++n) {
            stringBuffer.append(this.keyListeners.get(n) + ", ");
        }
        stringBuffer.append("] ]");
        return stringBuffer.toString();
    }

    protected final void setWindowHandle(long l) {
        this.windowHandle = l;
    }

    public void runOnEDTIfAvail(boolean bl, Runnable runnable) {
        Screen screen = this.getScreen();
        if (null == screen) {
            throw new RuntimeException("Null screen of inner class: " + this);
        }
        DisplayImpl displayImpl = (DisplayImpl)screen.getDisplay();
        displayImpl.runOnEDTIfAvail(bl, runnable);
    }

    protected void enqueueRequestFocus(boolean bl) {
        this.runOnEDTIfAvail(bl, this.requestFocusAction);
    }

    public void setFocusAction(Window.FocusRunnable focusRunnable) {
        this.focusAction = focusRunnable;
    }

    protected boolean focusAction() {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.focusAction() START - " + WindowImpl.getThreadName() + ", focusAction: " + this.focusAction + " - windowHandle " + WindowImpl.toHexString(this.getWindowHandle()));
        }
        boolean bl = null != this.focusAction ? this.focusAction.run() : false;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.focusAction() END - " + WindowImpl.getThreadName() + ", focusAction: " + this.focusAction + " - windowHandle " + WindowImpl.toHexString(this.getWindowHandle()) + ", res: " + bl);
        }
        return bl;
    }

    public void setPosition(int n, int n2) {
        if (this.isValid()) {
            SetPositionActionImpl setPositionActionImpl = new SetPositionActionImpl(n, n2);
            this.runOnEDTIfAvail(true, setPositionActionImpl);
        }
    }

    public boolean setFullscreen(boolean bl) {
        if (this.isValid()) {
            FullScreenActionImpl fullScreenActionImpl = new FullScreenActionImpl(bl);
            this.runOnEDTIfAvail(true, fullScreenActionImpl);
            this.sendWindowEvent(100);
        }
        return this.fullscreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChild(NativeWindow nativeWindow) {
        Object object = this.childWindowsLock;
        synchronized (object) {
            this.childWindows.remove(nativeWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChild(NativeWindow nativeWindow) {
        if (nativeWindow == null) {
            return;
        }
        Object object = this.childWindowsLock;
        synchronized (object) {
            this.childWindows.add(nativeWindow);
        }
    }

    private void doEvent(boolean bl, boolean bl2, NEWTEvent nEWTEvent) {
        boolean bl3 = false;
        if (!bl) {
            bl2 = bl3 = this.consumeEvent(nEWTEvent);
        }
        if (!bl3) {
            this.enqueueEvent(bl2, nEWTEvent);
        }
    }

    public void enqueueEvent(boolean bl, NEWTEvent nEWTEvent) {
        if (this.isValid()) {
            ((DisplayImpl)this.getScreen().getDisplay()).enqueueEvent(bl, nEWTEvent);
        }
    }

    public boolean consumeEvent(NEWTEvent nEWTEvent) {
        switch (nEWTEvent.getEventType()) {
            case 105: {
                if (this.isSurfaceLocked()) {
                    if (!this.repaintQueued) {
                        this.repaintQueued = true;
                        if (DEBUG_IMPLEMENTATION) {
                            System.err.println("Window.consumeEvent: queued " + nEWTEvent);
                        }
                        return false;
                    }
                    return true;
                }
                this.repaintQueued = false;
                break;
            }
            case 100: {
                if (!this.isSurfaceLocked()) break;
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.consumeEvent: queued " + nEWTEvent);
                }
                return false;
            }
        }
        if (nEWTEvent instanceof WindowEvent) {
            this.consumeWindowEvent((WindowEvent)nEWTEvent);
        } else if (nEWTEvent instanceof KeyEvent) {
            this.consumeKeyEvent((KeyEvent)nEWTEvent);
        } else if (nEWTEvent instanceof MouseEvent) {
            this.consumeMouseEvent((MouseEvent)nEWTEvent);
        } else {
            throw new NativeWindowException("Unexpected NEWTEvent type " + nEWTEvent);
        }
        return true;
    }

    public void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.addSurfaceUpdatedListener(-1, surfaceUpdatedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        if (surfaceUpdatedListener == null) {
            return;
        }
        Object object = this.surfaceUpdatedListenersLock;
        synchronized (object) {
            if (0 > n) {
                n = this.surfaceUpdatedListeners.size();
            }
            this.surfaceUpdatedListeners.add(n, surfaceUpdatedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        if (surfaceUpdatedListener == null) {
            return;
        }
        Object object = this.surfaceUpdatedListenersLock;
        synchronized (object) {
            this.surfaceUpdatedListeners.remove(surfaceUpdatedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllSurfaceUpdatedListener() {
        Object object = this.surfaceUpdatedListenersLock;
        synchronized (object) {
            this.surfaceUpdatedListeners = new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SurfaceUpdatedListener getSurfaceUpdatedListener(int n) {
        Object object = this.surfaceUpdatedListenersLock;
        synchronized (object) {
            if (0 > n) {
                n = this.surfaceUpdatedListeners.size() - 1;
            }
            return (SurfaceUpdatedListener)this.surfaceUpdatedListeners.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SurfaceUpdatedListener[] getSurfaceUpdatedListeners() {
        Object object = this.surfaceUpdatedListenersLock;
        synchronized (object) {
            return (SurfaceUpdatedListener[])this.surfaceUpdatedListeners.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        Object object2 = this.surfaceUpdatedListenersLock;
        synchronized (object2) {
            for (int i = 0; i < this.surfaceUpdatedListeners.size(); ++i) {
                SurfaceUpdatedListener surfaceUpdatedListener = (SurfaceUpdatedListener)this.surfaceUpdatedListeners.get(i);
                surfaceUpdatedListener.surfaceUpdated(object, nativeSurface, l);
            }
        }
    }

    public void sendMouseEvent(int n, int n2, int n3, int n4, int n5, int n6) {
        this.doMouseEvent(false, false, n, n2, n3, n4, n5, n6);
    }

    public void enqueueMouseEvent(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        this.doMouseEvent(true, bl, n, n2, n3, n4, n5, n6);
    }

    private void doMouseEvent(boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 < 0 || n4 < 0 || n3 >= this.width || n4 >= this.height) {
            return;
        }
        if (DEBUG_MOUSE_EVENT) {
            System.err.println("doMouseEvent: enqueue" + bl + ", wait " + bl2 + ", " + MouseEvent.getEventTypeString(n) + ", mod " + n2 + ", pos " + n3 + "/" + n4 + ", button " + n5);
        }
        if (n5 < 0 || n5 > 6) {
            throw new NativeWindowException("Invalid mouse button number" + n5);
        }
        long l = System.currentTimeMillis();
        MouseEvent mouseEvent = null;
        MouseEvent mouseEvent2 = null;
        if (203 == n) {
            this.lastMouseClickCount = l - this.lastMousePressed < (long)MouseEvent.getClickTimeout() ? ++this.lastMouseClickCount : 1;
            this.lastMousePressed = l;
            this.mouseButtonPressed = n5;
            mouseEvent2 = new MouseEvent(n, this, l, n2, n3, n4, this.lastMouseClickCount, n5, 0);
        } else if (204 == n) {
            mouseEvent2 = new MouseEvent(n, this, l, n2, n3, n4, this.lastMouseClickCount, n5, 0);
            if (l - this.lastMousePressed < (long)MouseEvent.getClickTimeout()) {
                mouseEvent = new MouseEvent(200, this, l, n2, n3, n4, this.lastMouseClickCount, n5, 0);
            } else {
                this.lastMouseClickCount = 0;
                this.lastMousePressed = 0L;
            }
            this.mouseButtonPressed = 0;
        } else {
            mouseEvent2 = 205 == n ? (this.mouseButtonPressed > 0 ? new MouseEvent(206, this, l, n2, n3, n4, 1, this.mouseButtonPressed, 0) : new MouseEvent(n, this, l, n2, n3, n4, 0, n5, 0)) : (207 == n ? new MouseEvent(n, this, l, n2, n3, n4, 0, n5, n6) : new MouseEvent(n, this, l, n2, n3, n4, 0, n5, 0));
        }
        this.doEvent(bl, bl2, mouseEvent2);
        if (null != mouseEvent) {
            if (DEBUG_MOUSE_EVENT) {
                System.err.println("doMouseEvent: synthesized MOUSE_CLICKED event");
            }
            this.doEvent(bl, bl2, mouseEvent);
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.addMouseListener(-1, mouseListener);
    }

    public void addMouseListener(int n, MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, mouseListener);
        this.mouseListeners = arrayList;
    }

    public void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        arrayList.remove(mouseListener);
        this.mouseListeners = arrayList;
    }

    public MouseListener getMouseListener(int n) {
        ArrayList arrayList = (ArrayList)this.mouseListeners.clone();
        if (0 > n) {
            n = arrayList.size() - 1;
        }
        return (MouseListener)arrayList.get(n);
    }

    public MouseListener[] getMouseListeners() {
        return (MouseListener[])this.mouseListeners.toArray();
    }

    protected void consumeMouseEvent(MouseEvent mouseEvent) {
        if (DEBUG_MOUSE_EVENT) {
            System.err.println("consumeMouseEvent: event:         " + mouseEvent);
        }
        block10: for (int i = 0; i < this.mouseListeners.size(); ++i) {
            MouseListener mouseListener = (MouseListener)this.mouseListeners.get(i);
            switch (mouseEvent.getEventType()) {
                case 200: {
                    mouseListener.mouseClicked(mouseEvent);
                    continue block10;
                }
                case 201: {
                    mouseListener.mouseEntered(mouseEvent);
                    continue block10;
                }
                case 202: {
                    mouseListener.mouseExited(mouseEvent);
                    continue block10;
                }
                case 203: {
                    mouseListener.mousePressed(mouseEvent);
                    continue block10;
                }
                case 204: {
                    mouseListener.mouseReleased(mouseEvent);
                    continue block10;
                }
                case 205: {
                    mouseListener.mouseMoved(mouseEvent);
                    continue block10;
                }
                case 206: {
                    mouseListener.mouseDragged(mouseEvent);
                    continue block10;
                }
                case 207: {
                    mouseListener.mouseWheelMoved(mouseEvent);
                    continue block10;
                }
                default: {
                    throw new NativeWindowException("Unexpected mouse event type " + mouseEvent.getEventType());
                }
            }
        }
    }

    public void sendKeyEvent(int n, int n2, int n3, char c) {
        this.consumeKeyEvent(new KeyEvent(n, this, System.currentTimeMillis(), n2, n3, c));
    }

    public void enqueueKeyEvent(boolean bl, int n, int n2, int n3, char c) {
        this.enqueueEvent(bl, new KeyEvent(n, this, System.currentTimeMillis(), n2, n3, c));
    }

    public void addKeyListener(KeyListener keyListener) {
        this.addKeyListener(-1, keyListener);
    }

    public void addKeyListener(int n, KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, keyListener);
        this.keyListeners = arrayList;
    }

    public void removeKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        arrayList.remove(keyListener);
        this.keyListeners = arrayList;
    }

    public KeyListener getKeyListener(int n) {
        ArrayList arrayList = (ArrayList)this.keyListeners.clone();
        if (0 > n) {
            n = arrayList.size() - 1;
        }
        return (KeyListener)arrayList.get(n);
    }

    public KeyListener[] getKeyListeners() {
        return (KeyListener[])this.keyListeners.toArray();
    }

    protected void consumeKeyEvent(KeyEvent keyEvent) {
        if (DEBUG_KEY_EVENT) {
            System.err.println("consumeKeyEvent: " + keyEvent);
        }
        block5: for (int i = 0; i < this.keyListeners.size(); ++i) {
            KeyListener keyListener = (KeyListener)this.keyListeners.get(i);
            switch (keyEvent.getEventType()) {
                case 300: {
                    keyListener.keyPressed(keyEvent);
                    continue block5;
                }
                case 301: {
                    keyListener.keyReleased(keyEvent);
                    continue block5;
                }
                case 302: {
                    keyListener.keyTyped(keyEvent);
                    continue block5;
                }
                default: {
                    throw new NativeWindowException("Unexpected key event type " + keyEvent.getEventType());
                }
            }
        }
    }

    public void sendWindowEvent(int n) {
        this.consumeWindowEvent(new WindowEvent(n, this, System.currentTimeMillis()));
    }

    public void enqueueWindowEvent(boolean bl, int n) {
        this.enqueueEvent(bl, new WindowEvent(n, this, System.currentTimeMillis()));
    }

    public void addWindowListener(WindowListener windowListener) {
        this.addWindowListener(-1, windowListener);
    }

    public void addWindowListener(int n, WindowListener windowListener) throws IndexOutOfBoundsException {
        if (windowListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.windowListeners.clone();
        if (0 > n) {
            n = arrayList.size();
        }
        arrayList.add(n, windowListener);
        this.windowListeners = arrayList;
    }

    public final void removeWindowListener(WindowListener windowListener) {
        if (windowListener == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.windowListeners.clone();
        arrayList.remove(windowListener);
        this.windowListeners = arrayList;
    }

    public WindowListener getWindowListener(int n) {
        ArrayList arrayList = (ArrayList)this.windowListeners.clone();
        if (0 > n) {
            n = arrayList.size() - 1;
        }
        return (WindowListener)arrayList.get(n);
    }

    public WindowListener[] getWindowListeners() {
        return (WindowListener[])this.windowListeners.toArray();
    }

    protected void consumeWindowEvent(WindowEvent windowEvent) {
        if (DEBUG_WINDOW_EVENT) {
            System.err.println("consumeWindowEvent: " + windowEvent + ", visible " + this.isVisible() + " " + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight());
        }
        block8: for (int i = 0; i < this.windowListeners.size(); ++i) {
            WindowListener windowListener = (WindowListener)this.windowListeners.get(i);
            switch (windowEvent.getEventType()) {
                case 100: {
                    windowListener.windowResized(windowEvent);
                    continue block8;
                }
                case 101: {
                    windowListener.windowMoved(windowEvent);
                    continue block8;
                }
                case 102: {
                    windowListener.windowDestroyNotify(windowEvent);
                    continue block8;
                }
                case 103: {
                    windowListener.windowGainedFocus(windowEvent);
                    continue block8;
                }
                case 104: {
                    windowListener.windowLostFocus(windowEvent);
                    continue block8;
                }
                case 105: {
                    windowListener.windowRepaint((WindowUpdateEvent)windowEvent);
                    continue block8;
                }
                default: {
                    throw new NativeWindowException("Unexpected window event type " + windowEvent.getEventType());
                }
            }
        }
    }

    protected void focusChanged(boolean bl) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.focusChanged: (" + WindowImpl.getThreadName() + "): " + this.hasFocus + " -> " + bl + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
        }
        this.hasFocus = bl;
        if (bl) {
            this.sendWindowEvent(103);
        } else {
            this.sendWindowEvent(104);
        }
    }

    protected void visibleChanged(boolean bl) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.visibleChanged (" + WindowImpl.getThreadName() + "): " + this.visible + " -> " + bl + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
        }
        this.visible = bl;
    }

    private boolean waitForVisible(boolean bl, boolean bl2) {
        return this.waitForVisible(bl, bl2, 1000L);
    }

    private boolean waitForVisible(boolean bl, boolean bl2, long l) {
        DisplayImpl displayImpl = (DisplayImpl)this.screen.getDisplay();
        for (long i = l; 0L < i && this.visible != bl; i -= 10L) {
            displayImpl.dispatchMessagesNative();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            i -= 10L;
        }
        if (this.visible != bl) {
            if (bl2) {
                throw new NativeWindowException("Visibility not reached as requested within " + l + "ms : requested " + bl + ", is " + this.visible);
            }
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("******* Visibility not reached as requested within " + l + "ms : requested " + bl + ", is " + this.visible);
            }
        }
        return this.visible == bl;
    }

    protected void sizeChanged(int n, int n2, boolean bl) {
        if (bl || this.width != n || this.height != n2) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.sizeChanged: (" + WindowImpl.getThreadName() + "): force " + bl + ", " + this.width + "x" + this.height + " -> " + n + "x" + n2 + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            this.width = n;
            this.height = n2;
            if (this.isNativeValid()) {
                this.sendWindowEvent(100);
            }
        }
    }

    protected void positionChanged(int n, int n2) {
        if (0L == this.parentWindowHandle && (this.x != n || this.y != n2)) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.positionChanged: (" + WindowImpl.getThreadName() + "): " + this.x + "/" + this.y + " -> " + n + "/" + n2 + " - windowHandle " + WindowImpl.toHexString(this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(this.parentWindowHandle));
            }
            this.x = n;
            this.y = n2;
            this.sendWindowEvent(101);
        }
    }

    protected void windowDestroyNotify() {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.windowDestroyNotify START " + WindowImpl.getThreadName());
        }
        this.enqueueWindowEvent(false, 102);
        if (this.handleDestroyNotify && this.isValid()) {
            this.destroy();
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.windowDestroyeNotify END " + WindowImpl.getThreadName());
        }
    }

    protected void windowDestroyed() {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.windowDestroyed " + WindowImpl.getThreadName());
        }
        this.closeAndInvalidate();
    }

    public void windowRepaint(int n, int n2, int n3, int n4) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Window.windowRepaint " + WindowImpl.getThreadName() + " - " + n + "/" + n2 + " " + n3 + "x" + n4);
        }
        if (this.isNativeValid()) {
            if (0 > n3) {
                n3 = this.width;
            }
            if (0 > n4) {
                n4 = this.height;
            }
            WindowUpdateEvent windowUpdateEvent = new WindowUpdateEvent(105, this, System.currentTimeMillis(), new Rectangle(n, n2, n3, n4));
            this.doEvent(false, false, windowUpdateEvent);
        }
    }

    protected int getWindowLockRecursionCount() {
        return this.windowLock.getRecursionCount();
    }

    private static Class[] getCustomConstructorArgumentTypes(Class clazz) {
        Class[] classArray = null;
        try {
            Method method = clazz.getDeclaredMethod("getCustomConstructorArgumentTypes", new Class[0]);
            classArray = (Class[])method.invoke(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return classArray;
    }

    private static int verifyConstructorArgumentTypes(Class[] classArray, Object[] objectArray) {
        if (classArray.length != objectArray.length) {
            return -1;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (classArray[i].isInstance(objectArray[i])) continue;
            return i;
        }
        return objectArray.length;
    }

    private static String getArgsStrList(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(objectArray[i].getClass());
            if (i >= objectArray.length) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private static String getTypeStrList(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i]);
            if (i >= classArray.length) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    protected final void shouldNotCallThis() {
        throw new NativeWindowException("Should not call this");
    }

    public static String getThreadName() {
        return Display.getThreadName();
    }

    public static String toHexString(int n) {
        return Display.toHexString(n);
    }

    public static String toHexString(long l) {
        return Display.toHexString(l);
    }

    class ScreenModeListenerImpl
    implements ScreenModeListener {
        boolean animatorPaused = false;

        ScreenModeListenerImpl() {
        }

        public void screenModeChangeNotify(ScreenMode screenMode) {
            if (Window.DEBUG_IMPLEMENTATION || Window.DEBUG_WINDOW_EVENT) {
                System.err.println("Window.screenModeChangeNotify: " + screenMode);
            }
            if (null != WindowImpl.this.lifecycleHook) {
                this.animatorPaused = WindowImpl.this.lifecycleHook.pauseRenderingAction();
            }
        }

        public void screenModeChanged(ScreenMode screenMode, boolean bl) {
            if (Window.DEBUG_IMPLEMENTATION || Window.DEBUG_WINDOW_EVENT) {
                System.err.println("Window.screenModeChanged: " + screenMode + ", success: " + bl);
            }
            if (bl) {
                DimensionReadOnly dimensionReadOnly = screenMode.getMonitorMode().getSurfaceSize().getResolution();
                if (WindowImpl.this.getHeight() > dimensionReadOnly.getHeight() || WindowImpl.this.getWidth() > dimensionReadOnly.getWidth()) {
                    WindowImpl.this.setSize(dimensionReadOnly.getWidth(), dimensionReadOnly.getHeight());
                }
            }
            if (this.animatorPaused) {
                WindowImpl.this.lifecycleHook.resumeRenderingAction();
            }
            WindowImpl.this.sendWindowEvent(100);
        }
    }

    class FullScreenActionImpl
    implements Runnable {
        boolean fullscreen;

        public FullScreenActionImpl(boolean bl) {
            this.fullscreen = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WindowImpl.this.windowLock.lock();
            try {
                if (WindowImpl.this.isNativeValid() && WindowImpl.this.fullscreen != this.fullscreen) {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    WindowImpl.this.fullscreen = this.fullscreen;
                    if (this.fullscreen) {
                        n4 = 0;
                        n3 = 0;
                        n2 = WindowImpl.this.screen.getWidth();
                        n = WindowImpl.this.screen.getHeight();
                        WindowImpl.this.nfs_width = WindowImpl.this.width;
                        WindowImpl.this.nfs_height = WindowImpl.this.height;
                        WindowImpl.this.nfs_x = n4;
                        WindowImpl.this.nfs_y = n3;
                    } else {
                        n4 = WindowImpl.this.nfs_x;
                        n3 = WindowImpl.this.nfs_y;
                        n2 = WindowImpl.this.nfs_width;
                        n = WindowImpl.this.nfs_height;
                    }
                    if (Window.DEBUG_IMPLEMENTATION || Window.DEBUG_WINDOW_EVENT) {
                        System.err.println("Window fs: " + this.fullscreen + " " + n4 + "/" + n3 + " " + n2 + "x" + n + ", " + WindowImpl.this.isUndecorated() + ", " + WindowImpl.this.screen);
                    }
                    DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                    displayImpl.dispatchMessagesNative();
                    boolean bl = WindowImpl.this.isVisible();
                    WindowImpl.this.setVisibleImpl(false, n4, n3, WindowImpl.this.width, WindowImpl.this.height);
                    WindowImpl.this.waitForVisible(false, true);
                    displayImpl.dispatchMessagesNative();
                    WindowImpl.this.x = n4;
                    WindowImpl.this.y = n3;
                    WindowImpl.this.width = n2;
                    WindowImpl.this.height = n;
                    WindowImpl.this.reconfigureWindowImpl(n4, n3, n2, n, WindowImpl.this.getParentWindowHandle() != 0L, this.fullscreen ? 1 : -1, WindowImpl.this.isUndecorated() ? -1 : 1);
                    displayImpl.dispatchMessagesNative();
                    if (bl) {
                        WindowImpl.this.setVisibleImpl(true, n4, n3, WindowImpl.this.width, WindowImpl.this.height);
                        boolean bl2 = WindowImpl.this.waitForVisible(true, true, 10000L);
                        displayImpl.dispatchMessagesNative();
                        if (bl2 && (WindowImpl.this.x != n4 || WindowImpl.this.y != n3 || WindowImpl.this.width != n2 || WindowImpl.this.height != n)) {
                            if (Window.DEBUG_IMPLEMENTATION || Window.DEBUG_WINDOW_EVENT) {
                                System.err.println("Window fs (reconfig): " + n4 + "/" + n3 + " " + n2 + "x" + n + ", " + WindowImpl.this.screen);
                            }
                            WindowImpl.this.reconfigureWindowImpl(n4, n3, WindowImpl.this.width, WindowImpl.this.height, false, 0, 0);
                            displayImpl.dispatchMessagesNative();
                        }
                        WindowImpl.this.requestFocusImpl(true);
                        displayImpl.dispatchMessagesNative();
                        if (Window.DEBUG_IMPLEMENTATION || Window.DEBUG_WINDOW_EVENT) {
                            System.err.println("Window fs done");
                        }
                    }
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                WindowImpl.this.windowLock.unlock();
                throw throwable;
            }
            WindowImpl.this.windowLock.unlock();
        }
    }

    class SetPositionActionImpl
    implements Runnable {
        int x;
        int y;

        public SetPositionActionImpl(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WindowImpl.this.windowLock.lock();
            try {
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window setPosition: " + WindowImpl.this.x + "/" + WindowImpl.this.y + " -> " + this.x + "/" + this.y + ", fs " + WindowImpl.this.fullscreen + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle));
                }
                if (!(WindowImpl.this.x == this.x && WindowImpl.this.y == this.y || WindowImpl.this.fullscreen)) {
                    if (0L != WindowImpl.this.windowHandle) {
                        WindowImpl.this.reconfigureWindowImpl(this.x, this.y, -1, -1, false, 0, 0);
                    } else {
                        WindowImpl.this.x = this.x;
                        WindowImpl.this.y = this.y;
                    }
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                WindowImpl.this.windowLock.unlock();
                throw throwable;
            }
            WindowImpl.this.windowLock.unlock();
        }
    }

    class RequestFocusAction
    implements Runnable {
        RequestFocusAction() {
        }

        public void run() {
            if (Window.DEBUG_IMPLEMENTATION) {
                System.err.println("Window.RequestFocusAction: (" + WindowImpl.getThreadName() + "): " + WindowImpl.this.hasFocus + " -> true - windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle));
            }
            WindowImpl.this.requestFocusImpl(false);
        }
    }

    class DecorationActionImpl
    implements Runnable {
        boolean undecorated;

        public DecorationActionImpl(boolean bl) {
            this.undecorated = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WindowImpl.this.windowLock.lock();
            try {
                if (!WindowImpl.this.fullscreen && WindowImpl.this.isNativeValid() && WindowImpl.this.undecorated != this.undecorated) {
                    WindowImpl.this.undecorated = this.undecorated;
                    int n = WindowImpl.this.x;
                    int n2 = WindowImpl.this.y;
                    int n3 = WindowImpl.this.width;
                    int n4 = WindowImpl.this.height;
                    if (0L != WindowImpl.this.windowHandle) {
                        DisplayImpl displayImpl = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                        displayImpl.dispatchMessagesNative();
                        boolean bl = WindowImpl.this.isVisible();
                        WindowImpl.this.setVisibleImpl(false, n, n2, n3, n4);
                        WindowImpl.this.waitForVisible(false, true);
                        displayImpl.dispatchMessagesNative();
                        WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, false, 0, this.undecorated ? -1 : 1);
                        displayImpl.dispatchMessagesNative();
                        if (bl) {
                            WindowImpl.this.setVisibleImpl(true, n, n2, n3, n4);
                            WindowImpl.this.waitForVisible(true, true);
                            displayImpl.dispatchMessagesNative();
                            if (WindowImpl.this.x != n || WindowImpl.this.y != n2 || WindowImpl.this.width != n3 || WindowImpl.this.height != n4) {
                                WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, false, 0, 0);
                                displayImpl.dispatchMessagesNative();
                            }
                            WindowImpl.this.requestFocusImpl(true);
                            displayImpl.dispatchMessagesNative();
                        }
                    }
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                WindowImpl.this.windowLock.unlock();
                throw throwable;
            }
            WindowImpl.this.windowLock.unlock();
        }
    }

    class ReparentActionRecreate
    implements Runnable {
        ReparentActionRecreate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WindowImpl.this.windowLock.lock();
            try {
                WindowImpl.this.visible = true;
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.reparentWindow: ReparentActionRecreate (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", visible: " + WindowImpl.this.visible + ", parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", parentWindow " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow));
                }
                WindowImpl.this.setVisible(true);
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                WindowImpl.this.windowLock.unlock();
                throw throwable;
            }
            WindowImpl.this.windowLock.unlock();
        }
    }

    class ReparentActionImpl
    implements Runnable,
    Window.ReparentAction {
        NativeWindow newParentWindow;
        boolean forceDestroyCreate;
        int reparentAction;

        public ReparentActionImpl(NativeWindow nativeWindow, boolean bl) {
            this.newParentWindow = nativeWindow;
            this.forceDestroyCreate = bl;
            this.reparentAction = -1;
        }

        public final int getStrategy() {
            return this.reparentAction;
        }

        private final void setScreen(ScreenImpl screenImpl) {
            WindowImpl.this.removeScreenReference();
            WindowImpl.this.screen = screenImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            boolean bl;
            block51: {
                block49: {
                    block48: {
                        int n = WindowImpl.this.x;
                        int n2 = WindowImpl.this.y;
                        int n3 = WindowImpl.this.width;
                        int n4 = WindowImpl.this.height;
                        WindowImpl.this.windowLock.lock();
                        try {
                            Object object;
                            long l;
                            block47: {
                                block52: {
                                    block54: {
                                        Window window;
                                        block53: {
                                            bl = WindowImpl.this.isVisible();
                                            window = null;
                                            if (this.newParentWindow instanceof Window) {
                                                window = (Window)this.newParentWindow;
                                            }
                                            l = 0L;
                                            if (Window.DEBUG_IMPLEMENTATION) {
                                                System.err.println("Window.reparent: START (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", visible " + bl + ", old parentWindow: " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow) + ", new parentWindow: " + Display.hashCodeNullSafe(this.newParentWindow) + ", forceDestroyCreate " + this.forceDestroyCreate + ", DEBUG_TEST_REPARENT_INCOMPATIBLE " + DEBUG_TEST_REPARENT_INCOMPATIBLE + " " + n + "/" + n2 + " " + n3 + "x" + n4);
                                            }
                                            if (null != WindowImpl.this.lifecycleHook) {
                                                WindowImpl.this.lifecycleHook.resetCounter();
                                            }
                                            if (null == this.newParentWindow) break block52;
                                            n = 0;
                                            n2 = 0;
                                            if (n3 > this.newParentWindow.getWidth()) {
                                                n3 = this.newParentWindow.getWidth();
                                            }
                                            if (n4 > this.newParentWindow.getHeight()) {
                                                n4 = this.newParentWindow.getHeight();
                                            }
                                            if (0L != (l = WindowImpl.getNativeWindowHandle(this.newParentWindow))) break block53;
                                            if (null == window) {
                                                throw new NativeWindowException("Reparenting with non NEWT Window type only available after it's realized: " + this.newParentWindow);
                                            }
                                            WindowImpl.this.destroy();
                                            this.setScreen((ScreenImpl)window.getScreen());
                                            this.reparentAction = 3;
                                            break block47;
                                        }
                                        if (this.newParentWindow == WindowImpl.this.getParent()) break block54;
                                        if (!WindowImpl.this.isNativeValid()) {
                                            if (null != window) {
                                                this.setScreen((ScreenImpl)window.getScreen());
                                            } else {
                                                object = NewtFactory.createCompatibleScreen(this.newParentWindow, WindowImpl.this.getScreen());
                                                if (WindowImpl.this.getScreen() != object) {
                                                    this.setScreen((ScreenImpl)object);
                                                }
                                            }
                                            this.reparentAction = 0 < n3 * n4 ? 2 : 3;
                                            break block47;
                                        } else if (DEBUG_TEST_REPARENT_INCOMPATIBLE || this.forceDestroyCreate || !NewtFactory.isScreenCompatible(this.newParentWindow, WindowImpl.this.getScreen())) {
                                            WindowImpl.this.destroy();
                                            if (null != window) {
                                                this.setScreen((ScreenImpl)window.getScreen());
                                            } else {
                                                this.setScreen((ScreenImpl)NewtFactory.createCompatibleScreen(this.newParentWindow, WindowImpl.this.getScreen()));
                                            }
                                            this.reparentAction = 2;
                                            break block47;
                                        } else {
                                            this.reparentAction = 1;
                                        }
                                        break block47;
                                    }
                                    this.reparentAction = 0;
                                    break block47;
                                }
                                if (null != WindowImpl.this.parentWindow) {
                                    object = WindowImpl.this.getLocationOnScreen(null);
                                    n = object.getX();
                                    n2 = object.getY();
                                }
                                if (0L == WindowImpl.this.getParentWindowHandle()) {
                                    this.reparentAction = 0;
                                } else if (!WindowImpl.this.isNativeValid() || DEBUG_TEST_REPARENT_INCOMPATIBLE || this.forceDestroyCreate) {
                                    WindowImpl.this.destroy();
                                    this.reparentAction = 0 < n3 * n4 ? 2 : 3;
                                } else {
                                    this.reparentAction = 1;
                                }
                            }
                            WindowImpl.this.parentWindowHandle = l;
                            if (0 > this.reparentAction) {
                                throw new NativeWindowException("Internal Error: reparentAction not set");
                            }
                            if (0 == this.reparentAction) {
                                if (Window.DEBUG_IMPLEMENTATION) {
                                    System.err.println("Window.reparent: NO CHANGE (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " new parentWindowHandle " + WindowImpl.toHexString(l) + ", visible " + bl);
                                }
                                Object var15_9 = null;
                                break block48;
                            }
                            if (Window.DEBUG_IMPLEMENTATION) {
                                System.err.println("Window.reparent: ACTION (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " new parentWindowHandle " + WindowImpl.toHexString(l) + ", reparentAction " + this.reparentAction + ", visible " + bl);
                            }
                            if (null != WindowImpl.this.parentWindow && WindowImpl.this.parentWindow instanceof Window) {
                                ((Window)WindowImpl.this.parentWindow).removeChild(WindowImpl.this);
                            }
                            WindowImpl.this.parentWindow = this.newParentWindow;
                            if (WindowImpl.this.parentWindow instanceof Window) {
                                ((Window)WindowImpl.this.parentWindow).addChild(WindowImpl.this);
                            }
                            if (3 == this.reparentAction) {
                                break block49;
                            }
                            if (1 == this.reparentAction) {
                                boolean bl2;
                                block50: {
                                    object = (DisplayImpl)WindowImpl.this.screen.getDisplay();
                                    ((DisplayImpl)object).dispatchMessagesNative();
                                    if (bl) {
                                        WindowImpl.this.setVisibleImpl(false, n, n2, n3, n4);
                                        WindowImpl.this.waitForVisible(false, true);
                                    }
                                    NativeWindow nativeWindow = null;
                                    if (null != WindowImpl.this.parentWindow && 1 >= (nativeWindow = WindowImpl.this.parentWindow).lockSurface()) {
                                        throw new NativeWindowException("Parent surface lock: not ready: " + WindowImpl.this.parentWindow);
                                    }
                                    bl2 = false;
                                    try {
                                        WindowImpl.this.x = n;
                                        WindowImpl.this.y = n2;
                                        WindowImpl.this.width = n3;
                                        WindowImpl.this.height = n4;
                                        bl2 = WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, true, 0, WindowImpl.this.isUndecorated() ? -1 : 1);
                                        Object var13_15 = null;
                                        if (null == nativeWindow) break block50;
                                    }
                                    catch (Throwable throwable) {
                                        Object var13_16 = null;
                                        if (null == nativeWindow) throw throwable;
                                        nativeWindow.unlockSurface();
                                        throw throwable;
                                    }
                                    nativeWindow.unlockSurface();
                                }
                                if (bl2) {
                                    ((DisplayImpl)object).dispatchMessagesNative();
                                    if (bl) {
                                        WindowImpl.this.setVisibleImpl(true, n, n2, n3, n4);
                                        bl2 = WindowImpl.this.waitForVisible(true, false);
                                        ((DisplayImpl)object).dispatchMessagesNative();
                                        if (bl2 && (WindowImpl.this.x != n || WindowImpl.this.y != n2 || WindowImpl.this.width != n3 || WindowImpl.this.height != n4)) {
                                            if (Window.DEBUG_IMPLEMENTATION) {
                                                System.err.println("Window.reparent (reconfig)");
                                            }
                                            WindowImpl.this.reconfigureWindowImpl(n, n2, n3, n4, false, 0, 0);
                                            ((DisplayImpl)object).dispatchMessagesNative();
                                            WindowImpl.this.waitForVisible(true, false);
                                            ((DisplayImpl)object).dispatchMessagesNative();
                                        }
                                    }
                                }
                                if (bl2) {
                                    if (bl) {
                                        WindowImpl.this.requestFocusImpl(true);
                                        ((DisplayImpl)object).dispatchMessagesNative();
                                    }
                                } else {
                                    if (Window.DEBUG_IMPLEMENTATION) {
                                        System.err.println("Window.reparent: native reparenting failed (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + " parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + " -> " + WindowImpl.toHexString(l) + " - Trying recreation");
                                    }
                                    WindowImpl.this.destroy();
                                    this.reparentAction = 2;
                                }
                            }
                            WindowImpl.this.x = n;
                            WindowImpl.this.y = n2;
                            WindowImpl.this.width = n3;
                            WindowImpl.this.height = n4;
                            if (Window.DEBUG_IMPLEMENTATION) {
                                System.err.println("Window.reparentWindow: END (" + WindowImpl.getThreadName() + ") windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", visible: " + WindowImpl.this.visible + ", parentWindowHandle " + WindowImpl.toHexString(WindowImpl.this.parentWindowHandle) + ", parentWindow " + Display.hashCodeNullSafe(WindowImpl.this.parentWindow) + " " + n + "/" + n2 + " " + n3 + "x" + n4);
                            }
                            break block51;
                        }
                        catch (Throwable throwable) {
                            Object var15_12 = null;
                            WindowImpl.this.windowLock.unlock();
                            throw throwable;
                        }
                    }
                    WindowImpl.this.windowLock.unlock();
                    return;
                }
                Object var15_10 = null;
                WindowImpl.this.windowLock.unlock();
                return;
            }
            Object var15_11 = null;
            WindowImpl.this.windowLock.unlock();
            if (!bl) return;
            switch (this.reparentAction) {
                case 1: {
                    WindowImpl.this.sendWindowEvent(100);
                    return;
                }
                case 2: {
                    WindowImpl.this.runOnEDTIfAvail(true, WindowImpl.this.reparentActionRecreate);
                    return;
                }
            }
        }
    }

    class DestroyAction
    implements Runnable {
        DestroyAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            WindowImpl.this.windowLock.lock();
            try {
                if (!WindowImpl.this.isValid()) {
                    Object var6_1 = null;
                    WindowImpl.this.windowLock.unlock();
                    return;
                }
                Object object = WindowImpl.this.childWindowsLock;
                // MONITORENTER : object
                if (WindowImpl.this.childWindows.size() > 0) {
                    ArrayList arrayList = (ArrayList)WindowImpl.this.childWindows.clone();
                    while (arrayList.size() > 0) {
                        NativeWindow nativeWindow = (NativeWindow)arrayList.remove(0);
                        if (nativeWindow instanceof WindowImpl) {
                            ((WindowImpl)nativeWindow).sendWindowEvent(102);
                            ((WindowImpl)nativeWindow).destroy();
                            continue;
                        }
                        nativeWindow.destroy();
                    }
                }
                // MONITOREXIT : object
                if (null != WindowImpl.this.lifecycleHook) {
                    WindowImpl.this.lifecycleHook.destroyActionInLock();
                }
                WindowImpl.this.closeAndInvalidate();
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window.destroy() END " + WindowImpl.getThreadName());
                }
                Object var6_2 = null;
                WindowImpl.this.windowLock.unlock();
                return;
            }
            catch (Throwable throwable) {
                Object var6_3 = null;
                WindowImpl.this.windowLock.unlock();
                throw throwable;
            }
        }
    }

    class SetSizeActionImpl
    implements Runnable {
        int visibleAction = 0;
        int width;
        int height;

        public int getVisibleAction() {
            return this.visibleAction;
        }

        public SetSizeActionImpl(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WindowImpl.this.windowLock.lock();
            try {
                if (!(WindowImpl.this.fullscreen || this.width == WindowImpl.this.width && WindowImpl.this.height == this.height)) {
                    if (Window.DEBUG_IMPLEMENTATION) {
                        String string = new String("Window setSize: START " + WindowImpl.this.width + "x" + WindowImpl.this.height + " -> " + this.width + "x" + this.height + ", fs " + WindowImpl.this.fullscreen + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", visible " + WindowImpl.this.visible);
                        System.err.println(string);
                    }
                    if (0L != WindowImpl.this.windowHandle && 0 >= this.width * this.height && WindowImpl.this.visible) {
                        this.visibleAction = 1;
                        WindowImpl.this.width = 0;
                        WindowImpl.this.height = 0;
                    } else if (0L == WindowImpl.this.windowHandle && 0 < this.width * this.height && WindowImpl.this.visible) {
                        this.visibleAction = 2;
                        WindowImpl.this.width = this.width;
                        WindowImpl.this.height = this.height;
                    } else if (0L != WindowImpl.this.windowHandle) {
                        WindowImpl.this.reconfigureWindowImpl(WindowImpl.this.x, WindowImpl.this.y, this.width, this.height, false, 0, 0);
                    } else {
                        WindowImpl.this.width = this.width;
                        WindowImpl.this.height = this.height;
                    }
                    if (Window.DEBUG_IMPLEMENTATION) {
                        System.err.println("Window setSize: END " + WindowImpl.this.width + "x" + WindowImpl.this.height + ", visibleAction " + this.visibleAction);
                    }
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                WindowImpl.this.windowLock.unlock();
                throw throwable;
            }
            WindowImpl.this.windowLock.unlock();
        }
    }

    class VisibleAction
    implements Runnable {
        boolean visible;
        boolean nativeWindowCreated;
        boolean madeVisible;

        public VisibleAction(boolean bl) {
            this.visible = bl;
            this.nativeWindowCreated = false;
            this.madeVisible = false;
        }

        public final boolean getNativeWindowCreated() {
            return this.nativeWindowCreated;
        }

        public final boolean getBecameVisible() {
            return this.madeVisible;
        }

        public final boolean getChanged() {
            return this.nativeWindowCreated || this.madeVisible;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WindowImpl.this.windowLock.lock();
            try {
                NativeWindow nativeWindow;
                int n;
                Object object;
                if (null != WindowImpl.this.lifecycleHook) {
                    WindowImpl.this.lifecycleHook.resetCounter();
                }
                if (!this.visible && null != WindowImpl.this.childWindows && WindowImpl.this.childWindows.size() > 0) {
                    object = WindowImpl.this.childWindowsLock;
                    synchronized (object) {
                        for (n = 0; n < WindowImpl.this.childWindows.size(); ++n) {
                            nativeWindow = (NativeWindow)WindowImpl.this.childWindows.get(n);
                            if (!(nativeWindow instanceof WindowImpl)) continue;
                            ((WindowImpl)nativeWindow).setVisible(false);
                        }
                    }
                }
                if (0L == WindowImpl.this.windowHandle && this.visible) {
                    if (0 < WindowImpl.this.width * WindowImpl.this.height) {
                        this.nativeWindowCreated = WindowImpl.this.createNative();
                        WindowImpl.this.waitForVisible(this.visible, true);
                        this.madeVisible = this.visible;
                    }
                } else if (WindowImpl.this.visible != this.visible && 0L != WindowImpl.this.windowHandle) {
                    WindowImpl.this.setVisibleImpl(this.visible, WindowImpl.this.x, WindowImpl.this.y, WindowImpl.this.width, WindowImpl.this.height);
                    WindowImpl.this.waitForVisible(this.visible, true);
                    this.madeVisible = this.visible;
                }
                if (null != WindowImpl.this.lifecycleHook) {
                    WindowImpl.this.lifecycleHook.setVisibleActionPost(this.visible, this.nativeWindowCreated);
                }
                if (0L != WindowImpl.this.windowHandle && this.visible && null != WindowImpl.this.childWindows && WindowImpl.this.childWindows.size() > 0) {
                    object = WindowImpl.this.childWindowsLock;
                    synchronized (object) {
                        for (n = 0; n < WindowImpl.this.childWindows.size(); ++n) {
                            nativeWindow = (NativeWindow)WindowImpl.this.childWindows.get(n);
                            if (!(nativeWindow instanceof WindowImpl)) continue;
                            ((WindowImpl)nativeWindow).setVisible(true);
                        }
                    }
                }
                if (Window.DEBUG_IMPLEMENTATION) {
                    System.err.println("Window setVisible: END (" + WindowImpl.getThreadName() + ") " + WindowImpl.this.x + "/" + WindowImpl.this.y + " " + WindowImpl.this.width + "x" + WindowImpl.this.height + ", fs " + WindowImpl.this.fullscreen + ", windowHandle " + WindowImpl.toHexString(WindowImpl.this.windowHandle) + ", visible: " + WindowImpl.this.visible + ", nativeWindowCreated: " + this.nativeWindowCreated + ", madeVisible: " + this.madeVisible);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                WindowImpl.this.windowLock.unlock();
                throw throwable;
            }
            WindowImpl.this.windowLock.unlock();
            if (this.getChanged()) {
                WindowImpl.this.sendWindowEvent(100);
            }
        }
    }

    public static interface LifecycleHook {
        public void resetCounter();

        public void setVisibleActionPost(boolean var1, boolean var2);

        public void destroyActionPreLock();

        public void destroyActionInLock();

        public void invalidate(boolean var1);

        public boolean pauseRenderingAction();

        public void resumeRenderingAction();
    }
}

