/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.impl.windows;

import com.jogamp.nativewindow.impl.Debug;
import com.jogamp.nativewindow.impl.windows.GDI;
import com.jogamp.nativewindow.impl.windows.RegisteredClass;
import java.util.ArrayList;
import javax.media.nativewindow.NativeWindowException;

public class RegisteredClassFactory {
    static final boolean DEBUG = Debug.debug("RegisteredClass");
    private static ArrayList sharedClasses = new ArrayList();
    private String classBaseName;
    long wndProc;
    private RegisteredClass sharedClass = null;
    private int classIter = 0;
    private int sharedRefCount = 0;
    private Object sync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownSharedClasses() {
        ArrayList arrayList = sharedClasses;
        synchronized (arrayList) {
            for (int i = 0; i < sharedClasses.size(); ++i) {
                RegisteredClass registeredClass = (RegisteredClass)sharedClasses.get(i);
                GDI.DestroyWindowClass(registeredClass.getHandle(), registeredClass.getName());
                if (!DEBUG) continue;
                System.err.println("RegisteredClassFactory shutdownSharedClasses " + i + "/" + sharedClasses.size() + ": " + registeredClass);
            }
            sharedClasses.clear();
        }
    }

    public RegisteredClassFactory(String string, long l) {
        this.classBaseName = string;
        this.wndProc = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredClass getSharedClass() throws NativeWindowException {
        Object object = this.sync;
        synchronized (object) {
            if (0 == this.sharedRefCount) {
                if (null != this.sharedClass) {
                    throw new InternalError("Error (" + this.sharedRefCount + "): SharedClass not null: " + this.sharedClass);
                }
                long l = GDI.GetApplicationHandle();
                if (0L == l) {
                    throw new NativeWindowException("Error: Null ModuleHandle for Application");
                }
                String string = null;
                boolean bl = false;
                while (!bl && Integer.MAX_VALUE >= this.classIter) {
                    string = this.classBaseName + this.classIter;
                    ++this.classIter;
                    bl = GDI.CreateWindowClass(l, string, this.wndProc);
                }
                if (!bl) {
                    throw new NativeWindowException("Error: Could not create WindowClass: " + string);
                }
                this.sharedClass = new RegisteredClass(l, string);
                ArrayList arrayList = sharedClasses;
                synchronized (arrayList) {
                    sharedClasses.add(this.sharedClass);
                }
                if (DEBUG) {
                    System.err.println("RegisteredClassFactory getSharedClass (" + this.sharedRefCount + ") initialized: " + this.sharedClass);
                }
            } else if (null == this.sharedClass) {
                throw new InternalError("Error (" + this.sharedRefCount + "): SharedClass is null");
            }
            ++this.sharedRefCount;
        }
        return this.sharedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSharedClass() {
        Object object = this.sync;
        synchronized (object) {
            if (0 == this.sharedRefCount) {
                if (null != this.sharedClass) {
                    throw new InternalError("Error (" + this.sharedRefCount + "): SharedClass not null: " + this.sharedClass);
                }
                return;
            }
            --this.sharedRefCount;
            if (null == this.sharedClass) {
                throw new InternalError("Error (" + this.sharedRefCount + "): SharedClass is null");
            }
            if (0 == this.sharedRefCount) {
                GDI.DestroyWindowClass(this.sharedClass.getHandle(), this.sharedClass.getName());
                ArrayList arrayList = sharedClasses;
                synchronized (arrayList) {
                    sharedClasses.remove(this.sharedClass);
                }
                if (DEBUG) {
                    System.err.println("RegisteredClassFactory releaseSharedClass (" + this.sharedRefCount + ") released: " + this.sharedClass);
                }
                this.sharedClass = null;
                this.sharedRefCount = 0;
                this.classIter = 0;
            }
        }
    }

    public int getSharedRefCount() {
        return this.sharedRefCount;
    }
}

