/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.impl.jawt;

import com.jogamp.nativewindow.impl.Debug;
import com.jogamp.nativewindow.impl.jawt.JAWT;
import com.jogamp.nativewindow.impl.jawt.JAWTJNILibLoader;
import com.jogamp.nativewindow.impl.jawt.JAWTToolkitLock;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Map;
import javax.media.nativewindow.NativeWindowException;

public class JAWTUtil {
    protected static final boolean DEBUG = Debug.debug("JAWT");
    private static final boolean headlessMode;
    private static final Method isQueueFlusherThread;
    private static final boolean j2dExist;
    private static Class sunToolkitClass;
    private static Method sunToolkitAWTLockMethod;
    private static Method sunToolkitAWTUnlockMethod;
    private static boolean hasSunToolkitAWTLock;
    private static final JAWTToolkitLock jawtToolkitLock;

    public static void initSingleton() {
    }

    public static final boolean hasJava2D() {
        return j2dExist;
    }

    public static final boolean isJava2DQueueFlusherThread() {
        boolean bl = false;
        if (j2dExist) {
            try {
                bl = (Boolean)isQueueFlusherThread.invoke(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public static boolean isHeadlessMode() {
        return headlessMode;
    }

    public static void awtLock() {
        if (hasSunToolkitAWTLock) {
            try {
                sunToolkitAWTLockMethod.invoke(null, null);
            }
            catch (Exception exception) {
                throw new NativeWindowException("SunToolkit.awtLock failed", exception);
            }
        } else {
            JAWT.getJAWT().Lock();
        }
    }

    public static void awtUnlock() {
        if (hasSunToolkitAWTLock) {
            try {
                sunToolkitAWTUnlockMethod.invoke(null, null);
            }
            catch (Exception exception) {
                throw new NativeWindowException("SunToolkit.awtUnlock failed", exception);
            }
        } else {
            JAWT.getJAWT().Unlock();
        }
    }

    public static void lockToolkit() throws NativeWindowException {
        if (!headlessMode && !JAWTUtil.isJava2DQueueFlusherThread()) {
            JAWTUtil.awtLock();
        }
    }

    public static void unlockToolkit() {
        if (!headlessMode && !JAWTUtil.isJava2DQueueFlusherThread()) {
            JAWTUtil.awtUnlock();
        }
    }

    public static JAWTToolkitLock getJAWTToolkitLock() {
        return jawtToolkitLock;
    }

    static {
        JAWTJNILibLoader.loadAWTImpl();
        JAWTJNILibLoader.loadNativeWindow("awt");
        headlessMode = GraphicsEnvironment.isHeadless();
        boolean bl = false;
        Class<?> clazz = null;
        Method method = null;
        if (!headlessMode) {
            try {
                clazz = Class.forName("com.jogamp.opengl.impl.awt.Java2D");
                method = clazz.getMethod("isQueueFlusherThread", null);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        isQueueFlusherThread = method;
        j2dExist = bl;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    sunToolkitClass = Class.forName("sun.awt.SunToolkit");
                    sunToolkitAWTLockMethod = sunToolkitClass.getDeclaredMethod("awtLock", new Class[0]);
                    sunToolkitAWTLockMethod.setAccessible(true);
                    sunToolkitAWTUnlockMethod = sunToolkitClass.getDeclaredMethod("awtUnlock", new Class[0]);
                    sunToolkitAWTUnlockMethod.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
        boolean bl2 = false;
        if (null != sunToolkitAWTLockMethod && null != sunToolkitAWTUnlockMethod) {
            try {
                sunToolkitAWTLockMethod.invoke(null, null);
                sunToolkitAWTUnlockMethod.invoke(null, null);
                bl2 = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        hasSunToolkitAWTLock = bl2;
        jawtToolkitLock = new JAWTToolkitLock();
        final ArrayList arrayList = new ArrayList();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Map map = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
                    if (null != map) {
                        arrayList.add(map);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        if (DEBUG) {
            System.err.println("JAWTUtil: Has sun.awt.SunToolkit.awtLock/awtUnlock " + hasSunToolkitAWTLock);
            System.err.println("JAWTUtil: Has Java2D " + j2dExist);
            System.err.println("JAWTUtil: Is headless " + headlessMode);
            int n = arrayList.size() > 0 ? ((Map)arrayList.get(0)).size() : 0;
            System.err.println("JAWTUtil: AWT Desktop hints " + n);
        }
    }
}

