/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.windows.wgl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.nativewindow.impl.ProxySurface;
import com.jogamp.nativewindow.impl.windows.GDI;
import com.jogamp.nativewindow.impl.windows.RegisteredClassFactory;
import com.jogamp.opengl.impl.DesktopGLDynamicLookupHelper;
import com.jogamp.opengl.impl.GLContextImpl;
import com.jogamp.opengl.impl.GLDrawableFactoryImpl;
import com.jogamp.opengl.impl.GLDrawableImpl;
import com.jogamp.opengl.impl.GLDynamicLookupHelper;
import com.jogamp.opengl.impl.SharedResourceRunner;
import com.jogamp.opengl.impl.windows.wgl.WGL;
import com.jogamp.opengl.impl.windows.wgl.WindowsBitmapWGLDrawable;
import com.jogamp.opengl.impl.windows.wgl.WindowsDummyWGLDrawable;
import com.jogamp.opengl.impl.windows.wgl.WindowsExternalWGLContext;
import com.jogamp.opengl.impl.windows.wgl.WindowsExternalWGLDrawable;
import com.jogamp.opengl.impl.windows.wgl.WindowsOnscreenWGLDrawable;
import com.jogamp.opengl.impl.windows.wgl.WindowsPbufferWGLDrawable;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLContext;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLDrawable;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLDynamicLibraryBundleInfo;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLGraphicsConfigurationFactory;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.windows.WindowsGraphicsDevice;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class WindowsWGLDrawableFactory
extends GLDrawableFactoryImpl {
    private static final DesktopGLDynamicLookupHelper windowsWGLDynamicLookupHelper;
    WindowsGraphicsDevice defaultDevice;
    SharedResourceImplementation sharedResourceImpl;
    SharedResourceRunner sharedResourceRunner;
    Thread sharedResourceThread;
    HashMap sharedMap = new HashMap();
    static final String GL_ARB_pbuffer = "GL_ARB_pbuffer";
    static final String WGL_ARB_make_current_read = "WGL_ARB_make_current_read";
    static final String wglMakeContextCurrent = "wglMakeContextCurrent";
    private static final int GAMMA_RAMP_LENGTH = 256;

    public GLDynamicLookupHelper getGLDynamicLookupHelper(int n) {
        return windowsWGLDynamicLookupHelper;
    }

    public WindowsWGLDrawableFactory() {
        new WindowsWGLGraphicsConfigurationFactory();
        if (GLProfile.isAWTAvailable()) {
            try {
                ReflectionUtil.createInstance((String)"com.jogamp.opengl.impl.windows.wgl.awt.WindowsAWTWGLGraphicsConfigurationFactory", null, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (JogampRuntimeException jogampRuntimeException) {
                // empty catch block
            }
        }
        this.defaultDevice = new WindowsGraphicsDevice(0);
        this.sharedResourceImpl = new SharedResourceImplementation();
        this.sharedResourceRunner = new SharedResourceRunner(this.sharedResourceImpl);
        this.sharedResourceThread = new Thread((Runnable)this.sharedResourceRunner, Thread.currentThread().getName() + "-SharedResourceRunner");
        this.sharedResourceThread.setDaemon(true);
        this.sharedResourceThread.start();
    }

    public final AbstractGraphicsDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    public final boolean getIsDeviceCompatible(AbstractGraphicsDevice abstractGraphicsDevice) {
        return abstractGraphicsDevice instanceof WindowsGraphicsDevice;
    }

    protected final GLContext getOrCreateSharedContextImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null != resource) {
            return resource.getContext();
        }
        return null;
    }

    protected AbstractGraphicsDevice getOrCreateSharedDeviceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null != resource) {
            return resource.getDevice();
        }
        return null;
    }

    protected WindowsWGLDrawable getSharedDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null != resource) {
            return (WindowsWGLDrawable)resource.getDrawable();
        }
        return null;
    }

    protected final void shutdownInstance() {
        this.sharedResourceRunner.releaseAndWait();
        RegisteredClassFactory.shutdownSharedClasses();
    }

    protected final GLDrawableImpl createOnscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        return new WindowsOnscreenWGLDrawable(this, nativeSurface);
    }

    protected final GLDrawableImpl createOffscreenDrawableImpl(final NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeSurface.getGraphicsConfiguration().getNativeGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            return new WindowsBitmapWGLDrawable(this, nativeSurface);
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        final SharedResource sharedResource = (SharedResource)this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null == sharedResource) {
            throw new IllegalArgumentException("No shared resource for " + abstractGraphicsDevice);
        }
        final ArrayList arrayList = new ArrayList();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                GLContext gLContext = GLContext.getCurrent();
                if (gLContext != null) {
                    gLContext.release();
                }
                sharedResource.context.makeCurrent();
                try {
                    WindowsPbufferWGLDrawable windowsPbufferWGLDrawable = new WindowsPbufferWGLDrawable(WindowsWGLDrawableFactory.this, nativeSurface, sharedResource.drawable, sharedResource.context);
                    arrayList.add(windowsPbufferWGLDrawable);
                }
                finally {
                    sharedResource.context.release();
                    if (gLContext != null) {
                        gLContext.makeCurrent();
                    }
                }
            }
        };
        this.maybeDoSingleThreadedWorkaround(runnable);
        return (GLDrawableImpl)arrayList.get(0);
    }

    public final int isReadDrawableAvailable(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource = (SharedResource)this.sharedResourceRunner.getOrCreateShared((AbstractGraphicsDevice)(null != abstractGraphicsDevice ? abstractGraphicsDevice : this.defaultDevice));
        if (null != sharedResource) {
            return sharedResource.isReadDrawableAvailable() ? 1 : 0;
        }
        return -1;
    }

    public final boolean canCreateGLPbuffer(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource = (SharedResource)this.sharedResourceRunner.getOrCreateShared((AbstractGraphicsDevice)(null != abstractGraphicsDevice ? abstractGraphicsDevice : this.defaultDevice));
        if (null != sharedResource) {
            return sharedResource.canCreateGLPbuffer();
        }
        return false;
    }

    protected final NativeSurface createOffscreenSurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault((String)"Windows");
        ProxySurface proxySurface = new ProxySurface((AbstractGraphicsConfiguration)WindowsWGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, abstractGraphicsScreen));
        proxySurface.setSize(n, n2);
        return proxySurface;
    }

    protected final GLContext createExternalGLContextImpl() {
        return WindowsExternalWGLContext.create(this, null);
    }

    public final boolean canCreateExternalGLDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return true;
    }

    protected final GLDrawable createExternalGLDrawableImpl() {
        return WindowsExternalWGLDrawable.create(this, null);
    }

    static String wglGetLastError() {
        long l = GDI.GetLastError();
        String string = null;
        switch ((int)l) {
            case 0: {
                string = "ERROR_SUCCESS";
                break;
            }
            case 2000: {
                string = "ERROR_INVALID_PIXEL_FORMAT";
                break;
            }
            case 1450: {
                string = "ERROR_NO_SYSTEM_RESOURCES";
                break;
            }
            case 13: {
                string = "ERROR_INVALID_DATA";
                break;
            }
            case 127: {
                string = "ERROR_PROC_NOT_FOUND";
                break;
            }
            case 1400: {
                string = "ERROR_INVALID_WINDOW_HANDLE";
                break;
            }
            default: {
                string = "(Unknown error code " + l + ")";
            }
        }
        return string;
    }

    public final boolean canCreateContextOnJava2DSurface(AbstractGraphicsDevice abstractGraphicsDevice) {
        return false;
    }

    public final GLContext createContextOnJava2DSurface(Object object, GLContext gLContext) throws GLException {
        throw new GLException("Unimplemented on this platform");
    }

    protected final int getGammaRampLength() {
        return 256;
    }

    protected final boolean setGammaRamp(float[] fArray) {
        short[] sArray = new short[768];
        for (int i = 0; i < 256; ++i) {
            short s;
            sArray[i] = s = (short)(fArray[i] * 65535.0f);
            sArray[i + 256] = s;
            sArray[i + 512] = s;
        }
        long l = GDI.GetDC((long)0L);
        boolean bl = GDI.SetDeviceGammaRamp((long)l, (Buffer)ShortBuffer.wrap(sArray));
        GDI.ReleaseDC((long)0L, (long)l);
        return bl;
    }

    protected final Buffer getGammaRamp() {
        ShortBuffer shortBuffer = ShortBuffer.wrap(new short[768]);
        long l = GDI.GetDC((long)0L);
        boolean bl = GDI.GetDeviceGammaRamp((long)l, (Buffer)shortBuffer);
        GDI.ReleaseDC((long)0L, (long)l);
        if (!bl) {
            return null;
        }
        return shortBuffer;
    }

    protected final void resetGammaRamp(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        long l = GDI.GetDC((long)0L);
        GDI.SetDeviceGammaRamp((long)l, (Buffer)buffer);
        GDI.ReleaseDC((long)0L, (long)l);
    }

    static {
        DesktopGLDynamicLookupHelper desktopGLDynamicLookupHelper;
        block3: {
            desktopGLDynamicLookupHelper = null;
            try {
                desktopGLDynamicLookupHelper = new DesktopGLDynamicLookupHelper(new WindowsWGLDynamicLibraryBundleInfo());
            }
            catch (GLException gLException) {
                if (!DEBUG) break block3;
                gLException.printStackTrace();
            }
        }
        windowsWGLDynamicLookupHelper = desktopGLDynamicLookupHelper;
        if (null != windowsWGLDynamicLookupHelper) {
            WGL.getWGLProcAddressTable().reset((DynamicLookupHelper)windowsWGLDynamicLookupHelper);
        }
    }

    class SharedResourceImplementation
    implements SharedResourceRunner.Implementation {
        SharedResourceImplementation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            HashMap hashMap = WindowsWGLDrawableFactory.this.sharedMap;
            synchronized (hashMap) {
                WindowsWGLDrawableFactory.this.sharedMap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedResourceRunner.Resource mapPut(String string, SharedResourceRunner.Resource resource) {
            HashMap hashMap = WindowsWGLDrawableFactory.this.sharedMap;
            synchronized (hashMap) {
                return WindowsWGLDrawableFactory.this.sharedMap.put(string, resource);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedResourceRunner.Resource mapGet(String string) {
            HashMap hashMap = WindowsWGLDrawableFactory.this.sharedMap;
            synchronized (hashMap) {
                return (SharedResourceRunner.Resource)WindowsWGLDrawableFactory.this.sharedMap.get(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection mapValues() {
            HashMap hashMap = WindowsWGLDrawableFactory.this.sharedMap;
            synchronized (hashMap) {
                return WindowsWGLDrawableFactory.this.sharedMap.values();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedResourceRunner.Resource createSharedResource(String string) {
            WindowsGraphicsDevice windowsGraphicsDevice = new WindowsGraphicsDevice(string, 0);
            windowsGraphicsDevice.lock();
            try {
                boolean bl;
                boolean bl2;
                DefaultGraphicsScreen defaultGraphicsScreen = new DefaultGraphicsScreen((AbstractGraphicsDevice)windowsGraphicsDevice, 0);
                if (null == defaultGraphicsScreen) {
                    throw new GLException("Couldn't create shared screen for device: " + windowsGraphicsDevice + ", idx 0");
                }
                GLProfile gLProfile = GLProfile.getDefault((AbstractGraphicsDevice)windowsGraphicsDevice);
                if (null == gLProfile) {
                    throw new GLException("Couldn't get default GLProfile for device: " + windowsGraphicsDevice);
                }
                WindowsDummyWGLDrawable windowsDummyWGLDrawable = WindowsDummyWGLDrawable.create(WindowsWGLDrawableFactory.this, gLProfile, (AbstractGraphicsScreen)defaultGraphicsScreen);
                if (null == windowsDummyWGLDrawable) {
                    throw new GLException("Couldn't create shared drawable for screen: " + defaultGraphicsScreen + ", " + gLProfile);
                }
                WindowsWGLContext windowsWGLContext = (WindowsWGLContext)windowsDummyWGLDrawable.createContext(null);
                if (null == windowsWGLContext) {
                    throw new GLException("Couldn't create shared context for drawable: " + windowsDummyWGLDrawable);
                }
                windowsWGLContext.setSynchronized(true);
                windowsWGLContext.makeCurrent();
                try {
                    bl2 = windowsWGLContext.getGL().isExtensionAvailable(WindowsWGLDrawableFactory.GL_ARB_pbuffer);
                    bl = windowsWGLContext.isExtensionAvailable(WindowsWGLDrawableFactory.WGL_ARB_make_current_read) && windowsWGLContext.isFunctionAvailable(WindowsWGLDrawableFactory.wglMakeContextCurrent);
                }
                finally {
                    windowsWGLContext.release();
                }
                if (DEBUG) {
                    System.err.println("!!! SharedDevice:  " + windowsGraphicsDevice);
                    System.err.println("!!! SharedScreen:  " + defaultGraphicsScreen);
                    System.err.println("!!! SharedContext: " + windowsWGLContext);
                    System.err.println("!!! pbuffer avail: " + bl2);
                    System.err.println("!!! readDrawable:  " + bl);
                }
                SharedResource sharedResource = new SharedResource(windowsGraphicsDevice, (AbstractGraphicsScreen)defaultGraphicsScreen, windowsDummyWGLDrawable, windowsWGLContext, bl, bl2);
                return sharedResource;
            }
            catch (Throwable throwable) {
                throw new GLException("WindowsWGLDrawableFactory - Could not initialize shared resources for " + string, throwable);
            }
            finally {
                windowsGraphicsDevice.unlock();
            }
        }

        public void releaseSharedResource(SharedResourceRunner.Resource resource) {
            SharedResource sharedResource = (SharedResource)resource;
            if (DEBUG) {
                System.err.println("!!! Shutdown Shared:");
                System.err.println("!!!   Device  : " + sharedResource.device);
                System.err.println("!!!   Screen  : " + sharedResource.screen);
                System.err.println("!!!   Drawable: " + sharedResource.drawable);
                System.err.println("!!!   CTX     : " + sharedResource.context);
            }
            if (null != sharedResource.context) {
                sharedResource.context = null;
            }
            if (null != sharedResource.drawable) {
                sharedResource.drawable.destroy();
                sharedResource.drawable = null;
            }
            if (null != sharedResource.screen) {
                sharedResource.screen = null;
            }
            if (null != sharedResource.device) {
                sharedResource.device.close();
                sharedResource.device = null;
            }
        }
    }

    static class SharedResource
    implements SharedResourceRunner.Resource {
        private WindowsGraphicsDevice device;
        private AbstractGraphicsScreen screen;
        private WindowsDummyWGLDrawable drawable;
        private WindowsWGLContext context;
        private boolean canCreateGLPbuffer;
        private boolean readDrawableAvailable;

        SharedResource(WindowsGraphicsDevice windowsGraphicsDevice, AbstractGraphicsScreen abstractGraphicsScreen, WindowsDummyWGLDrawable windowsDummyWGLDrawable, WindowsWGLContext windowsWGLContext, boolean bl, boolean bl2) {
            this.device = windowsGraphicsDevice;
            this.screen = abstractGraphicsScreen;
            this.drawable = windowsDummyWGLDrawable;
            this.context = windowsWGLContext;
            this.canCreateGLPbuffer = bl2;
            this.readDrawableAvailable = bl;
        }

        public AbstractGraphicsDevice getDevice() {
            return this.device;
        }

        public AbstractGraphicsScreen getScreen() {
            return this.screen;
        }

        public GLDrawableImpl getDrawable() {
            return this.drawable;
        }

        public GLContextImpl getContext() {
            return this.context;
        }

        boolean canCreateGLPbuffer() {
            return this.canCreateGLPbuffer;
        }

        boolean isReadDrawableAvailable() {
            return this.readDrawableAvailable;
        }
    }
}

