/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl;

import com.jogamp.opengl.impl.Debug;
import com.jogamp.opengl.impl.GLDrawableImpl;
import com.jogamp.opengl.impl.GLRunnableTask;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLRunnable;

public class GLDrawableHelper {
    protected static final boolean DEBUG = GLDrawableImpl.DEBUG;
    private static final boolean VERBOSE = Debug.verbose();
    private Object listenersLock = new Object();
    private List listeners;
    private volatile boolean listenersIter;
    private Set listenersToBeInit;
    private boolean autoSwapBufferMode;
    private Object glRunnablesLock = new Object();
    private ArrayList glRunnables;
    private GLAnimatorControl animatorCtrl;
    private static final ThreadLocal perThreadInitAction = new ThreadLocal();

    public GLDrawableHelper() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners = new ArrayList();
            this.listenersIter = false;
            this.listenersToBeInit = new HashSet();
        }
        this.autoSwapBufferMode = true;
        object = this.glRunnablesLock;
        synchronized (object) {
            this.glRunnables = new ArrayList();
        }
        this.animatorCtrl = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GLAnimatorControl: " + this.animatorCtrl + ", ");
        Object object = this.listenersLock;
        synchronized (object) {
            stringBuffer.append("GLEventListeners num " + this.listeners.size() + " [");
            this.listenersIter = true;
            for (int i = 0; i < this.listeners.size(); ++i) {
                Object e = this.listeners.get(i);
                stringBuffer.append(e);
                stringBuffer.append("[init ");
                stringBuffer.append(!this.listenersToBeInit.contains(e));
                stringBuffer.append("], ");
            }
            this.listenersIter = false;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final void addGLEventListener(GLEventListener gLEventListener) {
        this.addGLEventListener(-1, gLEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addGLEventListener(int n, GLEventListener gLEventListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (0 > n) {
                n = this.listeners.size();
            }
            this.listenersToBeInit.add(gLEventListener);
            if (!this.listenersIter) {
                this.listeners.add(n, gLEventListener);
            } else {
                List list = (List)((ArrayList)this.listeners).clone();
                list.add(n, gLEventListener);
                this.listeners = list;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeGLEventListener(GLEventListener gLEventListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (!this.listenersIter) {
                this.listeners.remove(gLEventListener);
            } else {
                List list = (List)((ArrayList)this.listeners).clone();
                list.remove(gLEventListener);
                this.listeners = list;
            }
            this.listenersToBeInit.remove(gLEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose(GLAutoDrawable gLAutoDrawable) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listenersIter = true;
            for (int i = 0; i < this.listeners.size(); ++i) {
                GLEventListener gLEventListener = (GLEventListener)this.listeners.get(i);
                gLEventListener.dispose(gLAutoDrawable);
                this.listenersToBeInit.add(gLEventListener);
            }
            this.listenersIter = false;
        }
    }

    private final boolean init(GLEventListener gLEventListener, GLAutoDrawable gLAutoDrawable, boolean bl) {
        if (this.listenersToBeInit.remove(gLEventListener)) {
            gLEventListener.init(gLAutoDrawable);
            if (bl) {
                this.reshape(gLEventListener, gLAutoDrawable, 0, 0, gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight(), true);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(GLAutoDrawable gLAutoDrawable) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listenersIter = true;
            for (int i = 0; i < this.listeners.size(); ++i) {
                GLEventListener gLEventListener = (GLEventListener)this.listeners.get(i);
                if (this.init(gLEventListener, gLAutoDrawable, false)) continue;
                throw new GLException("GLEventListener " + gLEventListener + " already initialized: " + gLAutoDrawable);
            }
            this.listenersIter = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void display(GLAutoDrawable gLAutoDrawable) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listenersIter = true;
            for (int i = 0; i < this.listeners.size(); ++i) {
                GLEventListener gLEventListener = (GLEventListener)this.listeners.get(i);
                this.init(gLEventListener, gLAutoDrawable, true);
                gLEventListener.display(gLAutoDrawable);
            }
            this.listenersIter = false;
        }
        this.execGLRunnables(gLAutoDrawable);
    }

    private final void reshape(GLEventListener gLEventListener, GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            gLAutoDrawable.getGL().glViewport(n, n2, n3, n4);
        }
        gLEventListener.reshape(gLAutoDrawable, n, n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listenersIter = true;
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.reshape((GLEventListener)this.listeners.get(i), gLAutoDrawable, n, n2, n3, n4, 0 == i);
            }
            this.listenersIter = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void execGLRunnables(GLAutoDrawable gLAutoDrawable) {
        if (this.glRunnables.size() > 0) {
            ArrayList arrayList = null;
            Object object = this.glRunnablesLock;
            synchronized (object) {
                if (this.glRunnables.size() > 0) {
                    arrayList = this.glRunnables;
                    this.glRunnables = new ArrayList();
                }
            }
            if (null != arrayList) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    ((GLRunnable)arrayList.get(i)).run(gLAutoDrawable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAnimator(GLAnimatorControl gLAnimatorControl) throws GLException {
        Object object = this.glRunnablesLock;
        synchronized (object) {
            if (this.animatorCtrl != gLAnimatorControl && null != gLAnimatorControl && null != this.animatorCtrl) {
                throw new GLException("Trying to register GLAnimatorControl " + gLAnimatorControl + ", where " + this.animatorCtrl + " is already registered. Unregister first.");
            }
            this.animatorCtrl = gLAnimatorControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GLAnimatorControl getAnimator() {
        Object object = this.glRunnablesLock;
        synchronized (object) {
            return this.animatorCtrl;
        }
    }

    public final boolean isExternalAnimatorRunning() {
        return null != this.animatorCtrl ? this.animatorCtrl.isStarted() && this.animatorCtrl.getThread() != Thread.currentThread() : false;
    }

    public final boolean isExternalAnimatorAnimating() {
        return null != this.animatorCtrl ? this.animatorCtrl.isAnimating() && this.animatorCtrl.getThread() != Thread.currentThread() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(GLAutoDrawable gLAutoDrawable, boolean bl, GLRunnable gLRunnable) {
        Object object;
        if (null == gLAutoDrawable || null == gLRunnable) {
            return;
        }
        Throwable throwable = null;
        GLRunnableTask gLRunnableTask = null;
        Object object2 = object = new Object();
        synchronized (object2) {
            boolean bl2;
            Object object3 = this.glRunnablesLock;
            synchronized (object3) {
                bl2 = this.isExternalAnimatorAnimating();
                if (!bl2) {
                    bl = false;
                }
                gLRunnableTask = new GLRunnableTask(gLRunnable, bl ? object : null, bl);
                this.glRunnables.add(gLRunnableTask);
            }
            if (!bl2) {
                gLAutoDrawable.display();
            } else if (bl) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = gLRunnableTask.getThrowable();
                }
                if (null != throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }
    }

    public final void setAutoSwapBufferMode(boolean bl) {
        this.autoSwapBufferMode = bl;
    }

    public final boolean getAutoSwapBufferMode() {
        return this.autoSwapBufferMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invokeGL(GLDrawable gLDrawable, GLContext gLContext, Runnable runnable, Runnable runnable2) {
        if (null == gLContext) {
            if (DEBUG) {
                GLException gLException = new GLException(Thread.currentThread().getName() + " Info: GLDrawableHelper " + this + ".invokeGL(): NULL GLContext");
                gLException.printStackTrace();
            }
            return;
        }
        if (null == runnable2 && !gLContext.isCreated()) {
            throw new GLException(Thread.currentThread().getName() + " GLDrawableHelper " + this + ".invokeGL(): Dispose case (no init action given): Native context is not created: " + gLContext);
        }
        GLContext gLContext2 = GLContext.getCurrent();
        Runnable runnable3 = (Runnable)perThreadInitAction.get();
        if (gLContext2 != null) {
            gLContext2.release();
        }
        int n = 0;
        try {
            n = gLContext.makeCurrent();
            if (n != 0) {
                if (null != runnable2) {
                    perThreadInitAction.set(runnable2);
                    if (n == 2) {
                        if (DEBUG) {
                            System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running initAction");
                        }
                        runnable2.run();
                    }
                }
                if (null != runnable) {
                    if (DEBUG && VERBOSE) {
                        System.err.println("GLDrawableHelper " + this + ".invokeGL(): Running runnable");
                    }
                    runnable.run();
                    if (this.autoSwapBufferMode && null != runnable2 && gLDrawable != null) {
                        gLDrawable.swapBuffers();
                    }
                }
            }
        }
        finally {
            int n2;
            try {
                if (n != 0) {
                    gLContext.release();
                }
            }
            catch (Exception exception) {}
            if (gLContext2 != null && (n2 = gLContext2.makeCurrent()) == 2) {
                runnable3.run();
            }
        }
    }
}

