/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLUtil {
    public static String clString2JavaString(byte[] chars, int clLength) {
        return clLength == 0 ? "" : new String(chars, 0, clLength - 1);
    }

    public static String clString2JavaString(ByteBuffer chars, int clLength) {
        if (clLength == 0) {
            return "";
        }
        byte[] array = new byte[clLength - 1];
        chars.get(array).rewind();
        return new String(array, 0, clLength - 1);
    }

    public static boolean clBoolean(int clBoolean) {
        return clBoolean == 1;
    }

    public static int clBoolean(boolean b) {
        return b ? 1 : 0;
    }

    public static Map<String, String> obtainPlatformProperties(CLPlatform platform) {
        return CLUtil.readCLProperties(platform);
    }

    public static Map<String, String> obtainDeviceProperties(CLDevice dev) {
        return CLUtil.readCLProperties(dev);
    }

    private static Map<String, String> readCLProperties(Object obj) {
        try {
            return CLUtil.invoke(CLUtil.listMethods(obj.getClass()), obj);
        }
        catch (IllegalArgumentException ex) {
            throw new JogampRuntimeException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new JogampRuntimeException((Throwable)ex);
        }
    }

    static Map<String, String> invoke(List<Method> methods, Object obj) throws IllegalArgumentException, IllegalAccessException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Method method : methods) {
            List<Number> info = null;
            try {
                info = method.invoke(obj, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                info = ex.getTargetException();
            }
            if (info.getClass().isArray()) {
                info = CLUtil.asList(info);
            }
            String value = method.getAnnotation(CLProperty.class).value();
            map.put(value, info.toString());
        }
        return map;
    }

    static List<Method> listMethods(Class<?> clazz) throws SecurityException {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = method.getDeclaredAnnotations()) {
                if (!(annotation instanceof CLProperty)) continue;
                list.add(method);
            }
        }
        return list;
    }

    private static List<Number> asList(Object info) {
        ArrayList<Number> list;
        block5: {
            double[] array;
            block7: {
                float[] array2;
                block6: {
                    long[] array3;
                    block4: {
                        int[] array4;
                        list = new ArrayList<Number>();
                        if (!(info instanceof int[])) break block4;
                        for (int i : array4 = (int[])info) {
                            list.add(i);
                        }
                        break block5;
                    }
                    if (!(info instanceof long[])) break block6;
                    for (long i : array3 = (long[])info) {
                        list.add(i);
                    }
                    break block5;
                }
                if (!(info instanceof float[])) break block7;
                for (float i : array2 = (float[])info) {
                    list.add(Float.valueOf(i));
                }
                break block5;
            }
            if (!(info instanceof double[])) break block5;
            for (double i : array = (double[])info) {
                list.add(i);
            }
        }
        return list;
    }
}

