/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util;

import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLVersion;
import com.jogamp.opencl.util.Filter;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLPlatformFilters {
    public static Filter<CLPlatform> version(final CLVersion version) {
        return new Filter<CLPlatform>(){

            @Override
            public boolean accept(CLPlatform item) {
                return item.isAtLeast(version);
            }
        };
    }

    public static Filter<CLPlatform> type(final CLDevice.Type type) {
        return new Filter<CLPlatform>(){

            @Override
            public boolean accept(CLPlatform item) {
                return item.listCLDevices(type).length > 0;
            }
        };
    }

    public static Filter<CLPlatform> extensions(final String ... extensions) {
        return new Filter<CLPlatform>(){

            @Override
            public boolean accept(CLPlatform item) {
                return item.getExtensions().containsAll(Arrays.asList(extensions));
            }
        };
    }
}

