/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.gl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.gl.CLGLBuffer;
import com.jogamp.opencl.gl.CLGLI;
import com.jogamp.opencl.gl.CLGLImage2d;
import com.jogamp.opencl.gl.CLGLTexture2d;
import com.jogamp.opencl.gl.CLGLTexture3d;
import com.jogamp.opengl.impl.GLContextImpl;
import com.jogamp.opengl.impl.egl.EGLContext;
import com.jogamp.opengl.impl.macosx.cgl.MacOSXCGLContext;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLContext;
import com.jogamp.opengl.impl.x11.glx.X11GLXContext;
import java.nio.Buffer;
import javax.media.opengl.GLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CLGLContext
extends CLContext {
    final long glID;
    private final GLContext glContext;

    private CLGLContext(CLPlatform platform, GLContext glContext, long clContextID, long glContextID, CLContext.ErrorDispatcher dispatcher) {
        super(platform, clContextID, dispatcher);
        this.glID = glContextID;
        this.glContext = glContext;
    }

    public static CLGLContext create(GLContext glContext) {
        return CLGLContext.create(glContext, (CLPlatform)null, CLDevice.Type.ALL);
    }

    public static CLGLContext create(GLContext glContext, CLPlatform platform) {
        return CLGLContext.create(glContext, platform, CLDevice.Type.ALL);
    }

    public static CLGLContext create(GLContext glContext, CLDevice.Type ... deviceTypes) {
        return CLGLContext.create(glContext, null, deviceTypes);
    }

    public static CLGLContext create(GLContext glContext, CLPlatform platform, CLDevice.Type ... deviceTypes) {
        if (platform == null) {
            platform = CLPlatform.getDefault();
        }
        long[] glID = new long[1];
        PointerBuffer properties = CLGLContext.setupContextProperties(platform, glContext, glID);
        CLContext.ErrorDispatcher dispatcher = CLGLContext.createErrorHandler();
        long clID = CLGLContext.createContextFromType(dispatcher, properties, CLGLContext.toDeviceBitmap(deviceTypes));
        return new CLGLContext(platform, glContext, clID, glID[0], dispatcher);
    }

    public static CLGLContext create(GLContext glContext, CLDevice ... devices) {
        if (devices == null) {
            throw new IllegalArgumentException("no devices specified");
        }
        if (devices[0] == null) {
            throw new IllegalArgumentException("first device was null");
        }
        CLPlatform platform = devices[0].getPlatform();
        long[] glID = new long[1];
        PointerBuffer properties = CLGLContext.setupContextProperties(platform, glContext, glID);
        CLContext.ErrorDispatcher dispatcher = CLGLContext.createErrorHandler();
        long clID = CLGLContext.createContext(dispatcher, properties, devices);
        CLGLContext context = new CLGLContext(platform, glContext, clID, glID[0], dispatcher);
        if (devices != null) {
            for (int i = 0; i < devices.length; ++i) {
                context.overrideContext(devices[i]);
            }
        }
        return context;
    }

    private static PointerBuffer setupContextProperties(CLPlatform platform, GLContext glContext, long[] glID) {
        PointerBuffer properties;
        if (platform == null) {
            throw new RuntimeException("no OpenCL installation found");
        }
        if (glContext == null) {
            throw new IllegalArgumentException("GLContext was null.");
        }
        if (!glContext.isCurrent()) {
            throw new IllegalArgumentException("OpenGL context is not current,\n creating a OpenCL context for context sharing is not allowed in this situation.");
        }
        GLContextImpl ctxImpl = (GLContextImpl)glContext;
        glID[0] = glContext.getHandle();
        if (glContext instanceof X11GLXContext) {
            properties = PointerBuffer.allocateDirect((int)7);
            long displayHandle = ctxImpl.getDrawableImpl().getNativeSurface().getDisplayHandle();
            properties.put(8200L).put(glID[0]).put(8202L).put(displayHandle).put(4228L).put(platform.ID);
        } else if (glContext instanceof WindowsWGLContext) {
            properties = PointerBuffer.allocateDirect((int)7);
            long surfaceHandle = ctxImpl.getDrawableImpl().getNativeSurface().getSurfaceHandle();
            properties.put(8200L).put(glID[0]).put(8203L).put(surfaceHandle).put(4228L).put(platform.ID);
        } else if (glContext instanceof MacOSXCGLContext) {
            properties = PointerBuffer.allocateDirect((int)5);
            properties.put(8204L).put(glID[0]).put(4228L).put(platform.ID);
        } else if (glContext instanceof EGLContext) {
            properties = PointerBuffer.allocateDirect((int)7);
            long displayHandle = ctxImpl.getDrawableImpl().getNativeSurface().getDisplayHandle();
            properties.put(8200L).put(glID[0]).put(8201L).put(displayHandle).put(4228L).put(platform.ID);
        } else {
            throw new RuntimeException("unsupported GLContext: " + glContext);
        }
        return (PointerBuffer)properties.put(0L).rewind();
    }

    public final CLGLBuffer<?> createFromGLBuffer(int glBuffer, CLMemory.Mem ... flags) {
        return this.createFromGLBuffer(null, glBuffer, CLMemory.Mem.flagsToInt(flags));
    }

    public final CLGLBuffer<?> createFromGLBuffer(int glBuffer, int flags) {
        return this.createFromGLBuffer(null, glBuffer, flags);
    }

    public final <B extends Buffer> CLGLBuffer<B> createFromGLBuffer(B directBuffer, int glBuffer, CLMemory.Mem ... flags) {
        return this.createFromGLBuffer(directBuffer, glBuffer, CLMemory.Mem.flagsToInt(flags));
    }

    public final <B extends Buffer> CLGLBuffer<B> createFromGLBuffer(B directBuffer, int glBuffer, int flags) {
        CLGLBuffer<B> buffer = CLGLBuffer.create(this, directBuffer, flags, glBuffer);
        this.memoryObjects.add(buffer);
        return buffer;
    }

    public final CLGLImage2d<?> createFromGLRenderbuffer(int glBuffer, CLMemory.Mem ... flags) {
        return this.createFromGLRenderbuffer(null, glBuffer, CLMemory.Mem.flagsToInt(flags));
    }

    public final CLGLImage2d<?> createFromGLRenderbuffer(int glBuffer, int flags) {
        return this.createFromGLRenderbuffer(null, glBuffer, flags);
    }

    public final <B extends Buffer> CLGLImage2d<B> createFromGLRenderbuffer(B directBuffer, int glBuffer, CLMemory.Mem ... flags) {
        return this.createFromGLRenderbuffer(directBuffer, glBuffer, CLMemory.Mem.flagsToInt(flags));
    }

    public final <B extends Buffer> CLGLImage2d<B> createFromGLRenderbuffer(B directBuffer, int glBuffer, int flags) {
        CLGLImage2d<B> buffer = CLGLImage2d.createFromGLRenderbuffer(this, directBuffer, flags, glBuffer);
        this.memoryObjects.add(buffer);
        return buffer;
    }

    public final CLGLTexture2d<?> createFromGLTexture2d(int target, int texture, int mipmap, CLMemory.Mem ... flags) {
        return this.createFromGLTexture2d(null, target, texture, mipmap, CLMemory.Mem.flagsToInt(flags));
    }

    public final CLGLTexture2d<?> createFromGLTexture2d(int target, int texture, int mipmap, int flags) {
        return this.createFromGLTexture2d(null, target, texture, mipmap, flags);
    }

    public final <B extends Buffer> CLGLTexture2d<B> createFromGLTexture2d(B directBuffer, int target, int texture, int mipmap, CLMemory.Mem ... flags) {
        return this.createFromGLTexture2d(directBuffer, target, texture, mipmap, CLMemory.Mem.flagsToInt(flags));
    }

    public final <B extends Buffer> CLGLTexture2d<B> createFromGLTexture2d(B directBuffer, int target, int texture, int mipmap, int flags) {
        CLGLTexture2d<B> buffer = CLGLTexture2d.createFromGLTexture2d(this, directBuffer, target, texture, mipmap, flags);
        this.memoryObjects.add(buffer);
        return buffer;
    }

    public final CLGLTexture3d<?> createFromGLTexture3d(int target, int texture, int mipmap, CLMemory.Mem ... flags) {
        return this.createFromGLTexture3d(null, target, texture, mipmap, CLMemory.Mem.flagsToInt(flags));
    }

    public final CLGLTexture3d<?> createFromGLTexture3d(int target, int texture, int mipmap, int flags) {
        return this.createFromGLTexture3d(null, target, texture, mipmap, flags);
    }

    public final <B extends Buffer> CLGLTexture3d<B> createFromGLTexture3d(B directBuffer, int target, int texture, int mipmap, CLMemory.Mem ... flags) {
        return this.createFromGLTexture3d(directBuffer, target, texture, mipmap, CLMemory.Mem.flagsToInt(flags));
    }

    public final <B extends Buffer> CLGLTexture3d<B> createFromGLTexture3d(B directBuffer, int target, int texture, int mipmap, int flags) {
        CLGLTexture3d<B> buffer = CLGLTexture3d.createFromGLTexture3d(this, directBuffer, target, texture, mipmap, flags);
        this.memoryObjects.add(buffer);
        return buffer;
    }

    @Override
    public CLGLI getCL() {
        return (CLGLI)super.getCL();
    }

    public GLContext getGLContext() {
        return this.glContext;
    }

    @Override
    public CLGLContext getContext() {
        return this;
    }
}

