/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.gl;

import com.jogamp.opencl.CL;
import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.gl.CLGLContext;
import com.jogamp.opencl.gl.CLGLI;
import com.jogamp.opencl.gl.CLGLObject;
import java.nio.Buffer;
import javax.media.opengl.GLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CLGLBuffer<B extends Buffer>
extends CLBuffer<B>
implements CLGLObject {
    public final int GLID;

    private CLGLBuffer(CLContext context, B directBuffer, long id, int glObject, int flags) {
        super(context, directBuffer, CLGLBuffer.getSizeImpl(context.getCL(), id), id, flags);
        this.GLID = glObject;
    }

    static <B extends Buffer> CLGLBuffer<B> create(CLContext context, B directBuffer, int flags, int glObject) {
        CLGLBuffer.checkBuffer(directBuffer, flags);
        CL cl = CLGLBuffer.getCL(context);
        int[] result = new int[1];
        CLGLI clgli = (CLGLI)cl;
        long id = clgli.clCreateFromGLBuffer(context.ID, flags, glObject, result, 0);
        return new CLGLBuffer<B>(context, directBuffer, id, glObject, flags);
    }

    static <B extends Buffer> void checkBuffer(B directBuffer, int flags) throws IllegalArgumentException {
        if (directBuffer != null && !directBuffer.isDirect()) {
            throw new IllegalArgumentException("buffer is not a direct buffer");
        }
        if (CLGLBuffer.isHostPointerFlag(flags)) {
            throw new IllegalArgumentException("CL_MEM_COPY_HOST_PTR or CL_MEM_USE_HOST_PTR can not be used with OpenGL Buffers.");
        }
    }

    @Override
    public int getGLObjectID() {
        return this.GLID;
    }

    @Override
    public CLMemory.GLObjectType getGLObjectType() {
        return CLMemory.GLObjectType.GL_OBJECT_BUFFER;
    }

    @Override
    public CLGLContext getContext() {
        return (CLGLContext)super.getContext();
    }

    @Override
    public GLContext getGLContext() {
        return this.getContext().getGLContext();
    }

    @Override
    public <T extends Buffer> CLGLBuffer<T> cloneWith(T directBuffer) {
        return new CLGLBuffer<T>(this.context, directBuffer, this.ID, this.GLID, this.FLAGS);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [id: " + this.ID + " glID: " + this.GLID + "]";
    }
}

